/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.params;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.params.editor.custom.CustomSystemPropertyEditor;
import pt.lsts.neptus.params.renderer.SystemPropertyRenderer;

public class SystemProperty
extends DefaultProperty
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Object defaultValue = null;
    private Scope scope;
    private Visibility visibility;
    private String categoryId = this.getCategory();
    private AbstractPropertyEditor editor = null;
    private DefaultCellRenderer renderer = null;
    private CustomSystemPropertyEditor sectionCustomEditor = null;
    private ValueTypeEnum valueType = ValueTypeEnum.STRING;
    private long timeSync = -2L;
    private long timeDirty = -1L;

    public void setValue(Object value) {
        boolean equals = false;
        if (this.getValue() != null && this.getValue().equals(value)) {
            equals = true;
        }
        super.setValue(value);
        if (!equals) {
            this.setTimeDirty(System.currentTimeMillis());
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void resetToDefault() {
        if (this.defaultValue != null) {
            this.setValue(this.defaultValue);
        }
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public AbstractPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(AbstractPropertyEditor editor) {
        this.editor = editor;
    }

    public DefaultCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DefaultCellRenderer renderer) {
        this.renderer = renderer;
        this.updatePropRenderer();
    }

    public CustomSystemPropertyEditor getSectionCustomEditor() {
        return this.sectionCustomEditor;
    }

    public void setSectionCustomEditor(CustomSystemPropertyEditor sectionCustomEditor) {
        this.sectionCustomEditor = sectionCustomEditor;
    }

    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public long getTimeSync() {
        return this.timeSync;
    }

    public void setTimeSync(long timeSync) {
        this.timeDirty = this.timeSync = timeSync;
        this.updatePropRenderer();
    }

    public long getTimeDirty() {
        return this.timeDirty;
    }

    public void setTimeDirty(long timeDirty) {
        this.timeDirty = timeDirty;
        this.updatePropRenderer();
    }

    private void updatePropRenderer() {
        if (this.renderer == null) {
            return;
        }
        if (!(this.renderer instanceof SystemPropertyRenderer)) {
            return;
        }
        if (this.timeDirty > this.timeSync || this.timeSync <= 0L) {
            ((SystemPropertyRenderer)this.renderer).setPropertyInSync(false);
        } else {
            ((SystemPropertyRenderer)this.renderer).setPropertyInSync(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.sectionCustomEditor != null) {
            this.sectionCustomEditor.propertyChange(evt);
            return;
        }
        if (!(evt.getSource() instanceof SystemProperty)) {
            return;
        }
        if (this.editor != null && this.editor instanceof PropertyChangeListener) {
            ((PropertyChangeListener)this.editor).propertyChange(evt);
            this.editor.setValue(this.getValue());
            this.setValue(this.editor.getValue());
        }
    }

    public static enum ValueTypeEnum {
        STRING(I18n.textmark("string")),
        INTEGER(I18n.textmark("integer")),
        REAL(I18n.textmark("real")),
        BOOLEAN(I18n.textmark("boolean"));

        private String text;

        private ValueTypeEnum(String text) {
            I18n.textmark("list");
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static ValueTypeEnum fromString(String text) {
            if (text != null) {
                for (ValueTypeEnum b : ValueTypeEnum.values()) {
                    if (!text.equalsIgnoreCase(b.text)) continue;
                    return b;
                }
            }
            return STRING;
        }
    }

    public static enum Visibility {
        DEVELOPER("developer"),
        USER("user");

        private String text;

        private Visibility(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Visibility fromString(String text) {
            if (text != null) {
                for (Visibility b : Visibility.values()) {
                    if (!text.equalsIgnoreCase(b.text)) continue;
                    return b;
                }
            }
            return null;
        }
    }

    public static enum Scope {
        GLOBAL(I18n.textmark("global")),
        IDLE(I18n.textmark("idle")),
        PLAN(I18n.textmark("plan")),
        MANEUVER(I18n.textmark("maneuver"));

        private String text;

        private Scope(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Scope fromString(String text) {
            if (text != null) {
                for (Scope b : Scope.values()) {
                    if (!text.equalsIgnoreCase(b.text)) continue;
                    return b;
                }
            }
            return null;
        }
    }
}

