/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.graph.VehiclePainter;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.planeditor.ManeuverGraphFactory;
import pt.lsts.neptus.planeditor.ManeuverNode;
import pt.lsts.neptus.planeditor.ManeuverTransition;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public class IndividualPlanGraph
extends NeptusGraph<ManeuverNode, ManeuverTransition> {
    private static final long serialVersionUID = 651868708935847095L;
    ManeuverGraphFactory factory;
    private PlanType plan;

    public IndividualPlanGraph(PlanType plan) {
        this.plan = plan;
        this.setFactory(new ManeuverGraphFactory(plan.getMissionType(), plan));
        this.addPreRenderPainter(new VehiclePainter(plan));
    }

    @Override
    public AbstractAction[] getClickActions(MouseEvent evt) {
        if (evt.getButton() == 3 && this.selection.size() == 1 && !this.isEditable()) {
            AbstractAction propsAction = new AbstractAction("Properties..."){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    IndividualPlanGraph.this.editSelectionProperties();
                }
            };
            return new AbstractAction[]{propsAction};
        }
        if (!this.isEditable()) {
            return new AbstractAction[0];
        }
        Vector<AbstractAction> actions = new Vector<AbstractAction>();
        for (AbstractAction action : super.getClickActions(evt)) {
            actions.add(action);
        }
        return actions.toArray(new AbstractAction[0]);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 1 && arg0.getClickCount() == 2 && this.getFirstNodeUnder(arg0.getPoint()) != null) {
            PropertiesEditor.editProperties(this.getFirstNodeUnder(arg0.getPoint()), this.isEditable());
            this.repaint();
        } else {
            JPopupMenu popup = new JPopupMenu();
            AbstractAction[] actions = this.getClickActions(arg0);
            if (actions.length == 0) {
                return;
            }
            for (AbstractAction action : actions) {
                popup.add(action);
            }
            popup.show(this, arg0.getX(), arg0.getY());
        }
        arg0.consume();
    }

    public void setFactory(ManeuverGraphFactory factory) {
        super.setFactory(factory);
        this.factory = factory;
    }

    public ManeuverGraphFactory getFactory() {
        return this.factory;
    }

    public static void main(String[] args) {
        IndividualPlanGraph graph = new IndividualPlanGraph(new PlanType(new MissionType()));
        graph.setBackground(Color.white);
        GuiUtils.testFrame(new JScrollPane(graph), "Individual Plan Editor");
        ManeuverNode node = new ManeuverNode(new FollowPath());
        node.getUserObject().setInitialManeuver(true);
        node.setPosition(new Point2D.Double(30.0, 56.0));
        node.setFinalNode(true);
        graph.addNode(node);
        ManeuverNode node2 = new ManeuverNode(new Goto());
        node2.getUserObject().setInitialManeuver(false);
        node2.setPosition(new Point2D.Double(120.0, 56.0));
        node2.setFinalNode(false);
        node2.setInitialNode(true);
        graph.addNode(node2);
        ManeuverTransition transition = new ManeuverTransition();
        transition.setSourceNodeID(node2.getID());
        transition.setTargetNodeID(node.getID());
        graph.addEdge(transition);
        ManeuverTransition transition2 = new ManeuverTransition();
        transition2.setSourceNodeID(node.getID());
        transition2.setTargetNodeID(node2.getID());
        graph.addEdge(transition2);
        ManeuverTransition loop = new ManeuverTransition();
        loop.setSourceNodeID(node.getID());
        loop.setTargetNodeID(node.getID());
        graph.addEdge(loop);
        ManeuverNode n1 = (ManeuverNode)graph.addNode();
        ManeuverNode n2 = (ManeuverNode)graph.addNode();
        graph.addEdge(n1.getID(), n2.getID());
    }

    public PlanType getPlan() {
        return this.plan;
    }
}

