/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import javax.swing.JOptionPane;
import pt.lsts.neptus.graph.GraphElementFactory;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverFactory;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.planeditor.ManeuverNode;
import pt.lsts.neptus.planeditor.ManeuverTransition;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

public class ManeuverGraphFactory
implements GraphElementFactory<ManeuverNode, ManeuverTransition> {
    private MissionType mission = null;
    private PlanType plan = null;
    private ManeuverFactory mf = null;

    public ManeuverGraphFactory(MissionType mt, PlanType plan) {
        this.mission = mt;
        this.plan = plan;
        this.mf = new ManeuverFactory(VehiclesHolder.getVehicleById(plan.getVehicle()));
    }

    @Override
    public ManeuverTransition createEdge() {
        return new ManeuverTransition();
    }

    @Override
    public ManeuverNode createNode() {
        Object[] avTypes = this.getManeuverNames();
        int index = 0;
        if (avTypes.length != 1) {
            index = JOptionPane.showOptionDialog(null, "Set maneuver type", "Set type...", 2, 3, null, avTypes, avTypes[0]);
        }
        if (index == -1) {
            return null;
        }
        Maneuver man = this.createManeuver(avTypes[index]);
        int i = 1;
        while (this.plan.getGraph().getManeuver(man.getType() + i) != null) {
            ++i;
        }
        man.setId(man.getType() + i);
        this.plan.getGraph().addManeuver(man);
        if (man instanceof LocatedManeuver) {
            ((LocatedManeuver)((Object)man)).getManeuverLocation().setLocation(new LocationType(this.mission.getHomeRef()));
        }
        return new ManeuverNode(man);
    }

    public String[] getManeuverNames() {
        return this.mf.getAvailableManeuversIDs();
    }

    public Maneuver createManeuver(String maneuverType) {
        return this.mf.getManeuver(maneuverType);
    }
}

