/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Vector;
import pt.lsts.neptus.graph.DefaultNode;
import pt.lsts.neptus.graph.NeptusEdgeElement;
import pt.lsts.neptus.graph.NeptusGraph;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.mp.Maneuver;

public class ManeuverNode
extends DefaultNode<Maneuver> {
    public static boolean showManeuverName = true;

    @Override
    public String getElementName() {
        return "Man";
    }

    @Override
    public void paint(Graphics2D g, NeptusGraph graph) {
        super.paint(g, graph);
        g.setTransform(graph.getCurrentTransform());
        g.translate(this.getPosition().getX(), this.getPosition().getY());
        String manType = this.getUserObject().getClass().getSimpleName();
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(manType, g);
        g.setColor(new Color(50, 100, 200));
        bounds = g.getFontMetrics().getStringBounds(manType, g);
        g.drawString(manType, (float)(-bounds.getWidth()) / 2.0f, (float)circleRadius + 12.0f);
    }

    public ManeuverNode(Maneuver maneuver) {
        this.setID(maneuver.getId());
        this.setUserObject(maneuver);
    }

    @Override
    public void setUserObject(Maneuver maneuver) {
        this.object = maneuver;
        this.setInitialNode(maneuver.isInitialManeuver());
        this.setPosition(new Point2D.Double(maneuver.getXPosition(), maneuver.getYPosition()));
    }

    @Override
    public Maneuver getUserObject() {
        ((Maneuver)this.object).setInitialManeuver(this.isInitialNode());
        ((Maneuver)this.object).setXPosition((int)this.getPosition().getX());
        ((Maneuver)this.object).setYPosition((int)this.getPosition().getY());
        return (Maneuver)this.object;
    }

    @Override
    public void addOutgoingEdge(NeptusEdgeElement edge) {
        super.addOutgoingEdge(edge);
        this.getUserObject().addTransition(edge.getTargetNodeID(), edge.getUserObject().toString());
    }

    @Override
    public void removeIncomingEdge(NeptusEdgeElement edge) {
        super.removeIncomingEdge(edge);
        this.getUserObject().removeTransition(edge.getTargetNodeID());
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getID() + " properties";
    }

    @Override
    public DefaultProperty[] getProperties() {
        if (this.getUserObject() instanceof PropertiesProvider) {
            Vector<DefaultProperty> allProps = new Vector<DefaultProperty>();
            allProps.addAll(Arrays.asList(super.getProperties()));
            allProps.addAll(Arrays.asList(this.getUserObject().getProperties()));
            return allProps.toArray(new DefaultProperty[0]);
        }
        return super.getProperties();
    }

    @Override
    public void setProperties(Property[] properties) {
        if (this.getUserObject() instanceof PropertiesProvider) {
            this.getUserObject().setProperties(properties);
        }
        super.setProperties(properties);
    }

    @Override
    public int getMaxX() {
        return super.getMaxX();
    }

    @Override
    public int getMaxY() {
        return super.getMaxY() + 12;
    }
}

