/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanPropertiesPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, Maneuver> pivotTable = new LinkedHashMap();
    private LinkedHashMap<String, DefaultProperty> props = new LinkedHashMap();
    private LinkedHashMap<String, PropertyEditor> propEditors = new LinkedHashMap();
    private static Vector<String> forbiddenProps = new Vector();

    public PlanPropertiesPanel(PlanType plan) {
        for (Maneuver man : plan.getGraph().getAllManeuvers()) {
            if (this.pivotTable.containsKey(man.getType())) continue;
            this.pivotTable.put(man.getType(), (Maneuver)man.clone());
            for (DefaultProperty dp : man.getProperties()) {
                if (forbiddenProps.contains(dp.getName()) || this.props.containsKey(dp.getName())) continue;
                this.props.put(dp.getName(), dp);
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        Object[] keys = this.props.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            JPanel tmp = new JPanel(new TableLayout(new double[][]{{3.0, 150.0, 3.0, 150.0, 3.0, 90.0, 3.0}, {3.0, 30.0, 3.0}}));
            PropertyEditor editor = PropertiesEditor.getPropertyEditorRegistry().getEditor((Property)this.props.get(keys[i]));
            this.propEditors.put((String)keys[i], editor);
            tmp.add((Component)new JLabel(this.props.get(keys[i]).getDisplayName()), "1,1");
            editor.setValue(this.props.get(keys[i]).getValue());
            Component comp = editor.getCustomEditor();
            if (comp instanceof JFormattedTextField) {
                ((JFormattedTextField)comp).setLocale(Locale.US);
            }
            tmp.add(editor.getCustomEditor(), "3,1");
            JButton apply = new JButton("Apply");
            apply.setActionCommand((String)keys[i]);
            apply.addActionListener(this);
            tmp.add((Component)apply, "5,1");
            if (i % 2 == 1) {
                tmp.setBackground(tmp.getBackground().darker());
            }
            this.add(tmp);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String propName = e.getActionCommand();
        PropertyEditor editor = this.propEditors.get(propName);
        NeptusLog.pub().info((Object)("<###> " + propName + " = " + editor.getValue()));
    }

    static {
        forbiddenProps.add("ID");
        forbiddenProps.add("Initial Maneuver");
    }
}

