/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import pt.lsts.neptus.types.map.PlanElement;

public class PlanRotatedEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected PlanElement plan;
    protected double dragN;
    protected double dragE;

    public PlanRotatedEdit(PlanElement plan, double dragN, double dragE) {
        this.plan = plan;
        this.dragE = dragE;
        this.dragN = dragN;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof PlanRotatedEdit && ((PlanRotatedEdit)anEdit).plan == this.plan) {
            PlanRotatedEdit other = (PlanRotatedEdit)anEdit;
            this.dragE += other.dragE;
            this.dragN += other.dragN;
            return true;
        }
        return false;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.plan.translatePlan(this.dragN, this.dragE, 0.0);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.plan.translatePlan(-this.dragN, -this.dragE, 0.0);
    }
}

