/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.mission.ActionType;
import pt.lsts.neptus.types.mission.ConditionType;
import pt.lsts.neptus.types.mission.TransitionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;

public class PlanTransitionsSimpleEditor
extends JPanel {
    private PlanType plan = null;
    private String[] nodeStrList = null;
    private Vector<PlanTransitionGuiPanel> toRemoveFromPlanGraph = null;
    private JPanel holder;
    private JPanel buttonBarPanel;
    private JScrollPane scrollHolder;
    private JButton okButton;
    private JButton cancelButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton clearSelectionButton;
    private AbstractAction okAction;
    private AbstractAction cancelAction;
    private AbstractAction addAction;
    private AbstractAction removeAction;
    private AbstractAction clearSelectionAction;

    public PlanTransitionsSimpleEditor(PlanType plan) {
        this.plan = plan;
        this.initializeActions();
        this.initialize();
    }

    private void initialize() {
        this.toRemoveFromPlanGraph = new Vector();
        Vector<String> nodes = new Vector<String>();
        for (Maneuver maneuver : this.plan.getGraph().getAllManeuvers()) {
            nodes.add(maneuver.getId());
        }
        this.nodeStrList = nodes.toArray(new String[nodes.size()]);
        this.setLayout(new BorderLayout(5, 10));
        this.holder = new JPanel();
        this.holder.setLayout(new BoxLayout(this.holder, 3));
        this.holder.setSize(100, 60);
        for (XmlOutputMethods xmlOutputMethods : this.plan.getGraph().getAllEdges()) {
            PlanTransitionGuiPanel tEd = new PlanTransitionGuiPanel(((TransitionType)xmlOutputMethods).getSourceManeuver(), ((TransitionType)xmlOutputMethods).getTargetManeuver(), ((TransitionType)xmlOutputMethods).getCondition().getStringRepresentation(), ((TransitionType)xmlOutputMethods).getAction().getStringRepresentation(), this.nodeStrList);
            tEd.transition = xmlOutputMethods;
            this.holder.add(tEd);
        }
        this.scrollHolder = new JScrollPane(this.holder);
        this.add(this.scrollHolder);
        Dimension buttonDimension = new Dimension(80, 30);
        this.okButton = new JButton(this.okAction);
        this.okButton.setSize(buttonDimension);
        this.cancelButton = new JButton(this.cancelAction);
        this.cancelButton.setSize(buttonDimension);
        this.addButton = new JButton(this.addAction);
        this.addButton.setSize(buttonDimension);
        this.removeButton = new JButton(this.removeAction);
        this.removeButton.setSize(buttonDimension);
        this.removeButton = new JButton(this.removeAction);
        this.removeButton.setSize(buttonDimension);
        this.clearSelectionButton = new JButton(this.clearSelectionAction);
        this.clearSelectionButton.setSize(buttonDimension);
        this.buttonBarPanel = new JPanel();
        this.buttonBarPanel.setLayout(new FlowLayout(2));
        this.buttonBarPanel.add(this.addButton);
        this.buttonBarPanel.add(Box.createHorizontalStrut(10));
        this.buttonBarPanel.add(this.removeButton);
        this.buttonBarPanel.add(this.clearSelectionButton);
        this.buttonBarPanel.add(Box.createHorizontalStrut(10));
        this.buttonBarPanel.add(this.okButton);
        this.buttonBarPanel.add(this.cancelButton);
        GuiUtils.reactEscapeKeyPress(this.cancelButton);
        this.add((Component)this.buttonBarPanel, "South");
    }

    private void initializeActions() {
        this.okAction = new AbstractAction(I18n.text("Save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanTransitionsSimpleEditor.this.updatePlanWithModifiedTransitions();
                Window window = SwingUtilities.getWindowAncestor(PlanTransitionsSimpleEditor.this);
                if (window != null) {
                    window.setVisible(false);
                    window.dispose();
                }
            }
        };
        this.cancelAction = new AbstractAction(I18n.text("Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = SwingUtilities.getWindowAncestor(PlanTransitionsSimpleEditor.this);
                if (window != null) {
                    window.setVisible(false);
                    window.dispose();
                }
            }
        };
        this.addAction = new AbstractAction(I18n.text("Add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = -1;
                for (int i = 0; i < PlanTransitionsSimpleEditor.this.holder.getComponentCount(); ++i) {
                    try {
                        PlanTransitionGuiPanel pt = (PlanTransitionGuiPanel)PlanTransitionsSimpleEditor.this.holder.getComponent(i);
                        if (!pt.selCheckBox.isSelected()) continue;
                        index = i;
                        break;
                    }
                    catch (ClassCastException e2) {
                        // empty catch block
                    }
                }
                PlanTransitionGuiPanel tEd = new PlanTransitionGuiPanel("", "", "ManeuverIsDone", "", PlanTransitionsSimpleEditor.this.nodeStrList);
                if (index < 0) {
                    PlanTransitionsSimpleEditor.this.holder.add(tEd);
                } else {
                    PlanTransitionsSimpleEditor.this.holder.add((Component)tEd, index);
                }
                PlanTransitionsSimpleEditor.this.holder.invalidate();
                PlanTransitionsSimpleEditor.this.holder.validate();
                PlanTransitionsSimpleEditor.this.scrollHolder.invalidate();
                PlanTransitionsSimpleEditor.this.scrollHolder.validate();
            }
        };
        this.removeAction = new AbstractAction(I18n.text("Remove Selected")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component comp : PlanTransitionsSimpleEditor.this.holder.getComponents()) {
                    try {
                        PlanTransitionGuiPanel pt = (PlanTransitionGuiPanel)comp;
                        if (!pt.selCheckBox.isSelected()) continue;
                        PlanTransitionsSimpleEditor.this.holder.remove(pt);
                        if (pt.transition == null) continue;
                        PlanTransitionsSimpleEditor.this.toRemoveFromPlanGraph.add(pt);
                    }
                    catch (ClassCastException e2) {
                        // empty catch block
                    }
                }
                PlanTransitionsSimpleEditor.this.holder.invalidate();
                PlanTransitionsSimpleEditor.this.holder.validate();
                PlanTransitionsSimpleEditor.this.scrollHolder.invalidate();
                PlanTransitionsSimpleEditor.this.scrollHolder.validate();
                PlanTransitionsSimpleEditor.this.holder.repaint();
            }
        };
        this.clearSelectionAction = new AbstractAction(I18n.text("Clear Selection")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component comp : PlanTransitionsSimpleEditor.this.holder.getComponents()) {
                    try {
                        PlanTransitionGuiPanel pt = (PlanTransitionGuiPanel)comp;
                        pt.selCheckBox.setSelected(false);
                    }
                    catch (ClassCastException e2) {
                        // empty catch block
                    }
                }
            }
        };
    }

    protected void updatePlanWithModifiedTransitions() {
        LinkedHashMap<String, TransitionType> transitions = this.plan.getGraph().getTransitions();
        for (Component comp : this.holder.getComponents()) {
            try {
                PlanTransitionGuiPanel pt = (PlanTransitionGuiPanel)comp;
                if (pt.transition == null) {
                    pt.transition = new TransitionType((String)pt.sourceComboBox.getSelectedItem(), (String)pt.targetComboBox.getSelectedItem());
                    pt.transition.setId(NameNormalizer.getRandomID());
                    ConditionType condT = new ConditionType();
                    condT.setCondition(pt.conditionPane.getText());
                    pt.transition.setCondition(condT);
                    ActionType actT = new ActionType();
                    actT.setAction(pt.actionPane.getText());
                    pt.transition.setAction(actT);
                    transitions.put(pt.transition.getId(), pt.transition);
                } else {
                    pt.transition.setSourceManeuver((String)pt.sourceComboBox.getSelectedItem());
                    pt.transition.setTargetManeuver((String)pt.targetComboBox.getSelectedItem());
                    pt.transition.getCondition().setCondition(pt.conditionPane.getText());
                    pt.transition.getAction().setAction(pt.actionPane.getText());
                }
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
            for (PlanTransitionGuiPanel pttr : this.toRemoveFromPlanGraph) {
                if (pttr.transition == null) continue;
                transitions.remove(pttr.transition.getId());
            }
        }
    }

    public void clean() {
        this.plan = null;
        this.toRemoveFromPlanGraph.clear();
        this.holder.removeAll();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clean();
    }

    public static void main(String[] args) {
        ConsoleParse.consoleLayoutLoader("conf/consoles/seacon-basic.ncon");
    }

    private static class ConditionActionView
    extends PlainView {
        HashMap<Pattern, Color> patternColors = new LinkedHashMap<Pattern, Color>();

        public ConditionActionView(Element element) {
            super(element);
            this.getDocument().putProperty("tabSize", 4);
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
            Document doc = this.getDocument();
            String text = doc.getText(p0, p1 - p0);
            Segment segment = this.getLineBuffer();
            TreeMap<Integer, Integer> startMap = new TreeMap<Integer, Integer>();
            TreeMap<Integer, Color> colorMap = new TreeMap<Integer, Color>();
            for (Map.Entry<Pattern, Color> entry : this.patternColors.entrySet()) {
                Matcher matcher = entry.getKey().matcher(text);
                while (matcher.find()) {
                    startMap.put(matcher.start(1), matcher.end());
                    colorMap.put(matcher.start(1), entry.getValue());
                }
            }
            int i = 0;
            for (Map.Entry entry : startMap.entrySet()) {
                int start = (Integer)entry.getKey();
                int end = (Integer)entry.getValue();
                if (i < start) {
                    graphics.setColor(Color.black);
                    doc.getText(p0 + i, start - i, segment);
                    x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
                }
                graphics.setColor((Color)colorMap.get(start));
                i = end;
                doc.getText(p0 + start, i - start, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
            }
            if (i < text.length()) {
                graphics.setColor(Color.black);
                doc.getText(p0 + i, text.length() - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            return x;
        }
    }

    private static class ActionView
    extends ConditionActionView {
        private static String GENERIC_TXT = "[A-Za-z]+[A-Za-z0-9\\-_]*(:[A-Za-z]+[A-Za-z0-9\\-_]+)?";
        private static String PAT_1;
        private static String PAT1;

        public ActionView(Element element) {
            super(element);
            this.patternColors.put(Pattern.compile(PAT1), Color.GREEN.darker());
        }

        static {
            PAT1 = PAT_1 = "(" + GENERIC_TXT + ")(;[ ]?(" + GENERIC_TXT + "))*";
        }
    }

    private static class ConditionView
    extends ConditionActionView {
        private static String GENERIC_TXT = "[A-Za-z]+[A-Za-z0-9\\-_]*(:[A-Za-z]+[A-Za-z0-9\\-_]+)?";
        private static String PAT_ATR = "\\w*\\=\\w*(\"[^\"]*\")";
        private static String PAT_COND = "((~?" + GENERIC_TXT + ")(\\[(" + PAT_ATR + "(;?|(;" + PAT_ATR + "))*)\\])?)";
        private static String PAT_1 = "(" + PAT_COND + "( [&|] " + PAT_COND + ")?)";
        private static String PAT_2 = "(" + PAT_1 + "( [&|] " + PAT_1 + ")*)";
        private static String PAT_3 = "(" + PAT_2 + "|(~?\\([ ]*" + PAT_2 + "[ ]*\\)))";
        private static String PAT1 = PAT_3 + "( [&|] " + PAT_3 + ")*";

        public ConditionView(Element element) {
            super(element);
            this.patternColors.put(Pattern.compile(PAT1), Color.GREEN.darker());
        }
    }

    private static class ActionStyleEdtorKit
    extends StyledEditorKit {
        private ViewFactory viewFactory = new ViewFactory(){

            @Override
            public View create(Element elem) {
                return new ActionView(elem);
            }
        };

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }

        @Override
        public String getContentType() {
            return "text/imc-act";
        }
    }

    private static class ConditionStyleEdtorKit
    extends StyledEditorKit {
        private ViewFactory viewFactory = new ViewFactory(){

            @Override
            public View create(Element elem) {
                return new ConditionView(elem);
            }
        };

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }

        @Override
        public String getContentType() {
            return "text/imc-cond";
        }
    }

    static class PlanTransitionGuiPanel
    extends JPanel {
        TransitionType transition = null;
        String[] nodesStrList = null;
        JCheckBox selCheckBox = null;
        JComboBox<?> sourceComboBox = null;
        JComboBox<?> targetComboBox = null;
        JTextPane conditionPane = null;
        JTextPane actionPane = null;

        public PlanTransitionGuiPanel(String source, String target, String condition, String action, String[] nodesStrList) {
            this.sourceComboBox = new JComboBox<String>(nodesStrList);
            this.targetComboBox = new JComboBox<String>(nodesStrList);
            this.conditionPane = new JTextPane();
            this.conditionPane.setEditorKitForContentType("text/imc-cond", new ConditionStyleEdtorKit());
            this.conditionPane.setContentType("text/imc-cond");
            this.conditionPane.setText(condition);
            this.conditionPane.setEditable(false);
            this.actionPane = new JTextPane();
            this.actionPane.setEditorKitForContentType("text/imc-act", new ActionStyleEdtorKit());
            this.actionPane.setContentType("text/imc-act");
            this.actionPane.setText(action);
            this.actionPane.setEditable(false);
            this.sourceComboBox.setSelectedItem(source);
            this.targetComboBox.setSelectedItem(target);
            this.initialize();
        }

        private void initialize() {
            this.selCheckBox = new JCheckBox();
            JScrollPane conditionPaneScroll = new JScrollPane(this.conditionPane, 20, 30);
            JScrollPane actionPaneScroll = new JScrollPane(this.actionPane, 20, 30);
            JLabel aL = new JLabel("<html><b>>");
            JLabel gL = new JLabel("<html><b>/");
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setAutoCreateContainerGaps(true);
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.selCheckBox).addComponent(this.sourceComboBox, 40, 80, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(aL).addGap(10, 10, 10).addComponent(this.targetComboBox).addGap(20, 20, 20).addComponent(conditionPaneScroll, 90, 180, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(gL).addGap(10, 10, 10).addComponent(actionPaneScroll, 90, 180, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent(this.selCheckBox).addComponent(this.sourceComboBox, 10, 10, 30).addComponent(aL).addComponent(this.targetComboBox).addComponent(conditionPaneScroll, 40, 60, Short.MAX_VALUE).addComponent(gL).addComponent(actionPaneScroll, 40, 60, Short.MAX_VALUE));
            groupLayout.linkSize(0, this.sourceComboBox, this.targetComboBox);
            groupLayout.linkSize(0, conditionPaneScroll, actionPaneScroll);
            groupLayout.linkSize(0, aL, gL);
            groupLayout.linkSize(1, this.sourceComboBox, this.targetComboBox, aL, gL);
            groupLayout.linkSize(1, conditionPaneScroll, actionPaneScroll);
        }
    }
}

