/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.planeditor;

import java.util.Vector;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanValidator {
    public static String[] validatePlan(PlanType plan) {
        Vector<String> errors = new Vector<String>();
        String type = plan.getVehicleType().getType();
        if (type.equals("AUV")) {
            errors.addAll(PlanValidator.validateAUVPlan(plan));
        }
        if (type.equals("UAV")) {
            errors.addAll(PlanValidator.validateUAVPlan(plan));
        }
        return errors.toArray(new String[0]);
    }

    private static Vector<String> validateAUVPlan(PlanType plan) {
        Vector<String> errors = new Vector<String>();
        for (Maneuver m : plan.getGraph().getAllManeuvers()) {
            LocationType loc;
            if (!(m instanceof LocatedManeuver) || !((loc = new LocationType(((LocatedManeuver)((Object)m)).getManeuverLocation())).getAllZ() < 0.0)) continue;
            errors.add("The maneuver <font color='#000066'>" + m.getId() + "</font> has negative depth. (" + loc.getAllZ() + " m)");
        }
        return errors;
    }

    private static Vector<String> validateUAVPlan(PlanType plan) {
        Vector<String> errors = new Vector<String>();
        for (Maneuver m : plan.getGraph().getAllManeuvers()) {
            LocationType loc;
            if (!(m instanceof LocatedManeuver) || !((loc = new LocationType(((LocatedManeuver)((Object)m)).getManeuverLocation())).getAllZ() > 0.0)) continue;
            errors.add("The maneuver <font color='#000066'>" + m.getId() + "</font> has negative altitude. (" + loc.getAllZ() + " m)");
        }
        return errors;
    }
}

