/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.ReflectionUtil;

public class ExtensionsBag {
    private LinkedHashMap<Class<?>, LinkedHashMap<String, Class<?>>> extensions = new LinkedHashMap();

    public ExtensionsBag(Class<?> ... extensionTypes) {
        for (Class<?> c : extensionTypes) {
            this.extensions.put(c, new LinkedHashMap());
        }
    }

    public void addPlugin(String className) {
        try {
            Class<?> c = Class.forName(className);
            NeptusLog.pub().debug((Object)("loading '" + PluginUtils.getPluginName(c) + "'..."));
            boolean added = false;
            for (Class<?> intf : this.extensions.keySet()) {
                if (ReflectionUtil.hasInterface(c, intf) || ReflectionUtil.isSubclass(c, intf)) {
                    String name = PluginUtils.getPluginName(c);
                    if (name.isEmpty()) {
                        name = c.getSimpleName();
                    }
                    this.extensions.get(intf).put(name, c);
                }
                added = true;
            }
            if (!added) {
                System.err.println(c.getCanonicalName() + " not recognized");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public <T> LinkedHashMap<String, Class<? extends T>> listExtensions(Class<T> type) {
        LinkedHashMap<String, Class<T>> ret = new LinkedHashMap<String, Class<T>>();
        if (this.extensions.containsKey(type)) {
            for (Map.Entry<String, Class<?>> ent : this.extensions.get(type).entrySet()) {
                ret.put(ent.getKey(), ent.getValue());
            }
        }
        return ret;
    }

    public <T> T getPlugin(String name, Class<T> type, Object ... initParams) {
        if (!this.extensions.containsKey(type)) {
            NeptusLog.pub().warn((Object)("There is no such plugin type: " + type.getSimpleName()));
            return null;
        }
        if (!this.extensions.get(type).containsKey(name)) {
            NeptusLog.pub().warn((Object)("There is no such plugin: '" + name + "' (of type " + type.getSimpleName() + ")"));
            return null;
        }
        Class[] initTypes = new Class[initParams.length];
        for (int i = 0; i < initParams.length; ++i) {
            initTypes[i] = initParams[i].getClass();
        }
        try {
            if (initTypes.length > 0) {
                Class<?> c = this.extensions.get(type).get(name);
                Constructor<?> cons = c.getConstructor(initTypes);
                return (T)cons.newInstance(initParams);
            }
            return (T)this.extensions.get(type).get(name).newInstance();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            e.printStackTrace();
            return null;
        }
        catch (Error e) {
            NeptusLog.pub().error((Object)e);
            return null;
        }
    }
}

