/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.CommManagerStatusChangeListener;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.loader.NeptusMain;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

public abstract class MultiSystemIMCMessageListener {
    private String realListenerClientStr;
    private Vector<String> messagesToListen = new Vector();
    private boolean listenToAllSystems = false;
    private MessageListener<MessageInfo, IMCMessage> allSystemsListener = null;
    private Map<ImcId16, MessageListener<MessageInfo, IMCMessage>> systemsListen = Collections.synchronizedMap(new HashMap());
    private CommManagerStatusChangeListener comStatusListener = null;

    public MultiSystemIMCMessageListener(String realListenerClientStr) {
        this.realListenerClientStr = realListenerClientStr;
        this.initialize();
    }

    private void initialize() {
        this.initAllSystemsListener();
        this.initComStatusListener();
        ImcMsgManager.getManager().addStatusListener(this.comStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clean() {
        ImcMsgManager.getManager().removeStatusListener(this.comStatusListener);
        HashMap<ImcId16, MessageListener<MessageInfo, IMCMessage>> systemsListen = new HashMap<ImcId16, MessageListener<MessageInfo, IMCMessage>>();
        Map<ImcId16, MessageListener<MessageInfo, IMCMessage>> map = this.systemsListen;
        synchronized (map) {
            systemsListen.putAll(this.systemsListen);
            this.systemsListen.clear();
        }
        for (ImcId16 id : systemsListen.keySet()) {
            ImcMsgManager.getManager().removeListener((MessageListener)systemsListen.get(id), id);
        }
        systemsListen.clear();
    }

    private void initAllSystemsListener() {
        if (this.allSystemsListener != null) {
            return;
        }
        this.allSystemsListener = new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
                ImcId16 id;
                try {
                    id = new ImcId16(msg.getHeader().getValue("src"));
                }
                catch (Exception e) {
                    id = ImcId16.NULL_ID;
                }
                MultiSystemIMCMessageListener.this.newMessageFromSystem(id, info, msg);
            }
        };
    }

    private void initComStatusListener() {
        if (this.comStatusListener != null) {
            return;
        }
        this.comStatusListener = new CommManagerStatusChangeListener(){

            @Override
            public void managerStatusChanged(int status, String msg) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void managerSystemAdded(String systemId) {
                if (!MultiSystemIMCMessageListener.this.listenToAllSystems) {
                    return;
                }
                ImcId16 id = new ImcId16(systemId);
                boolean ret = ImcMsgManager.getManager().addListener(MultiSystemIMCMessageListener.this.allSystemsListener, id);
                Map map = MultiSystemIMCMessageListener.this.systemsListen;
                synchronized (map) {
                    if (ret) {
                        MultiSystemIMCMessageListener.this.systemsListen.put(id, MultiSystemIMCMessageListener.this.allSystemsListener);
                    }
                }
            }

            @Override
            public void managerSystemRemoved(String systemId) {
            }

            @Override
            public void managerSystemStatusChanged(String systemId, int status) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void managerVehicleAdded(VehicleType vehicle) {
                if (!MultiSystemIMCMessageListener.this.listenToAllSystems) {
                    return;
                }
                ImcId16 id = vehicle.getImcId();
                boolean ret = ImcMsgManager.getManager().addListener(MultiSystemIMCMessageListener.this.allSystemsListener, id);
                Map map = MultiSystemIMCMessageListener.this.systemsListen;
                synchronized (map) {
                    if (ret) {
                        MultiSystemIMCMessageListener.this.systemsListen.put(id, MultiSystemIMCMessageListener.this.allSystemsListener);
                    }
                }
            }

            @Override
            public void managerVehicleRemoved(VehicleType vehicle) {
            }

            @Override
            public void managerVehicleStatusChanged(VehicleType vehicle, int status) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getMessagesToListen() {
        Vector<String> vector = this.messagesToListen;
        synchronized (vector) {
            return this.messagesToListen.toArray(new String[this.messagesToListen.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMessagesToListen(String ... messages) {
        Vector<String> vector = this.messagesToListen;
        synchronized (vector) {
            this.messagesToListen.clear();
            if (messages != null) {
                for (String msg : messages) {
                    if (msg == null || "".equalsIgnoreCase(msg)) continue;
                    this.messagesToListen.add(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImcId16[] getSystemToListen() {
        Map<ImcId16, MessageListener<MessageInfo, IMCMessage>> map = this.systemsListen;
        synchronized (map) {
            return this.systemsListen.keySet().toArray(new ImcId16[this.systemsListen.size()]);
        }
    }

    public final void setSystemToListenStrings(String ... idsOrNames) {
        Vector<ImcId16> ids = new Vector<ImcId16>();
        for (String str : idsOrNames) {
            try {
                ImcId16 id = ImcId16.valueOf(str);
                ids.add(id);
            }
            catch (NumberFormatException e) {
                ImcSystem res = ImcSystemsHolder.lookupSystemByName(str);
                if (res != null) {
                    if (res.getId() == null) continue;
                    ids.add(res.getId());
                    continue;
                }
                VehicleType veh = VehiclesHolder.getVehicleById(str);
                if (veh == null || veh.getImcId() == null) continue;
                ids.add(veh.getImcId());
            }
        }
        this.setSystemToListen(ids.toArray(new ImcId16[ids.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSystemToListen(ImcId16 ... ids) {
        Vector<ImcId16> systemsToListen = new Vector<ImcId16>();
        Vector systemsToRemove = new Vector();
        Map<ImcId16, MessageListener<MessageInfo, IMCMessage>> map = this.systemsListen;
        synchronized (map) {
            this.initialize();
            this.listenToAllSystems = ids == null || ids.length == 0;
            systemsToListen.addAll(this.systemsListen.keySet());
        }
        systemsToRemove = (Vector)systemsToListen.clone();
        if (ids != null && ids.length != 0) {
            systemsToListen.clear();
            for (ImcId16 id : ids) {
                systemsToListen.add(id);
            }
        }
        for (ImcId16 id : systemsToRemove.toArray(new ImcId16[systemsToRemove.size()])) {
            boolean ret;
            if (systemsToListen.contains(id)) {
                systemsToRemove.remove(id);
                continue;
            }
            MessageListener<MessageInfo, IMCMessage> list = this.systemsListen.get(id);
            if (list == null || !(ret = ImcMsgManager.getManager().removeListener(list, id))) continue;
            Vector<ImcId16> vector = systemsToListen;
            synchronized (vector) {
                this.systemsListen.remove(id);
            }
        }
        if (ids == null || ids.length == 0) {
            systemsToListen.addAll(ImcMsgManager.getManager().getCommInfo().keySet());
        }
        for (final ImcId16 id : systemsToListen) {
            MessageListener<MessageInfo, IMCMessage> list = this.systemsListen.get(id);
            if (list != null) continue;
            list = new MessageListener<MessageInfo, IMCMessage>(){

                public void onMessage(MessageInfo info, IMCMessage msg) {
                    MultiSystemIMCMessageListener.this.newMessageFromSystem(id, info, msg);
                }
            };
            boolean ret = ImcMsgManager.getManager().addListener(list, id);
            if (!ret) continue;
            Vector<ImcId16> vector = systemsToListen;
            synchronized (vector) {
                this.systemsListen.put(id, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newMessageFromSystem(ImcId16 id, MessageInfo info, IMCMessage msg) {
        Vector<String> vector = this.messagesToListen;
        synchronized (vector) {
            if (this.messagesToListen.size() == 0 || this.messagesToListen.contains(msg.getAbbrev())) {
                this.messageArrived(id, msg);
            }
        }
    }

    public abstract void messageArrived(ImcId16 var1, IMCMessage var2);

    public String toString() {
        return this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "] working for " + this.realListenerClientStr;
    }

    public String getRealListenerClientStr() {
        return this.realListenerClientStr;
    }

    public static void main(String[] args) {
        NeptusMain.main(new String[0]);
        MultiSystemIMCMessageListener msl = new MultiSystemIMCMessageListener("Test"){

            @Override
            public void messageArrived(ImcId16 id, IMCMessage msg) {
                System.out.print(id + ":  ");
                msg.dump((OutputStream)System.out);
            }
        };
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>-------------- Change");
        msl.setSystemToListen(new ImcId16("00:16"));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>-------------- Change");
        msl.setMessagesToListen("EstimatedState", "Abort");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>-------------- Change");
        msl.setSystemToListen(new ImcId16("00:15"));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>-------------- Change");
        msl.setMessagesToListen(new String[0]);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>-------------- Change");
        msl.setSystemToListenStrings(new String[0]);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>-------------- Change");
        msl.setSystemToListenStrings("00:16", "lauv-seacon-3");
    }
}

