/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Method;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.plugins.PropertyType;
import pt.lsts.neptus.util.ReflectionUtil;

public class PluginProperty
extends DefaultProperty {
    private static final long serialVersionUID = 1L;
    private boolean editionModeOnly = true;

    public PluginProperty(Property prop) {
        this.setName(prop.getName());
        this.setType(prop.getClass());
        this.setDisplayName(prop.getDisplayName());
        this.setCategory(prop.getCategory());
        this.setValue(prop.getValue());
        this.setShortDescription(prop.getShortDescription());
    }

    public PluginProperty(String name, Class<?> clazz, Object value) {
        this.setName(name);
        this.setDisplayName(name);
        this.setShortDescription(name);
        this.setType(clazz);
        this.setValue(value);
    }

    public void enableEditByUser() {
        this.editionModeOnly = false;
    }

    public boolean isEditByUser() {
        return !this.editionModeOnly;
    }

    public String serialize() {
        if (this.getType().equals(IMCMessage.class)) {
            IMCMessage m = (IMCMessage)this.getValue();
            if (m == null || m.getMgid() == 65535) {
                return "";
            }
            return m.asXml(true);
        }
        return this.getValue() != null ? this.getValue().toString() : null;
    }

    public void unserialize(String value) throws Exception {
        Object m;
        if (this.getType().equals(String.class)) {
            this.setValue(value);
            return;
        }
        if (this.getType().equals(File.class)) {
            this.setValue(new File(value));
            return;
        }
        if (this.getType().equals(Color.class)) {
            String color = value.replace("java.awt.Color[", "");
            color = color.replaceAll("[\\]rgb=]", "");
            String[] rgb = color.split(",");
            this.setValue(new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2])));
            return;
        }
        if (this.getType().equals(ColorMap.class)) {
            String color = value;
            if (ColorMapFactory.colorMapNamesList.contains(color)) {
                ColorMap colorMap = ColorMapFactory.getColorMapByName(color);
                this.setValue(colorMap);
            }
            return;
        }
        if (ReflectionUtil.hasInterface(this.getType(), PropertyType.class)) {
            PropertyType pt = (PropertyType)this.getValue();
            pt.fromString(value);
            this.setValue(pt);
            return;
        }
        if (this.getType().getEnumConstants() != null) {
            this.setValue(Enum.valueOf(this.getType(), value));
            return;
        }
        if (this.getType().equals(Boolean.class) || this.getType().equals(Boolean.TYPE)) {
            this.setValue(value.equalsIgnoreCase("true") || value.equals("1"));
            return;
        }
        if (this.getType().equals(Long.TYPE) || this.getType().equals(Integer.TYPE) || this.getType().equals(Short.TYPE) || this.getType().equals(Byte.TYPE)) {
            try {
                Double val = Double.parseDouble(value);
                this.setValue(val.longValue());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getType().equals(Double.TYPE) || this.getType().equals(Float.TYPE)) {
            try {
                Double val = Double.parseDouble(value);
                this.setValue(val);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (IMCMessage.class.isAssignableFrom(this.getType())) {
            try {
                m = IMCDefinition.getInstance().create(this.getType(), new Object[0]);
                IMCMessage.parseXml((String)value);
                this.setValue(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            m = this.getType().getMethod("valueOf", String.class);
            Object o = ((Method)m).invoke((Object)value, new Object[0]);
            this.setValue(o);
            return;
        }
        catch (Exception e) {
            try {
                Method m2 = this.getType().getMethod("valueOf", String.class);
                Object o = m2.invoke(this.getValue(), value);
                this.setValue(o);
                return;
            }
            catch (Exception e2) {
                throw new Exception("Object type not supported: " + this.getName() + "@" + this.getType().getSimpleName(), e2);
            }
        }
    }

    public void validate(Object value) throws Exception {
    }
}

