/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.spi.ServiceRegistry;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.io.IOUtils;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.EnumEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PropertyType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.ReflectionUtil;

public class PluginUtils {
    public static String DEFAULT_ICON = "images/plugin.png";
    private static final Class[] parameters = new Class[]{URL.class};
    public static final File PLUGINS_DIR = new File(".", "plugins");
    private static boolean pluginsLoaded = false;
    public static Map<Class<?>, LinkedHashMap<String, PluginProperty>> defaultValuesProperties = Collections.synchronizedMap(new LinkedHashMap());

    public static String getPluginName(Class<?> clazz) {
        PluginDescription pd = clazz.getAnnotation(PluginDescription.class);
        String name = pd != null && !pd.name().isEmpty() ? pd.name() : clazz.getSimpleName();
        return name;
    }

    public static String getPluginI18nName(Class<?> clazz) {
        return PluginUtils.i18nTranslate(PluginUtils.getPluginName(clazz));
    }

    public static String i18nTranslate(String txt) {
        String txt1 = txt.replaceFirst("(_\\d+)$", "");
        String translation = I18n.text(txt1);
        return translation;
    }

    public static String getLocalizedPluginName(Class<?> clazz) {
        return I18n.textAdvanced("PLUGINNAME_" + clazz.getSimpleName(), PluginUtils.getPluginName(clazz), clazz);
    }

    public static String getPluginDescription(Class<?> clazz) {
        PluginDescription pd = clazz.getAnnotation(PluginDescription.class);
        String description = pd != null ? pd.description() : clazz.getSimpleName();
        if (description == null || description.length() == 0) {
            description = PluginUtils.getLocalizedPluginName(clazz);
        }
        return I18n.textAdvanced("PLUGINDESC_" + clazz.getSimpleName(), description, clazz);
    }

    public static boolean isPluginActive(Class<?> clazz) {
        PluginDescription pd = clazz.getAnnotation(PluginDescription.class);
        return pd != null && pd.active();
    }

    public static String getPluginIcon(Class<?> clazz) {
        PluginDescription pd = clazz.getAnnotation(PluginDescription.class);
        String icon = "";
        if (pd != null) {
            icon = pd.icon();
        }
        if (icon.length() == 0 || ClassLoader.getSystemResource(icon) == null) {
            return DEFAULT_ICON;
        }
        return icon;
    }

    public static LinkedHashMap<String, PluginProperty> getProperties(Object obj, boolean forEdit) {
        LinkedHashMap<String, PluginProperty> props = new LinkedHashMap<String, PluginProperty>();
        Map<String, PluginProperty> defaults = PluginUtils.getDefaultsValues(obj);
        for (Field f : PluginUtils.getFields(obj)) {
            PluginProperty pp;
            String defaultStr = null;
            if (defaults.containsKey(f.getName())) {
                defaultStr = defaults.get(f.getName()).serialize();
            }
            if ((pp = PluginUtils.createPluginProperty(obj, f, defaultStr, forEdit)) == null) continue;
            props.put(f.getName(), pp);
        }
        return props;
    }

    public static PluginProperty createPluginProperty(Object obj, Field f, boolean forEdit) {
        return PluginUtils.createPluginProperty(obj, f, null, forEdit);
    }

    public static PluginProperty createPluginProperty(Object obj, Field f) {
        return PluginUtils.createPluginProperty(obj, f, null, true);
    }

    public static PluginProperty createPluginProperty(Object obj, Field f, String defaultValueString, boolean forEdit) {
        NeptusProperty a = f.getAnnotation(NeptusProperty.class);
        if (a != null) {
            f.setAccessible(true);
            String name = a.name();
            String desc = a.description();
            String defaultStr = "";
            if (defaultValueString != null && forEdit) {
                if (f.getType().getEnumConstants() != null) {
                    defaultValueString = I18n.text(defaultValueString);
                }
                defaultStr = "<br><i>[[" + I18n.text("Default value:") + " \"<b><code>" + defaultValueString + "</code></b>\"]]</i>";
            }
            Class<? extends PropertyEditor> editClass = null;
            String category = a.category();
            if (a.name().length() == 0) {
                name = f.getName();
            }
            if (a.description().length() == 0) {
                desc = f.getName();
            }
            if (a.editorClass() != PropertyEditor.class) {
                editClass = a.editorClass();
            }
            if (category == null || category.length() == 0) {
                category = I18n.text("Base");
            }
            Object o = null;
            try {
                o = f.get(null);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (o == null) {
                try {
                    o = f.get(obj);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            PluginProperty pp = new PluginProperty(name, f.getType(), o);
            pp.setShortDescription((forEdit ? I18n.text(desc) : desc) + defaultStr);
            pp.setEditable(a.editable());
            pp.setDisplayName(forEdit ? I18n.text(name) : name);
            if (category != null && category.length() > 0) {
                pp.setCategory(category);
            }
            if (editClass != null) {
                PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)pp, editClass);
            } else {
                if (ReflectionUtil.hasInterface(f.getType(), PropertyType.class)) {
                    PropertyType pt = (PropertyType)o;
                    PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)pp, pt.getPropertyEditor());
                }
                if (f.getType().getEnumConstants() != null && o != null) {
                    PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)pp, (PropertyEditor)((Object)new EnumEditor(o.getClass())));
                    PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)pp, (TableCellRenderer)new DefaultCellRenderer(){
                        {
                            this.setOpaque(false);
                        }

                        protected String convertToString(Object value) {
                            return I18n.text(value.toString());
                        }
                    });
                }
            }
            return pp;
        }
        return null;
    }

    public static void editPluginProperties(final Object obj, boolean editable) {
        PropertiesProvider provider = new PropertiesProvider(){

            @Override
            public void setProperties(Property[] properties) {
                PluginUtils.setPluginProperties(obj, properties);
            }

            @Override
            public String[] getPropertiesErrors(Property[] properties) {
                return null;
            }

            @Override
            public String getPropertiesDialogTitle() {
                return PluginUtils.getPluginName(obj.getClass()) + " properties";
            }

            @Override
            public DefaultProperty[] getProperties() {
                return PluginUtils.getPluginProperties(obj);
            }
        };
        PropertiesEditor.editProperties(provider, editable);
    }

    public static PluginProperty[] getPluginProperties(Object obj, boolean forEdit) {
        return PluginUtils.getProperties(obj, forEdit).values().toArray(new PluginProperty[0]);
    }

    public static PluginProperty[] getPluginProperties(Object obj) {
        return PluginUtils.getPluginProperties(obj, true);
    }

    public static void setPluginProperties(Object obj, Property[] props) {
        LinkedHashMap<String, PluginProperty> ps = new LinkedHashMap<String, PluginProperty>();
        for (Property p : props) {
            ps.put(p.getName(), new PluginProperty(p));
        }
        PluginUtils.setPluginProperties(obj, ps);
    }

    public static String[] validatePluginProperties(Object obj, Property[] props) {
        LinkedHashMap<String, PluginProperty> ps = new LinkedHashMap<String, PluginProperty>();
        for (Property p : props) {
            ps.put(p.getName(), new PluginProperty(p));
        }
        return PluginUtils.validatePluginProperties(obj, ps);
    }

    public static String[] validatePluginProperties(Object obj, LinkedHashMap<String, PluginProperty> props) {
        Vector<String> errors = new Vector<String>();
        Class<?> providerClass = obj.getClass();
        for (Field f : PluginUtils.getFields(providerClass)) {
            Object res;
            Method m;
            NeptusProperty a = f.getAnnotation(NeptusProperty.class);
            if (a == null) continue;
            String name = a.name();
            String fieldName = f.getName();
            if (name.length() == 0) {
                name = fieldName;
            }
            if (props.get(name) == null) continue;
            String validateMethodUpper = "validate" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String validateMethodLower = "validate" + Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            Object propValue = props.get(name).getValue();
            if (propValue == null) {
                NeptusLog.pub().debug((Object)("Property " + providerClass.getSimpleName() + "." + name + " has no method to validate user input!"));
                continue;
            }
            Class<Object> propClass = propValue.getClass();
            if (f.getType().isPrimitive()) {
                if (propClass == Double.class) {
                    propClass = Double.TYPE;
                } else if (propClass == Float.class) {
                    propClass = Float.TYPE;
                } else if (propClass == Byte.class) {
                    propClass = Byte.TYPE;
                } else if (propClass == Character.class) {
                    propClass = Character.TYPE;
                } else if (propClass == Short.class) {
                    propClass = Short.TYPE;
                } else if (propClass == Integer.class) {
                    propClass = Integer.TYPE;
                } else if (propClass == Long.class) {
                    propClass = Long.TYPE;
                } else if (propClass == Boolean.class) {
                    propClass = Boolean.TYPE;
                }
            }
            try {
                m = providerClass.getMethod(validateMethodUpper, propClass);
            }
            catch (NoSuchMethodException e1) {
                try {
                    m = providerClass.getMethod(validateMethodLower, propClass);
                }
                catch (NoSuchMethodException e) {
                    NeptusLog.pub().debug((Object)("Property " + providerClass.getSimpleName() + "." + name + " has no method to validate user input!"));
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
                continue;
            }
            try {
                res = m.invoke(obj, propValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            if (res == null) continue;
            errors.add(res.toString());
        }
        return errors.toArray(new String[0]);
    }

    private static Field[] getFields(Object o) {
        Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
        HashSet<Field> fields = new HashSet<Field>();
        for (Field f : c.getFields()) {
            fields.add(f);
        }
        for (Field f : c.getDeclaredFields()) {
            f.setAccessible(true);
            fields.add(f);
        }
        return fields.toArray(new Field[0]);
    }

    public static void setPluginProperties(Object obj, LinkedHashMap<String, PluginProperty> props) {
        Class<?> providerClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        for (Field f : PluginUtils.getFields(providerClass)) {
            Object propertyValue;
            PluginProperty property;
            NeptusProperty a = f.getAnnotation(NeptusProperty.class);
            if (a == null) continue;
            String name = a.name();
            if (a.name().length() == 0) {
                name = f.getName();
            }
            if ((property = props.get(name)) == null) {
                NeptusLog.pub().debug((Object)("Property " + name + " will not be saved."));
                continue;
            }
            try {
                propertyValue = property.getValue();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                continue;
            }
            try {
                if (!a.editable()) continue;
                f.set(obj, propertyValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    if ("int".equalsIgnoreCase(f.getGenericType().toString()) || "Integer".equalsIgnoreCase(f.getGenericType().toString())) {
                        String className = propertyValue.getClass().getName();
                        if (className.equals("java.lang.String")) {
                            f.set(obj, Integer.parseInt((String)propertyValue));
                            continue;
                        }
                        f.set(obj, ((Long)propertyValue).intValue());
                        continue;
                    }
                    if ("short".equalsIgnoreCase(f.getGenericType().toString())) {
                        f.set(obj, ((Long)propertyValue).shortValue());
                        continue;
                    }
                    if ("byte".equalsIgnoreCase(f.getGenericType().toString())) {
                        f.set(obj, ((Long)propertyValue).byteValue());
                        continue;
                    }
                    if (!"float".equalsIgnoreCase(f.getGenericType().toString())) continue;
                    f.set(obj, Float.valueOf(((Double)propertyValue).floatValue()));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (obj instanceof ConfigurationListener) {
            ((ConfigurationListener)obj).propertiesChanged();
        }
    }

    public static Properties saveProperties(Object obj, boolean clean) {
        try {
            LinkedHashMap<String, PluginProperty> ps = PluginUtils.getProperties(obj, false);
            LinkedHashMap<String, PluginProperty> defPs = new LinkedHashMap<String, PluginProperty>();
            if (clean) {
                Object[] keys;
                LinkedHashMap<String, PluginProperty> vl = PluginUtils.getDefaultsPropertyValues(obj);
                if (vl != null) {
                    defPs.putAll(vl);
                }
                for (Object key : keys = ps.keySet().toArray()) {
                    PluginProperty curP = ps.get(key);
                    PluginProperty defaultP = (PluginProperty)((Object)defPs.get(key));
                    if (curP != null && curP.serialize() != null && (defaultP == null || !curP.serialize().equals(defaultP.serialize()))) continue;
                    ps.remove(key);
                }
            }
            Properties props = new Properties();
            for (String key : ps.keySet()) {
                if (ps.get(key).getValue() == null) {
                    NeptusLog.pub().warn((Object)("Not saving plugin null property named " + key + "=" + (Object)((Object)ps.get(key))));
                    continue;
                }
                PluginProperty p = ps.get(key);
                props.setProperty(p.getName(), p.serialize());
            }
            return props;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static synchronized void extractDefaultFieldsValues(Object obj) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (!defaultValuesProperties.containsKey(clazz)) {
            LinkedHashMap defPs = new LinkedHashMap();
            LinkedHashMap<String, PluginProperty> vl = new LinkedHashMap<String, PluginProperty>();
            for (Field f : PluginUtils.getFields(obj)) {
                PluginProperty pp = PluginUtils.createPluginProperty(obj, f, null, false);
                if (pp == null) continue;
                vl.put(f.getName(), pp);
            }
            if (vl.size() > 0) {
                defPs.putAll(vl);
            }
            defaultValuesProperties.put(clazz, defPs);
        }
    }

    public static Map<String, PluginProperty> getDefaultsValues(Object obj) {
        Class<?> clazz;
        Map<String, PluginProperty> defs = new LinkedHashMap<String, PluginProperty>();
        Class<?> clazz2 = clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (defaultValuesProperties.containsKey(clazz)) {
            defs = Collections.unmodifiableMap((Map)defaultValuesProperties.get(clazz));
        }
        return defs;
    }

    private static LinkedHashMap<String, PluginProperty> getDefaultsPropertyValues(Object obj) {
        LinkedHashMap<String, PluginProperty> df;
        LinkedHashMap<String, PluginProperty> vl;
        LinkedHashMap<String, PluginProperty> defPs = new LinkedHashMap<String, PluginProperty>();
        Object defaults = null;
        try {
            defaults = (obj instanceof Class ? (Class<?>)obj : obj.getClass()).newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (defaults != null && !(obj instanceof Class) && (vl = PluginUtils.getProperties(defaults, false)) != null) {
            defPs.putAll(vl);
        }
        if ((df = defaultValuesProperties.get(obj instanceof Class ? (Class<?>)obj : obj.getClass())) != null) {
            defPs.putAll(df);
        }
        return defPs;
    }

    public static void saveProperties(String filename, boolean ignorePropertiesWithDefaultValues, Object obj) throws IOException {
        Properties props = PluginUtils.saveProperties(obj, ignorePropertiesWithDefaultValues);
        props.store(new FileOutputStream(filename), "Properties generated by Neptus");
    }

    public static void saveProperties(String filename, Object obj) throws IOException {
        PluginUtils.saveProperties(filename, false, obj);
    }

    public static void savePropertiesToXML(String filename, boolean ignorePropertiesWithDefaultValues, Object obj) throws IOException {
        Properties props = PluginUtils.saveProperties(obj, ignorePropertiesWithDefaultValues);
        props.storeToXML(new FileOutputStream(filename), "Properties generated by Neptus");
    }

    public static void savePropertiesToXML(String filename, Object obj) throws IOException {
        PluginUtils.savePropertiesToXML(filename, false, obj);
    }

    public static void loadProperties(String filename, Object obj) throws IOException {
        Properties props = new Properties();
        PluginUtils.loadProperties(filename, props, obj);
    }

    public static void loadProperties(String filename, Properties props, Object obj) throws IOException {
        if (new File(filename).exists()) {
            try {
                props.loadFromXML(new FileInputStream(filename));
            }
            catch (InvalidPropertiesFormatException e) {
                props.load(new FileReader(filename));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PluginUtils.loadProperties(props, obj);
    }

    public static void loadProperties(Properties props, Object obj) {
        PluginProperty[] ps;
        PluginUtils.extractDefaultFieldsValues(obj);
        for (PluginProperty p : ps = PluginUtils.getPluginProperties(obj, false)) {
            if (!props.containsKey(p.getName())) continue;
            try {
                p.unserialize(props.getProperty(p.getName().toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PluginUtils.setPluginProperties(obj, (Property[])ps);
    }

    public static String getConfigXml(Object obj) {
        Properties props = PluginUtils.saveProperties(obj, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.storeToXML(baos, "Generated by Neptus on " + new Date());
            String xml = baos.toString("utf-8");
            int start = xml.indexOf("<properties");
            return xml.substring(start);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<properties/>";
        }
    }

    public static void setConfigXml(Object obj, String xml) {
        Properties props = new Properties();
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n" + xml;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            props.loadFromXML(bais);
            PluginUtils.loadProperties(props, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadProperties(Object obj, String instanceName) {
        String propsFilename = "conf/plugins/" + obj.getClass().getSimpleName() + "-" + instanceName + ".properties";
        File propsFile = new File(propsFilename);
        if (propsFile.canRead()) {
            try {
                PluginUtils.loadProperties(propsFilename, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveProperties(Object obj, String instanceName) {
        new File("conf/plugins").mkdirs();
        String propsFilename = "conf/plugins/" + obj.getClass().getSimpleName() + "-" + instanceName + ".properties";
        try {
            PluginUtils.saveProperties(propsFilename, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final PropertiesProvider wrapIntoAPlugInPropertiesProvider(final Object objWithNeptusPropertyAnotation) {
        PropertiesProvider pp = new PropertiesProvider(){

            @Override
            public DefaultProperty[] getProperties() {
                return PluginUtils.getPluginProperties(objWithNeptusPropertyAnotation, true);
            }

            @Override
            public void setProperties(Property[] properties) {
                PluginUtils.setPluginProperties(objWithNeptusPropertyAnotation, properties);
            }

            @Override
            public String getPropertiesDialogTitle() {
                return PluginUtils.getPluginName(objWithNeptusPropertyAnotation.getClass()) + " parameters";
            }

            @Override
            public String[] getPropertiesErrors(Property[] properties) {
                return PluginUtils.validatePluginProperties(objWithNeptusPropertyAnotation, properties);
            }
        };
        return pp;
    }

    public static void extractFieldsWorker(Class<?> clazz, Vector<Field> dFA) {
        Field[] dFt;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Field fd : dFt = clazz.getDeclaredFields()) {
            if (fd.getAnnotation(NeptusProperty.class) == null) continue;
            boolean hasField = false;
            for (Field fdC : dFA) {
                if (!fdC.getName().equals(fd.getName())) continue;
                hasField = true;
                break;
            }
            if (hasField) continue;
            dFA.add(fd);
        }
        PluginUtils.extractFieldsWorker(clazz.getSuperclass(), dFA);
    }

    public static void loadPlugins() {
        if (!PLUGINS_DIR.isDirectory() || !PLUGINS_DIR.exists()) {
            NeptusLog.pub().warn((Object)("No plugins found to load at \"" + PLUGINS_DIR.getPath() + "\""));
            return;
        }
        for (File f : PLUGINS_DIR.listFiles()) {
            if (!FileUtil.getFileExtension(f).equalsIgnoreCase("jar")) continue;
            try {
                NeptusLog.pub().info((Object)("<###>Adding " + f + " to classpath..."));
                PluginUtils.addToClassPath(f.toURI().toURL());
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        pluginsLoaded = true;
    }

    public static String[] listPlugins(String interfaceName) {
        if (!pluginsLoaded) {
            PluginUtils.loadPlugins();
        }
        Vector<String> plugins = new Vector<String>();
        try {
            Class<?> c = Class.forName(interfaceName);
            Iterator<?> iter = ServiceRegistry.lookupProviders(c);
            while (iter.hasNext()) {
                plugins.add(iter.next().getClass().getCanonicalName());
            }
            return plugins.toArray(new String[0]);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return new String[0];
        }
    }

    public static InputStream getResourceAsStream(String filename) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
    }

    public static String getResourceAsString(String filename) throws IOException {
        return IOUtils.toString((InputStream)PluginUtils.getResourceAsStream(filename));
    }

    public static void addToClassPath(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

