/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class PluginsLoader {
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static void load() {
        PluginsLoader.loadCorePlugins();
        if (ConfigFetch.ENV == ConfigFetch.ENVIROMENT.PRODUCTION) {
            List<Path> pluginsJars = PluginsLoader.findJars();
            for (Path jar : pluginsJars) {
                try {
                    PluginsLoader.addToSysClassLoader(jar.toUri().toURL());
                    FindPlugins plugins = new FindPlugins();
                    FileSystem zipFileSystem = PluginsLoader.createZipFileSystem(jar.toAbsolutePath().toString(), false);
                    Path root = zipFileSystem.getPath("/", new String[0]);
                    Files.walkFileTree(root, plugins);
                    List<Path> pluginsLST = plugins.getPlugins();
                    for (Path lst : pluginsLST) {
                        PluginsLoader.loadPluginFromLST(lst);
                    }
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)"Error loading plugins from jars", (Throwable)e);
                }
            }
        }
        if (ConfigFetch.ENV == ConfigFetch.ENVIROMENT.DEVELOPMENT) {
            List<Path> externalJars = PluginsLoader.findExternalPluginsJars();
            for (Path jar : externalJars) {
                try {
                    PluginsLoader.addToSysClassLoader(jar.toUri().toURL());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            FindPlugins plugins = new FindPlugins();
            Path start = Paths.get("plugins-dev", new String[0]);
            try {
                Files.walkFileTree(start, plugins);
                List<Path> pluginsLST = plugins.getPlugins();
                for (Path lst : pluginsLST) {
                    PluginsLoader.loadPluginFromLST(lst);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadCorePlugins() {
        for (String pkg : new String[]{"pt.lsts.neptus.console.plugins", "pt.lsts.neptus.mra"}) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            for (Class c : reflections.getTypesAnnotatedWith(PluginDescription.class)) {
                PluginsRepository.addPlugin(c.getCanonicalName());
            }
        }
    }

    private static List<Path> findJars() {
        Path start = Paths.get("plugins", new String[0]);
        FindJars findJars = new FindJars();
        try {
            Files.walkFileTree(start, findJars);
            List<Path> jars = findJars.getJars();
            return jars;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<Path> findExternalPluginsJars() {
        Path start = Paths.get("plugins-dev", new String[0]);
        FindJars findJars = new FindJars();
        try {
            Files.walkFileTree(start, findJars);
            List<Path> jars = findJars.getJars();
            return jars;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addToSysClassLoader(URL u) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("Error, could not add URL to system classloader: " + t.getMessage());
        }
    }

    private static void loadPluginFromLST(Path file) {
        Charset charset = Charset.forName("UTF-8");
        try (BufferedReader reader = Files.newBufferedReader(file, charset);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                PluginsRepository.addPlugin(line);
            }
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
        }
    }

    private static FileSystem createZipFileSystem(String zipFilename, boolean create) throws IOException {
        Path path = Paths.get(zipFilename, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    protected static class FindPlugins
    extends SimpleFileVisitor<Path> {
        List<Path> plugins = new ArrayList<Path>();

        protected FindPlugins() {
        }

        public List<Path> getPlugins() {
            return this.plugins;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileName().toString().equalsIgnoreCase("plugins.lst")) {
                this.plugins.add(file);
                return FileVisitResult.SKIP_SIBLINGS;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    protected static class FindJars
    extends SimpleFileVisitor<Path> {
        List<Path> jars = new ArrayList<Path>();

        protected FindJars() {
        }

        public List<Path> getJars() {
            return this.jars;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (FilenameUtils.getExtension((String)file.getFileName().toString()).equalsIgnoreCase("jar")) {
                this.jars.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

