/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import java.util.LinkedHashMap;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleInteraction;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.mra.replay.LogReplayPanel;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.ExtensionsBag;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.plugins.NeptusAction;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.tiles.MapPainterProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.types.mission.plan.IPlanFileExporter;
import pt.lsts.neptus.util.ReflectionUtil;

public class PluginsRepository {
    private static ExtensionsBag extensions = new ExtensionsBag(NeptusAction.class, ConsolePanel.class, ConsoleLayer.class, ConsoleInteraction.class, MRAVisualization.class, MRAExporter.class, LogReplayLayer.class, LogReplayPanel.class, IPlanFileExporter.class);
    private static LinkedHashMap<String, Class<? extends MapTileProvider>> tileProviders = new LinkedHashMap();

    public static void addPlugin(String className) {
        extensions.addPlugin(className);
        try {
            Class<?> c = Class.forName(className);
            if (ReflectionUtil.hasAnnotation(c, MapTileProvider.class) && (ReflectionUtil.hasAnySuperClass(c, Tile.class) || ReflectionUtil.hasInterface(c, MapPainterProvider.class))) {
                tileProviders.put(PluginUtils.getPluginName(c), c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public static ConsolePanel getPanelPlugin(String pluginName, ConsoleLayout console) {
        try {
            ConsolePanel spprov = extensions.getPlugin(pluginName, ConsolePanel.class, console);
            return spprov;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"loading panel plugin ", (Throwable)e);
            return null;
        }
    }

    public static ConsoleLayer getConsoleLayer(String pluginName) {
        try {
            ConsoleLayer spprov = extensions.getPlugin(pluginName, ConsoleLayer.class, new Object[0]);
            return spprov;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"loading layer plugin ", (Throwable)e);
            return null;
        }
    }

    public static ConsoleInteraction getConsoleInteraction(String pluginName) {
        try {
            ConsoleInteraction spprov = extensions.getPlugin(pluginName, ConsoleInteraction.class, new Object[0]);
            return spprov;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"loading interaction plugin ", (Throwable)e);
            return null;
        }
    }

    public static <T> LinkedHashMap<String, Class<? extends T>> listExtensions(Class<T> type) {
        return extensions.listExtensions(type);
    }

    public static <T> T getPlugin(String name, Class<T> type, Object ... initParams) {
        return extensions.getPlugin(name, type, initParams);
    }

    public static LinkedHashMap<String, Class<? extends ConsolePanel>> getPanelPlugins() {
        return extensions.listExtensions(ConsolePanel.class);
    }

    public static LinkedHashMap<String, Class<? extends ConsoleLayer>> getConsoleLayerPlugins() {
        return extensions.listExtensions(ConsoleLayer.class);
    }

    public static LinkedHashMap<String, Class<? extends ConsoleInteraction>> getConsoleInteractions() {
        return extensions.listExtensions(ConsoleInteraction.class);
    }

    public static LinkedHashMap<String, Class<? extends MRAVisualization>> getMraVisualizations() {
        return extensions.listExtensions(MRAVisualization.class);
    }

    public static LinkedHashMap<String, Class<? extends LogReplayLayer>> getReplayLayers() {
        return extensions.listExtensions(LogReplayLayer.class);
    }

    public static LinkedHashMap<String, Class<? extends MapTileProvider>> getTileProviders() {
        return tileProviders;
    }
}

