/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.CheckMenuChangeListener;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.ImageUtils;

public abstract class SimpleMenuAction
extends ConsolePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected AbstractAction action = null;
    protected boolean selectionState = false;
    private JCheckBoxMenuItem checkItem = null;
    private JMenuItem item = null;

    public SimpleMenuAction(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
        this.setSize(100, 100);
        this.setBackground(Color.yellow);
    }

    public String getMenuName() {
        return "Plugins>" + PluginUtils.getPluginName(this.getClass());
    }

    public boolean isMenuSelectable() {
        return false;
    }

    protected boolean isMenuSelected() {
        return this.selectionState;
    }

    protected void setMenuSelected(boolean selected) {
        if (this.checkItem != null) {
            this.checkItem.setSelected(selected);
        } else {
            NeptusLog.pub().warn((Object)("The menu '" + this.getMenuName() + "' does not support selection states"));
        }
    }

    protected void setMenuEnabled(boolean enabled) {
        this.item.setEnabled(enabled);
    }

    protected boolean isMenuEnabled() {
        return this.item.isEnabled();
    }

    @Override
    public void initSubPanel() {
        if (this.isMenuSelectable()) {
            this.checkItem = this.addCheckMenuItem(this.getMenuName(), ImageUtils.getIcon(PluginUtils.getPluginIcon(this.getClass())), new CheckMenuChangeListener(){

                @Override
                public void menuChecked(ActionEvent e) {
                    SimpleMenuAction.this.selectionState = true;
                    SimpleMenuAction.this.actionPerformed(e);
                }

                @Override
                public void menuUnchecked(ActionEvent e) {
                    SimpleMenuAction.this.selectionState = false;
                    SimpleMenuAction.this.actionPerformed(e);
                }
            });
            this.item = this.checkItem;
        } else {
            this.item = this.addMenuItem(this.getMenuName(), ImageUtils.getIcon(PluginUtils.getPluginIcon(this.getClass())), this);
        }
    }

    public static void main(String[] args) {
        ConsoleParse.testSubPanel(SimpleMenuAction.class);
    }
}

