/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.controllers;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.io.output.ByteArrayOutputStream;
import pt.lsts.imc.AcousticOperation;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.FollowRefState;
import pt.lsts.imc.FollowReference;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.Maneuver;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.PlanManeuver;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.plugins.controllers.IController;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

public class ControllerManager {
    protected LinkedHashMap<String, IController> activeControllers = new LinkedHashMap();
    protected LinkedHashMap<String, Timer> timers = new LinkedHashMap();
    protected Vector<Class<? extends IController>> controllers = new Vector();
    protected boolean useAcousticComms = false;
    protected boolean debug = true;

    public void addController(Class<? extends IController> cClass) {
        if (!this.controllers.contains(cClass)) {
            this.controllers.add(cClass);
        }
    }

    protected void startTimers() {
    }

    public void stop() {
        if (this.debug) {
            System.out.println("Stopping all controller manager timers");
        }
        for (String v : this.activeControllers.keySet()) {
            this.activeControllers.get(v).stopControlling(VehiclesHolder.getVehicleById(v));
        }
        this.activeControllers.clear();
        for (Timer t : this.timers.values()) {
            t.cancel();
            t.purge();
        }
        this.timers.clear();
    }

    public void associateControl(final IController controller, final VehicleType vehicle, int controlLatencySeconds, int timeoutSeconds) throws Exception {
        EstimatedState lastState = ImcMsgManager.getManager().getState(vehicle).lastEstimatedState();
        if (!controller.supportsVehicle(vehicle, lastState)) {
            throw new Exception("The vehicle " + vehicle.getName() + " is not supported by " + controller.getControllerName() + " controller");
        }
        PlanControl startPlan = new PlanControl();
        startPlan.setType(PlanControl.TYPE.REQUEST);
        startPlan.setOp(PlanControl.OP.START);
        startPlan.setPlanId(controller.getControllerName());
        FollowReference man = new FollowReference();
        man.setControlEnt((short)255);
        man.setControlSrc(65535);
        man.setAltitudeInterval(1.0);
        man.setTimeout((double)timeoutSeconds);
        man.setLoiterRadius(7.5);
        PlanSpecification spec = new PlanSpecification();
        spec.setPlanId(controller.getControllerName());
        spec.setStartManId("external_control");
        PlanManeuver pm = new PlanManeuver();
        pm.setData((Maneuver)man);
        pm.setManeuverId("external_control");
        spec.setManeuvers(Arrays.asList(pm));
        startPlan.setArg((IMCMessage)spec);
        int reqId = 0;
        startPlan.setRequestId(reqId);
        startPlan.setFlags(0);
        ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)startPlan, vehicle.getId());
        if (this.debug) {
            System.out.println(controller.getControllerName() + " is now controlling " + vehicle.getId());
        }
        controller.startControlling(vehicle, lastState);
        this.activeControllers.put(vehicle.getName(), controller);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                EstimatedState state = ImcMsgManager.getManager().getState(vehicle.getId()).lastEstimatedState();
                FollowRefState frefState = ImcMsgManager.getManager().getState(vehicle.getId()).lastFollowRefState();
                Reference ref = controller.guide(vehicle, state, frefState);
                try {
                    System.out.println("size in bytes of the reference message: " + ref.serialize(new IMCOutputStream((OutputStream)new ByteArrayOutputStream(256))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ControllerManager.this.useAcousticComms) {
                    ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)ref, vehicle.getId());
                    AcousticOperation op = new AcousticOperation();
                    op.setOp(AcousticOperation.OP.MSG);
                    op.setSystem(vehicle.getId());
                    op.setMsg((IMCMessage)ref);
                    ImcSystem[] sysLst = ImcSystemsHolder.lookupSystemByService("acoustic/operation", VehicleType.SystemTypeEnum.ALL, true);
                    if (sysLst.length == 0) {
                        NeptusLog.pub().error((Object)"Cannot send reference acoustically because no system is capable of it");
                        return;
                    }
                    int successCount = 0;
                    for (ImcSystem sys : sysLst) {
                        if (!ImcMsgManager.getManager().sendMessage((IMCMessage)op, sys.getId(), (String)null)) continue;
                        ++successCount;
                        NeptusLog.pub().warn((Object)("Sent reference to " + vehicle.getId() + " acoustically via " + sys.getName()));
                    }
                    if (successCount == 0) {
                        NeptusLog.pub().error((Object)"Cannot send reference acoustically because no system is capable of it");
                    }
                } else {
                    ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)ref, vehicle.getId());
                }
            }
        };
        Timer t = new Timer(controller.getControllerName() + " control timer", true);
        t.schedule(task, 0L, (long)(controlLatencySeconds * 1000));
        this.timers.put(vehicle.getId(), t);
    }

    public void dissociateControl(VehicleType vehicle) {
        IController controller = this.activeControllers.get(vehicle.getId());
        if (controller == null) {
            return;
        }
        this.activeControllers.get(vehicle.getId()).stopControlling(vehicle);
        this.activeControllers.remove(vehicle.getId());
        PlanControl stopPlan = new PlanControl();
        stopPlan.setType(PlanControl.TYPE.REQUEST);
        stopPlan.setOp(PlanControl.OP.STOP);
        ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)stopPlan, vehicle.getId());
        if (this.debug) {
            System.out.println(controller.getControllerName() + " stopped controlling " + vehicle.getId());
        }
        if (this.timers.containsKey(vehicle.getId())) {
            this.timers.get(vehicle.getId()).cancel();
        }
        this.timers.remove(vehicle.getId());
    }

    public void setUseAcousticComms(boolean useAcousticComms) {
        this.useAcousticComms = useAcousticComms;
    }
}

