/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.controllers;

import pt.lsts.imc.DesiredZ;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.FollowRefState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.plugins.controllers.IController;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;

public abstract class FollowRefController
implements IController {
    protected VehicleType controlledVehicle = null;
    protected LocationType destination = null;

    public abstract LocationType getDestination(LocationType var1, double var2, double var4);

    @Override
    public Reference guide(VehicleType vehicle, EstimatedState estate, FollowRefState frefState) {
        LocationType loc = IMCUtils.parseLocation((IMCMessage)estate);
        double depth = estate.getDepth();
        double alt = estate.getAlt();
        LocationType dest = this.getDestination(loc, depth, alt);
        Reference ref = new Reference();
        if (dest == null) {
            return null;
        }
        dest.convertToAbsoluteLatLonDepth();
        ref.setLat(dest.getLatitudeRads());
        ref.setLon(dest.getLongitudeRads());
        DesiredZ z = dest.getDepth() >= 0.0 ? new DesiredZ((float)dest.getDepth(), DesiredZ.Z_UNITS.DEPTH) : new DesiredZ((float)(-dest.getDepth()), DesiredZ.Z_UNITS.ALTITUDE);
        ref.setZ(z);
        ref.setFlags((short)5);
        return ref;
    }

    @Override
    public String getControllerName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean supportsVehicle(VehicleType vehicle, EstimatedState state) {
        return vehicle.getFeasibleManeuvers().containsKey("FollowReference");
    }

    @Override
    public void startControlling(VehicleType vehicle, EstimatedState state) {
        this.controlledVehicle = vehicle;
    }

    @Override
    public void vehicleTimedOut(VehicleType vehicle) {
    }

    @Override
    public void stopControlling(VehicleType vehicle) {
    }
}

