/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.update;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.plugins.update.UpdateRequest;
import pt.lsts.neptus.util.ReflectionUtil;

public class PeriodicUpdatesService {
    protected static LinkedBlockingQueue<UpdateRequest> updateRequests = new LinkedBlockingQueue();
    private static boolean updatesEnabled = true;
    private static final int DEFAULT_NUMBER_OF_THREADS = 2;
    private static boolean started = false;
    private static Vector<IPeriodicUpdates> clients = new Vector();
    private static Vector<IPeriodicUpdates> defunctClients = new Vector();
    private static Vector<Thread> updaterThreads = new Vector();
    protected static LinkedHashMap<Object, Long> updateTimes = new LinkedHashMap();

    private PeriodicUpdatesService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdatesEnabled() {
        Class<PeriodicUpdatesService> clazz = PeriodicUpdatesService.class;
        synchronized (PeriodicUpdatesService.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return updatesEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopUpdating() {
        Class<PeriodicUpdatesService> clazz = PeriodicUpdatesService.class;
        synchronized (PeriodicUpdatesService.class) {
            updatesEnabled = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void register(IPeriodicUpdates client) {
        if (clients.contains(client)) {
            NeptusLog.pub().info((Object)("Code in " + ReflectionUtil.getCallerStamp() + " tried to add an already registered updates client"));
            return;
        }
        updateTimes.put(client, 0L);
        clients.add(client);
        updateRequests.add(new UpdateRequest(client));
        if (!started) {
            started = true;
            for (int i = 0; i < 2; ++i) {
                Thread t = PeriodicUpdatesService.getUpdaterThread("Periodic Updates - " + (i + 1));
                updaterThreads.add(t);
                t.setDaemon(true);
                t.start();
            }
        }
    }

    public static Collection<IPeriodicUpdates> inspect(Object pojo) {
        Vector<IPeriodicUpdates> upReq = new Vector<IPeriodicUpdates>();
        Collection<Method> methods = ReflectionUtil.getMethodsAnnotatedWith(Periodic.class, pojo);
        if (methods.isEmpty()) {
            return upReq;
        }
        for (Method m : methods) {
            if (m.getParameterTypes().length > 0) {
                NeptusLog.pub().error((Object)("The method " + pojo.getClass().getSimpleName() + "." + m.getName() + "() is annotated as @Periodic but has a non-empty parameters list... ignored."));
                continue;
            }
            IPeriodicUpdates updatee = PeriodicUpdatesService.forge(pojo, m, m.getAnnotation(Periodic.class).millisBetweenUpdates());
            upReq.add(updatee);
        }
        return upReq;
    }

    private static IPeriodicUpdates forge(final Object o, final Method m, final long millisBetweenUpdates) {
        return new IPeriodicUpdates(){

            @Override
            public boolean update() {
                try {
                    Object ret = m.invoke(o, new Object[0]);
                    return !Boolean.FALSE.equals(ret);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public long millisBetweenUpdates() {
                return millisBetweenUpdates;
            }
        };
    }

    public static void unregister(IPeriodicUpdates client) {
        updateTimes.remove(client);
        if (clients.contains(client)) {
            clients.remove(client);
            if (clients.isEmpty()) {
                NeptusLog.pub().info((Object)"Periodic Listener Service with 0 clients - cleaning...");
                for (Thread t : updaterThreads) {
                    t.interrupt();
                }
                started = false;
                defunctClients.clear();
                updateRequests.clear();
            } else {
                defunctClients.add(client);
            }
        }
    }

    private static boolean nextUpdate() {
        UpdateRequest ur = null;
        try {
            ur = updateRequests.take();
            while (ur == null || ur.getNextUpdateTime() >= System.currentTimeMillis()) {
                if (defunctClients.contains(ur.getSource())) {
                    defunctClients.remove(ur.getSource());
                    ur = null;
                }
                if (ur != null) {
                    updateRequests.put(ur);
                }
                Thread.sleep(10L);
                ur = updateRequests.take();
            }
            long time = System.currentTimeMillis();
            if (!updateTimes.containsKey(ur.getSource())) {
                updateTimes.put(ur.getSource(), 0L);
            }
            boolean not_finished = true;
            try {
                not_finished = ur.update();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Exception: " + ReflectionUtil.getCallerStamp()), (Throwable)e);
            }
            catch (Error e) {
                NeptusLog.pub().error((Object)("Error: " + ReflectionUtil.getCallerStamp()), (Throwable)e);
            }
            time = System.currentTimeMillis() - time;
            Long lastTime = updateTimes.get(ur.getSource());
            if (lastTime != null) {
                updateTimes.put(ur.getSource(), lastTime + time);
            }
            if (not_finished) {
                updateRequests.add(ur);
            } else {
                PeriodicUpdatesService.unregister(ur.getSource());
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static Thread getUpdaterThread(String name) {
        Thread t = new Thread(name){

            @Override
            public void run() {
                while (PeriodicUpdatesService.isUpdatesEnabled() && PeriodicUpdatesService.nextUpdate()) {
                }
            }
        };
        t.setPriority(1);
        return t;
    }

    public static void main(String[] args) {
        PeriodicUpdatesService.register(new IPeriodicUpdates(){
            long previousTime = System.currentTimeMillis();

            @Override
            public long millisBetweenUpdates() {
                return 500L;
            }

            @Override
            public boolean update() {
                NeptusLog.pub().info((Object)("<###>a " + (System.currentTimeMillis() - this.previousTime)));
                this.previousTime = System.currentTimeMillis();
                return true;
            }
        });
        PeriodicUpdatesService.register(new IPeriodicUpdates(){
            long previousTime = System.currentTimeMillis();

            @Override
            public long millisBetweenUpdates() {
                return 900L;
            }

            @Override
            public boolean update() {
                NeptusLog.pub().info((Object)("<###>b " + (System.currentTimeMillis() - this.previousTime)));
                this.previousTime = System.currentTimeMillis();
                return true;
            }
        });
    }
}

