/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.update;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;

public class UpdateRequest
implements Comparable<UpdateRequest> {
    private IPeriodicUpdates source;
    private long nextUpdateTime;

    public long getNextUpdateTime() {
        return this.nextUpdateTime;
    }

    public UpdateRequest(IPeriodicUpdates source) {
        this.source = source;
        if (source == null) {
            new Exception().printStackTrace();
        }
        this.nextUpdateTime = System.currentTimeMillis();
    }

    @Override
    public int compareTo(UpdateRequest o) {
        return (int)(this.nextUpdateTime - o.nextUpdateTime);
    }

    public boolean update() {
        if (this.source == null) {
            return false;
        }
        this.nextUpdateTime = System.currentTimeMillis() + this.source.millisBetweenUpdates();
        try {
            return this.source.update();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(PeriodicUpdatesService.class.getSimpleName() + " exception on updated call from " + "'" + this.source + "' " + e.getMessage()), (Throwable)e);
        }
        catch (Error e) {
            NeptusLog.pub().error((Object)(PeriodicUpdatesService.class.getSimpleName() + " error on updated call from " + "'" + this.source + "' " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public IPeriodicUpdates getSource() {
        return this.source;
    }
}

