/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;

@LayerPriority(priority=100)
public class CursorLocationPainter
implements Renderer2DPainter {
    private StateRenderer2D r2d = null;
    private LocationType curLocation = null;
    JLabel lbl = new JLabel();
    boolean visible = true;
    Point2D curLoc = null;

    public CursorLocationPainter() {
        this.lbl.setBackground(new Color(255, 255, 255, 100));
        this.lbl.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.lbl.setOpaque(true);
        this.lbl.setBounds(0, 0, 0, 0);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.r2d == null) {
            this.r2d = renderer;
            renderer.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    CursorLocationPainter.this.curLoc = e.getPoint();
                }
            });
            renderer.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    CursorLocationPainter.this.curLocation = null;
                    CursorLocationPainter.this.r2d.repaint();
                }
            });
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.curLoc != null) {
            this.curLocation = this.r2d.getRealWorldLocation(this.curLoc);
            this.lbl.setText(this.getPrettyLocation());
        } else {
            this.lbl.setText("");
        }
        Dimension ldim = this.lbl.getPreferredSize();
        this.lbl.setBounds(0, 0, ldim.width, ldim.height);
        g.translate(10, this.r2d.getHeight() - ldim.height - 10);
        if (!this.lbl.getText().equals("")) {
            this.lbl.paint(g);
        }
    }

    private String getPrettyLocation() {
        if (this.curLocation == null) {
            return "";
        }
        StringBuilder loc = new StringBuilder();
        loc.append("<html>");
        double[] latLonDepth = this.curLocation.getAbsoluteLatLonDepth();
        loc.append("" + CoordinateUtil.latitudeAsString(latLonDepth[0], true));
        loc.append(" / " + CoordinateUtil.longitudeAsString(latLonDepth[1], true));
        loc.append("</html>");
        return loc.toString();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

