/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.renderer3d.Camera3D;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class EstimatedStateGenerator {
    private SystemPositionAndAttitude lastState = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
    private long lastTimeStamp = 0L;
    private long lastGenStamp = 0L;
    private SystemPositionAndAttitude lastGenState = this.lastState;
    private double[] disturbanceVxyz = new double[]{0.0, 0.0, 0.0};

    public void setState(SystemPositionAndAttitude state) {
        this.lastState = state;
        this.lastGenStamp = this.lastTimeStamp = System.currentTimeMillis();
        this.lastGenState = new SystemPositionAndAttitude(this.lastState);
        this.disturbanceVxyz = this.calcDisturbance();
    }

    private double[] calcDisturbance() {
        SystemPositionAndAttitude st = this.lastState;
        double[] uvwNED = CoordinateUtil.bodyFrameToInertialFrame(st.getU(), st.getV(), st.getW(), st.getRoll(), st.getPitch(), st.getYaw());
        double[] dist = new double[]{st.getVx() - uvwNED[0], st.getVy() - uvwNED[1], st.getVz() - uvwNED[2]};
        return dist;
    }

    public long timeSinceLastState() {
        return System.currentTimeMillis() - this.lastTimeStamp;
    }

    public SystemPositionAndAttitude getInterpolatedState() {
        SystemPositionAndAttitude st = new SystemPositionAndAttitude(this.lastGenState);
        double diffSecs = (double)(System.currentTimeMillis() - this.lastGenStamp) / 1000.0;
        st.setYaw(st.getYaw() + st.getR() * diffSecs);
        st.setPitch(st.getPitch() + st.getQ() * diffSecs);
        st.setRoll(st.getRoll() + st.getP() * diffSecs);
        double[] deltaUVW_NED = CoordinateUtil.bodyFrameToInertialFrame(st.getU() * diffSecs, st.getV() * diffSecs, st.getW() * diffSecs, st.getRoll(), st.getPitch(), st.getYaw());
        double[] ww = new double[]{deltaUVW_NED[0] + this.disturbanceVxyz[0] * diffSecs, deltaUVW_NED[1] + this.disturbanceVxyz[1] * diffSecs, deltaUVW_NED[2] + this.disturbanceVxyz[2] * diffSecs};
        st.addNEDOffsets(ww[0], ww[1], ww[2]);
        double[] uvwNED = CoordinateUtil.bodyFrameToInertialFrame(st.getU(), st.getV(), st.getW(), st.getRoll(), st.getPitch(), st.getYaw());
        double[] distP = new double[]{uvwNED[0] + this.disturbanceVxyz[0], uvwNED[1] + this.disturbanceVxyz[1], uvwNED[2] + this.disturbanceVxyz[2]};
        st.setVxyz(distP[0], distP[1], distP[2]);
        this.lastGenState = st;
        this.lastGenStamp = System.currentTimeMillis();
        return st;
    }

    public static void main(String[] args) throws Exception {
        ConfigFetch.initialize();
        Renderer3D sr = new Renderer3D(new Camera3D[]{new Camera3D(3)}, 1, 1);
        VehicleType veh = VehiclesHolder.getVehicleById("alfa02");
        GuiUtils.testFrame(sr, "Test Interpolation State", 800, 600);
        SystemPositionAndAttitude st = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
        st.setUVW(1.0, 0.0, 0.0);
        st.setPQR(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(5.0));
        st.setVxyz(0.0, 0.0, 0.0);
        sr.vehicleStateChanged(veh.getId(), st);
        sr.followVehicle(veh.getId());
        sr.setVehicleTailOn(new String[]{veh.getId()});
        EstimatedStateGenerator gen = new EstimatedStateGenerator();
        gen.setState(st);
        for (int i = 0; i < 100000; ++i) {
            System.out.printf("x=%f, y=%f, z=%f,  |uvw|=%f, |VxVyVz|=%f\n", st.getNEDPosition()[0], st.getNEDPosition()[1], st.getNEDPosition()[2], Math.sqrt(st.getU() * st.getU() + st.getV() * st.getV() + st.getW() * st.getW()), Math.sqrt(st.getVx() * st.getVx() + st.getVy() * st.getVy() + st.getVz() * st.getVz()));
            Thread.sleep(100L);
            st = gen.getInterpolatedState();
            sr.vehicleStateChanged(veh.getId(), st);
        }
    }
}

