/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.systems.external.ExternalSystemsHolder;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ImageUtils;

public class FeatureFocuser
implements IEditorMenuExtension {
    protected static final ImageIcon markIcon = ImageUtils.getIcon("images/buttons/addpoint.png");
    protected static final ImageIcon homeIcon = ImageUtils.getIcon("images/buttons/homeRef.png");
    protected static final ImageIcon transpIcon = ImageUtils.getIcon("images/transponder.png");
    protected static final ImageIcon myLocIcon = ImageUtils.getScaledIcon("images/myloc.png", 24, 24);
    private final ConsoleLayout console;
    private String mainVeh = "";

    public FeatureFocuser(ConsoleLayout console) {
        this.console = console;
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        JMenuItem menuItem;
        LocationType l;
        final StateRenderer2D renderer = source.getRenderer();
        MapGroup mg = renderer.getMapGroup();
        JMenu centerInMenu = new JMenu(I18n.text("Center map in..."));
        if (mg == null) {
            return null;
        }
        final LocationType myLoc = MyState.getLocation();
        if (!myLoc.isLocationEqual(LocationType.ABSOLUTE_ZERO)) {
            JMenuItem myLocItem = new JMenuItem(I18n.text("My location"), myLocIcon);
            myLocItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    renderer.focusLocation(myLoc);
                }
            });
            centerInMenu.add(myLocItem);
            centerInMenu.addSeparator();
        }
        final LocationType location = mg.getHomeRef().getCenterLocation();
        JMenuItem homeItem = new JMenuItem(I18n.text("Home Reference"), homeIcon);
        homeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                renderer.focusLocation(location);
            }
        });
        centerInMenu.add(homeItem);
        JMenu marksMenu = new JMenu(I18n.text("Marks"));
        marksMenu.setIcon(markIcon);
        for (MarkElement markElement : mg.getAllObjectsOfType(MarkElement.class)) {
            l = markElement.getPosition();
            menuItem = new JMenuItem(markElement.getId(), markIcon);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    renderer.focusLocation(l);
                }
            });
            marksMenu.add(menuItem);
        }
        MenuScroller.setScrollerFor(marksMenu);
        centerInMenu.add(marksMenu);
        for (TransponderElement transponderElement : mg.getAllObjectsOfType(TransponderElement.class)) {
            l = transponderElement.getCenterLocation();
            menuItem = new JMenuItem(transponderElement.getDisplayName(), transpIcon);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    renderer.focusLocation(l);
                }
            });
            centerInMenu.add(menuItem);
        }
        centerInMenu.addSeparator();
        JMenu vehMenu = new JMenu(I18n.text("Vehicles"));
        Comparator<ImcSystem> comparator = new Comparator<ImcSystem>(){

            @Override
            public int compare(ImcSystem o1, ImcSystem o2) {
                if (o1.isWithAuthority() ^ o2.isWithAuthority()) {
                    return o1.isWithAuthority() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
                if (o1.getAuthorityState() != o2.getAuthorityState()) {
                    return o2.getAuthorityState().ordinal() - o1.getAuthorityState().ordinal();
                }
                return o1.compareTo(o2);
            }
        };
        ImcSystem[] veh = ImcSystemsHolder.lookupSystemVehicles();
        Arrays.sort(veh, comparator);
        for (ImcSystem sys : veh) {
            final LocationType l2 = sys.getLocation();
            VehicleType vehS = VehiclesHolder.getVehicleById(sys.getName());
            JMenuItem menuItem2 = veh != null ? new JMenuItem(vehS.getId(), vehS.getIcon()) : new JMenuItem(sys.getName());
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    renderer.focusLocation(l2);
                }
            });
            vehMenu.add(menuItem2);
        }
        MenuScroller.setScrollerFor(vehMenu);
        centerInMenu.add(vehMenu);
        JMenu otherMenu = new JMenu(I18n.text("Others"));
        ImcSystem[] other = ImcSystemsHolder.lookupAllSystems();
        Arrays.sort(other, comparator);
        List<ImcSystem> vecLst = Arrays.asList(veh);
        for (ImcSystem sys : other) {
            if (vecLst.contains(sys)) continue;
            final LocationType l3 = sys.getLocation();
            JMenuItem menuItem3 = new JMenuItem(sys.getName());
            menuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    renderer.focusLocation(l3);
                }
            });
            otherMenu.add(menuItem3);
        }
        MenuScroller.setScrollerFor(otherMenu);
        centerInMenu.add(otherMenu);
        JMenu extMenu = new JMenu(I18n.text("External"));
        Object[] exts = ExternalSystemsHolder.lookupAllSystems();
        Arrays.sort(exts);
        for (Object ext : exts) {
            final LocationType l4 = ((ExternalSystem)ext).getLocation();
            JMenuItem menuItem4 = new JMenuItem(((ExternalSystem)ext).getName());
            menuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    renderer.focusLocation(l4);
                }
            });
            extMenu.add(menuItem4);
        }
        MenuScroller.setScrollerFor(extMenu);
        centerInMenu.add(extMenu);
        JMenuItem centerInMainVeh = new JMenuItem();
        this.mainVeh = this.console.getMainSystem() != null ? this.console.getMainSystem() : "";
        centerInMainVeh.setText(I18n.text("Center map in: ") + this.mainVeh);
        centerInMainVeh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FeatureFocuser.this.console.getMainSystem() != null) {
                    String mainVeh = FeatureFocuser.this.console.getMainSystem();
                    ImcSystem sys = ImcSystemsHolder.getSystemWithName(mainVeh);
                    LocationType lt = sys.getLocation();
                    renderer.focusLocation(lt);
                }
            }
        });
        ArrayList<JMenuItem> listItems = new ArrayList<JMenuItem>();
        listItems.add(centerInMenu);
        listItems.add(centerInMainVeh);
        return listItems;
    }
}

