/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.ColorUtils;

public class HoveringButton {
    private static final Color COLOR_RED_TRANSP = ColorUtils.setTransparencyToColor(Color.RED, 170);
    private final Image image;
    private int xPos = -55;
    private int yPos = 100;
    private int xRealPos = this.xPos;
    private int yRealPos = this.yPos;
    private final int width;
    private final int height;
    private boolean selected = false;
    private boolean hovering = false;
    private boolean useHoveringAlfa = true;
    private boolean visible = true;
    private boolean isToggle = true;

    public HoveringButton(Image image) {
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    public Image getImage() {
        return this.image;
    }

    public int[] getXYConfiguredPos() {
        return new int[]{this.xPos, this.yPos};
    }

    public void setXYConfiguredPos(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public int[] getXYRealPos() {
        return new int[]{this.xRealPos, this.yRealPos};
    }

    public void setRealXYPos(int xRealPos, int yRealPos) {
        this.xRealPos = xRealPos;
        this.yRealPos = yRealPos;
    }

    public int[] getImageWidthHeight() {
        return new int[]{this.width, this.height};
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (!this.isVisible()) {
            return;
        }
        this.selected = !this.isToggle() ? true : selected;
        this.onSelectedChange(this.selected);
    }

    public void toggleSelected() {
        this.setSelected(!this.selected);
    }

    public boolean isHovering() {
        return this.hovering;
    }

    public void setHovering(boolean hovering) {
        if (!this.isVisible()) {
            return;
        }
        this.hovering = hovering;
        this.onHoveringChange(hovering);
    }

    public boolean isUseHoveringAlfa() {
        return this.useHoveringAlfa;
    }

    public void setUseHoveringAlfa(boolean useHoveringAlfa) {
        this.useHoveringAlfa = useHoveringAlfa;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isToggle() {
        return this.isToggle;
    }

    public void setToggle(boolean isToggle) {
        this.isToggle = isToggle;
    }

    public void onSelectedChange(boolean selected) {
    }

    public void onHoveringChange(boolean hovering) {
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        int x = this.xPos;
        int y = this.yPos;
        int[] realXYPos = HoveringButton.calcRealXYPos(x, y, this.width, this.height, renderer.getWidth(), renderer.getHeight());
        x = realXYPos[0];
        y = realXYPos[1];
        int type = 3;
        g2.setComposite(AlphaComposite.getInstance(type, !this.useHoveringAlfa ? 0.8f : (this.hovering ? 0.8f : 0.3f)));
        g2.drawImage(this.image, x, y, this.width, this.height, null);
        if (this.selected && this.isToggle) {
            g2.setColor(COLOR_RED_TRANSP);
            float sz = (float)this.width / 3.0f;
            g2.setStroke(new BasicStroke(sz));
            g2.drawLine((int)((float)(x + this.width) - sz / 2.0f), (int)((float)y + sz / 2.0f), (int)((float)x + sz / 2.0f), (int)((float)(y + this.height) - sz / 2.0f));
        }
        this.xRealPos = x;
        this.yRealPos = y;
        g2.dispose();
    }

    public Rectangle2D createRectangle2DBounds() {
        return new Rectangle2D.Double(this.xRealPos, this.yRealPos, this.width, this.height);
    }

    public static int[] calcRealXYPos(int xPos, int yPos, int iconWidth, int iconHeight, int rendererWidth, int rendererHeight) {
        int x = xPos;
        int y = yPos;
        if (x < 0) {
            x = rendererWidth + x;
        }
        if (y < 0) {
            y = rendererHeight + x;
        }
        if (x + iconWidth + 2 >= rendererWidth) {
            x = Math.max(0, x - 2 - (x + iconWidth + 2 - rendererWidth));
        }
        if (y + iconHeight + 2 >= rendererHeight) {
            y = Math.max(0, y - 2 - (y + iconHeight + 2 - rendererHeight));
        }
        return new int[]{x, y};
    }
}

