/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class ImageLayer
implements Serializable,
Renderer2DPainter {
    private static final long serialVersionUID = -3596078283131291222L;
    private String name;
    private LocationType topLeft;
    private double zoom;
    private double transparency = 0.3;
    private transient BufferedImage image;

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        Point2D tl = renderer.getScreenPosition(this.topLeft);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.translate(tl.getX(), tl.getY());
        g.draw(new Line2D.Double(-3.0, -3.0, 3.0, 3.0));
        g.draw(new Line2D.Double(-3.0, 3.0, 3.0, -3.0));
        g.scale((double)renderer.getZoom() * this.zoom, (double)renderer.getZoom() * this.zoom);
        g.rotate(-renderer.getRotation());
        g.setComposite(AlphaComposite.getInstance(3, (float)this.transparency));
        g.drawImage((Image)this.image, 0, 0, null);
    }

    public ImageLayer(String name, BufferedImage img, LocationType topLeft, LocationType bottomRight) {
        this.name = name;
        this.topLeft = new LocationType(topLeft);
        this.image = img;
        this.zoom = topLeft.getOffsetFrom(bottomRight)[0] / (double)img.getHeight();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public LocationType getTopLeft() {
        return new LocationType(this.topLeft);
    }

    public LocationType getBottomRight() {
        LocationType loc = new LocationType(this.topLeft);
        loc.translatePosition((double)(-this.image.getHeight()) * this.zoom, (double)this.image.getWidth() * this.zoom, 0.0);
        return loc;
    }

    public static ImageLayer read(File f) throws Exception {
        ObjectInputStream is = new ObjectInputStream(new FileInputStream(f));
        ImageLayer imgLayer = (ImageLayer)is.readObject();
        is.close();
        return imgLayer;
    }

    public void saveToFile(File f) throws Exception {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
        os.writeObject(this);
        os.close();
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public String getName() {
        return this.name;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.image = ImageIO.read(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ImageIO.write((RenderedImage)this.image, "PNG", out);
    }
}

