/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.ImageUtils;

public class InteractionAdapter
extends ConsolePanel
implements StateRendererInteraction {
    private static final long serialVersionUID = 1L;
    private Point2D lastDragPoint = null;
    private double deltaX = 0.0;
    private double deltaY = 0.0;
    private static Cursor cursor;
    private static Image image;
    private boolean active = false;
    protected ToolbarSwitch associatedSwitch = null;
    boolean rotating = false;
    boolean measuring = false;
    boolean zooming = false;
    private LocationType firstDragPoint = null;
    private static final Image rotateIcon;
    private static final Image zoomIcon;
    private static final Image rulerIcon;
    long lastMouseWheelMillis;

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
        g.setTransform(source.identity);
        if (this.rotating) {
            g.drawImage(rotateIcon, 20, 50, null);
        } else if (this.measuring) {
            if (this.firstDragPoint != null) {
                LocationType end = source.getRealWorldLocation(this.lastDragPoint);
                double distance = end.getDistanceInMeters(this.firstDragPoint);
                String txt = String.format("%.2f m", distance);
                g.setStroke(new BasicStroke(5.2f, 1, 1));
                g.setColor(new Color(0, 0, 0, 100));
                Point2D start = source.getScreenPosition(this.firstDragPoint);
                int angle = (int)Math.toDegrees(1.5707963267948966 + Math.atan2(this.lastDragPoint.getY() - start.getY(), this.lastDragPoint.getX() - start.getX()));
                if (angle < 0) {
                    angle += 360;
                }
                String angleTxt = String.format("%d\u00ba", angle);
                g.fillArc((int)start.getX() - 15, (int)start.getY() - 15, 30, 30, 90, -angle);
                g.draw(new Line2D.Double(start, this.lastDragPoint));
                g.setColor(Color.black);
                g.setStroke(new BasicStroke(2.5f));
                g.setColor(Color.green.brighter().brighter());
                g.draw(new Line2D.Double(start, this.lastDragPoint));
                g.setFont(new Font("Arial", 1, 16));
                g.setColor(new Color(0, 0, 0, 100));
                g.drawString(txt, (int)(this.lastDragPoint.getX() + 12.0), (int)(this.lastDragPoint.getY() + 11.0));
                g.drawString(txt, (int)(this.lastDragPoint.getX() + 12.0), (int)(this.lastDragPoint.getY() + 12.0));
                g.setFont(new Font("Arial", 1, 12));
                g.drawString(angleTxt, (int)(start.getX() + 7.0), (int)(start.getY() + 6.0));
                g.drawString(angleTxt, (int)(start.getX() + 6.0), (int)(start.getY() + 6.0));
                g.setFont(new Font("Arial", 1, 12));
                g.setColor(Color.gray.brighter());
                g.drawString(angleTxt, (int)(start.getX() + 5.0), (int)(start.getY() + 5.0));
                g.setColor(Color.white);
                g.setFont(new Font("Arial", 1, 16));
                g.drawString(txt, (int)(this.lastDragPoint.getX() + 10.0), (int)(this.lastDragPoint.getY() + 10.0));
            }
            g.drawImage(rulerIcon, 20, 50, null);
        } else if (this.zooming) {
            g.drawImage(zoomIcon, 20, 50, null);
        }
    }

    public InteractionAdapter(ConsoleLayout console) {
        super(console);
        cursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/crosshair_cursor.png"), new Point(6, 6), "Zoom");
        image = ImageUtils.getImage("images/buttons/alarm.png");
        this.lastMouseWheelMillis = 0L;
    }

    @Override
    public Cursor getMouseCursor() {
        return cursor;
    }

    @Override
    public Image getIconImage() {
        return image;
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    public void resetView() {
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        switch (event.getKeyCode()) {
            case 33: 
            case 521: {
                source.setLevelOfDetail(source.getLevelOfDetail() + 1);
                source.repaint();
                break;
            }
            case 34: 
            case 45: {
                source.setLevelOfDetail(source.getLevelOfDetail() - 1);
                source.repaint();
                break;
            }
            case 37: {
                if (!event.isControlDown()) {
                    double deltaX = (double)(-source.getWidth()) / 16.0;
                    double deltaY = 0.0;
                    if (source.getRotation() != 0.0) {
                        double[] offsets = AngleCalc.rotate(source.getRotation(), deltaX, deltaY, false);
                        deltaX = offsets[0];
                        deltaY = offsets[1];
                    }
                    source.worldPixelXY.setLocation(source.worldPixelXY.getX() + deltaX, source.worldPixelXY.getY() + deltaY);
                } else {
                    source.setRotation(source.getRotation() - 0.05);
                }
                source.repaint();
                break;
            }
            case 39: {
                if (!event.isControlDown()) {
                    double deltaX = (double)source.getWidth() / 16.0;
                    double deltaY = 0.0;
                    if (source.getRotation() != 0.0) {
                        double[] offsets = AngleCalc.rotate(source.getRotation(), deltaX, deltaY, false);
                        deltaX = offsets[0];
                        deltaY = offsets[1];
                    }
                    source.worldPixelXY.setLocation(source.worldPixelXY.getX() + deltaX, source.worldPixelXY.getY() + deltaY);
                } else {
                    source.setRotation(source.getRotation() + 0.05);
                }
                source.repaint();
                break;
            }
            case 38: {
                double deltaXU = 0.0;
                double deltaYU = (double)(-source.getHeight()) / 16.0;
                if (source.getRotation() != 0.0) {
                    double[] offsets = AngleCalc.rotate(source.getRotation(), deltaXU, deltaYU, false);
                    deltaXU = offsets[0];
                    deltaYU = offsets[1];
                }
                source.worldPixelXY.setLocation(source.worldPixelXY.getX() + deltaXU, source.worldPixelXY.getY() + deltaYU);
                source.repaint();
                break;
            }
            case 40: {
                double deltaXD = 0.0;
                double deltaYD = (double)source.getHeight() / 16.0;
                if (source.getRotation() != 0.0) {
                    double[] offsets = AngleCalc.rotate(source.getRotation(), deltaXD, deltaYD, false);
                    deltaXD = offsets[0];
                    deltaYD = offsets[1];
                }
                source.worldPixelXY.setLocation(source.worldPixelXY.getX() + deltaXD, source.worldPixelXY.getY() + deltaYD);
                source.repaint();
                break;
            }
            case 78: {
                source.setRotation(0.0);
                source.repaint();
                break;
            }
            case 76: {
                source.setLegendShown(!source.isLegendShown());
                source.repaint();
                break;
            }
            case 112: {
                source.resetView();
                this.repaint();
                break;
            }
            case 71: {
                source.setGridShown(!source.isGridShown());
                this.repaint();
                break;
            }
            case 16: {
                this.rotating = true;
                break;
            }
            case 17: {
                this.measuring = true;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        switch (event.getKeyCode()) {
            case 16: {
                this.rotating = false;
                break;
            }
            case 17: {
                this.measuring = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.lastDragPoint == null || this.measuring) {
            this.lastDragPoint = event.getPoint();
            this.deltaY = 0.0;
            this.deltaX = 0.0;
            return;
        }
        this.deltaX = event.getPoint().getX() - this.lastDragPoint.getX();
        this.deltaY = event.getPoint().getY() - this.lastDragPoint.getY();
        double rotationRads = source.getRotation();
        if (this.rotating) {
            source.setRotation(rotationRads + this.deltaY * 0.05);
        } else {
            if (rotationRads != 0.0) {
                double dist = event.getPoint().distance(this.lastDragPoint);
                double angle = Math.atan2(event.getPoint().getY() - this.lastDragPoint.getY(), event.getPoint().getX() - this.lastDragPoint.getX());
                this.deltaX = dist * Math.cos(angle + rotationRads);
                this.deltaY = dist * Math.sin(angle + rotationRads);
            }
            source.worldPixelXY.setLocation(source.worldPixelXY.getX() - this.deltaX, source.worldPixelXY.getY() - this.deltaY);
        }
        this.lastDragPoint = event.getPoint();
        source.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.lastDragPoint = event.getPoint();
        if (!event.isControlDown()) {
            this.measuring = false;
        }
        if (!event.isShiftDown()) {
            this.rotating = false;
        }
        if (this.measuring && this.firstDragPoint == null) {
            this.firstDragPoint = source.getRealWorldLocation(event.getPoint());
        }
        this.deltaY = 0.0;
        this.deltaX = 0.0;
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.lastDragPoint = null;
        this.firstDragPoint = null;
    }

    @Override
    public void wheelMoved(MouseWheelEvent arg0, StateRenderer2D source) {
        if (arg0.getWhen() - this.lastMouseWheelMillis < 50L) {
            return;
        }
        this.lastMouseWheelMillis = arg0.getWhen();
        source.zoomInOut(arg0.getWheelRotation() < 0, arg0.getPoint().getX(), arg0.getPoint().getY());
        source.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
    }

    @Override
    public void mouseClicked(MouseEvent e, StateRenderer2D source) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.isShiftDown()) {
                source.zoomInOut(false, e.getX(), e.getY());
            } else {
                source.zoomInOut(true, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.lastDragPoint = null;
        this.firstDragPoint = null;
        this.rotating = false;
        this.measuring = false;
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.active = mode;
    }

    public boolean isActive() {
        return this.active;
    }

    public ToolbarSwitch getAssociatedSwitch() {
        return this.associatedSwitch;
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch associatedSwitch) {
        this.associatedSwitch = associatedSwitch;
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }

    static {
        rotateIcon = ImageUtils.getImage("images/menus/rotate.png");
        zoomIcon = ImageUtils.getImage("images/menus/zoom.png");
        rulerIcon = ImageUtils.getImage("images/menus/ruler.png");
    }
}

