/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.renderer2d.MapLegend;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.util.GuiUtils;

public class LoiterPainter
implements Renderer2DPainter {
    private Loiter loiterManeuver = null;
    private static MapLegend legend = new MapLegend();

    public LoiterPainter() {
        this.setLoiterManeuver(new Loiter());
    }

    public LoiterPainter(Loiter loiterManeuver) {
        this.setLoiterManeuver(loiterManeuver);
    }

    public static void paint(Loiter loiterManeuver, Graphics2D g, double zoom, double rotation) {
        boolean isClockwise;
        g.drawLine(-4, -4, 4, 4);
        g.drawLine(-4, 4, 4, -4);
        double bearing = -loiterManeuver.getBearing() - rotation;
        double radius = loiterManeuver.getRadius() * zoom;
        double length = loiterManeuver.getLength() * zoom;
        g.rotate(bearing);
        boolean bl = isClockwise = loiterManeuver.getDirection().equalsIgnoreCase("Clockwise");
        if (loiterManeuver.getLoiterType().equalsIgnoreCase("circular")) {
            double rt = loiterManeuver.getRadiusTolerance() * zoom;
            g.setColor(new Color(255, 255, 255, 100));
            Area outer = new Area(new Ellipse2D.Double(-radius - rt, -radius - rt, (radius + rt) * 2.0, (radius + rt) * 2.0));
            Area inner = new Area(new Ellipse2D.Double(-radius + rt, -radius + rt, (radius - rt) * 2.0, (radius - rt) * 2.0));
            outer.subtract(inner);
            g.fill(outer);
            g.setColor(Color.RED);
            g.draw(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
            g.translate(0.0, -radius);
            if (isClockwise) {
                g.drawLine(-5, 5, 0, 0);
                g.drawLine(-5, -5, 0, 0);
            } else {
                g.drawLine(5, 5, 0, 0);
                g.drawLine(5, -5, 0, 0);
            }
            return;
        }
        if (loiterManeuver.getLoiterType().equalsIgnoreCase("racetrack")) {
            double rt = loiterManeuver.getRadiusTolerance() * zoom;
            g.setColor(new Color(255, 255, 255, 100));
            Area outer = new Area(new Rectangle2D.Double(-length / 2.0, -radius - rt, length, (radius + rt) * 2.0));
            outer.add(new Area(new Ellipse2D.Double(-radius - rt - length / 2.0, -radius - rt, (radius + rt) * 2.0, (radius + rt) * 2.0)));
            outer.add(new Area(new Ellipse2D.Double(-radius - rt + length / 2.0, -radius - rt, (radius + rt) * 2.0, (radius + rt) * 2.0)));
            Area inner = new Area(new Rectangle2D.Double(-length / 2.0, -radius + rt, length, (radius - rt) * 2.0));
            inner.add(new Area(new Ellipse2D.Double(-radius + rt - length / 2.0, -radius + rt, (radius - rt) * 2.0, (radius - rt) * 2.0)));
            inner.add(new Area(new Ellipse2D.Double(-radius + rt + length / 2.0, -radius + rt, (radius - rt) * 2.0, (radius - rt) * 2.0)));
            outer.subtract(inner);
            g.fill(outer);
            g.setColor(Color.RED);
            Area a = new Area();
            a.add(new Area(new Ellipse2D.Double(-radius - length / 2.0, -radius, radius * 2.0, radius * 2.0)));
            a.add(new Area(new Ellipse2D.Double(-radius + length / 2.0, -radius, radius * 2.0, radius * 2.0)));
            a.add(new Area(new Rectangle2D.Double(-length / 2.0, -radius, length, radius * 2.0)));
            g.draw(a);
            g.translate(0.0, -radius);
            if (isClockwise) {
                g.drawLine(-5, 5, 0, 0);
                g.drawLine(-5, -5, 0, 0);
            } else {
                g.drawLine(5, 5, 0, 0);
                g.drawLine(5, -5, 0, 0);
            }
            return;
        }
        if (loiterManeuver.getLoiterType().equalsIgnoreCase("Figure 8")) {
            double rt = loiterManeuver.getRadiusTolerance() * zoom;
            g.setColor(new Color(255, 255, 255, 100));
            Area outer = new Area();
            outer.add(new Area(new Ellipse2D.Double(-radius - rt - length / 2.0, -radius - rt, (radius + rt) * 2.0, (radius + rt) * 2.0)));
            outer.add(new Area(new Ellipse2D.Double(-radius - rt + length / 2.0, -radius - rt, (radius + rt) * 2.0, (radius + rt) * 2.0)));
            outer.subtract(new Area(new Rectangle2D.Double(-length / 2.0, -radius - rt, length, (radius + rt) * 2.0)));
            Area inner = new Area(new Rectangle2D.Double(-length / 2.0, -radius + rt, length, (radius - rt) * 2.0));
            inner.add(new Area(new Ellipse2D.Double(-radius + rt - length / 2.0, -radius + rt, (radius - rt) * 2.0, (radius - rt) * 2.0)));
            inner.add(new Area(new Ellipse2D.Double(-radius + rt + length / 2.0, -radius + rt, (radius - rt) * 2.0, (radius - rt) * 2.0)));
            outer.subtract(inner);
            GeneralPath p = new GeneralPath();
            p.moveTo(-length / 2.0, -radius - rt);
            p.lineTo(length / 2.0, radius - rt);
            p.lineTo(length / 2.0, radius + rt);
            p.lineTo(-length / 2.0, -radius + rt);
            p.closePath();
            outer.add(new Area(p));
            p = new GeneralPath();
            p.moveTo(-length / 2.0, radius - rt);
            p.lineTo(length / 2.0, -radius - rt);
            p.lineTo(length / 2.0, -radius + rt);
            p.lineTo(-length / 2.0, radius + rt);
            p.closePath();
            outer.add(new Area(p));
            g.fill(outer);
            g.setColor(Color.RED);
            Area a = new Area();
            a.add(new Area(new Ellipse2D.Double(-radius - length / 2.0, -radius, radius * 2.0, radius * 2.0)));
            a.add(new Area(new Ellipse2D.Double(-radius + length / 2.0, -radius, radius * 2.0, radius * 2.0)));
            a.subtract(new Area(new Rectangle2D.Double(-length / 2.0, -radius, length, radius * 2.0)));
            p = new GeneralPath();
            p.moveTo(-length / 2.0 - 1.0, -radius);
            p.lineTo(length / 2.0 + 1.0, radius);
            p.lineTo(length / 2.0 + 1.0, -radius);
            p.lineTo(-length / 2.0 - 1.0, radius);
            p.closePath();
            a.add(new Area(p));
            g.draw(a);
            g.translate(0.0, -radius);
            if (isClockwise) {
                g.drawLine(-5, 5, 0, 0);
                g.drawLine(-5, -5, 0, 0);
            } else {
                g.drawLine(5, 5, 0, 0);
                g.drawLine(5, -5, 0, 0);
            }
            return;
        }
        if (loiterManeuver.getLoiterType().equalsIgnoreCase("Hover")) {
            g.setColor(new Color(255, 255, 255, 100));
            g.fill(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
            return;
        }
        g.setColor(new Color(255, 255, 255, 100));
        g.fill(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        g.rotate(-bearing);
        g.setColor(Color.RED);
        g.drawString("?", 5, 10);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        LoiterPainter.paint(this.loiterManeuver, g, renderer.getZoom(), renderer.getRotation());
    }

    public void setLoiterManeuver(Loiter loiterManeuver) {
        this.loiterManeuver = loiterManeuver;
    }

    public static Image previewLoiter(Loiter loiter, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        NeptusLog.pub().info((Object)("<###>width=" + width));
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.translate((double)width / 2.0, (double)height / 2.0);
        LoiterPainter.paint(loiter, g, 1.0, 0.0);
        g.setTransform(new AffineTransform());
        legend.paint(g, width, height, true);
        return bi;
    }

    public static void main(String[] args) {
        StateRenderer2D r2d = new StateRenderer2D(MapGroup.getNewInstance(new CoordinateSystem()));
        Loiter loiter = new Loiter();
        LocationType lt = new LocationType();
        lt.setOffsetEast(150.0);
        loiter.getManeuverLocation().setLocation(lt);
        loiter.setLength(50.0);
        loiter.setLoiterType("Circular");
        loiter.setBearing(Math.toRadians(45.0));
        loiter.setDirection("Clockwise");
        r2d.addPostRenderPainter(new LoiterPainter(loiter), "Loiter Painter");
        GuiUtils.testFrame(r2d, "Testing loiter painter...");
    }
}

