/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@LayerPriority(priority=100)
public class MapLegend
implements Renderer2DPainter {
    private double zoomValue = 1.0;
    private LocationType centerLocation = new LocationType();
    private double mapRotation = 0.0;
    private int width = 70;
    private int height = 80;
    private NumberFormat nf = DecimalFormat.getInstance(Locale.US);

    public MapLegend() {
        this.nf.setGroupingUsed(false);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        int screenWidth = renderer.getWidth();
        int screenHeight = renderer.getHeight();
        this.zoomValue = renderer.getZoom();
        this.centerLocation = renderer.getCenter();
        this.setMapRotation(renderer.getRotation());
        this.paint(g, screenWidth, screenHeight, false);
    }

    public void paint(Graphics2D g, int screenWidth, int screenHeight, boolean simple) {
        AffineTransform identity = g.getTransform();
        int cornerX = screenWidth - 10 - this.width;
        int cornerY = 10;
        double realWidth = (double)(this.width - 20) / this.getZoomValue();
        String units = "m";
        if (realWidth < 1.0) {
            units = "cm";
            realWidth *= 100.0;
        } else if (realWidth > 1000.0) {
            units = "Km";
            realWidth /= 1000.0;
        }
        String text = this.nf.format(realWidth) + " " + units;
        if (!simple) {
            g.setColor(new Color(255, 255, 255, 100));
            g.fillRect(cornerX, cornerY, this.width, this.height);
            g.setColor(Color.BLACK);
            g.drawRect(cornerX, cornerY, this.width, this.height);
        } else {
            g.setColor(Color.BLACK);
        }
        g.drawLine(cornerX + 10, cornerY + 10, cornerX + this.width - 10, cornerY + 10);
        g.drawLine(cornerX + 10, cornerY + 5, cornerX + 10, cornerY + 15);
        g.drawLine(cornerX + this.width - 10, cornerY + 5, cornerX + this.width - 10, cornerY + 15);
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(text, g);
        if (stringBounds.getWidth() >= (double)(this.width - 20)) {
            g.translate(cornerX + 10, cornerY + 25);
            g.scale((double)(this.width - 20) / stringBounds.getWidth(), (double)(this.width - 20) / stringBounds.getWidth());
            g.drawString(text, 0, 0);
            g.setTransform(identity);
        } else {
            int advance = (int)((double)(this.width - 20) - stringBounds.getWidth()) / 2;
            g.drawString(text, advance + cornerX + 10, cornerY + 25);
        }
        if (!simple) {
            g.translate(cornerX + this.width / 2, cornerY + this.height / 2 + 13);
            g.rotate(-this.getMapRotation());
            GeneralPath gp = new GeneralPath();
            gp.moveTo(0.0f, -15.0f);
            gp.lineTo(-8.0f, 10.0f);
            gp.lineTo(0.0f, 7.0f);
            gp.lineTo(8.0f, 10.0f);
            gp.closePath();
            g.setColor(new Color(0, 0, 0, 200));
            g.fill(gp);
            if (this.getMapRotation() == 0.0) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.red.darker());
            }
            g.draw(gp);
            Rectangle2D nBounds = g.getFontMetrics().getStringBounds("N", g);
            g.drawString("N", -((int)nBounds.getWidth()) / 2, -16);
        }
    }

    public LocationType getCenterLocation() {
        return this.centerLocation;
    }

    public void setCenterLocation(LocationType centerLocation) {
        this.centerLocation = centerLocation;
    }

    public double getZoomValue() {
        return this.zoomValue;
    }

    public void setZoomValue(double zoomValue) {
        this.zoomValue = zoomValue;
    }

    public double getMapRotation() {
        return this.mapRotation;
    }

    public void setMapRotation(double mapRotation) {
        this.mapRotation = mapRotation;
    }
}

