/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.renderer2d.EstimatedStateGenerator;
import pt.lsts.neptus.renderer2d.Renderer;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.VehicleStateListener;
import pt.lsts.neptus.renderer3d.Camera3D;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Object3DCreationHelper;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.DynamicElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MissionRenderer
extends JPanel
implements ActionListener,
ChangeListener,
VehicleStateListener {
    static final long serialVersionUID = 14L;
    private StateRenderer2D renderer2d;
    private Renderer3D renderer3d;
    private MapGroup myMapGroup = null;
    public static final int R2D_ONLY = 0;
    public static final int R3D_1CAM = 1;
    public static final int R2D_AND_R3D1CAM = 2;
    public static final int R3D_MULTICAMS = 3;
    public static final int R2D_AND_R3D_MULTICAMS = 4;
    private VehicleType vehicle = null;
    private SystemPositionAndAttitude curstate;
    private SystemPositionAndAttitude initState = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
    private Renderer[] renderers;
    private PlanType plan;
    private int currentMode = 1;
    private ClassLoader cl = this.getClass().getClassLoader();
    private JButton pauseMode;
    private JButton restart;
    private JButton findVehicle;
    private JButton tailClean;
    private JButton selectPainters;
    private ToolbarSwitch interpolate;
    private ToolbarSwitch followMode;
    private ToolbarSwitch tailOnOff;
    private JToggleButton zoomMode;
    private JToggleButton translateMode;
    private JToggleButton rotateMode;
    private JToggleButton rulerMode;
    private ButtonGroup bgroup = new ButtonGroup();
    private JToolBar toolbar;
    private JLabel status = new JLabel();
    private JComponent renderPanel;
    private Hashtable<VehicleType, SystemPositionAndAttitude> shownVehicles = new Hashtable();
    private Hashtable<VehicleType, EstimatedStateGenerator> stateInterpolators = new Hashtable();
    private VehicleType mainVehicle = null;
    private MissionType mission = null;
    private int vehicleIterator = 0;
    boolean generateIntermediateStates = true;
    private long millisBetweenInterpolatedStates = 100L;
    private long millisUntilGenerationEnd = 2000L;
    private Timer interpolationTimer = null;
    private PlanElement po;
    private MapType localMap = new MapType();
    private Timer dynElemsTimer = null;

    public void startInterpolatingStates() {
        if (this.interpolationTimer != null) {
            this.interpolationTimer.cancel();
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                for (VehicleType vt : MissionRenderer.this.stateInterpolators.keySet()) {
                    if (((EstimatedStateGenerator)MissionRenderer.this.stateInterpolators.get(vt)).timeSinceLastState() > MissionRenderer.this.millisUntilGenerationEnd) continue;
                    SystemPositionAndAttitude tmp = ((EstimatedStateGenerator)MissionRenderer.this.stateInterpolators.get(vt)).getInterpolatedState();
                    for (int i = 0; i < MissionRenderer.this.renderers.length; ++i) {
                        MissionRenderer.this.renderers[i].vehicleStateChanged(vt.getId(), tmp);
                    }
                }
            }
        };
        this.interpolationTimer = new Timer("State Interpolator");
        this.interpolationTimer.schedule(task, this.millisBetweenInterpolatedStates, this.millisBetweenInterpolatedStates);
    }

    public void stopInterpolatingStates() {
        if (this.interpolationTimer != null) {
            this.interpolationTimer.cancel();
        }
    }

    @Override
    public void setVehicleState(VehicleType vehicle, SystemPositionAndAttitude state) {
        if (vehicle == null) {
            return;
        }
        this.curstate = state;
        for (int i = 0; i < this.renderers.length; ++i) {
            this.renderers[i].vehicleStateChanged(vehicle.getId(), state);
        }
        this.shownVehicles.put(vehicle, state);
        if (this.stateInterpolators.containsKey(vehicle)) {
            this.stateInterpolators.get(vehicle).setState(state);
        } else {
            EstimatedStateGenerator gen = new EstimatedStateGenerator();
            gen.setState(state);
            this.stateInterpolators.put(vehicle, gen);
        }
        this.followMode.setEnabled(true);
        this.findVehicle.setEnabled(true);
    }

    public MissionRenderer(PlanType plan, MissionType mission, int shownRenderers) {
        this(plan, MapGroup.getMapGroupInstance(mission), shownRenderers);
        this.mission = mission;
    }

    public MissionRenderer(MissionType mission, int shownRenderers) {
        this(null, MapGroup.getMapGroupInstance(mission), shownRenderers);
    }

    public MissionRenderer(PlanType plan, MapGroup map, int shownRenderers) {
        this.plan = plan;
        this.myMapGroup = map;
        map.addMap(this.localMap);
        LocationType startLocation = new LocationType();
        double angle = 0.0;
        if (map != null && plan != null) {
            if (map.getMapObjectsByID("start").length > 0) {
                startLocation.setLocation(map.getMapObjectsByID("start")[0].getCenterLocation());
                Maneuver startMan = plan.getGraph().getManeuver(plan.getGraph().getInitialManeuverId());
                if (startMan instanceof Goto) {
                    Goto g = (Goto)startMan;
                    angle = startLocation.getXYAngle(g.getManeuverLocation());
                }
            } else {
                startLocation.setLocation(map.getCoordinateSystem());
            }
        }
        switch (shownRenderers) {
            case 0: {
                StateRenderer2D r2d = new StateRenderer2D(map);
                r2d.setMapGroup(map);
                r2d.focusLocation(map.getCoordinateSystem());
                r2d.addChangeListener(this);
                this.po = new PlanElement(map, new MapType());
                this.po.setPlan(plan);
                this.po.setRenderer(r2d);
                this.po.setShowDistances(false);
                this.po.setShowManNames(false);
                r2d.addPostRenderPainter(this.po, "Plan Painter");
                this.renderers = new Renderer[]{r2d};
                this.renderPanel = new JPanel();
                this.renderPanel.setLayout(new BorderLayout());
                this.renderPanel.add((Component)r2d, "Center");
                this.renderer2d = r2d;
                break;
            }
            case 1: {
                Obj3D o3d;
                Camera3D cam = new Camera3D(3);
                Camera3D[] cams = new Camera3D[]{cam};
                Renderer3D r3d = new Renderer3D(cams, 1, 1);
                r3d.setMapGroup(map);
                r3d.focusLocation(map.getCoordinateSystem());
                r3d.addChangeListener(this);
                r3d.setBackgroundType((short)2);
                if (plan != null && (o3d = Object3DCreationHelper.getPlanModel3D(plan)) != null) {
                    r3d.addObj3D(o3d);
                }
                this.renderers = new Renderer[]{r3d};
                this.renderPanel = new JPanel();
                this.renderPanel.setLayout(new BorderLayout());
                this.renderPanel.add((Component)r3d, "Center");
                this.renderer3d = r3d;
                break;
            }
            case 3: {
                Obj3D o3d;
                Renderer3D r3d = new Renderer3D();
                r3d.setMapGroup(map);
                r3d.focusLocation(map.getCoordinateSystem());
                r3d.addChangeListener(this);
                r3d.setBackgroundType((short)2);
                if (plan != null && (o3d = Object3DCreationHelper.getPlanModel3D(plan)) != null) {
                    r3d.addObj3D(o3d);
                }
                this.renderers = new Renderer[]{r3d};
                this.renderPanel = new JPanel();
                this.renderPanel.setLayout(new BorderLayout());
                this.renderPanel.add((Component)r3d, "Center");
                this.renderer3d = r3d;
                break;
            }
            case 2: {
                Obj3D o3d;
                StateRenderer2D r2d = new StateRenderer2D(map);
                r2d.setMapGroup(map);
                r2d.focusLocation(map.getCoordinateSystem());
                r2d.addChangeListener(this);
                this.po = new PlanElement(map, new MapType());
                this.po.setPlan(plan);
                this.po.setRenderer(r2d);
                this.po.setShowDistances(false);
                this.po.setShowManNames(false);
                r2d.addPostRenderPainter(this.po, "Plan Painter");
                Camera3D cam = new Camera3D(3);
                Camera3D[] cams = new Camera3D[]{cam};
                Renderer3D r3d = new Renderer3D(cams, 1, 1);
                r3d.setMapGroup(map);
                r3d.focusLocation(map.getCoordinateSystem());
                r3d.addChangeListener(this);
                r3d.setBackgroundType((short)2);
                if (plan != null && (o3d = Object3DCreationHelper.getPlanModel3D(plan)) != null) {
                    r3d.addObj3D(o3d);
                }
                this.renderers = new Renderer[]{r2d, r3d};
                this.renderPanel = new JTabbedPane(1);
                this.renderPanel.add((Component)r2d, "Renderer 2D");
                this.renderPanel.add((Component)r3d, "Renderer 3D");
                this.renderer2d = r2d;
                this.renderer3d = r3d;
                break;
            }
            case 4: {
                Obj3D o3d;
                StateRenderer2D r2d = new StateRenderer2D(map);
                r2d.setMapGroup(map);
                r2d.focusLocation(map.getCoordinateSystem());
                r2d.addChangeListener(this);
                Renderer3D r3d = new Renderer3D();
                r3d.setMapGroup(map);
                r3d.focusLocation(map.getCoordinateSystem());
                r3d.addChangeListener(this);
                r3d.setBackgroundType((short)2);
                if (plan != null && (o3d = Object3DCreationHelper.getPlanModel3D(plan)) != null) {
                    r3d.addObj3D(o3d);
                }
                this.renderers = new Renderer[]{r2d, r3d};
                this.renderPanel = new JTabbedPane(1);
                this.renderPanel.add((Component)r2d, "Renderer 2D");
                this.renderPanel.add((Component)r3d, "Renderer 3D");
                this.renderer2d = r2d;
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildToolbar(plan != null), "South");
        this.add((Component)this.renderPanel, "Center");
        if (plan != null) {
            this.initState = new SystemPositionAndAttitude(startLocation, 0.0, 0.0, 0.0);
            this.initState.setYaw(angle);
            this.vehicle = plan.getVehicleType();
            for (int i = 0; i < this.renderers.length; ++i) {
                this.renderers[i].vehicleStateChanged(this.vehicle.getId(), this.initState);
            }
            this.pauseMode.setIcon(new ImageIcon(this.cl.getResource("images/buttons/play.png")));
            this.pauseMode.setActionCommand("resume");
            this.pauseMode.setToolTipText("Resume the animation");
        }
        NeptusLog.pub().info((Object)"Start updating dynamic elements...");
        this.startUpdatingDynamicElements();
    }

    public JToolBar buildToolbar(boolean showExecutionControls) {
        this.toolbar = new JToolBar(0);
        this.toolbar.setMargin(new Insets(0, 0, 0, 0));
        this.pauseMode = new ToolbarButton("images/buttons/pause.png", "Pause the animation", "pause");
        this.pauseMode.setToolTipText("Pause the animation");
        this.addButtonToToolbar(this.pauseMode);
        this.restart = new ToolbarButton("images/buttons/restart.png", "Restart the animation", "restart");
        this.addButtonToToolbar(this.restart);
        if (!showExecutionControls) {
            this.pauseMode.setVisible(false);
            this.restart.setVisible(false);
        }
        this.findVehicle = new ToolbarButton("images/buttons/vehicle.png", "Center map on vehicle position", "findVehicle");
        this.addButtonToToolbar(this.findVehicle);
        this.findVehicle.setEnabled(false);
        this.bgroup.add(this.zoomMode);
        this.followMode = new ToolbarSwitch("images/buttons/lock_vehicle.png", "Follow vehicle", "follow", this.cl);
        this.addButtonToToolbar(this.followMode);
        this.followMode.setEnabled(false);
        this.zoomMode = new ToolbarSwitch("images/buttons/zoom_btn.png", "Activate zoom mode", "viewMode", this.cl);
        this.addButtonToToolbar(this.zoomMode);
        this.translateMode = new ToolbarSwitch("images/buttons/translate_btn.png", "De-activate translation mode", "viewMode", this.cl);
        this.translateMode.setSelected(true);
        this.addButtonToToolbar(this.translateMode);
        this.rotateMode = new ToolbarSwitch("images/buttons/rotate_btn.png", "Activate rotation mode", "viewMode", this.cl);
        this.addButtonToToolbar(this.rotateMode);
        this.rulerMode = new ToolbarSwitch("images/buttons/ruler_btn.png", "Measure distances between two points", "viewMode", this.cl);
        this.addButtonToToolbar(this.rulerMode);
        this.bgroup.add(this.zoomMode);
        this.bgroup.add(this.translateMode);
        this.bgroup.add(this.rotateMode);
        this.bgroup.add(this.rulerMode);
        this.interpolate = new ToolbarSwitch("images/buttons/preview.png", "Interpolate the estimated vehicle states", "interpolate", this.cl);
        if (!ConfigFetch.isOnLockedMode()) {
            this.addButtonToToolbar(this.interpolate);
        }
        this.tailOnOff = new ToolbarSwitch("images/buttons/tailOnOff.png", "Switch on/off vehicle tail", "tailOnOff", this.cl);
        this.addButtonToToolbar(this.tailOnOff);
        this.tailClean = new ToolbarButton("images/buttons/tailClean.png", "Clean vehicle tail", "tailClean");
        this.addButtonToToolbar(this.tailClean);
        this.selectPainters = new ToolbarButton("images/buttons/tailClean.png", "Map Layers", "selectPainters");
        this.addButtonToToolbar(this.selectPainters);
        this.toolbar.add(this.status);
        return this.toolbar;
    }

    public void addButtonToToolbar(AbstractButton button) {
        button.removeActionListener(this);
        button.addActionListener(this);
        this.toolbar.add(button);
    }

    public void dispose() {
        this.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        int i;
        if ("interpolate".equals(action.getActionCommand())) {
            if (this.interpolate.isSelected()) {
                this.startInterpolatingStates();
            } else {
                this.stopInterpolatingStates();
            }
        }
        if ("restart".equals(action.getActionCommand())) {
            this.pauseMode.setIcon(new ImageIcon(this.cl.getResource("images/buttons/pause.png")));
            this.pauseMode.setActionCommand("pause");
            this.pauseMode.setToolTipText("Pause the animation");
        }
        if ("pause".equals(action.getActionCommand())) {
            this.pauseMode.setIcon(new ImageIcon(this.cl.getResource("images/buttons/play.png")));
            this.pauseMode.setActionCommand("resume");
            this.pauseMode.setToolTipText("Resume the animation");
        }
        if ("resume".equals(action.getActionCommand())) {
            this.pauseMode.setIcon(new ImageIcon(this.cl.getResource("images/buttons/pause.png")));
            this.pauseMode.setActionCommand("pause");
            this.pauseMode.setToolTipText("Pause the animation");
        }
        if ("follow".equals(action.getActionCommand())) {
            if (this.followMode.isSelected()) {
                for (i = 0; i < this.renderers.length; ++i) {
                    this.renderers[i].followVehicle(this.getMainVehicle().getId());
                }
            } else {
                for (i = 0; i < this.renderers.length; ++i) {
                    this.renderers[i].followVehicle(null);
                }
            }
        }
        if ("findVehicle".equals(action.getActionCommand())) {
            for (i = 0; i < this.renderers.length; ++i) {
                SystemPositionAndAttitude state = this.shownVehicles.get(this.getShownVehicles()[this.vehicleIterator]);
                this.renderers[i].focusLocation(state.getPosition());
            }
        }
        if ("viewMode".equals(action.getActionCommand())) {
            ToolbarSwitch src = (ToolbarSwitch)action.getSource();
            if (!src.isSelected()) {
                this.currentMode = -1;
                this.rotateMode.setToolTipText("Activate rotate mode");
                this.translateMode.setToolTipText("Activate translation mode");
                this.zoomMode.setToolTipText("Activate zoom mode");
            } else {
                if (this.translateMode.isSelected()) {
                    this.currentMode = 1;
                }
                if (this.zoomMode.isSelected()) {
                    this.currentMode = 2;
                }
                if (this.rotateMode.isSelected()) {
                    this.currentMode = 3;
                }
                if (this.rulerMode.isSelected()) {
                    this.currentMode = 4;
                }
            }
            for (int i2 = 0; i2 < this.renderers.length; ++i2) {
                this.renderers[i2].setViewMode(this.currentMode);
            }
        }
        if ("tailOnOff".equals(action.getActionCommand())) {
            Renderer rend;
            int i$;
            if (this.tailOnOff.isSelected()) {
                Renderer[] arr$ = this.renderers;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    rend = arr$[i$];
                    rend.setVehicleTailOn(null);
                }
            } else {
                Renderer[] arr$ = this.renderers;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    rend = arr$[i$];
                    rend.setVehicleTailOff(null);
                }
            }
        }
        if ("tailClean".equals(action.getActionCommand())) {
            for (Renderer rend : this.renderers) {
                rend.clearVehicleTail(null);
            }
        }
        if ("selectPainters".equals(action.getActionCommand())) {
            this.add((Component)this.renderer2d.painters.getSelectionPanel(), "East");
        }
    }

    private VehicleType[] getShownVehicles() {
        VehicleType[] vts = new VehicleType[this.shownVehicles.size()];
        int i = 0;
        Enumeration<VehicleType> e = this.shownVehicles.keys();
        while (e.hasMoreElements()) {
            vts[i++] = e.nextElement();
        }
        return vts;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Renderer source = (Renderer)e.getSource();
        this.currentMode = source.getShowMode();
        if (this.currentMode == 2) {
            this.zoomMode.setSelected(true);
            this.rotateMode.setSelected(false);
            this.translateMode.setSelected(false);
        }
        if (this.currentMode == 1) {
            this.zoomMode.setSelected(false);
            this.rotateMode.setSelected(false);
            this.translateMode.setSelected(true);
        }
        if (this.currentMode == 3) {
            this.zoomMode.setSelected(false);
            this.rotateMode.setSelected(true);
            this.translateMode.setSelected(false);
        }
        if (this.renderers.length > 1) {
            for (int i = 0; i < this.renderers.length; ++i) {
                if (this.renderers[i] == source) continue;
                this.renderers[i].setViewMode(this.currentMode);
            }
        }
    }

    public void setMapGroup(MapGroup mg) {
        for (int i = 0; i < this.renderers.length; ++i) {
            this.renderers[i].setMapGroup(mg);
        }
        this.myMapGroup = mg;
    }

    public Renderer[] getRenderers() {
        return this.renderers;
    }

    public JComponent getRenderPanel() {
        return this.renderPanel;
    }

    public SystemPositionAndAttitude getCurstate() {
        return this.curstate;
    }

    public VehicleType getMainVehicle() {
        if (this.mainVehicle != null) {
            return this.mainVehicle;
        }
        if (this.getShownVehicles().length == 0) {
            return null;
        }
        return this.getShownVehicles()[0];
    }

    public void setMainVehicle(VehicleType mainVehicle) {
        this.mainVehicle = mainVehicle;
        if (this.followMode.isSelected()) {
            ActionEvent evt = new ActionEvent(this.followMode, 0, "follow");
            this.actionPerformed(evt);
        }
    }

    public void cleanup() {
        this.stopUpdatingDynamicElements();
        this.stopInterpolatingStates();
        for (int i = 0; i < this.renderers.length; ++i) {
            if (this.renderers[i] == null) continue;
            this.renderers[i].cleanup();
        }
    }

    public StateRenderer2D getRenderer2d() {
        return this.renderer2d;
    }

    public Renderer3D getRenderer3d() {
        return this.renderer3d;
    }

    public void setMission(MissionType mission) {
        this.mission = mission;
        if (this.getMapGroup() != null) {
            this.getMapGroup().removeMap(this.getLocalMap().getId());
        }
        MapGroup mg = MapGroup.getMapGroupInstance(mission);
        this.setMapGroup(mg);
        mg.addMap(this.getLocalMap());
        if (this.getRenderer2d() != null) {
            this.getRenderer2d().repaint();
        }
    }

    public MissionType getMission() {
        return this.mission;
    }

    public void setPlan(PlanType plan) {
        MapGroup newMapGroup = null;
        if (plan != null) {
            newMapGroup = MapGroup.getMapGroupInstance(plan.getMissionType());
        }
        this.plan = plan;
        for (Renderer r : this.renderers) {
            if (newMapGroup != null && !newMapGroup.equals(r.getMapGroup())) {
                r.setMapGroup(MapGroup.getMapGroupInstance(this.mission));
                NeptusLog.pub().info((Object)"MapGroup has changed!");
            }
            if (r instanceof StateRenderer2D) {
                StateRenderer2D r2d = (StateRenderer2D)r;
                r2d.removePaintersOfType(PlanElement.class);
                if (plan != null) {
                    PlanElement po = new PlanElement(r2d.getMapGroup(), new MapType());
                    po.setPlan(plan);
                    po.setRenderer(r2d);
                    po.setColor(new Color(255, 255, 255, 128));
                    po.setShowDistances(false);
                    po.setShowManNames(false);
                    r2d.addPostRenderPainter(po, "Plan Painter");
                }
            }
            if (!(r instanceof Renderer3D)) continue;
            Renderer3D r3d = (Renderer3D)r;
            if (plan == null) {
                r3d.setPlanObj(null);
                continue;
            }
            r3d.setPlanObj(Object3DCreationHelper.getPlanModel3D(plan));
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public void showPreviewControls(boolean showPreviewControls) {
        this.pauseMode.setVisible(showPreviewControls);
        this.restart.setVisible(showPreviewControls);
    }

    public void addToolbarAction(AbstractAction action) {
        this.toolbar.add((Component)((Object)new ToolbarButton(action)));
        this.toolbar.revalidate();
    }

    public void setActiveManeuver(String manId) {
        this.po.setActiveManeuver(manId);
        this.status.setText("<html>maneuver: <b>" + manId + "</b>");
    }

    public void setInterpolateStatesVisible(boolean visible) {
        this.interpolate.setVisible(visible);
    }

    public void startUpdatingDynamicElements() {
        if (this.dynElemsTimer != null) {
            return;
        }
        NeptusLog.pub().info((Object)"Started updating dynamic elements");
        this.dynElemsTimer = new Timer("Dynamic Elements updater", true);
        this.dynElemsTimer.schedule(this.getDynObjectsUpdater(), 0L, 1000L);
    }

    public void stopUpdatingDynamicElements() {
        if (this.dynElemsTimer != null) {
            NeptusLog.pub().debug((Object)"Stopped updating dynamic elements");
            this.dynElemsTimer.cancel();
        }
    }

    public MapType getLocalMap() {
        return this.localMap;
    }

    protected TimerTask getDynObjectsUpdater() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                if (MissionRenderer.this.myMapGroup == null) {
                    return;
                }
                Vector<DynamicElement> dynElems = MissionRenderer.this.myMapGroup.getAllObjectsOfType(DynamicElement.class);
                long curTime = System.currentTimeMillis();
                for (DynamicElement dynElem : dynElems) {
                    long lastUpdate = dynElem.getLastUpdateTime();
                    if (lastUpdate == -1L) continue;
                    dynElem.setIdleTimeSecs((int)((curTime - dynElem.getLastUpdateTime()) / 1000L));
                    if (MissionRenderer.this.getRenderer2d() == null) continue;
                    MissionRenderer.this.getRenderer2d().repaint();
                }
            }
        };
        return t;
    }

    public MapGroup getMapGroup() {
        return this.myMapGroup;
    }
}

