/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ReflectionUtil;

public class PaintersBag {
    protected LinkedHashMap<String, Renderer2DPainter> paintersByName = new LinkedHashMap();
    protected LinkedHashMap<String, Boolean> activePainters = new LinkedHashMap();
    protected LinkedHashMap<String, BufferedImage> painterCaches = new LinkedHashMap();
    protected LinkedHashMap<String, Integer> painterPriorities = new LinkedHashMap();
    protected LinkedHashMap<String, Integer> cacheMillis = new LinkedHashMap();
    protected Vector<String> sortByPriority = new Vector();
    protected Vector<String> sortByName = new Vector();
    protected StateRenderer2D renderer;

    public PaintersBag(StateRenderer2D renderer) {
        this.renderer = renderer;
    }

    public void addPainter(String name, Renderer2DPainter painter, int priority, int cacheMillis) {
        for (Renderer2DPainter p : this.paintersByName.values()) {
            if (p != painter) continue;
            return;
        }
        this.paintersByName.put(name, painter);
        this.activePainters.put(name, true);
        this.painterPriorities.put(name, priority);
        this.cacheMillis.put(name, cacheMillis);
        this.sortThem();
    }

    public void removePainter(String name) {
        if (this.paintersByName.containsKey(name)) {
            this.paintersByName.remove(name);
            this.activePainters.remove(name);
            this.painterCaches.remove(name);
            this.painterPriorities.remove(name);
            this.cacheMillis.remove(name);
            this.sortThem();
        }
    }

    protected void sortThem() {
        this.sortByPriority.clear();
        this.sortByName.clear();
        this.sortByName.addAll(this.paintersByName.keySet());
        Collections.sort(this.sortByName);
        Vector<String> painterNames = new Vector<String>();
        Vector<Integer> priorities = new Vector<Integer>();
        painterNames.addAll(this.sortByName);
        priorities.addAll(this.painterPriorities.values());
        Collections.sort(priorities);
        block0: while (!priorities.isEmpty()) {
            int prio = (Integer)priorities.get(0);
            priorities.remove(0);
            for (int i = 0; i < painterNames.size(); ++i) {
                if (this.painterPriorities.get(painterNames.get(i)) != prio) continue;
                this.sortByPriority.add((String)painterNames.get(i));
                painterNames.remove(i);
                continue block0;
            }
        }
    }

    public void removePaintersOfType(Class<?> c) {
        Vector<String> namesToRemove = new Vector<String>();
        for (String name : this.paintersByName.keySet()) {
            if (!ReflectionUtil.isSubclass(this.paintersByName.get(name).getClass(), c)) continue;
            namesToRemove.add(name);
        }
        for (String name : namesToRemove) {
            this.removePainter(name);
        }
    }

    public Vector<Renderer2DPainter> getPaintersSortedByPriority() {
        Vector<Renderer2DPainter> painters = new Vector<Renderer2DPainter>();
        for (String name : this.sortByPriority) {
            painters.add(this.paintersByName.get(name));
        }
        return painters;
    }

    public Vector<Renderer2DPainter> getPaintersSortedByName() {
        Vector<Renderer2DPainter> painters = new Vector<Renderer2DPainter>();
        for (String name : this.sortByName) {
            painters.add(this.paintersByName.get(name));
        }
        return painters;
    }

    public void setPainterActive(String name, boolean active) {
        this.activePainters.put(name, active);
    }

    public Vector<Renderer2DPainter> getPreRenderPainters() {
        Vector<Renderer2DPainter> ret = new Vector<Renderer2DPainter>();
        for (String painter : this.sortByPriority) {
            if (this.painterPriorities.get(painter) > 0 || !this.activePainters.get(painter).booleanValue()) continue;
            ret.add(this.paintersByName.get(painter));
        }
        return ret;
    }

    public void remove(Renderer2DPainter painter) {
        String nameToRemove = null;
        for (String name : this.paintersByName.keySet()) {
            if (!this.paintersByName.get(name).equals(painter)) continue;
            nameToRemove = name;
            break;
        }
        if (nameToRemove != null) {
            this.removePainter(nameToRemove);
        }
    }

    public Vector<Renderer2DPainter> getPostRenderPainters() {
        Vector<Renderer2DPainter> ret = new Vector<Renderer2DPainter>();
        for (String painter : this.sortByPriority) {
            if (this.painterPriorities.get(painter) <= 0 || !this.activePainters.get(painter).booleanValue()) continue;
            ret.add(this.paintersByName.get(painter));
        }
        return ret;
    }

    public void showSelectionDialog(Window owner) {
        JPanel inner = this.getSelectionPanel();
        JDialog dialog = new JDialog(owner);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.setTitle(I18n.text("Active layers selection"));
        JScrollPane scrollPane = new JScrollPane(inner);
        scrollPane.setVerticalScrollBarPolicy(22);
        dialog.getContentPane().add(scrollPane);
        dialog.setSize(300, 300);
        dialog.setDefaultCloseOperation(2);
        GuiUtils.centerOnScreen(dialog);
        dialog.setVisible(true);
    }

    public JPanel getSelectionPanel() {
        JPanel inner = new JPanel();
        inner.setLayout(new BoxLayout(inner, 3));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = e.getActionCommand();
                PaintersBag.this.setPainterActive(name, ((JCheckBox)e.getSource()).isSelected());
                PaintersBag.this.renderer.repaint();
            }
        };
        for (String name : this.sortByName) {
            JCheckBox check = new JCheckBox(name);
            check.setSelected(this.activePainters.get(name));
            check.setActionCommand(name);
            check.addActionListener(listener);
            inner.add(check);
        }
        return inner;
    }
}

