/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.MapChangeListener;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.renderer2d.CursorLocationPainter;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.MapClickListener;
import pt.lsts.neptus.renderer2d.MapLegend;
import pt.lsts.neptus.renderer2d.PaintersBag;
import pt.lsts.neptus.renderer2d.Renderer;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.RightMouseClickListener;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.renderer2d.SystemPainterProvider;
import pt.lsts.neptus.renderer2d.WorldRenderPainter;
import pt.lsts.neptus.renderer2d.tiles.TileMercadorSVG;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.VehicleTailElement;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;
import pt.lsts.neptus.util.coord.MapTileUtil;

public class StateRenderer2D
extends JPanel
implements PropertiesProvider,
Renderer,
MapChangeListener,
MouseWheelListener,
MouseMotionListener,
MouseListener,
KeyListener,
PreferencesListener,
ILayerPainter,
CustomInteractionSupport,
IMapPopup,
FocusListener {
    static final long serialVersionUID = 15L;
    public static final int MAP_MOVES = 0;
    public static final int VEHICLE_MOVES = 1;
    public static final float DEFAULT_ZOOM = 1.25f;
    private final int DEFAULT_LOD = 18;
    private final int MIN_LOD = 1;
    private final int MAX_LOD = 22;
    private boolean worldMapShowScreenControls = false;
    public static Cursor rotateCursor;
    public static Cursor translateCursor;
    public static Cursor zoomCursor;
    public static Cursor grabCursor;
    public static Cursor grab2Cursor;
    public static Cursor crosshairCursor;
    public static Cursor drawCursor;
    protected AffineTransform identity = new AffineTransform();
    private final LocationType center = new LocationType();
    public final Point2D worldPixelXY = new Point2D.Double(){

        @Override
        public void setLocation(double x, double y) {
            super.setLocation(x, y);
            this.propagateChange();
        }

        @Override
        public void setLocation(Point2D p) {
            super.setLocation(p);
            this.propagateChange();
        }

        public void propagateChange() {
            StateRenderer2D.this.updateCenter();
            StateRenderer2D.this.setLevelOfDetail(StateRenderer2D.this.levelOfDetail);
            StateRenderer2D.this.repaint();
        }
    };
    private float zoom;
    private int levelOfDetail;
    private double setLevelOfDetailLastLat;
    private double mapScale;
    private double mapScaleLastLat;
    private int mapScaleLastLevelOfDetail;
    private int mapScaleLastScreenResolution;
    protected double rotationRads;
    protected double gridSize;
    protected double fixedVehicleWidth;
    protected int show_mode;
    protected int lastClickedButton;
    protected LinkedList<MapClickListener> clickListeners;
    protected Hashtable<String, SystemPositionAndAttitude> vehicleStates;
    protected String[] vehicles;
    protected Hashtable<String, Image> vehicleImages;
    protected Hashtable<String, VehicleTailElement> vehicleTails;
    protected HashSet<String> vehiclesTailOn;
    protected boolean worldMapShown;
    protected boolean worldBondariesShown;
    protected String worldMapStyle;
    protected boolean gridShown;
    protected boolean showDots;
    protected boolean legendShown;
    protected boolean vehicleImageShown;
    protected boolean mapCenterShown;
    protected boolean mapDragEnable;
    protected boolean isAllTailOn;
    protected int numberOfShownPoints;
    protected Point2D lastDragPoint;
    protected Point2D rulerFirstPoint;
    protected Point2D rulerLastPoint;
    protected MarkElement homeRef;
    protected MapLegend legend;
    protected CursorLocationPainter cursorPainter;
    protected final NumberFormat df;
    protected MapChangeEvent lastMapChangeEvent;
    protected Color gridColor;
    protected MapGroup mapGroup;
    protected int countCache;
    protected static GeneralPath arrow;
    protected WorldRenderPainter worldMapPainter;
    protected String lockedVehicle;
    protected PaintersBag painters;
    protected boolean ignoreRightClicks;
    protected boolean showProperties;
    protected int minDelay;
    protected String editingMap;
    protected Vector<RightMouseClickListener> rightClickListeners;
    protected GeneralPath triangle;
    protected Vector<ChangeListener> changeListeners;
    protected boolean smoothResizing;
    protected boolean antialiasing;
    protected Vector<StateRendererInteraction> interactions;
    private final StateRendererInteraction defaultInteraction;
    protected StateRendererInteraction activeInteraction;
    protected long lastPaintTime;
    protected BufferedImage cache;
    protected boolean forceRepaint;
    protected double lastAngle;
    protected boolean shuttingDown;
    private BufferedImage stage;
    private Vector<IEditorMenuExtension> menuExtensions;
    private Long startTime;

    public StateRenderer2D() {
        double ms2 = (double)MapTileUtil.mapSize(18) / 2.0;
        this.worldPixelXY.setLocation(ms2, ms2);
        this.zoom = 1.25f;
        this.levelOfDetail = 18;
        this.setLevelOfDetail(this.getLevelOfDetail());
        this.setLevelOfDetailLastLat = Double.NaN;
        this.mapScale = Double.NaN;
        this.mapScaleLastLat = Double.NaN;
        this.mapScaleLastLevelOfDetail = -1;
        this.mapScaleLastScreenResolution = -1;
        this.rotationRads = 0.0;
        this.gridSize = 100.0;
        this.fixedVehicleWidth = 25.0;
        this.show_mode = 1;
        this.clickListeners = new LinkedList();
        this.vehicleStates = new Hashtable();
        this.vehicles = new String[0];
        this.vehicleImages = new Hashtable();
        this.vehicleTails = new Hashtable();
        this.vehiclesTailOn = new HashSet();
        this.worldMapShown = true;
        this.worldBondariesShown = false;
        this.worldMapStyle = TileMercadorSVG.getTileStyleID();
        this.gridShown = false;
        this.showDots = false;
        this.legendShown = false;
        this.vehicleImageShown = false;
        this.mapCenterShown = true;
        this.mapDragEnable = true;
        this.isAllTailOn = false;
        this.numberOfShownPoints = 0;
        this.lastDragPoint = null;
        this.rulerFirstPoint = null;
        this.rulerLastPoint = null;
        this.legend = new MapLegend();
        this.cursorPainter = new CursorLocationPainter();
        this.df = GuiUtils.getNeptusDecimalFormat(2);
        this.lastMapChangeEvent = null;
        this.gridColor = new Color(0, 0, 0);
        this.mapGroup = null;
        this.countCache = 0;
        arrow.moveTo(-2.0f, -10.0f);
        arrow.lineTo(2.0f, -10.0f);
        arrow.lineTo(2.0f, 0.0f);
        arrow.lineTo(5.0f, 0.0f);
        arrow.lineTo(0.0f, 10.0f);
        arrow.lineTo(-5.0f, 0.0f);
        arrow.lineTo(-2.0f, 0.0f);
        arrow.closePath();
        this.worldMapPainter = null;
        this.lockedVehicle = null;
        this.painters = new PaintersBag(this);
        this.ignoreRightClicks = false;
        this.showProperties = true;
        this.minDelay = 10;
        this.editingMap = null;
        this.rightClickListeners = new Vector();
        this.triangle = null;
        this.changeListeners = new Vector();
        this.smoothResizing = false;
        this.antialiasing = true;
        this.interactions = new Vector();
        this.activeInteraction = this.defaultInteraction = new InteractionAdapter(null);
        this.lastPaintTime = 0L;
        this.cache = null;
        this.forceRepaint = false;
        this.lastAngle = 0.0;
        this.shuttingDown = false;
        this.menuExtensions = new Vector();
        this.startTime = null;
        this.setMapGroup(MapGroup.getMapGroupInstance(null));
        LocationType portugal = new LocationType();
        portugal.setLatitudeDegs(38.711233);
        portugal.setLongitudeDegs(-9.18457);
        this.setCenter(portugal);
        this.init();
    }

    public StateRenderer2D(LocationType center) {
        double ms2 = (double)MapTileUtil.mapSize(18) / 2.0;
        this.worldPixelXY.setLocation(ms2, ms2);
        this.zoom = 1.25f;
        this.levelOfDetail = 18;
        this.setLevelOfDetail(this.getLevelOfDetail());
        this.setLevelOfDetailLastLat = Double.NaN;
        this.mapScale = Double.NaN;
        this.mapScaleLastLat = Double.NaN;
        this.mapScaleLastLevelOfDetail = -1;
        this.mapScaleLastScreenResolution = -1;
        this.rotationRads = 0.0;
        this.gridSize = 100.0;
        this.fixedVehicleWidth = 25.0;
        this.show_mode = 1;
        this.clickListeners = new LinkedList();
        this.vehicleStates = new Hashtable();
        this.vehicles = new String[0];
        this.vehicleImages = new Hashtable();
        this.vehicleTails = new Hashtable();
        this.vehiclesTailOn = new HashSet();
        this.worldMapShown = true;
        this.worldBondariesShown = false;
        this.worldMapStyle = TileMercadorSVG.getTileStyleID();
        this.gridShown = false;
        this.showDots = false;
        this.legendShown = false;
        this.vehicleImageShown = false;
        this.mapCenterShown = true;
        this.mapDragEnable = true;
        this.isAllTailOn = false;
        this.numberOfShownPoints = 0;
        this.lastDragPoint = null;
        this.rulerFirstPoint = null;
        this.rulerLastPoint = null;
        this.legend = new MapLegend();
        this.cursorPainter = new CursorLocationPainter();
        this.df = GuiUtils.getNeptusDecimalFormat(2);
        this.lastMapChangeEvent = null;
        this.gridColor = new Color(0, 0, 0);
        this.mapGroup = null;
        this.countCache = 0;
        arrow.moveTo(-2.0f, -10.0f);
        arrow.lineTo(2.0f, -10.0f);
        arrow.lineTo(2.0f, 0.0f);
        arrow.lineTo(5.0f, 0.0f);
        arrow.lineTo(0.0f, 10.0f);
        arrow.lineTo(-5.0f, 0.0f);
        arrow.lineTo(-2.0f, 0.0f);
        arrow.closePath();
        this.worldMapPainter = null;
        this.lockedVehicle = null;
        this.painters = new PaintersBag(this);
        this.ignoreRightClicks = false;
        this.showProperties = true;
        this.minDelay = 10;
        this.editingMap = null;
        this.rightClickListeners = new Vector();
        this.triangle = null;
        this.changeListeners = new Vector();
        this.smoothResizing = false;
        this.antialiasing = true;
        this.interactions = new Vector();
        this.activeInteraction = this.defaultInteraction = new InteractionAdapter(null);
        this.lastPaintTime = 0L;
        this.cache = null;
        this.forceRepaint = false;
        this.lastAngle = 0.0;
        this.shuttingDown = false;
        this.menuExtensions = new Vector();
        this.startTime = null;
        CoordinateSystem cs = new CoordinateSystem();
        cs.setLocation(center);
        this.setMapGroup(MapGroup.getNewInstance(cs));
        this.setCenter(center);
        this.init();
    }

    public StateRenderer2D(MapGroup mapGroup) {
        double ms2 = (double)MapTileUtil.mapSize(18) / 2.0;
        this.worldPixelXY.setLocation(ms2, ms2);
        this.zoom = 1.25f;
        this.levelOfDetail = 18;
        this.setLevelOfDetail(this.getLevelOfDetail());
        this.setLevelOfDetailLastLat = Double.NaN;
        this.mapScale = Double.NaN;
        this.mapScaleLastLat = Double.NaN;
        this.mapScaleLastLevelOfDetail = -1;
        this.mapScaleLastScreenResolution = -1;
        this.rotationRads = 0.0;
        this.gridSize = 100.0;
        this.fixedVehicleWidth = 25.0;
        this.show_mode = 1;
        this.clickListeners = new LinkedList();
        this.vehicleStates = new Hashtable();
        this.vehicles = new String[0];
        this.vehicleImages = new Hashtable();
        this.vehicleTails = new Hashtable();
        this.vehiclesTailOn = new HashSet();
        this.worldMapShown = true;
        this.worldBondariesShown = false;
        this.worldMapStyle = TileMercadorSVG.getTileStyleID();
        this.gridShown = false;
        this.showDots = false;
        this.legendShown = false;
        this.vehicleImageShown = false;
        this.mapCenterShown = true;
        this.mapDragEnable = true;
        this.isAllTailOn = false;
        this.numberOfShownPoints = 0;
        this.lastDragPoint = null;
        this.rulerFirstPoint = null;
        this.rulerLastPoint = null;
        this.legend = new MapLegend();
        this.cursorPainter = new CursorLocationPainter();
        this.df = GuiUtils.getNeptusDecimalFormat(2);
        this.lastMapChangeEvent = null;
        this.gridColor = new Color(0, 0, 0);
        this.mapGroup = null;
        this.countCache = 0;
        arrow.moveTo(-2.0f, -10.0f);
        arrow.lineTo(2.0f, -10.0f);
        arrow.lineTo(2.0f, 0.0f);
        arrow.lineTo(5.0f, 0.0f);
        arrow.lineTo(0.0f, 10.0f);
        arrow.lineTo(-5.0f, 0.0f);
        arrow.lineTo(-2.0f, 0.0f);
        arrow.closePath();
        this.worldMapPainter = null;
        this.lockedVehicle = null;
        this.painters = new PaintersBag(this);
        this.ignoreRightClicks = false;
        this.showProperties = true;
        this.minDelay = 10;
        this.editingMap = null;
        this.rightClickListeners = new Vector();
        this.triangle = null;
        this.changeListeners = new Vector();
        this.smoothResizing = false;
        this.antialiasing = true;
        this.interactions = new Vector();
        this.activeInteraction = this.defaultInteraction = new InteractionAdapter(null);
        this.lastPaintTime = 0L;
        this.cache = null;
        this.forceRepaint = false;
        this.lastAngle = 0.0;
        this.shuttingDown = false;
        this.menuExtensions = new Vector();
        this.startTime = null;
        this.setMapGroup(mapGroup);
        this.init();
    }

    protected void init() {
        this.loadCursors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.setBackground(new Color(2, 113, 171));
        this.setFocusable(true);
        this.addKeyListener(this);
        this.preferencesUpdated();
        GeneralPreferences.addPreferencesListener(this);
        try {
            this.worldMapPainter = new WorldRenderPainter(this, this.isWorldBondariesShown(), this.isWorldMapShown(), this.getWorldMapStyle());
            this.worldMapPainter.setShowOnScreenControls(this.worldMapShowScreenControls);
            this.addPreRenderPainter(this.worldMapPainter);
            this.addPostRenderPainter(this.worldMapPainter.getPostRenderPainter(), "World Map Painter Control");
        }
        catch (NoClassDefFoundError e) {
            NeptusLog.pub().warn((Object)"Probably running inside a reduced api jar!!", (Throwable)e);
            e.printStackTrace();
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                StateRenderer2D.this.stage = null;
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public boolean isShowWorldMapOnScreen() {
        return this.worldMapPainter.isDrawWorldMap();
    }

    public void setShowWorldMapOnScreen(boolean showOnScreen) {
        this.worldMapPainter.setDrawWorldMap(showOnScreen);
    }

    public boolean isShowWorldMapOnScreenControls() {
        return this.worldMapShowScreenControls;
    }

    public void setShowWorldMapOnScreenControls(boolean showOnScreenControls) {
        this.worldMapShowScreenControls = showOnScreenControls;
        if (this.worldMapPainter != null) {
            this.worldMapPainter.setShowOnScreenControls(showOnScreenControls);
        }
    }

    protected Thread getRenderer2dUpdaterThread(int millisBetweenUpdates) {
        final long millis = millisBetweenUpdates;
        Thread t = new Thread("R2D updater"){

            @Override
            public void run() {
                while (!StateRenderer2D.this.shuttingDown) {
                    try {
                        Thread.sleep(millis);
                        StateRenderer2D.this.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        return t;
    }

    private void loadCursors() {
        rotateCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/rotate_cursor.png"), new Point(12, 12), "Rotate");
        zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/zoom_cursor.png"), new Point(6, 6), "Zoom");
        translateCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/translate_cursor.png"), new Point(12, 12), "Translate");
        grabCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/grab_cursor.png"), new Point(11, 11), "Grab");
        grab2Cursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/grab2_cursor.png"), new Point(11, 11), "Grab2");
        crosshairCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/crosshair_cursor.png"), new Point(12, 12), "Crosshair");
        drawCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/pencil.png"), new Point(0, 20), "Draw");
    }

    public LocationType getTopLeftLocationType() {
        return this.getRealWorldLocation(new Point2D.Double(0.0, 0.0));
    }

    public LocationType getBottomRightLocationType() {
        return this.getRealWorldLocation(new Point2D.Double(this.getWidth(), this.getHeight()));
    }

    public LocationType getRandomVisibleLocationType() {
        LocationType center = new LocationType(this.getCenter());
        Random rnd = new Random(System.currentTimeMillis());
        double offsetEast = (float)this.getWidth() / (2.0f * this.zoom);
        double offsetNorth = (float)this.getHeight() / (2.0f * this.zoom);
        if (rnd.nextBoolean()) {
            offsetEast *= -1.0;
        }
        if (rnd.nextBoolean()) {
            offsetNorth *= -1.0;
        }
        center.translatePosition(offsetNorth *= (double)rnd.nextFloat(), offsetEast *= (double)rnd.nextFloat(), 0.0);
        this.setLevelOfDetail(this.levelOfDetail);
        return center;
    }

    public Point2D getScreenPosition(LocationType lt) {
        double x = (double)this.getWidth() / 2.0;
        double y = (double)this.getHeight() / 2.0;
        Point2D ltPix = lt.getPointInPixel(this.levelOfDetail);
        double[] dxy = new double[]{-this.worldPixelXY.getX() + ltPix.getX(), -this.worldPixelXY.getY() + ltPix.getY()};
        Point2D.Double pt = new Point2D.Double(x += dxy[0], y += dxy[1]);
        double xc = (double)this.getWidth() / 2.0;
        double yc = (double)this.getHeight() / 2.0;
        if (this.rotationRads != 0.0) {
            double dist = pt.distance(xc, yc);
            double angle = Math.atan2(y - yc, x - xc);
            double newX = xc + dist * Math.cos(angle -= this.rotationRads);
            double newY = yc + dist * Math.sin(angle);
            x = newX;
            y = newY;
        }
        Point2D.Double result = new Point2D.Double(x, y);
        return result;
    }

    public void setFixedVehicleWidth(double fixedVehicleWidth) {
        this.fixedVehicleWidth = fixedVehicleWidth;
    }

    @Override
    public void mapChanged(MapChangeEvent mapChange) {
        if (mapChange.equals(this.lastMapChangeEvent)) {
            return;
        }
        this.lastMapChangeEvent = mapChange;
        if (mapChange.getEventType() == -1) {
            LocationType oldCenter = new LocationType(this.getCenter());
            this.setMapGroup(MapGroup.getMapGroupInstance(this.getMapGroup().getMission()));
            this.setCenter(oldCenter);
            this.repaint();
            return;
        }
        this.forceRepaint();
    }

    @Override
    public void setMapGroup(MapGroup mapGroup) {
        if (this.mapGroup != null) {
            this.mapGroup.removeChangeListener(this);
        }
        this.mapGroup = mapGroup;
        this.setCenter((LocationType)mapGroup.getCoordinateSystem().getNewAbsoluteLatLonDepth());
        mapGroup.addChangeListener(this);
        this.legend.setCenterLocation(this.getCenter());
        this.setLegendShown(true);
        this.addMouseWheelListener(this);
    }

    public void showAllMap() {
        AbstractElement[] objs = this.mapGroup.getAllObjects();
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < objs.length; ++i) {
            double[] ned = objs[i].getNEDPosition();
            minX = Math.min(minX, ned[1]);
            minY = Math.min(minY, ned[0]);
            maxX = Math.max(maxX, ned[1]);
            maxY = Math.max(maxY, ned[0]);
        }
        double realWidth = maxX - minX;
        double realHeight = maxY - minY;
        LocationType newCenter = new LocationType();
        newCenter.setOffsetNorth(realHeight / 2.0);
        newCenter.setOffsetEast(realWidth / 2.0);
        this.setZoom((float)this.getWidth() / (float)realWidth);
        this.focusLocation(newCenter);
    }

    @Override
    public MapGroup getMapGroup() {
        return this.mapGroup;
    }

    public void vehicleStateChanged(String systemId, SystemPositionAndAttitude state, boolean repaint) {
        if (state == null) {
            this.vehicleStates.remove(systemId);
            this.vehicleTails.remove(systemId);
            this.vehicles = this.vehicleStates.keySet().toArray(new String[0]);
            if (repaint) {
                this.repaint();
            }
        } else {
            VehicleType vehicleType = VehiclesHolder.getVehicleById(systemId);
            if (!this.vehicleImages.containsKey(systemId) && vehicleType != null) {
                Image vehicleImage = ImageUtils.getImage(vehicleType.getTopImageHref());
                this.vehicleImages.put(systemId, vehicleImage);
            }
            if (!this.vehicleTails.containsKey(systemId)) {
                VehicleTailElement vehicleTail;
                if (vehicleType != null) {
                    vehicleTail = new VehicleTailElement(this.getMapGroup(), new MapType(), vehicleType.getIconColor());
                    vehicleTail.setNumberOfPoints(this.numberOfShownPoints);
                    this.vehicleTails.put(systemId, vehicleTail);
                } else {
                    vehicleTail = new VehicleTailElement(this.getMapGroup(), new MapType(), Color.black);
                    vehicleTail.setNumberOfPoints(this.numberOfShownPoints);
                    this.vehicleTails.put(systemId, vehicleTail);
                }
            }
            if (!this.vehicleStates.containsKey(systemId)) {
                this.vehicles = this.vehicleStates.keySet().toArray(new String[0]);
            }
            this.vehicleStates.put(systemId, state);
            this.vehicleTails.get(systemId).addPoint(state.getPosition());
            if (!repaint || System.currentTimeMillis() - this.lastPaintTime < (long)this.minDelay) {
                return;
            }
            this.repaint();
        }
    }

    @Override
    public void vehicleStateChanged(String systemId, SystemPositionAndAttitude state) {
        this.vehicleStateChanged(systemId, state, true);
    }

    public void removeVehicle(VehicleType vehicle) {
        this.vehicleStates.remove(vehicle);
        this.vehicleImages.remove(vehicle);
        this.vehicleTails.remove(vehicle);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        this.activeInteraction.wheelMoved(arg0, this);
        this.repaint();
    }

    public int getLevelOfDetail() {
        return this.levelOfDetail;
    }

    public int setLevelOfDetail(int levelOfDetail) {
        int oldLevelOfDetail = this.levelOfDetail;
        if (this.levelOfDetail != levelOfDetail) {
            levelOfDetail = Math.min(Math.max(levelOfDetail, 1), 22);
            int minLod = 1;
            for (int lod = 1; lod <= 22; ++lod) {
                int mst = MapTileUtil.mapSize(lod);
                int wt = this.getWidth();
                int ht = this.getHeight();
                minLod = lod;
                if (mst >= wt && mst >= ht) break;
            }
            levelOfDetail = Math.max(minLod, levelOfDetail);
            double tz = 1.0 / MapTileUtil.groundResolution(this.getCenter().getLatitudeDegs(), levelOfDetail);
            if (tz < 0.0) {
                return this.levelOfDetail;
            }
            this.levelOfDetail = levelOfDetail;
            this.zoom = (float)tz;
            this.setLevelOfDetailLastLat = this.getCenter().getLatitudeDegs();
        }
        if (Double.isNaN(this.setLevelOfDetailLastLat) || this.setLevelOfDetailLastLat != this.getCenter().getLatitudeDegs()) {
            this.setLevelOfDetailLastLat = this.getCenter().getLatitudeDegs();
            double tz = 1.0 / MapTileUtil.groundResolution(this.setLevelOfDetailLastLat, this.levelOfDetail);
            this.zoom = (float)tz;
        }
        if (this.levelOfDetail != oldLevelOfDetail) {
            double wc = Math.pow(2.0, this.levelOfDetail - oldLevelOfDetail);
            double nwx = this.worldPixelXY.getX() == 0.0 ? 0.0 : this.worldPixelXY.getX() * wc;
            double nwy = this.worldPixelXY.getY() == 0.0 ? 0.0 : this.worldPixelXY.getY() * wc;
            this.worldPixelXY.setLocation(nwx, nwy);
        }
        this.getMapScale();
        this.repaint();
        return this.levelOfDetail;
    }

    public void zoomIn() {
        this.zoomInOut(true, this.getWidth() / 2, this.getHeight() / 2);
    }

    public void zoomOut() {
        this.zoomInOut(false, this.getWidth() / 2, this.getHeight() / 2);
    }

    public void zoomInOut(boolean inOrOut, double localRenderX, double localRenderY) {
        if (!inOrOut) {
            double nwx = -(localRenderX - (double)(this.getWidth() / 2));
            double nwy = -(localRenderY - (double)(this.getHeight() / 2));
            this.worldPixelXY.setLocation(this.worldPixelXY.getX() + nwx, this.worldPixelXY.getY() + nwy);
            this.setLevelOfDetail(this.getLevelOfDetail() - 1);
        } else {
            this.setLevelOfDetail(this.getLevelOfDetail() + 1);
            double nwx = localRenderX - (double)(this.getWidth() / 2);
            double nwy = localRenderY - (double)(this.getHeight() / 2);
            this.worldPixelXY.setLocation(this.worldPixelXY.getX() + nwx, this.worldPixelXY.getY() + nwy);
        }
    }

    public void resetView() {
        this.focusLocation(this.getMapGroup().getHomeRef().getCenterLocation());
        this.setRotation(0.0);
        this.setZoom(1.25f);
        this.setLevelOfDetail(18);
        this.repaint();
    }

    public float getZoom() {
        return this.zoom;
    }

    public float setZoom(float newZoom) {
        double grdResol = 1.0 / (double)newZoom;
        for (int lod = 1; lod <= 22; ++lod) {
            double t2;
            double lodG1 = MapTileUtil.groundResolution(this.getCenter().getLatitudeDegs(), lod);
            double lodG2 = MapTileUtil.groundResolution(this.getCenter().getLatitudeDegs(), lod + 1);
            if (grdResol > lodG1) {
                this.setLevelOfDetail(lod);
                break;
            }
            if (!(grdResol > lodG2)) continue;
            double t1 = Math.abs(lodG1 - grdResol);
            if (t1 <= (t2 = Math.abs(grdResol - lodG2))) {
                this.setLevelOfDetail(lod);
                break;
            }
            this.setLevelOfDetail(lod + 1);
            break;
        }
        return this.zoom;
    }

    public double getMapScale() {
        boolean recalc = false;
        if (Double.isNaN(this.mapScale) || Double.isNaN(this.mapScaleLastLat) || this.mapScaleLastLevelOfDetail == -1 || this.mapScaleLastScreenResolution == -1) {
            recalc = true;
        } else if (this.mapScaleLastLat != this.getCenter().getLatitudeDegs() || this.mapScaleLastLevelOfDetail != this.levelOfDetail || this.mapScaleLastScreenResolution != Toolkit.getDefaultToolkit().getScreenResolution()) {
            recalc = true;
        }
        if (recalc) {
            this.mapScaleLastLat = this.getCenter().getLatitudeDegs();
            this.mapScaleLastLevelOfDetail = this.levelOfDetail;
            this.mapScaleLastScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
            this.mapScale = MapTileUtil.mapScale(this.mapScaleLastLat, this.mapScaleLastLevelOfDetail, this.mapScaleLastScreenResolution);
        }
        return this.mapScale;
    }

    public void setMap(MapType map) {
        this.mapGroup = MapGroup.getNewInstance(null);
        this.mapGroup.addMap(map);
        this.forceRepaint();
    }

    public void forceRepaint() {
        this.forceRepaint = true;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.zoom = Math.min(50.0f, this.zoom);
        if (this.startTime == null) {
            this.startTime = System.currentTimeMillis();
        }
        if (!this.isVisible() || this.getWidth() <= 0) {
            return;
        }
        if (this.stage == null) {
            this.stage = ImageUtils.createCompatibleImage(this.getWidth(), this.getHeight(), 1);
        }
        Graphics2D g2d = (Graphics2D)this.stage.getGraphics();
        this.update(g2d, this.forceRepaint);
        g.drawImage(this.stage, 0, 0, this.getWidth(), this.getHeight(), null);
        this.forceRepaint = false;
        this.lastPaintTime = System.currentTimeMillis();
    }

    public void addMapClickListener(MapClickListener newListener) {
        NeptusLog.pub().info((Object)("Added a map click listener: " + newListener.getClass().getSimpleName()));
        this.clickListeners.addLast(newListener);
    }

    public void removeMapClickListener(MapClickListener listener) {
        this.clickListeners.remove(listener);
    }

    public boolean isVehicleImageShown() {
        return this.vehicleImageShown;
    }

    public void setVehicleImageShown(boolean vehicleImageShown) {
        this.vehicleImageShown = vehicleImageShown;
    }

    public boolean isMapCenterShown() {
        return this.mapCenterShown;
    }

    public void setMapCenterShow(boolean mapCenterShown) {
        this.mapCenterShown = mapCenterShown;
    }

    public boolean isMapDragEnable() {
        return this.mapDragEnable;
    }

    public void setMapDragEnable(boolean mapDragEnable) {
        this.mapDragEnable = mapDragEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics2D g2d, boolean force) {
        Object loc;
        if (this.antialiasing) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Graphics2D original = g2d;
        if (this.lockedVehicle != null && this.vehicleStates.get(this.lockedVehicle) != null) {
            SystemPositionAndAttitude state = this.vehicleStates.get(this.lockedVehicle);
            loc = new LocationType(state.getPosition());
            ((LocationType)loc).convertToAbsoluteLatLonDepth();
            this.setRotation(state.getYaw());
            this.setCenter((LocationType)loc);
        }
        this.identity = g2d.getTransform();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        boolean systemsPainterActive = false;
        loc = this.painters;
        synchronized (loc) {
            for (Renderer2DPainter painter : this.painters.getPreRenderPainters()) {
                if (painter instanceof SystemPainterProvider) {
                    SystemPainterProvider spp = (SystemPainterProvider)painter;
                    systemsPainterActive = systemsPainterActive || spp.isSystemPainterEnabled();
                }
                Graphics2D g = (Graphics2D)original.create();
                try {
                    painter.paint(g, this);
                }
                catch (Exception e) {
                    NeptusLog.pub().warn((Object)(painter.getClass().getSimpleName() + " pre-render painter: " + e.getMessage()), (Throwable)e);
                }
                g.dispose();
            }
        }
        AbstractElement[] objs = this.mapGroup.getAllObjects();
        for (int i = 0; i < objs.length; ++i) {
            AbstractElement tmp = objs[i];
            if (tmp.getTransparency() >= 100) continue;
            try {
                tmp.paint((Graphics2D)original.create(), this, (float)(-this.rotationRads));
                continue;
            }
            catch (Exception e) {
                NeptusLog.pub().warn((Object)(tmp.getClass().getSimpleName() + " map element paint: " + e.getMessage()), (Throwable)e);
            }
        }
        g2d = (Graphics2D)original.create();
        PaintersBag i = this.painters;
        synchronized (i) {
            for (Renderer2DPainter painter : this.painters.getPostRenderPainters()) {
                if (painter instanceof SystemPainterProvider) {
                    SystemPainterProvider spp = (SystemPainterProvider)painter;
                    systemsPainterActive = systemsPainterActive || spp.isSystemPainterEnabled();
                }
                Graphics2D g = (Graphics2D)original.create();
                try {
                    painter.paint(g, this);
                }
                catch (Exception e) {
                    NeptusLog.pub().warn((Object)(painter.getClass().getSimpleName() + " post-render painter: " + e.getMessage()), (Throwable)e);
                }
                g.dispose();
            }
        }
        g2d.setTransform(this.identity);
        for (String key : this.vehicleTails.keySet()) {
            VehicleTailElement vte = this.vehicleTails.get(key);
            if (!this.isAllTailOn && (this.isAllTailOn || !this.vehiclesTailOn.contains(key)) || vte == null) continue;
            try {
                vte.paint(g2d, this, (float)(-this.rotationRads));
            }
            catch (Exception e) {
                NeptusLog.pub().warn((Object)(vte.getClass().getSimpleName() + " vehicle breadcrums painter: " + e.getMessage()), (Throwable)e);
            }
        }
        g2d.setTransform(this.identity);
        g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
        g2d.scale(1.0, -1.0);
        g2d.setColor(Color.BLACK);
        Enumeration<String> e = this.vehicleStates.keys();
        while (e.hasMoreElements()) {
            String system = e.nextElement();
            VehicleType vehicle = VehiclesHolder.getVehicleById(system);
            Image vehicleImage = this.vehicleImages.get(system);
            SystemPositionAndAttitude vehicleState = this.vehicleStates.get(system);
            double wSize = vehicle != null ? (double)vehicle.getYSize() : 1.0;
            double hSize = vehicle != null ? (double)vehicle.getXSize() : 1.0;
            double vehicleWidth = wSize * (double)this.zoom;
            double vehicleHeight = hSize * (double)this.zoom;
            if (this.fixedVehicleWidth != 0.0) {
                if (hSize > wSize) {
                    vehicleHeight = this.fixedVehicleWidth;
                    vehicleWidth = this.fixedVehicleWidth * (wSize / hSize);
                } else {
                    vehicleWidth = this.fixedVehicleWidth;
                    vehicleHeight = hSize / wSize * this.fixedVehicleWidth;
                }
            }
            Point2D tt = this.getScreenPosition(vehicleState.getPosition());
            Graphics2D copy = (Graphics2D)original.create();
            copy.setStroke(new BasicStroke(1.0f));
            if (this.lockedVehicle != null && system != null && this.lockedVehicle.equals(system)) {
                copy.setColor(Color.green.brighter());
            } else {
                copy.setColor(Color.red.darker());
            }
            copy.translate(tt.getX(), tt.getY());
            if (!systemsPainterActive) {
                copy.drawString(system, 12, 0);
            }
            copy.rotate(vehicleState.getYaw() - this.rotationRads);
            if (!systemsPainterActive) {
                Color iconColor = vehicle != null ? vehicle.getIconColor() : Color.WHITE;
                copy.draw(new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0));
                copy.scale(1.0, -1.0);
                copy.setColor(iconColor);
                copy.fill(arrow);
                copy.setColor(iconColor.darker());
                copy.draw(arrow);
                copy.scale(1.0, -1.0);
            }
            if (!this.isVehicleImageShown()) continue;
            Graphics2D otherCopy = (Graphics2D)copy.create();
            otherCopy.scale(vehicleWidth / (double)vehicleImage.getWidth(null), -vehicleHeight / (double)vehicleImage.getHeight(null));
            otherCopy.drawImage(vehicleImage, -vehicleImage.getWidth(null) / 2, -vehicleImage.getHeight(null) / 2, null);
            otherCopy.dispose();
        }
        this.activeInteraction.paintInteraction(g2d, this);
        if (this.isGridShown()) {
            this.drawGrid(g2d, this.getGridSize());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.requestFocusInWindow();
        this.activeInteraction.mouseDragged(e, this);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.requestFocusInWindow();
        this.activeInteraction.mouseMoved(e, this);
        this.repaint();
    }

    public void addRightMouseClickListener(RightMouseClickListener listener) {
        if (!this.rightClickListeners.contains(listener)) {
            this.rightClickListeners.add(listener);
        }
    }

    public void removeRightMouseClickListener(RightMouseClickListener listener) {
        this.rightClickListeners.remove(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
        this.activeInteraction.mouseClicked(e, this);
        if (this.activeInteraction != this.defaultInteraction && this.activeInteraction.isExclusive()) {
            return;
        }
        Point mousePoint = e.getPoint();
        LocationType loc = this.getRealWorldLocation(mousePoint);
        if (e.getButton() == 3 && !this.ignoreRightClicks) {
            JPopupMenu popup = new JPopupMenu();
            if (this.rightClickListeners.size() > 0) {
                final MouseEvent evt = e;
                Iterator<RightMouseClickListener> i$ = this.rightClickListeners.iterator();
                while (i$.hasNext()) {
                    RightMouseClickListener l;
                    final RightMouseClickListener r = l = i$.next();
                    AbstractAction act = new AbstractAction(r.getPresentationName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            r.itemSelected(StateRenderer2D.this, evt.getPoint(), StateRenderer2D.this.getRealWorldLocation(evt.getPoint()));
                        }
                    };
                    popup.add(act);
                }
                popup.addSeparator();
            }
            final LocationType lt = this.getRealWorldLocation(e.getPoint());
            JMenuItem item = new JMenuItem(I18n.text("Choose Visible World Map"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StateRenderer2D.this.worldMapPainter.showChooseMapStyleDialog(StateRenderer2D.this);
                }
            });
            item.setIcon(new ImageIcon(this.worldMapPainter.ICON_WORLD_SETTINGS));
            popup.add(item);
            item = new JMenuItem(I18n.text("Choose Visible Layers"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StateRenderer2D.this.painterSelection();
                }
            });
            popup.add(item);
            item = new JMenuItem(I18n.text("Copy Location"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CoordinateUtil.copyToClipboard(lt);
                }
            });
            item.setIcon(ImageUtils.getIcon("images/menus/editcopy.png"));
            popup.add(item);
            item = new JMenuItem(I18n.text("Center"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StateRenderer2D.this.setCenter(lt);
                    StateRenderer2D.this.repaint();
                }
            });
            item = new JMenuItem(I18n.text("R2D Shortcuts"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiUtils.htmlMessage(ConfigFetch.getSuperParentFrame() == null ? StateRenderer2D.this : ConfigFetch.getSuperParentFrame(), I18n.text("2D Renderer Shortcuts"), I18n.text("(Keys pressed while the Renderer component is focused)"), "<html><h1>" + I18n.text("2D Renderer Shortcuts") + "</h1><br><div align='center'><table border='1' align='center'><tr><th>" + I18n.text("Key Combination") + "</th><th>" + I18n.text("Action") + "</th></tr>" + "<tr><td>" + I18n.text("plus (+)") + "</td><td>" + I18n.text("Double the current zoom value") + "</td></tr>" + "<tr><td>" + I18n.text("minus (-)") + "</td><td>" + I18n.text("Half the current zoom value") + "</td></tr>" + "<tr><td>" + I18n.text("left") + "</td><td>" + I18n.text("Move the map to the left") + "</td></tr>" + "<tr><td>" + I18n.text("right") + "</td><td>" + I18n.text("Move the map to the right") + "</td></tr>" + "<tr><td>" + I18n.text("up") + "</td><td>" + I18n.text("Move the map upwards") + "</td></tr>" + "<tr><td>" + I18n.text("down") + "</td><td>" + I18n.text("Move the map downwards") + "</td></tr>" + "<tr><td>" + I18n.textc("N", "N key") + "</td><td>" + I18n.text("Reset the current rotation (up facing north)") + "</td></tr>" + "<tr><td>" + I18n.text("F1") + "</td><td>" + I18n.text("Reset the current view to defaults") + "</td></tr></table></div>");
                }
            });
            item.setIcon(ImageUtils.getIcon("images/menus/info.png"));
            popup.add(item);
            item = new JMenuItem(I18n.text("Settings..."));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PropertiesEditor.editProperties(StateRenderer2D.this, true);
                }
            });
            item.setIcon(ImageUtils.getIcon("images/menus/settings.png"));
            for (IEditorMenuExtension extension : this.menuExtensions) {
                Collection<JMenuItem> items = null;
                try {
                    items = extension.getApplicableItems(loc, this);
                }
                catch (Exception ex) {
                    NeptusLog.pub().error((Object)ex);
                }
                if (items == null || items.isEmpty()) continue;
                popup.addSeparator();
                for (JMenuItem it : items) {
                    if (it instanceof JMenu) {
                        MenuScroller.setScrollerFor((JMenu)it, (Component)this, 150, 0, 0);
                    }
                    popup.add(it);
                }
            }
            popup.show(this, e.getX(), e.getY());
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.activeInteraction.mouseExited(e, this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.activeInteraction.mousePressed(e, this);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.requestFocusInWindow();
        this.activeInteraction.mouseReleased(e, this);
        this.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.activeInteraction.focusGained(e, this);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.activeInteraction.focusLost(e, this);
    }

    public double getRealXCoord(int screenX) {
        double[] mapcenter = this.getCenter().getOffsetFrom(new LocationType());
        double x = screenX;
        return mapcenter[1] + (x -= (double)(this.getWidth() / 2)) / (double)this.zoom;
    }

    public double getRealYCoord(int screenY) {
        double[] mapcenter = this.getCenter().getOffsetFrom(new LocationType());
        double y = screenY;
        return mapcenter[0] - (y -= (double)(this.getHeight() / 2)) / (double)this.zoom;
    }

    public LocationType getRealWorldLocation(Point2D screenCoordinates) {
        double tx = screenCoordinates.getX() - (double)(this.getWidth() / 2);
        double ty = screenCoordinates.getY() - (double)(this.getHeight() / 2);
        if (this.rotationRads != 0.0) {
            double angle = Math.atan2(ty, tx);
            double dist = Math.sqrt(tx * tx + ty * ty);
            tx = dist * Math.cos(angle += this.rotationRads);
            ty = dist * Math.sin(angle);
        }
        Point2D centerXY = this.worldPixelXY;
        double[] latLong = MapTileUtil.XYToDegrees(centerXY.getX() + tx, centerXY.getY() + ty, this.levelOfDetail);
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(latLong[0]);
        loc.setLongitudeDegs(latLong[1]);
        return loc;
    }

    @Override
    public void focusLocation(LocationType location) {
        this.setCenter((LocationType)location.getNewAbsoluteLatLonDepth());
        this.repaint();
    }

    @Override
    public void focusObject(AbstractElement mo) {
        this.focusLocation(mo.getCenterLocation());
    }

    public int getViewMode() {
        return 1;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public void setMinDelay(int minDelay) {
        this.minDelay = minDelay;
    }

    @Override
    public void followVehicle(String systemId) {
        this.show_mode = systemId != null ? 0 : 1;
        this.lockedVehicle = systemId;
        this.repaint();
    }

    @Override
    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    @Override
    public int getShowMode() {
        return this.show_mode;
    }

    public boolean isLegendShown() {
        return this.legendShown;
    }

    public void setLegendShown(boolean legendShown) {
        if (!this.legendShown && legendShown) {
            this.addPostRenderPainter(this.legend, "Legend");
            this.addPostRenderPainter(this.cursorPainter, "Cursor Painter");
        }
        if (this.legendShown && !legendShown) {
            this.removePostRenderPainter(this.legend);
            this.removePostRenderPainter(this.cursorPainter);
        }
        this.legendShown = legendShown;
    }

    public boolean isWorldMapShown() {
        return this.worldMapShown;
    }

    public void setWorldMapShown(boolean worldMapShown) {
        if (this.worldMapPainter == null) {
            return;
        }
        this.worldMapPainter.setDrawWorldMap(worldMapShown);
        this.worldMapShown = worldMapShown;
    }

    public boolean isWorldBondariesShown() {
        return this.worldBondariesShown;
    }

    public void setWorldBondariesShown(boolean worldBondariesShown) {
        if (this.worldMapPainter == null) {
            return;
        }
        this.worldMapPainter.setDrawWorldBoundaries(worldBondariesShown);
        this.worldBondariesShown = worldBondariesShown;
    }

    public String getWorldMapStyle() {
        return this.worldMapStyle;
    }

    public void setWorldMapStyle(String worldMapStyle) {
        if (this.worldMapPainter == null) {
            return;
        }
        this.worldMapPainter.setMapStyle(worldMapStyle);
        this.worldMapStyle = worldMapStyle;
    }

    public LocationType getCenter() {
        return this.center.getNewAbsoluteLatLonDepth();
    }

    private final void updateCenter() {
        double[] latLon = MapTileUtil.XYToDegrees(this.worldPixelXY.getX(), this.worldPixelXY.getY(), this.getLevelOfDetail());
        this.center.setLatitudeDegs(latLon[0]);
        this.center.setLongitudeDegs(latLon[1]);
    }

    public void setCenter(LocationType center) {
        Point2D nc = ((LocationType)center.getNewAbsoluteLatLonDepth()).getPointInPixel(this.getLevelOfDetail());
        this.worldPixelXY.setLocation(nc);
        this.setLevelOfDetail(this.getLevelOfDetail());
    }

    public void drawGrid(Graphics2D g, double cellSize) {
        double panelCellSize = cellSize * (double)this.zoom;
        if (panelCellSize < 3.0) {
            return;
        }
        g.setTransform(this.identity);
        g.setColor(new Color(this.getGridColor().getRed(), this.getGridColor().getGreen(), this.getGridColor().getBlue(), 100));
        if (this.getRotation() == 0.0) {
            double i;
            double[] offsets = this.getRealWorldLocation(new Point2D.Double(0.0, 0.0)).getOffsetFrom(this.getMapGroup().getCoordinateSystem());
            for (i = -(offsets[1] % this.gridSize) * (double)this.getZoom(); i < (double)this.getWidth(); i += panelCellSize) {
                g.draw(new Line2D.Double(i, 0.0, i, this.getHeight()));
            }
            for (i = offsets[0] % this.gridSize * (double)this.getZoom(); i < (double)this.getHeight(); i += panelCellSize) {
                g.draw(new Line2D.Double(0.0, i, this.getWidth(), i));
            }
        }
    }

    public boolean isGridShown() {
        return this.gridShown;
    }

    public void setGridShown(boolean gridShown) {
        this.gridShown = gridShown;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(double gridSize) {
        this.gridSize = gridSize;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    @Override
    public String getLockedVehicle() {
        return this.lockedVehicle;
    }

    public void setLockedVehicle(String lockedVehicle) {
        this.lockedVehicle = lockedVehicle;
    }

    @Override
    public void cleanup() {
        if (this.getMapGroup() != null) {
            this.getMapGroup().removeChangeListener(this);
        }
        GeneralPreferences.removePreferencesListener(this);
        this.shuttingDown = true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvt) {
        this.activeInteraction.keyPressed(keyEvt, this);
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvt) {
        this.activeInteraction.keyReleased(keyEvt, this);
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvt) {
        this.activeInteraction.keyTyped(keyEvt, this);
        this.repaint();
    }

    @Override
    public DefaultProperty[] getProperties() {
        DefaultProperty p1 = PropertiesEditor.getPropertyInstance("World Bondaries Shown", Boolean.class, new Boolean(this.isWorldBondariesShown()), true);
        DefaultProperty p2 = PropertiesEditor.getPropertyInstance("WorldMap Shown", Boolean.class, new Boolean(this.isWorldMapShown()), true);
        return new DefaultProperty[]{p1, p2};
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Renderer2D properties";
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            if (p.getName().equals("Show Grid")) {
                this.setGridShown((Boolean)p.getValue());
            }
            if (p.getName().equals("Grid Size")) {
                this.setGridSize((Double)p.getValue());
            }
            if (p.getName().equals("Grid Color")) {
                this.setGridColor((Color)p.getValue());
            }
            if (p.getName().equals("World Bondaries Shown")) {
                this.setWorldBondariesShown((Boolean)p.getValue());
            }
            if (p.getName().equals("WorldMap Shown")) {
                this.setWorldMapShown((Boolean)p.getValue());
            }
            if (!p.getName().equals("WorldMap Style")) continue;
            this.setWorldMapStyle((String)p.getValue());
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPostRenderPainter(Renderer2DPainter painter, String name) {
        PaintersBag paintersBag = this.painters;
        synchronized (paintersBag) {
            LayerPriority lp = painter.getClass().getAnnotation(LayerPriority.class);
            if (lp != null) {
                this.painters.addPainter(I18n.text(name), painter, lp.priority(), 0);
            } else {
                this.painters.addPainter(I18n.text(name), painter, 1, 0);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePostRenderPainter(Renderer2DPainter painter) {
        PaintersBag paintersBag = this.painters;
        synchronized (paintersBag) {
            this.painters.remove(painter);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreRenderPainter(Renderer2DPainter painter) {
        PaintersBag paintersBag = this.painters;
        synchronized (paintersBag) {
            LayerPriority lp = painter.getClass().getAnnotation(LayerPriority.class);
            if (lp != null) {
                this.painters.addPainter(painter.getClass().getSimpleName(), painter, lp.priority(), 0);
            } else {
                this.painters.addPainter(painter.getClass().getSimpleName(), painter, -1, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreRenderPainter(Renderer2DPainter painter) {
        PaintersBag paintersBag = this.painters;
        synchronized (paintersBag) {
            this.painters.remove(painter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaintersOfType(Class<?> clazz) {
        PaintersBag paintersBag = this.painters;
        synchronized (paintersBag) {
            this.painters.removePaintersOfType(clazz);
        }
    }

    public void setPainterActive(String painterName, boolean active) {
        this.painters.setPainterActive(painterName, active);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
    }

    public void setIgnoreRightClicks(boolean ignoreNextClick) {
        this.ignoreRightClicks = ignoreNextClick;
    }

    public double getRotation() {
        while (this.rotationRads > Math.PI * 2) {
            this.rotationRads -= Math.PI * 2;
        }
        while (this.rotationRads < Math.PI * -2) {
            this.rotationRads += Math.PI * 2;
        }
        return this.rotationRads;
    }

    public void setRotation(double rotationAngle) {
        this.rotationRads = rotationAngle;
    }

    public AbstractElement getFirstInterceptedObject(Point2D screenPoint) {
        LocationType lt = this.getRealWorldLocation(screenPoint);
        AbstractElement[] objArray = this.editingMap == null ? this.mapGroup.getAllObjects() : this.mapGroup.getObjectsFromMap(this.editingMap);
        for (int i = 0; i < objArray.length; ++i) {
            AbstractElement obj = objArray[i];
            if (!obj.containsPoint(lt, this)) continue;
            return obj;
        }
        return null;
    }

    public String getEditingMap() {
        return this.editingMap;
    }

    public void setEditingMap(String editingMap) {
        this.editingMap = editingMap;
    }

    @Override
    public void clearVehicleTail(String[] vehicles) {
        if (vehicles == null) {
            for (VehicleTailElement vte : this.vehicleTails.values()) {
                vte.clearPoints();
            }
            return;
        }
        for (String v : vehicles) {
            VehicleTailElement vte = this.vehicleTails.get(v);
            if (vte == null) continue;
            vte.clearPoints();
        }
        this.repaint();
    }

    @Override
    public void setVehicleTailOff(String[] vehicles) {
        if (vehicles == null) {
            this.isAllTailOn = false;
            this.vehiclesTailOn.clear();
        } else if (this.isAllTailOn) {
            boolean oneOK = false;
            for (String v : vehicles) {
                if (!this.vehiclesTailOn.remove(v)) continue;
                oneOK = true;
            }
            if (oneOK) {
                this.isAllTailOn = false;
            }
        }
    }

    @Override
    public void setVehicleTailOn(String[] vehicles) {
        if (vehicles == null) {
            this.isAllTailOn = true;
            this.vehiclesTailOn.clear();
        } else if (!this.isAllTailOn) {
            for (String v : vehicles) {
                this.vehiclesTailOn.add(v);
            }
        }
    }

    @Override
    public void preferencesUpdated() {
        int np = GeneralPreferences.numberOfShownPoints;
        for (VehicleTailElement vte : this.vehicleTails.values()) {
            vte.setNumberOfPoints(np);
        }
        this.numberOfShownPoints = np < 0 ? Integer.MAX_VALUE : np;
    }

    public boolean isSmoothResizing() {
        return this.smoothResizing;
    }

    public void setSmoothResizing(boolean smoothResizing) {
        this.smoothResizing = smoothResizing;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing;
    }

    public LocationType getVehicleLocation(String vehicle) {
        try {
            return this.vehicleStates.get(VehiclesHolder.getVehicleById(vehicle)).getPosition();
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)("getVehicleLocation(" + vehicle + ")"));
            return null;
        }
    }

    public SystemPositionAndAttitude getVehicleState(String vehicle) {
        try {
            return this.vehicleStates.get(VehiclesHolder.getVehicleById(vehicle));
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)("getVehicleState(" + vehicle + ")"));
            return null;
        }
    }

    public String[] getVehiclesInRender() {
        return this.vehicles;
    }

    @Override
    public void addInteraction(StateRendererInteraction interaction) {
        if (!this.interactions.contains(interaction)) {
            this.interactions.add(interaction);
        }
    }

    @Override
    public void removeInteraction(StateRendererInteraction interaction) {
        if (this.activeInteraction == interaction) {
            this.setActiveInteraction(this.defaultInteraction);
        }
        this.interactions.remove(interaction);
    }

    @Override
    @Deprecated
    public void setViewMode(int mode) {
    }

    @Override
    public void setActiveInteraction(StateRendererInteraction interaction) {
        this.requestFocusInWindow();
        this.activeInteraction = interaction == null ? this.defaultInteraction : interaction;
    }

    @Override
    public StateRendererInteraction getActiveInteraction() {
        return this.activeInteraction;
    }

    @Override
    public final Collection<StateRendererInteraction> getInteractionModes() {
        return this.interactions;
    }

    public Point2D getLastDragPoint() {
        return this.lastDragPoint;
    }

    public void painterSelection() {
        this.painters.showSelectionDialog(SwingUtilities.getWindowAncestor(this));
    }

    @Override
    public boolean addMenuExtension(IEditorMenuExtension extension) {
        if (!this.menuExtensions.contains(extension)) {
            return this.menuExtensions.add(extension);
        }
        return false;
    }

    @Override
    public final Collection<IEditorMenuExtension> getMenuExtensions() {
        return this.menuExtensions;
    }

    @Override
    public boolean removeMenuExtension(IEditorMenuExtension extension) {
        return this.menuExtensions.remove(extension);
    }

    @Override
    public StateRenderer2D getRenderer() {
        return this;
    }

    public WorldRenderPainter getWorldMapPainter() {
        return this.worldMapPainter;
    }

    static {
        arrow = new GeneralPath();
    }
}

