/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.TransponderElement;

@LayerPriority(priority=-10)
public class TransponderSecurityArea
implements Renderer2DPainter {
    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        int i;
        g.setColor(Color.WHITE);
        MapGroup mg = renderer.getMapGroup();
        AbstractElement[] objs = mg.getAllObjects();
        TransponderElement trans1 = null;
        AbstractElement trans2 = null;
        for (i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof TransponderElement)) continue;
            trans1 = (TransponderElement)objs[i];
            break;
        }
        ++i;
        while (i < objs.length) {
            if (objs[i] instanceof TransponderElement) {
                trans2 = (TransponderElement)objs[i];
                break;
            }
            ++i;
        }
        if (trans1 != null && trans2 != null) {
            LocationType lt1 = trans1.getCenterLocation();
            LocationType lt2 = trans2.getCenterLocation();
            double angle = lt1.getXYAngle(lt2) - renderer.getRotation();
            double blDistance = lt1.getPixelDistanceTo(lt2, renderer.getLevelOfDetail());
            if (blDistance > 5000.0) {
                return;
            }
            Point2D pt1 = renderer.getScreenPosition(lt1);
            pt1.setLocation(pt1.getX(), pt1.getY());
            g.setStroke(new BasicStroke(2.0f, 0, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, -blDistance, blDistance * 0.75, blDistance);
            g.translate(pt1.getX(), pt1.getY());
            g.rotate(angle);
            g.translate(blDistance * 0.25, 0.0);
            g.draw(rect);
            g.translate(-blDistance * 1.25, 0.0);
            g.draw(rect);
            g.setStroke(new BasicStroke());
        }
    }
}

