/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXStatusBar;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.proxy.ProxyInfoProvider;
import pt.lsts.neptus.doc.NeptusDoc;
import pt.lsts.neptus.gui.InfiniteProgressPanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.renderer2d.HoveringButton;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.tiles.MapPainterProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileMercadorSVG;
import pt.lsts.neptus.renderer2d.tiles.TileOpenStreetMap;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.coord.MapTileUtil;

@NeptusDoc(ArticleFilename="world-overlay/world-overlay.html", Section="Renderer2D")
@LayerPriority(priority=-500)
public class WorldRenderPainter
implements Renderer2DPainter,
MouseListener,
MouseMotionListener {
    private final int ICON_SIZE = 20;
    private final Image ICON_WORLD_ON = ImageUtils.getScaledIcon("images/world/worldmap-show.png", 20, 20).getImage();
    public final Image ICON_WORLD_SETTINGS = ImageUtils.getScaledIcon("images/world/worldmap-settings.png", 20, 20).getImage();
    private final Image ICON_WORLD_DIALOG = ImageUtils.getScaledIcon("images/world/worldmap-conf-dialog.png", 20, 20).getImage();
    @NeptusProperty
    public static String defaultActiveLayers;
    private static final String ROOT_PREFIX;
    private static final int MAX_LEVEL_OF_DETAIL = 15;
    private static final Color COLOR_CYAN_TRANSP_200;
    private static final Color COLOR_WHITE_TRANS_150;
    private static final Color COLOR_BLACK_TRANS_150;
    private static final Color COLOR_BLACK_TRANS_40;
    private Vector<HoveringButton> controlRenderButtons = new Vector();
    private HoveringButton mapControlButton = null;
    private HoveringButton mapSettingsButton = null;
    private HoveringButton mapShowActiveLayerDialogButton = null;
    private JDialog dialogProperties = null;
    private LinkedHashMap<String, JDialog> openPaintersDialog = new LinkedHashMap();
    private boolean showOnScreenControls = true;
    private boolean drawWorldBoundaries = false;
    private boolean drawWorldMap = false;
    private boolean useTransparency = true;
    private StateRenderer2D renderer2D = null;
    private Renderer2DPainter postRenderPainter = null;
    private static Map<String, Boolean> mapActiveHolderList;
    private static Map<String, Boolean> mapBaseOrLayerHolderList;
    private static Map<String, Short> mapLayerPrioriryHolderList;
    private static Map<String, MapPainterProvider> mapPainterHolderList;
    private static Map<String, Map<String, Tile>> tileHolderList;
    private static Map<String, Class<? extends Tile>> tileClassList;
    private static List<String> mapsOrderedForPainting;
    private static Map<String, PropertiesOrCustomOptionsDialogEnum> mapHasPropertiesOrCustomOptions;
    private static long numberOfLoadingMapTiles;
    private static long numberOfLoadedMapTiles;
    private static Timer timer;
    private static TimerTask ttask;
    private static TimerTask ttask1;
    private boolean mouseActive = false;

    public WorldRenderPainter(StateRenderer2D renderer2D, boolean drawWorldBoundaries, boolean drawWorldMap, String ... mapStyle) {
        if (renderer2D != null) {
            this.renderer2D = renderer2D;
        }
        this.drawWorldBoundaries = drawWorldBoundaries;
        this.drawWorldMap = drawWorldMap;
        int xPos = -35;
        int yPos = 100;
        this.mapControlButton = new HoveringButton(this.ICON_WORLD_ON){

            @Override
            public void onSelectedChange(boolean selected) {
                WorldRenderPainter.this.drawWorldMap = selected;
            }
        };
        this.mapControlButton.setXYConfiguredPos(xPos, yPos);
        this.mapControlButton.setSelected(this.drawWorldMap);
        this.controlRenderButtons.add(this.mapControlButton);
        this.mapSettingsButton = new HoveringButton(this.ICON_WORLD_SETTINGS){

            @Override
            public void onSelectedChange(boolean selected) {
                WorldRenderPainter.this.showChooseMapStyleDialog(WorldRenderPainter.this.renderer2D);
            }
        };
        this.mapSettingsButton.setXYConfiguredPos(xPos, yPos += 25);
        this.mapSettingsButton.setToggle(false);
        this.controlRenderButtons.add(this.mapSettingsButton);
        this.mapShowActiveLayerDialogButton = new HoveringButton(this.ICON_WORLD_DIALOG){

            @Override
            public void onSelectedChange(boolean selected) {
                Window wp = SwingUtilities.windowForComponent(WorldRenderPainter.this.renderer2D);
                for (String mp : mapActiveHolderList.keySet()) {
                    if (((Boolean)mapActiveHolderList.get(mp)).booleanValue()) {
                        switch (WorldRenderPainter.this.hasPropertiesOrCustomDialog(mp)) {
                            case CustomOptionsDialog: {
                                JDialog dialog = WorldRenderPainter.this.getOrCreateCustomOptionsDialog(mp);
                                if (dialog == null) break;
                                boolean makeCustomOptionsDialogIndependent = WorldRenderPainter.this.getClassForStyle(mp).getAnnotation(MapTileProvider.class).makeCustomOptionsDialogIndependent();
                                if (!makeCustomOptionsDialogIndependent) {
                                    dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                                }
                                dialog.requestFocus();
                                GuiUtils.centerParent(dialog, wp);
                                dialog.setVisible(true);
                                break;
                            }
                            case PropertiesDialog: {
                                Vector<Field> dFA = new Vector<Field>();
                                PluginUtils.extractFieldsWorker(WorldRenderPainter.this.getClassForStyle(mp), dFA);
                                if (dFA.isEmpty()) break;
                                PropertiesProvider pprov = WorldRenderPainter.this.createPropertiesProvider(mp, dFA);
                                PropertiesEditor.editProperties(pprov, wp, true);
                                break;
                            }
                        }
                    }
                }
            }
        };
        this.mapShowActiveLayerDialogButton.setXYConfiguredPos(xPos, yPos += 25);
        this.mapShowActiveLayerDialogButton.setToggle(false);
        this.controlRenderButtons.add(this.mapShowActiveLayerDialogButton);
        for (String key : mapStyle) {
            if (!mapActiveHolderList.containsKey(key)) continue;
            mapActiveHolderList.put(key, true);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    public void cleanup() {
        if (this.dialogProperties != null) {
            this.dialogProperties.setVisible(false);
            this.dialogProperties.dispose();
        }
        for (JDialog dialog : this.openPaintersDialog.values()) {
            if (dialog == null) continue;
            dialog.setVisible(false);
            dialog.dispose();
        }
        this.renderer2D = null;
    }

    public static synchronized void savePropertiesToDisk() {
        try {
            PluginUtils.saveProperties(ROOT_PREFIX + "conf/" + WorldRenderPainter.class.getSimpleName().toLowerCase() + ".properties", WorldRenderPainter.class);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + WorldRenderPainter.class.getSimpleName().toLowerCase() + ".properties\""));
        }
    }

    public boolean isUseTransparency() {
        return this.useTransparency;
    }

    public void setUseTransparency(boolean useTransparency) {
        this.useTransparency = useTransparency;
    }

    public static int getMaxLevelOfDetail(String mapStyle) {
        Class<Tile> clazz;
        Class<? extends Tile> clazz1 = tileClassList.get(mapStyle);
        if (clazz1 == null) {
            MapPainterProvider mp = mapPainterHolderList.get(mapStyle);
            if (mp == null) {
                return 15;
            }
            clazz = mp.getClass();
        } else {
            clazz = clazz1;
        }
        try {
            return (Integer)clazz.getMethod("getMaxLevelOfDetail", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return 15;
        }
    }

    public static long getNumberOfLoadingMapTiles() {
        return numberOfLoadingMapTiles;
    }

    public static long getNumberOfLoadedMapTiles() {
        return numberOfLoadedMapTiles;
    }

    public static void clearMemCache() {
        for (Map<String, Tile> map : tileHolderList.values()) {
            Tile[] lst = map.values().toArray(new Tile[0]);
            map.clear();
            for (Tile tile : lst) {
                tile.dispose();
            }
        }
    }

    public static void clearMemCache(String mapStyle) {
        Map<String, Tile> map = tileHolderList.get(mapStyle);
        if (map != null) {
            Tile[] lst = map.values().toArray(new Tile[0]);
            map.clear();
            for (Tile tile : lst) {
                tile.dispose();
            }
        }
    }

    public static void clearDiskCache() {
        for (Class<? extends Tile> clazz : tileClassList.values()) {
            try {
                clazz.getMethod("clearDiskCache", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void clearDiskCache(String mapStyle) {
        Class<? extends Tile> clazz = tileClassList.get(mapStyle);
        if (clazz != null) {
            try {
                clazz.getMethod("clearDiskCache", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setMapStyle(String mapStyleName) {
        this.setMapStyle(true, true, mapStyleName);
    }

    public void setMapStyle(boolean exclusive, boolean activate, String ... mapStyleName) {
        List<String> mapStyleList = Arrays.asList(mapStyleName);
        for (String mapStyle : mapStyleList) {
            for (String mapKey : mapActiveHolderList.keySet()) {
                if (mapKey.equalsIgnoreCase(mapStyle)) {
                    mapActiveHolderList.put(mapKey, activate);
                    continue;
                }
                if (!exclusive || mapStyleList.contains(mapKey)) continue;
                mapActiveHolderList.put(mapKey, !activate);
            }
        }
        this.updateDefaultActiveLayers();
        WorldRenderPainter.savePropertiesToDisk();
    }

    private void updateDefaultActiveLayers() {
        String tmp = "";
        for (String mapKey : mapActiveHolderList.keySet()) {
            if (!mapActiveHolderList.get(mapKey).booleanValue()) continue;
            tmp = tmp + (tmp.length() != 0 ? ";" : "") + mapKey;
            if (mapBaseOrLayerHolderList.get(mapKey).booleanValue() || mapLayerPrioriryHolderList.get(mapKey) == 0) continue;
            tmp = tmp + ":" + mapLayerPrioriryHolderList.get(mapKey);
        }
        defaultActiveLayers = tmp;
    }

    public boolean isDrawWorldBoundaries() {
        return this.drawWorldBoundaries;
    }

    public void setDrawWorldBoundaries(boolean drawWorldBoundaries) {
        this.drawWorldBoundaries = drawWorldBoundaries;
    }

    public boolean isDrawWorldMap() {
        return this.drawWorldMap;
    }

    public void setDrawWorldMap(boolean drawWorldMap) {
        this.drawWorldMap = drawWorldMap;
        this.mapControlButton.setSelected(drawWorldMap);
    }

    public boolean isShowOnScreenControls() {
        return this.showOnScreenControls;
    }

    public void setShowOnScreenControls(boolean showOnScreenControls) {
        this.showOnScreenControls = showOnScreenControls;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        this.paint(g, renderer, this.useTransparency);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer, boolean useTransparency) {
        this.renderer2D = renderer;
        if (this.drawWorldBoundaries) {
            this.drawWorldBoundaries(g, renderer);
        }
        if (this.drawWorldMap) {
            this.drawWorldMap(g, renderer, useTransparency);
        }
    }

    public Renderer2DPainter getPostRenderPainter() {
        if (this.postRenderPainter == null) {
            this.postRenderPainter = new ControlsPostRender();
        }
        return this.postRenderPainter;
    }

    private void drawWorldBoundaries(Graphics2D g, StateRenderer2D renderer) {
        Graphics2D g2t = (Graphics2D)g.create();
        g2t.translate(renderer.getWidth() / 2, renderer.getHeight() / 2);
        int msize = MapTileUtil.mapSize(renderer.getLevelOfDetail());
        Point2D xyWC = renderer.getCenter().getPointInPixel(renderer.getLevelOfDetail());
        double[] rMinMax = new double[]{0.0, 0.0, msize, msize};
        if (renderer.getRotation() != 0.0) {
            rMinMax = WorldRenderPainter.getRendererWorldXYMinMax(renderer);
        }
        int minX = (int)rMinMax[0] - (int)xyWC.getX();
        int maxX = (int)rMinMax[2] - (int)xyWC.getX();
        int minY = (int)rMinMax[1] - (int)xyWC.getY();
        int maxY = (int)rMinMax[3] - (int)xyWC.getY();
        GeneralPath wShape = new GeneralPath();
        int debugOff = -1;
        if (renderer.getRotation() == 0.0) {
            wShape.moveTo(Math.max(minX, -renderer.getWidth() / 2) + debugOff, Math.max(minY, -renderer.getHeight() / 2) + debugOff);
            wShape.lineTo(Math.max(minX, -renderer.getWidth() / 2) + debugOff, Math.min(maxY, renderer.getHeight() / 2) - debugOff);
            wShape.lineTo(Math.min(maxX, renderer.getWidth() / 2) - debugOff, Math.min(maxY, renderer.getHeight() / 2) - debugOff);
            wShape.lineTo(Math.min(maxX, renderer.getWidth() / 2) - debugOff, Math.max(minY, -renderer.getHeight() / 2) + debugOff);
        } else {
            wShape.moveTo(minX + debugOff, minY + debugOff);
            wShape.lineTo(minX + debugOff, maxY - debugOff);
            wShape.lineTo(maxX - debugOff, maxY - debugOff);
            wShape.lineTo(maxX - debugOff, minY + debugOff);
        }
        wShape.closePath();
        g2t.rotate(-renderer.getRotation());
        g2t.setColor(COLOR_BLACK_TRANS_40);
        g2t.draw(wShape);
        g2t.dispose();
        g2t = null;
    }

    private void drawWorldMap(Graphics2D g, StateRenderer2D renderer, boolean useTransparency) {
        List<String> mapKeys = mapsOrderedForPainting;
        Iterator<String> i$ = mapKeys.iterator();
        while (i$.hasNext()) {
            String mapKey;
            String mapStyle = mapKey = i$.next();
            if (!mapActiveHolderList.get(mapKey).booleanValue() || renderer.getLevelOfDetail() > WorldRenderPainter.getMaxLevelOfDetail(mapStyle)) continue;
            if (tileHolderList.containsKey(mapKey)) {
                int[] tmmr = WorldRenderPainter.getTileMinMaxForRenderer(renderer);
                int tileXMin = tmmr[0];
                int tileXMax = tmmr[2];
                int tileYMin = tmmr[1];
                int tileYMax = tmmr[3];
                Graphics2D g2 = (Graphics2D)g.create();
                g2.rotate(-renderer.getRotation(), renderer.getWidth() / 2, renderer.getHeight() / 2);
                for (int x = tileXMin; x <= tileXMax; ++x) {
                    for (int y = tileYMin; y <= tileYMax; ++y) {
                        Tile tile;
                        block12: {
                            String quadKey = MapTileUtil.tileXYToQuadKey(x, y, renderer.getLevelOfDetail());
                            tile = null;
                            try {
                                Map<String, Tile> map = tileHolderList.get(mapStyle);
                                if (map == null || (tile = map.get(quadKey)) != null) break block12;
                                try {
                                    tile = this.createTile(quadKey, mapStyle);
                                    if (tile != null) {
                                        map.put(quadKey, tile);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (tile == null) continue;
                        if (tile.getState() == Tile.TileState.ERROR) {
                            tile.retryLoadingTile();
                        }
                        tile.paint(g2, renderer, useTransparency);
                    }
                }
                g2.dispose();
                continue;
            }
            if (!mapPainterHolderList.containsKey(mapStyle)) continue;
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                mapPainterHolderList.get(mapStyle).paint(g2, renderer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            g2.dispose();
        }
        this.drawLatLonZeroMarker(g, renderer);
        this.drawOverlayName(g, renderer);
    }

    private Tile createTile(String quadKey, String mapStyle) throws Exception {
        Tile tile;
        Class<? extends Tile> clazz = tileClassList.get(mapStyle);
        if (clazz != null && (tile = clazz.getConstructor(String.class).newInstance(quadKey)) != null) {
            return tile;
        }
        return null;
    }

    private void drawLatLonZeroMarker(Graphics2D g, StateRenderer2D renderer) {
        Graphics2D g2 = (Graphics2D)g.create();
        Point2D gXY = renderer.getScreenPosition(LocationType.ABSOLUTE_ZERO);
        g2.translate(gXY.getX(), gXY.getY());
        g2.setColor(COLOR_CYAN_TRANSP_200);
        g2.drawOval(-4, -4, 8, 8);
        g2.dispose();
    }

    private void drawOverlayName(Graphics2D g, StateRenderer2D renderer) {
        String mapStyle = "";
        for (String mapKey : mapActiveHolderList.keySet()) {
            if (!mapActiveHolderList.get(mapKey).booleanValue()) continue;
            String lodTxt = "";
            if (renderer.getLevelOfDetail() > WorldRenderPainter.getMaxLevelOfDetail(mapKey)) {
                lodTxt = " (" + I18n.textf("no tiles at this zoom, max is %zoomLevel", WorldRenderPainter.getMaxLevelOfDetail(mapKey)) + ")";
            }
            mapStyle = mapStyle + (mapStyle.length() != 0 ? ", " : "") + mapKey + lodTxt;
        }
        Graphics2D gg = (Graphics2D)g.create();
        gg.setColor(COLOR_WHITE_TRANS_150);
        gg.setFont(new Font("Arial", 0, 10));
        String text = I18n.textf("\u00a9 %layerName world overlay", mapStyle.toString().toLowerCase());
        text = StringUtils.wrapEveryNChars(text, (short)100);
        Rectangle2D stringBounds = gg.getFontMetrics().getStringBounds(text, g);
        int advance = (int)((double)(renderer.getWidth() - 20) - stringBounds.getWidth()) / 2;
        gg.drawString(text, (float)(advance + 10), (float)((double)renderer.getHeight() - stringBounds.getHeight() - 10.0));
        gg.setColor(COLOR_BLACK_TRANS_150);
        gg.drawString(text, (float)(advance + 10 + 1), (float)((double)renderer.getHeight() - stringBounds.getHeight() - 10.0 + 1.0));
        gg.dispose();
    }

    public static double[] getRendererWorldXYMinMax(StateRenderer2D renderer) {
        Point2D xyWC = renderer.getCenter().getPointInPixel(renderer.getLevelOfDetail());
        double wXMin = xyWC.getX() - (double)renderer.getWidth() / 2.0;
        double wXMax = xyWC.getX() + (double)renderer.getWidth() / 2.0;
        double wYMin = xyWC.getY() - (double)renderer.getHeight() / 2.0;
        double wYMax = xyWC.getY() + (double)renderer.getHeight() / 2.0;
        if (renderer.getRotation() != 0.0) {
            LocationType topLeft = renderer.getRealWorldLocation(new Point2D.Double(0.0, 0.0));
            LocationType bottomRight = renderer.getRealWorldLocation(new Point2D.Double(renderer.getWidth(), renderer.getHeight()));
            LocationType topRight = renderer.getRealWorldLocation(new Point2D.Double(renderer.getWidth(), 0.0));
            LocationType bottomLeft = renderer.getRealWorldLocation(new Point2D.Double(0.0, renderer.getHeight()));
            double lat1 = topLeft.getLatitudeDegs();
            double lat2 = bottomRight.getLatitudeDegs();
            double lat3 = topRight.getLatitudeDegs();
            double lat4 = bottomLeft.getLatitudeDegs();
            double lon1 = topLeft.getLongitudeDegs();
            double lon2 = bottomRight.getLongitudeDegs();
            double lon3 = topRight.getLongitudeDegs();
            double lon4 = bottomLeft.getLongitudeDegs();
            double latMax = Math.max(Math.max(Math.max(lat1, lat2), lat3), lat4);
            double latMin = Math.min(Math.min(Math.min(lat1, lat2), lat3), lat4);
            double lonMax = Math.max(Math.max(Math.max(lon1, lon2), lon3), lon4);
            double lonMin = Math.min(Math.min(Math.min(lon1, lon2), lon3), lon4);
            Point2D lmin = MapTileUtil.degreesToXY(latMin, lonMin, renderer.getLevelOfDetail());
            Point2D lmax = MapTileUtil.degreesToXY(latMax, lonMax, renderer.getLevelOfDetail());
            wXMin = Math.min(lmin.getX(), lmax.getX());
            wXMax = Math.max(lmin.getX(), lmax.getX());
            wYMin = Math.min(lmin.getY(), lmax.getY());
            wYMax = Math.max(lmin.getY(), lmax.getY());
        }
        return new double[]{wXMin, wYMin, wXMax, wYMax};
    }

    public static int[] getTileMinMaxForRenderer(StateRenderer2D renderer) {
        double[] tmpRWMaxMin = WorldRenderPainter.getRendererWorldXYMinMax(renderer);
        int wXMin = (int)tmpRWMaxMin[0];
        int wXMax = (int)tmpRWMaxMin[2];
        int wYMin = (int)tmpRWMaxMin[1];
        int wYMax = (int)tmpRWMaxMin[3];
        int[] tlMin = MapTileUtil.pixelXYToTileXY(wXMin, wYMin);
        int[] tlMax = MapTileUtil.pixelXYToTileXY(wXMax, wYMax);
        int tileXMin = tlMin[0];
        int tileXMax = tlMax[0];
        int tileYMin = tlMin[1];
        int tileYMax = tlMax[1];
        return new int[]{tileXMin, tileYMin, tileXMax, tileYMax};
    }

    private void fetchAllTilesForRendererVisibleArea(StateRenderer2D renderer, String mapStyle) {
        int[] tmmr = WorldRenderPainter.getTileMinMaxForRenderer(renderer);
        int tileXMin = tmmr[0];
        int tileXMax = tmmr[2];
        int tileYMin = tmmr[1];
        int tileYMax = tmmr[3];
        int levelOfDetail = renderer.getLevelOfDetail();
        int maxLevelOfDetail = Math.min(WorldRenderPainter.getMaxLevelOfDetail(mapStyle), levelOfDetail + 2);
        NeptusLog.pub().info((Object)("<###>tileXMin=" + tileXMin + ", tileYMin=" + tileYMin + ", tileXMax=" + tileXMax + ", tileYMax=" + tileYMax));
        Vector<String> bagList = new Vector<String>();
        for (int x = tileXMin; x <= tileXMax; ++x) {
            for (int y = tileYMin; y <= tileYMax; ++y) {
                String quadKey = MapTileUtil.tileXYToQuadKey(x, y, levelOfDetail);
                bagList.add(quadKey);
                if (levelOfDetail >= maxLevelOfDetail) continue;
                for (int sLoD = levelOfDetail + 1; sLoD <= maxLevelOfDetail; ++sLoD) {
                    this.produceQuadKeysWorker(quadKey, maxLevelOfDetail, bagList);
                }
            }
        }
        NeptusLog.pub().info((Object)("<###> " + bagList.size() + " tiles"));
        Collections.sort(bagList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (String quadKey : bagList) {
            Map<String, Tile> map = tileHolderList.get(mapStyle);
            if (map == null) continue;
            Tile tile = map.get(quadKey);
            if (tile == null) {
                try {
                    tile = this.createTile(quadKey, mapStyle);
                    if (tile == null) continue;
                    map.put(quadKey, tile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (tile.getState() != Tile.TileState.ERROR) continue;
            tile.retryLoadingTile();
        }
    }

    private List<String> produceQuadKeysWorker(String quadKey, int maxLevelOfDetail, List<String> bagList) {
        if (quadKey.length() >= maxLevelOfDetail) {
            return bagList;
        }
        String qk0 = quadKey + "0";
        String qk1 = quadKey + "1";
        String qk2 = quadKey + "2";
        String qk3 = quadKey + "3";
        bagList.add(qk0);
        bagList.add(qk1);
        bagList.add(qk2);
        bagList.add(qk3);
        this.produceQuadKeysWorker(qk0, maxLevelOfDetail, bagList);
        this.produceQuadKeysWorker(qk1, maxLevelOfDetail, bagList);
        this.produceQuadKeysWorker(qk2, maxLevelOfDetail, bagList);
        this.produceQuadKeysWorker(qk3, maxLevelOfDetail, bagList);
        return bagList;
    }

    public void showChooseMapStyleDialog(Component parent) {
        if (this.dialogProperties != null) {
            GuiUtils.centerParent(this.dialogProperties, this.dialogProperties.getOwner());
            this.dialogProperties.setVisible(true);
            return;
        }
        this.createChooseMapStyleDialog();
        this.dialogProperties.setVisible(true);
    }

    public void createChooseMapStyleDialog() {
        if (this.dialogProperties != null) {
            return;
        }
        Window winParent = SwingUtilities.windowForComponent(this.renderer2D);
        this.dialogProperties = new JDialog(winParent);
        this.dialogProperties.setLayout(new BorderLayout(10, 0));
        this.dialogProperties.setSize(700, 350);
        this.dialogProperties.setIconImages(ConfigFetch.getIconImagesForFrames());
        this.dialogProperties.setDefaultCloseOperation(2);
        this.dialogProperties.setTitle(I18n.text("World Map Layer"));
        ButtonGroup baseMapsButtonGroup = new ButtonGroup();
        JPanel confPanel = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 5"));
        confPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        List<String> mapKeys = WorldRenderPainter.getOrderedMapList();
        boolean alreadyinsertedBaseOrLayerMapSeparator = false;
        confPanel.add((Component)new JLabel("<html><b>" + I18n.text("Base Maps") + "</b></html>"), "wrap");
        for (final String ms : mapKeys) {
            JLabel label;
            if (!alreadyinsertedBaseOrLayerMapSeparator && mapBaseOrLayerHolderList.containsKey(ms) && !mapBaseOrLayerHolderList.get(ms).booleanValue()) {
                alreadyinsertedBaseOrLayerMapSeparator = true;
                confPanel.add((Component)new JLabel("<html><b>" + I18n.text("Layer Maps") + "</b></html>"), "wrap");
            }
            final JToggleButton rButton = mapBaseOrLayerHolderList.containsKey(ms) && mapBaseOrLayerHolderList.get(ms) != false ? new JRadioButton(ms.toString()) : new JCheckBox(ms.toString());
            rButton.setActionCommand(ms);
            if (mapActiveHolderList.containsKey(ms) && mapActiveHolderList.get(ms).booleanValue()) {
                rButton.setSelected(true);
            }
            rButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WorldRenderPainter.this.setMapStyle(false, rButton.isSelected(), ms);
                }
            });
            if (mapBaseOrLayerHolderList.containsKey(ms) && mapBaseOrLayerHolderList.get(ms).booleanValue()) {
                baseMapsButtonGroup.add(rButton);
            }
            confPanel.add((Component)rButton, "sg sel, grow, push");
            if (mapBaseOrLayerHolderList.containsKey(ms) && mapBaseOrLayerHolderList.get(ms).booleanValue()) {
                confPanel.add((Component)new JLabel(), "sg prio");
            } else {
                short lp = mapLayerPrioriryHolderList.get(ms);
                final JSpinner spinner = new JSpinner(new SpinnerNumberModel(lp, 0, 10, 1));
                spinner.setSize(new Dimension(20, 20));
                spinner.setToolTipText(I18n.text("This sets the layer priority. The higher the value more on top will appear."));
                ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setEditable(false);
                ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setBackground(Color.WHITE);
                spinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        short val = ((Integer)spinner.getValue()).shortValue();
                        mapLayerPrioriryHolderList.put(ms, val);
                        WorldRenderPainter.this.updateDefaultActiveLayers();
                        WorldRenderPainter.refreshMapsListOrderedForPainting();
                        WorldRenderPainter.savePropertiesToDisk();
                    }
                });
                confPanel.add((Component)spinner, "sg prio, width 50:50:");
            }
            boolean tileOrMapProvider = this.isTileOrMapProvider(ms);
            if (tileOrMapProvider) {
                final JButton clearButton = new JButton();
                AbstractAction clearAction = new AbstractAction(I18n.text("Clear cache").toLowerCase()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        clearButton.setEnabled(false);
                        new SwingWorker<Void, Void>(){

                            @Override
                            protected Void doInBackground() throws Exception {
                                WorldRenderPainter.clearMemCache(ms);
                                WorldRenderPainter.clearDiskCache(ms);
                                return null;
                            }

                            @Override
                            protected void done() {
                                try {
                                    this.get();
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e);
                                }
                                clearButton.setEnabled(true);
                            }
                        }.execute();
                    }
                };
                clearButton.setAction(clearAction);
                confPanel.add((Component)clearButton, "sg buttons");
            } else {
                confPanel.add((Component)new JLabel(), "sg buttons");
            }
            Class<?> clazz = this.getClassForStyle(ms);
            if (clazz.getAnnotation(MapTileProvider.class).usePropertiesOrCustomOptionsDialog()) {
                Vector<Field> dFA = new Vector<Field>();
                PluginUtils.extractFieldsWorker(clazz, dFA);
                if (dFA.isEmpty()) {
                    label = new JLabel(I18n.text("No properties").toLowerCase());
                    label.setHorizontalAlignment(0);
                    label.setEnabled(false);
                    confPanel.add((Component)label, "sg buttons");
                } else {
                    final PropertiesProvider pprov = this.createPropertiesProvider(ms, dFA);
                    confPanel.add((Component)new JButton(new AbstractAction(I18n.text("Edit properties").toLowerCase()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesEditor.editProperties(pprov, WorldRenderPainter.this.dialogProperties, true);
                        }
                    }), "sg buttons");
                }
            } else {
                boolean makeCustomOptionsDialogIndependent = clazz.getAnnotation(MapTileProvider.class).makeCustomOptionsDialogIndependent();
                try {
                    JDialog dialog = this.getOrCreateCustomOptionsDialog(ms);
                    if (dialog == null) {
                        throw new Exception("No custom options dialog found!!");
                    }
                    if (!makeCustomOptionsDialogIndependent) {
                        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                    }
                    final JDialog dialog1 = dialog;
                    confPanel.add((Component)new JButton(new AbstractAction(I18n.text("Edit properties").toLowerCase()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dialog1.requestFocus();
                            GuiUtils.centerParent(dialog1, WorldRenderPainter.this.dialogProperties);
                            dialog1.setVisible(true);
                        }
                    }), "sg buttons");
                }
                catch (Exception e1) {
                    JLabel label2 = new JLabel(I18n.text("No properties").toLowerCase());
                    label2.setHorizontalAlignment(0);
                    label2.setEnabled(false);
                    confPanel.add((Component)label2, "sg buttons");
                }
            }
            boolean isFetch = false;
            if (tileOrMapProvider) {
                try {
                    Class<? extends Tile> clazz1 = tileClassList.get(ms);
                    isFetch = (Boolean)clazz1.getMethod("isFetchableOrGenerated", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (!isFetch) {
                label = new JLabel("");
                label.setHorizontalAlignment(0);
                label.setEnabled(false);
                confPanel.add((Component)label, "sg buttons");
                continue;
            }
            final JButton fetchButton = new JButton();
            AbstractAction fetchAction = new AbstractAction(I18n.text("Fetch visible area").toLowerCase()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fetchButton.setEnabled(false);
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (WorldRenderPainter.this.renderer2D != null) {
                                WorldRenderPainter.this.fetchAllTilesForRendererVisibleArea(WorldRenderPainter.this.renderer2D, ms);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            fetchButton.setEnabled(true);
                        }
                    }.execute();
                }
            };
            fetchButton.setAction(fetchAction);
            fetchButton.setToolTipText(I18n.text("Fetch visible area tiles to up to 2 more zoom levels."));
            confPanel.add((Component)fetchButton, "sg buttons");
        }
        final JLabel levelOfDetailLabel = new JLabel();
        JButton zoomInButton = new JButton(new AbstractAction("+"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldRenderPainter.this.renderer2D.zoomIn();
            }
        });
        zoomInButton.setToolTipText(I18n.text("Zoom in"));
        JButton zoomOutButton = new JButton(new AbstractAction("-"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldRenderPainter.this.renderer2D.zoomOut();
            }
        });
        zoomOutButton.setToolTipText(I18n.text("Zoom out"));
        final JLabel memInfoLabel = new JLabel();
        final JLabel loadingTilesLabel = new JLabel();
        JButton stopLoadingButton = new JButton(new AbstractAction(I18n.text("Stop Loading")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldRenderPainter.clearMemCache();
            }
        });
        final JXBusyLabel busyPanel = InfiniteProgressPanel.createBusyAnimationInfiniteBeans(20);
        busyPanel.setVisible(false);
        JXStatusBar statusBar = new JXStatusBar();
        statusBar.add((Component)levelOfDetailLabel);
        statusBar.add((Component)zoomInButton);
        statusBar.add((Component)zoomOutButton);
        statusBar.add((Component)memInfoLabel, (Object)JXStatusBar.Constraint.ResizeBehavior.FILL);
        statusBar.add((Component)loadingTilesLabel);
        statusBar.add((Component)stopLoadingButton);
        statusBar.add((Component)busyPanel);
        this.dialogProperties.add((Component)statusBar, "North");
        final JCheckBox useProxyCheck = new JCheckBox(new AbstractAction(I18n.text("Use HTTP Proxy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProxyInfoProvider.setEnableProxy(((JCheckBox)e.getSource()).isSelected());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        useProxyCheck.setSelected(ProxyInfoProvider.isEnableProxy());
        useProxyCheck.setOpaque(false);
        JButton proxySettingsButton = new JButton(new AbstractAction(I18n.text("Configure HTTP Proxy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyInfoProvider.showConfigurations(WorldRenderPainter.this.dialogProperties);
            }
        });
        JXStatusBar bottomStatusBar = new JXStatusBar();
        bottomStatusBar.add((Component)useProxyCheck);
        bottomStatusBar.add((Component)proxySettingsButton);
        this.dialogProperties.add((Component)bottomStatusBar, "South");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                int levelOfDetail = WorldRenderPainter.this.renderer2D.getLevelOfDetail();
                long nlt = WorldRenderPainter.getNumberOfLoadingMapTiles();
                long nlt1 = WorldRenderPainter.getNumberOfLoadedMapTiles();
                levelOfDetailLabel.setText(I18n.text("Zoom Level:") + " " + levelOfDetail);
                memInfoLabel.setText(I18n.textf("Free Memory: %freeMem of %totalMem", MathMiscUtils.parseToEngineeringRadix2Notation(Runtime.getRuntime().freeMemory(), 1) + "B", MathMiscUtils.parseToEngineeringRadix2Notation(Runtime.getRuntime().totalMemory(), 1) + "B"));
                loadingTilesLabel.setText(I18n.textf("Tiles Loading: %tiles of %totalTiles", nlt, nlt1));
                busyPanel.setVisible(nlt != 0L);
                busyPanel.setBusy(nlt != 0L);
                useProxyCheck.setSelected(ProxyInfoProvider.isEnableProxy());
                WorldRenderPainter.this.dialogProperties.repaint();
            }
        }, 500L, 200L);
        JScrollPane scroll = new JScrollPane(confPanel);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(20);
        this.dialogProperties.add(scroll);
        GuiUtils.centerParent(this.dialogProperties, winParent);
    }

    private static void refreshMapsListOrderedForPainting() {
        mapsOrderedForPainting.clear();
        mapsOrderedForPainting.addAll(WorldRenderPainter.getOrderedMapList(false));
    }

    private static List<String> getOrderedMapList() {
        return WorldRenderPainter.getOrderedMapList(false);
    }

    private static List<String> getOrderedMapList(final boolean orderWithDisplayPriority) {
        Comparator<String> comparatorMapBaseOrLayer = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                short o2Prio;
                boolean o1Base = mapBaseOrLayerHolderList.containsKey(o1) ? (Boolean)mapBaseOrLayerHolderList.get(o1) : false;
                boolean o2Base = mapBaseOrLayerHolderList.containsKey(o2) ? (Boolean)mapBaseOrLayerHolderList.get(o2) : false;
                short o1Prio = mapLayerPrioriryHolderList.containsKey(o1) ? (Short)mapLayerPrioriryHolderList.get(o1) : (short)0;
                short s = o2Prio = mapLayerPrioriryHolderList.containsKey(o2) ? (Short)mapLayerPrioriryHolderList.get(o2) : (short)0;
                if (o1Base ^ o2Base) {
                    return o1Base ? -1 : 1;
                }
                if (o1Base & o2Base) {
                    return 0;
                }
                return orderWithDisplayPriority ? o1Prio - o2Prio : 0;
            }
        };
        String[] tmpArrayMapKeysToSorted = mapActiveHolderList.keySet().toArray(new String[0]);
        Arrays.sort(tmpArrayMapKeysToSorted, comparatorMapBaseOrLayer);
        List<String> mapKeys = Arrays.asList(tmpArrayMapKeysToSorted);
        return mapKeys;
    }

    private PropertiesProvider createPropertiesProvider(final String mapStyle, Vector<Field> dFA) {
        final Class<?> clazz = this.getClassForStyle(mapStyle);
        final LinkedHashMap<String, PluginProperty> props = new LinkedHashMap<String, PluginProperty>();
        for (Field field : dFA) {
            try {
                PluginProperty pp = PluginUtils.createPluginProperty(null, field);
                if (pp == null) continue;
                props.put(pp.getName(), pp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new PropertiesProvider(){

            @Override
            public void setProperties(Property[] properties) {
                PluginUtils.setPluginProperties((Object)clazz, properties);
                if (properties != null && properties.length > 0) {
                    try {
                        Method met = clazz.getMethod("staticPropertiesChanged", new Class[0]);
                        if (met != null) {
                            met.invoke(null, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public String[] getPropertiesErrors(Property[] properties) {
                return null;
            }

            @Override
            public String getPropertiesDialogTitle() {
                return mapStyle.toString() + " - " + I18n.text("Map Provider Properties");
            }

            @Override
            public DefaultProperty[] getProperties() {
                return props.values().toArray(new PluginProperty[0]);
            }
        };
    }

    private Class<?> getClassForStyle(String mapStyle) {
        boolean tileOrMapProvider = this.isTileOrMapProvider(mapStyle);
        Class<Tile> clazz = tileOrMapProvider ? tileClassList.get(mapStyle) : mapPainterHolderList.get(mapStyle).getClass();
        return clazz;
    }

    private boolean isTileOrMapProvider(String mapStyle) {
        boolean tileOrMapProvider = true;
        if (mapPainterHolderList.containsKey(mapStyle)) {
            tileOrMapProvider = false;
        }
        return tileOrMapProvider;
    }

    private PropertiesOrCustomOptionsDialogEnum hasPropertiesOrCustomDialog(String mapStyle) {
        PropertiesOrCustomOptionsDialogEnum ret = mapHasPropertiesOrCustomOptions.get(mapStyle);
        if (ret != null) {
            return ret;
        }
        Class<?> clazz = this.getClassForStyle(mapStyle);
        if (clazz == null) {
            mapHasPropertiesOrCustomOptions.put(mapStyle, PropertiesOrCustomOptionsDialogEnum.None);
            return PropertiesOrCustomOptionsDialogEnum.None;
        }
        if (clazz.getAnnotation(MapTileProvider.class).usePropertiesOrCustomOptionsDialog()) {
            Vector<Field> dFA = new Vector<Field>();
            PluginUtils.extractFieldsWorker(clazz, dFA);
            if (!dFA.isEmpty()) {
                mapHasPropertiesOrCustomOptions.put(mapStyle, PropertiesOrCustomOptionsDialogEnum.PropertiesDialog);
                return PropertiesOrCustomOptionsDialogEnum.PropertiesDialog;
            }
            mapHasPropertiesOrCustomOptions.put(mapStyle, PropertiesOrCustomOptionsDialogEnum.None);
            return PropertiesOrCustomOptionsDialogEnum.None;
        }
        if (this.getOrCreateCustomOptionsDialog(mapStyle) != null) {
            mapHasPropertiesOrCustomOptions.put(mapStyle, PropertiesOrCustomOptionsDialogEnum.CustomOptionsDialog);
            return PropertiesOrCustomOptionsDialogEnum.CustomOptionsDialog;
        }
        mapHasPropertiesOrCustomOptions.put(mapStyle, PropertiesOrCustomOptionsDialogEnum.None);
        return PropertiesOrCustomOptionsDialogEnum.None;
    }

    private JDialog getOrCreateCustomOptionsDialog(String mapStyle) {
        this.createChooseMapStyleDialog();
        Class<?> clazz = this.getClassForStyle(mapStyle);
        if (clazz == null) {
            return null;
        }
        if (clazz.getAnnotation(MapTileProvider.class).usePropertiesOrCustomOptionsDialog()) {
            return null;
        }
        JDialog parentDialogProperties = this.dialogProperties;
        JDialog dialog = this.openPaintersDialog.get(mapStyle);
        if (dialog == null) {
            try {
                dialog = (JDialog)clazz.getMethod("getOptionsDialog", JDialog.class, StateRenderer2D.class).invoke(null, parentDialogProperties, this.renderer2D);
            }
            catch (Exception e1) {
                try {
                    dialog = (JDialog)clazz.getMethod("getOptionsDialog", JDialog.class, StateRenderer2D.class).invoke((Object)mapPainterHolderList.get(mapStyle), parentDialogProperties, this.renderer2D);
                }
                catch (Exception e) {
                    try {
                        dialog = (JDialog)clazz.getMethod("getOptionsDialog", JDialog.class).invoke(null, parentDialogProperties);
                    }
                    catch (Exception e2) {
                        try {
                            dialog = (JDialog)clazz.getMethod("getOptionsDialog", JDialog.class).invoke((Object)mapPainterHolderList.get(mapStyle), parentDialogProperties);
                        }
                        catch (Exception e3) {
                            dialog = null;
                        }
                    }
                }
            }
            if (dialog != null) {
                this.openPaintersDialog.put(mapStyle, dialog);
            }
        }
        return dialog;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.mouseActive) {
            return;
        }
        for (HoveringButton hb : this.controlRenderButtons) {
            Rectangle2D ret = hb.createRectangle2DBounds();
            if (ret.contains(e.getPoint())) {
                hb.setHovering(true);
                continue;
            }
            hb.setHovering(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mouseActive) {
            return;
        }
        for (HoveringButton hb : this.controlRenderButtons) {
            Rectangle2D ret = hb.createRectangle2DBounds();
            if (!ret.contains(e.getPoint())) continue;
            hb.toggleSelected();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseActive = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseActive = false;
        for (HoveringButton hb : this.controlRenderButtons) {
            hb.setHovering(false);
        }
    }

    public Map<String, MapPainterProvider> getMapPainters() {
        return Collections.unmodifiableMap(mapPainterHolderList);
    }

    /*
     * WARNING - void declaration
     */
    static {
        String id;
        void var5_9;
        Class<?>[] vis;
        long start = System.currentTimeMillis();
        Class<?>[] arr$ = vis = ReflectionUtil.listTileProviders();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_9 < len$) {
            Class<?> sp = arr$[var5_9];
            if (ReflectionUtil.hasAnnotation(sp, MapTileProvider.class)) {
                PluginsRepository.addPlugin(sp.getCanonicalName());
            }
            ++var5_9;
        }
        NeptusLog.pub().debug((Object)("Loading MapProviders in " + DateTimeUtil.milliSecondsToFormatedString(System.currentTimeMillis() - start)));
        defaultActiveLayers = TileMercadorSVG.class.getAnnotation(MapTileProvider.class).name();
        if (new File("../conf").exists()) {
            ROOT_PREFIX = "../";
        } else {
            ROOT_PREFIX = "";
            new File("conf").mkdir();
        }
        try {
            String confFx = ROOT_PREFIX + "conf/" + WorldRenderPainter.class.getSimpleName().toLowerCase() + ".properties";
            if (new File(confFx).exists()) {
                PluginUtils.loadProperties(confFx, WorldRenderPainter.class);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + WorldRenderPainter.class.getSimpleName().toLowerCase() + ".properties\""));
        }
        COLOR_CYAN_TRANSP_200 = ColorUtils.setTransparencyToColor(Color.CYAN, 200);
        COLOR_WHITE_TRANS_150 = ColorUtils.setTransparencyToColor(Color.WHITE, 150);
        COLOR_BLACK_TRANS_150 = ColorUtils.setTransparencyToColor(Color.BLACK, 150);
        COLOR_BLACK_TRANS_40 = ColorUtils.setTransparencyToColor(Color.BLACK, 40);
        mapActiveHolderList = Collections.synchronizedMap(new LinkedHashMap());
        mapBaseOrLayerHolderList = Collections.synchronizedMap(new LinkedHashMap());
        mapLayerPrioriryHolderList = Collections.synchronizedMap(new LinkedHashMap());
        mapPainterHolderList = Collections.synchronizedMap(new LinkedHashMap());
        tileHolderList = Collections.synchronizedMap(new LinkedHashMap());
        tileClassList = Collections.synchronizedMap(new LinkedHashMap());
        mapsOrderedForPainting = Collections.synchronizedList(new ArrayList());
        start = System.currentTimeMillis();
        String mapId = TileMercadorSVG.class.getAnnotation(MapTileProvider.class).name();
        mapActiveHolderList.put(mapId, true);
        mapBaseOrLayerHolderList.put(mapId, TileMercadorSVG.class.getAnnotation(MapTileProvider.class).isBaseMapOrLayer());
        mapLayerPrioriryHolderList.put(mapId, TileMercadorSVG.class.getAnnotation(MapTileProvider.class).layerPriority());
        tileHolderList.put(mapId, TileMercadorSVG.getTilesMap());
        tileClassList.put(mapId, TileMercadorSVG.class);
        mapId = TileOpenStreetMap.class.getAnnotation(MapTileProvider.class).name();
        mapActiveHolderList.put(mapId, false);
        mapBaseOrLayerHolderList.put(mapId, TileMercadorSVG.class.getAnnotation(MapTileProvider.class).isBaseMapOrLayer());
        mapLayerPrioriryHolderList.put(mapId, TileMercadorSVG.class.getAnnotation(MapTileProvider.class).layerPriority());
        tileHolderList.put(mapId, TileOpenStreetMap.getTilesMap());
        tileClassList.put(mapId, TileOpenStreetMap.class);
        Vector<Class<? extends MapTileProvider>> lst = new Vector<Class<? extends MapTileProvider>>();
        block16: for (Class<? extends MapTileProvider> clazz : PluginsRepository.getTileProviders().values()) {
            try {
                if (lst.isEmpty()) {
                    lst.add(clazz);
                    continue;
                }
                id = clazz.getAnnotation(MapTileProvider.class).name();
                for (int i = 0; i < lst.size(); ++i) {
                    Class clazzC = (Class)lst.get(i);
                    String idComp = clazzC.getAnnotation(MapTileProvider.class).name();
                    if (id.compareTo(idComp) < 0) {
                        int indx = lst.indexOf(clazzC);
                        lst.add(indx, clazz);
                        continue block16;
                    }
                    if (i != lst.size() - 1) continue;
                    lst.add(clazz);
                    continue block16;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Class<MapTileProvider> clazz : lst) {
            try {
                id = clazz.getAnnotation(MapTileProvider.class).name();
                if (mapActiveHolderList.containsKey(id)) continue;
                try {
                    clazz.asSubclass(Tile.class);
                    Class<MapTileProvider> cz = clazz;
                    try {
                        Map map = (Map)clazz.getMethod("getTilesMap", new Class[0]).invoke(null, new Object[0]);
                        mapActiveHolderList.put(id, false);
                        mapBaseOrLayerHolderList.put(id, clazz.getAnnotation(MapTileProvider.class).isBaseMapOrLayer());
                        mapLayerPrioriryHolderList.put(id, clazz.getAnnotation(MapTileProvider.class).layerPriority());
                        tileHolderList.put(id, map);
                        tileClassList.put(id, cz);
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                }
                catch (ClassCastException e) {
                    try {
                        Class<MapTileProvider> cz = clazz;
                        MapPainterProvider instance = (MapPainterProvider)((Object)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        mapActiveHolderList.put(id, false);
                        mapBaseOrLayerHolderList.put(id, clazz.getAnnotation(MapTileProvider.class).isBaseMapOrLayer());
                        mapLayerPrioriryHolderList.put(id, clazz.getAnnotation(MapTileProvider.class).layerPriority());
                        mapPainterHolderList.put(id, instance);
                    }
                    catch (ClassCastException e1) {
                        e1.printStackTrace();
                    }
                    catch (NoSuchMethodException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (defaultActiveLayers.length() != 0) {
            boolean bl2;
            List<String> list = Arrays.asList(defaultActiveLayers.split(";"));
            for (String mapKey : mapActiveHolderList.keySet()) {
                mapActiveHolderList.put(mapKey, false);
            }
            for (String mapDefTag : list) {
                String[] tags = mapDefTag.split(":");
                String mapDef = tags[0];
                if (mapActiveHolderList.containsKey(mapDef)) {
                    mapActiveHolderList.put(mapDef, true);
                }
                if (!mapLayerPrioriryHolderList.containsKey(mapDef) || tags.length <= 1) continue;
                try {
                    short prio = Short.parseShort(tags[1]);
                    mapLayerPrioriryHolderList.put(mapDef, prio);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            boolean bl3 = false;
            for (Boolean mapBool : mapActiveHolderList.values()) {
                if (!mapBool.booleanValue()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                mapActiveHolderList.entrySet().iterator().next().setValue(true);
            }
        }
        WorldRenderPainter.refreshMapsListOrderedForPainting();
        NeptusLog.pub().info((Object)("Initialized Map Providers in " + DateTimeUtil.milliSecondsToFormatedString(System.currentTimeMillis() - start)));
        mapHasPropertiesOrCustomOptions = Collections.synchronizedMap(new LinkedHashMap());
        numberOfLoadingMapTiles = 0L;
        numberOfLoadedMapTiles = 0L;
        timer = new Timer(WorldRenderPainter.class.getSimpleName() + " Timer", true);
        ttask = new TimerTask(){

            @Override
            public void run() {
                Collection list = tileHolderList.values();
                for (Map map : list) {
                    String[] tlist;
                    for (String key : tlist = map.keySet().toArray(new String[0])) {
                        Tile tile = (Tile)map.get(key);
                        if (System.currentTimeMillis() - tile.getLastPaintTimeMillis() <= 20000L) continue;
                        map.remove(key);
                        tile.dispose();
                    }
                }
            }
        };
        ttask1 = new TimerTask(){

            @Override
            public void run() {
                Collection list = tileHolderList.values();
                long tmpNumberOfLoadingMapTiles = 0L;
                long tmpNumberOfLoadedMapTiles = 0L;
                for (Map map : list) {
                    String[] tlist;
                    block4: for (String key : tlist = map.keySet().toArray(new String[0])) {
                        Tile tile = (Tile)map.get(key);
                        ++tmpNumberOfLoadedMapTiles;
                        switch (tile.getState()) {
                            case LOADING: 
                            case RETRYING: {
                                ++tmpNumberOfLoadingMapTiles;
                                continue block4;
                            }
                        }
                    }
                }
                numberOfLoadingMapTiles = tmpNumberOfLoadingMapTiles;
                numberOfLoadedMapTiles = tmpNumberOfLoadedMapTiles;
            }
        };
        timer.scheduleAtFixedRate(ttask, 30000L, 10000L);
        timer.scheduleAtFixedRate(ttask1, 5000L, 1000L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WorldRenderPainter.clearMemCache();
                ttask.cancel();
                ttask1.cancel();
                timer.cancel();
            }
        });
    }

    @LayerPriority(priority=100)
    public class ControlsPostRender
    implements Renderer2DPainter {
        @Override
        public void paint(Graphics2D g, StateRenderer2D renderer) {
            if (!WorldRenderPainter.this.isShowOnScreenControls()) {
                for (HoveringButton hb : WorldRenderPainter.this.controlRenderButtons) {
                    hb.setVisible(false);
                }
                return;
            }
            boolean visible = true;
            if (!WorldRenderPainter.this.mapControlButton.isSelected()) {
                visible = false;
            }
            for (HoveringButton hb : WorldRenderPainter.this.controlRenderButtons) {
                if (hb == WorldRenderPainter.this.mapControlButton) continue;
                hb.setVisible(visible);
            }
            if (visible) {
                boolean show = false;
                for (String ms : mapActiveHolderList.keySet()) {
                    if (!((Boolean)mapActiveHolderList.get(ms)).booleanValue() || WorldRenderPainter.this.hasPropertiesOrCustomDialog(ms) == PropertiesOrCustomOptionsDialogEnum.None) continue;
                    show = true;
                    break;
                }
                WorldRenderPainter.this.mapShowActiveLayerDialogButton.setVisible(show);
            }
            for (HoveringButton hb : WorldRenderPainter.this.controlRenderButtons) {
                hb.paint(g, renderer);
            }
        }
    }

    private static enum PropertiesOrCustomOptionsDialogEnum {
        None,
        PropertiesDialog,
        CustomOptionsDialog;

    }
}

