/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.imageio.ImageIO;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.coord.MapTileUtil;

public abstract class Tile
implements Serializable {
    private static final long serialVersionUID = 564094012577853170L;
    private static boolean useImageFromLowerLevelOfDetailWhileLoading = true;
    private static final ReentrantReadWriteLock tileCacheDiskClearOrTileSaveLock = new ReentrantReadWriteLock();
    protected static String TILE_BASE_CACHE_DIR;
    protected static final String TILE_FX_EXTENSION = "png";
    public static final long MILISECONDS_TO_TILE_MEM_REMOVAL = 20000L;
    private static final int MILLIS_TO_NOT_TRY_LOAD_LOW_LEVEL_IMAGE = 30000;
    private static final Color COLOR_WHITE_TRANS_100;
    private static final Color COLOR_GREEN;
    private TileState state;
    protected String lasErrorMessage;
    protected static String tileClassId;
    public final String id;
    public final int levelOfDetail;
    public final int tileX;
    public final int tileY;
    public final int worldX;
    public final int worldY;
    protected BufferedImage image;
    protected boolean temporaryTransparencyDetectedOnImageOnDisk;
    private boolean showTileId;
    private Image imageFromLowerLevelOfDetail;
    private int levelOfDetailFromImageFromLowerLevelOfDetail;
    private long lastPaintTimeMillis;
    private Timer timer;
    private TimerTask timerTask;
    private boolean isFetchingAlternativeImage;

    public Tile(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        TILE_BASE_CACHE_DIR = new File("../.cache/wmcache").exists() ? "../.cache/wmcache" : ".cache/wmcache";
        this.state = TileState.LOADING;
        this.lasErrorMessage = "";
        this.image = null;
        this.temporaryTransparencyDetectedOnImageOnDisk = false;
        this.showTileId = false;
        this.imageFromLowerLevelOfDetail = null;
        this.levelOfDetailFromImageFromLowerLevelOfDetail = 0;
        this.lastPaintTimeMillis = -1L;
        this.timer = null;
        this.timerTask = null;
        this.isFetchingAlternativeImage = false;
        this.id = MapTileUtil.tileXYToQuadKey(tileX, tileY, levelOfDetail);
        this.levelOfDetail = levelOfDetail;
        this.tileX = tileX;
        this.tileY = tileY;
        int[] pxy = MapTileUtil.tileXYToPixelXY(tileX, tileY);
        this.worldX = pxy[0];
        this.worldY = pxy[1];
        this.testForAlfaOnLoaddImage(image);
        this.image = image;
        this.state = TileState.LOADED;
        this.lastPaintTimeMillis = System.currentTimeMillis();
    }

    public Tile(String id) throws Exception {
        TILE_BASE_CACHE_DIR = new File("../.cache/wmcache").exists() ? "../.cache/wmcache" : ".cache/wmcache";
        this.state = TileState.LOADING;
        this.lasErrorMessage = "";
        this.image = null;
        this.temporaryTransparencyDetectedOnImageOnDisk = false;
        this.showTileId = false;
        this.imageFromLowerLevelOfDetail = null;
        this.levelOfDetailFromImageFromLowerLevelOfDetail = 0;
        this.lastPaintTimeMillis = -1L;
        this.timer = null;
        this.timerTask = null;
        this.isFetchingAlternativeImage = false;
        this.id = id;
        this.levelOfDetail = id.length();
        int[] tlxy = MapTileUtil.quadKeyToTileXY(id);
        this.tileX = tlxy[0];
        this.tileY = tlxy[1];
        int[] pxy = MapTileUtil.tileXYToPixelXY(this.tileX, this.tileY);
        this.worldX = pxy[0];
        this.worldY = pxy[1];
        this.loadOrCreateTileImage();
    }

    public long getLastPaintTimeMillis() {
        return this.lastPaintTimeMillis;
    }

    public TileState getState() {
        return this.state;
    }

    protected void setState(TileState state) {
        if (state != TileState.DISPOSING && (this.state == TileState.DISPOSING || this.state == TileState.FATAL_ERROR)) {
            return;
        }
        this.state = state;
    }

    public String getLasErrorMessage() {
        return this.lasErrorMessage;
    }

    public void retryLoadingTile() {
        if (this.state == TileState.ERROR) {
            this.setState(TileState.LOADING);
            this.loadOrCreateTileImage();
        }
    }

    public boolean isShowTileId() {
        return this.showTileId;
    }

    public void setShowTileId(boolean showTileId) {
        this.showTileId = showTileId;
    }

    public static int getMaxLevelOfDetail() {
        return 22;
    }

    protected final void loadOrCreateTileImage() {
        this.lastPaintTimeMillis = System.currentTimeMillis();
        new Thread("World Tile loader"){

            @Override
            public void run() {
                if (!Tile.this.loadTile()) {
                    Tile.this.createTileImage();
                }
            }
        }.start();
    }

    protected float getTransparencyToApplyToImage() {
        return 0.4f;
    }

    protected abstract void createTileImage();

    public static boolean isFetchableOrGenerated() {
        return false;
    }

    public static String getTileStyleID() {
        return null;
    }

    public static void staticPropertiesChanged() {
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer, boolean useTransparency) {
        this.lastPaintTimeMillis = System.currentTimeMillis();
        Point2D xyWC = renderer.getCenter().getPointInPixel(renderer.getLevelOfDetail());
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(renderer.getWidth() / 2, renderer.getHeight() / 2);
        g2.translate((double)this.worldX - xyWC.getX(), (double)this.worldY - xyWC.getY());
        if (this.image == null) {
            if (this.imageFromLowerLevelOfDetail != null) {
                Graphics2D gt = (Graphics2D)g2.create();
                double sz = 256 / this.imageFromLowerLevelOfDetail.getWidth(null);
                gt.scale(sz, sz);
                if (useTransparency && !this.temporaryTransparencyDetectedOnImageOnDisk && this.getTransparencyToApplyToImage() >= 0.0f && this.getTransparencyToApplyToImage() < 1.0f) {
                    gt.setComposite(AlphaComposite.getInstance(3, this.getTransparencyToApplyToImage()));
                }
                gt.drawImage(this.imageFromLowerLevelOfDetail, 0, 0, this.imageFromLowerLevelOfDetail.getWidth(null), this.imageFromLowerLevelOfDetail.getHeight(null), 0, 0, this.imageFromLowerLevelOfDetail.getWidth(null), this.imageFromLowerLevelOfDetail.getHeight(null), null);
                gt.dispose();
            } else {
                this.scheduleLoadImageFromLowerLevelOfDetail();
            }
            g2.setColor(COLOR_WHITE_TRANS_100);
            if (this.state == TileState.LOADING || this.state == TileState.RETRYING) {
                g2.setFont(new Font("Arial", 0, 10));
                g2.drawString(I18n.text(this.state.toString()), 128, 128);
            }
            g2.dispose();
        } else {
            Graphics2D gt = (Graphics2D)g2.create();
            if (useTransparency && !this.temporaryTransparencyDetectedOnImageOnDisk && this.getTransparencyToApplyToImage() >= 0.0f && this.getTransparencyToApplyToImage() < 1.0f) {
                gt.setComposite(AlphaComposite.getInstance(3, this.getTransparencyToApplyToImage()));
            }
            gt.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
            gt.dispose();
            if (this.showTileId) {
                g2.setColor(COLOR_GREEN);
                g2.setFont(new Font("Arial", 0, 10));
                g2.drawString(this.getId(), 128, 128);
            }
        }
        g2.dispose();
    }

    public void dispose() {
        this.state = TileState.DISPOSING;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timerTask = null;
        this.timer = null;
    }

    protected final String getTileFilePath() {
        return this.getTileFilePathFor(this.levelOfDetail, this.tileX, this.tileY);
    }

    protected final String getTileFilePathFor(int levelOfDetailToUse, int tileXToUse, int tileYToUse) {
        return TILE_BASE_CACHE_DIR + "/" + this.getClass().getSimpleName() + "/z" + levelOfDetailToUse + "/x" + tileXToUse + "/y" + tileYToUse + "." + TILE_FX_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveTile() {
        if (this.state != TileState.LOADED) {
            return false;
        }
        tileCacheDiskClearOrTileSaveLock.readLock().lock();
        try {
            File outFile = new File(this.getTileFilePath());
            outFile.mkdirs();
            boolean bl = ImageIO.write((RenderedImage)this.image, TILE_FX_EXTENSION.toUpperCase(), outFile);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            tileCacheDiskClearOrTileSaveLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadTile() {
        tileCacheDiskClearOrTileSaveLock.readLock().lock();
        try {
            BufferedImage img;
            File inFile;
            if (this.image == null) {
                this.state = TileState.LOADING;
            }
            if (!(inFile = new File(this.getTileFilePath())).exists()) {
                this.lasErrorMessage = "Error loading tile from file not existing!";
                if (this.image == null) {
                    this.state = TileState.ERROR;
                }
                boolean bl = false;
                return bl;
            }
            try {
                img = ImageIO.read(inFile);
            }
            catch (IndexOutOfBoundsException e) {
                inFile.delete();
                throw new Exception("Image not complete to load! Was deleted.");
            }
            this.testForAlfaOnLoaddImage(img);
            this.image = img;
            this.imageFromLowerLevelOfDetail = null;
            this.state = TileState.LOADED;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.lasErrorMessage = "Error loading tile from file: " + e;
            if (this.image == null) {
                this.state = TileState.ERROR;
            }
            this.loadImageFromLowerLevelOfDetail();
            boolean bl = false;
            return bl;
        }
        finally {
            tileCacheDiskClearOrTileSaveLock.readLock().unlock();
        }
    }

    protected void testForAlfaOnLoaddImage(BufferedImage img) {
        boolean isBaseOrLayer = this.isBaseOrLayerMap();
        this.temporaryTransparencyDetectedOnImageOnDisk = isBaseOrLayer ? GuiUtils.hasAlpha(img) : false;
    }

    protected boolean isBaseOrLayerMap() {
        try {
            MapTileProvider anotat = this.getClass().getAnnotation(MapTileProvider.class);
            return anotat == null ? true : anotat.isBaseMapOrLayer();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private void scheduleLoadImageFromLowerLevelOfDetail() {
        if (this.state == TileState.DISPOSING || !useImageFromLowerLevelOfDetailWhileLoading) {
            return;
        }
        if (this.imageFromLowerLevelOfDetail != null && this.levelOfDetail - this.levelOfDetailFromImageFromLowerLevelOfDetail == 1) {
            return;
        }
        if (this.timerTask == null) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    Tile.this.loadImageFromLowerLevelOfDetail();
                    if (Tile.this.state == TileState.DISPOSING || Tile.this.image != null || System.currentTimeMillis() - Tile.this.lastPaintTimeMillis > 30000L) {
                        this.cancel();
                        Tile.this.timerTask = null;
                        if (Tile.this.timer != null) {
                            Tile.this.timer.cancel();
                            Tile.this.timer = null;
                        }
                    }
                    if (Tile.this.imageFromLowerLevelOfDetail != null && Tile.this.levelOfDetail - Tile.this.levelOfDetailFromImageFromLowerLevelOfDetail == 1) {
                        this.cancel();
                        Tile.this.timerTask = null;
                        if (Tile.this.timer != null) {
                            Tile.this.timer.cancel();
                            Tile.this.timer = null;
                        }
                    }
                }
            };
            if (this.timer == null) {
                this.timer = new Timer(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "] ::LOD" + this.levelOfDetail + ":: " + "createLowerLevelTileImage", true);
            }
            this.timer.scheduleAtFixedRate(this.timerTask, 1000L, 30000L);
        }
    }

    private void loadImageFromLowerLevelOfDetail() {
        if (this.isFetchingAlternativeImage) {
            return;
        }
        this.isFetchingAlternativeImage = true;
        if (this.imageFromLowerLevelOfDetail != null && this.levelOfDetail - this.levelOfDetailFromImageFromLowerLevelOfDetail == 1) {
            return;
        }
        String quadKey = MapTileUtil.tileXYToQuadKey(this.tileX, this.tileY, this.levelOfDetail);
        int currentLevelOfDetailFromImageFromLowerLevelOfDetail = this.imageFromLowerLevelOfDetail == null ? 0 : this.levelOfDetailFromImageFromLowerLevelOfDetail;
        for (int nCuts = 1; nCuts < 6; ++nCuts) {
            String tmpQK = quadKey.substring(0, quadKey.length() - nCuts);
            String tmpMatrix = quadKey.substring(quadKey.length() - nCuts);
            try {
                BufferedImage img;
                int[] tmpTs = MapTileUtil.quadKeyToTileXY(tmpQK);
                int tmpTileX = tmpTs[0];
                int tmpTileY = tmpTs[1];
                if (currentLevelOfDetailFromImageFromLowerLevelOfDetail == tmpQK.length()) {
                    return;
                }
                File inFile = new File(this.getTileFilePathFor(tmpQK.length(), tmpTileX, tmpTileY));
                if (!inFile.exists()) continue;
                try {
                    img = ImageIO.read(inFile);
                }
                catch (IndexOutOfBoundsException e) {
                    continue;
                }
                int px = 0;
                int py = 0;
                block11: for (int i = 0; i < tmpMatrix.length(); ++i) {
                    int slice = Integer.parseInt("" + tmpMatrix.charAt(i));
                    switch (slice) {
                        case 0: {
                            px += 0;
                            py += 0;
                            continue block11;
                        }
                        case 1: {
                            px = (int)((double)px + 256.0 / Math.pow(2.0, i) / 2.0);
                            py += 0;
                            continue block11;
                        }
                        case 2: {
                            px += 0;
                            py = (int)((double)py + 256.0 / Math.pow(2.0, i) / 2.0);
                            continue block11;
                        }
                        case 3: {
                            px = (int)((double)px + 256.0 / Math.pow(2.0, i) / 2.0);
                            py = (int)((double)py + 256.0 / Math.pow(2.0, i) / 2.0);
                        }
                    }
                }
                double tileDivision = Math.pow(2.0, tmpMatrix.length());
                int sts = (int)(256.0 / tileDivision);
                img = img.getSubimage(px, py, sts, sts);
                this.imageFromLowerLevelOfDetail = ImageUtils.getScaledImage(img, 256, 256, true);
                this.levelOfDetailFromImageFromLowerLevelOfDetail = tmpQK.length();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isFetchingAlternativeImage = false;
    }

    public static void clearDiskCache() {
    }

    protected static void clearDiskCache(String tileClassId) {
        final String path = TILE_BASE_CACHE_DIR + "/" + tileClassId;
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                tileCacheDiskClearOrTileSaveLock.writeLock().lock();
                try {
                    File base = new File(path);
                    File[] zList = base.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory() && pathname.getName().length() > 0 && pathname.getName().charAt(0) == 'z';
                        }
                    });
                    if (zList == null) {
                        return;
                    }
                    for (File fileZ : zList) {
                        String zStr = fileZ.getName().replace("z", "");
                        try {
                            Integer.parseInt(zStr);
                            File[] xList = fileZ.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File pathname) {
                                    return pathname.isDirectory() && pathname.getName().length() > 0 && pathname.getName().charAt(0) == 'x';
                                }
                            });
                            if (xList == null) continue;
                            for (File fileX : xList) {
                                String xStr = fileX.getName().replace("x", "");
                                try {
                                    Integer.parseInt(xStr);
                                    File[] yList = fileX.listFiles(new FileFilter(){

                                        @Override
                                        public boolean accept(File pathname) {
                                            return pathname.isFile() && Tile.TILE_FX_EXTENSION.equalsIgnoreCase(FileUtil.getFileExtension(pathname)) && pathname.getName().length() > 0 && pathname.getName().charAt(0) == 'y';
                                        }
                                    });
                                    if (yList == null) continue;
                                    for (File fileY : yList) {
                                        String yStr = fileY.getName().replace("y", "").replace(".png", "");
                                        try {
                                            Integer.parseInt(yStr);
                                            fileY.delete();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    fileX.delete();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            fileZ.delete();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    base.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    tileCacheDiskClearOrTileSaveLock.writeLock().unlock();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected static <T extends Tile> Vector<T> loadCache(String tileClassId) {
        String path = TILE_BASE_CACHE_DIR + "/" + tileClassId;
        Vector<Tile> ret = new Vector<Tile>();
        File base = new File(path);
        File[] zList = base.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().length() > 0 && pathname.getName().charAt(0) == 'z';
            }
        });
        if (zList == null) {
            return ret;
        }
        for (File fileZ : zList) {
            String zStr = fileZ.getName().replace("z", "");
            try {
                int lod = Integer.parseInt(zStr);
                File[] xList = fileZ.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory() && pathname.getName().length() > 0 && pathname.getName().charAt(0) == 'x';
                    }
                });
                if (xList == null) continue;
                for (File fileX : xList) {
                    String xStr = fileX.getName().replace("x", "");
                    try {
                        int xTile = Integer.parseInt(xStr);
                        File[] yList = fileX.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.isFile() && Tile.TILE_FX_EXTENSION.equalsIgnoreCase(FileUtil.getFileExtension(pathname)) && pathname.getName().length() > 0 && pathname.getName().charAt(0) == 'y';
                            }
                        });
                        if (yList == null) continue;
                        for (File fileY : yList) {
                            String yStr = fileY.getName().replace("y", "").replace(".png", "");
                            try {
                                BufferedImage image;
                                int yTile = Integer.parseInt(yStr);
                                String pack = Tile.class.getPackage().getName() + ".";
                                try {
                                    image = ImageIO.read(fileY);
                                }
                                catch (IndexOutOfBoundsException e) {
                                    fileY.delete();
                                    throw new Exception("Image not complete to load! Was deleted.");
                                }
                                Tile tile = (Tile)Tile.class.getClassLoader().loadClass(pack + tileClassId).getConstructor(Integer.class, Integer.class, Integer.class, BufferedImage.class).newInstance(lod, xTile, yTile, image);
                                ret.add(tile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    static {
        COLOR_WHITE_TRANS_100 = ColorUtils.setTransparencyToColor(Color.WHITE, 100);
        COLOR_GREEN = Color.GREEN;
        tileClassId = "unknown";
    }

    public static enum TileState {
        LOADING,
        RETRYING,
        LOADED,
        ERROR,
        FATAL_ERROR,
        DISPOSING;

    }
}

