/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.proxy.ProxyInfoProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;

public abstract class TileHttpFetcher
extends Tile {
    private static final long serialVersionUID = 536559879996297467L;
    private static final long TIME_MILLIS_TO_RETIRE_THREAD_WORKER = 10000L;
    protected static String tileClassId = TileHttpFetcher.class.getSimpleName();
    protected static Random rnd = new Random(System.currentTimeMillis());
    private static final int MAX_LEVEL_OF_DETAIL = 18;
    private static final int MAX_RETRIES = 4;
    protected static final long MAX_WAIT_TIME_MILLIS = 30000L;
    private static boolean isInStateForbidden = false;
    protected int retries = 0;
    protected static DefaultHttpClient client;
    protected static PoolingClientConnectionManager httpConnectionManager;
    private static final boolean DEBUG = false;
    private static boolean useThreadPool;
    private static AtomicLong workingThreadCounter;
    private static final int MAX_WORKING_THREADS = 10;
    private static LinkedBlockingQueue<HttpFetcherWorker> httpFetcherWorkerList;

    public TileHttpFetcher(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
        this.initialize();
    }

    public TileHttpFetcher(String id) throws Exception {
        super(id);
        this.initialize();
    }

    private final synchronized void initialize() {
        if (client != null) {
            return;
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        httpConnectionManager = new PoolingClientConnectionManager(schemeRegistry);
        httpConnectionManager.setMaxTotal(50);
        httpConnectionManager.setDefaultMaxPerRoute(10);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
        client = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager, (HttpParams)params);
        ProxyInfoProvider.setRoutePlanner((AbstractHttpClient)client);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                client.getConnectionManager().shutdown();
                httpConnectionManager.shutdown();
            }
        });
    }

    public static int getMaxLevelOfDetail() {
        return 18;
    }

    @Override
    public void retryLoadingTile() {
        this.retries = 0;
        super.retryLoadingTile();
    }

    protected abstract String createTileRequestURL();

    protected long getWaitTimeMillisToSeparateConnections() {
        return 0L;
    }

    protected ReentrantLock getWaitTimeLock() {
        return null;
    }

    @Override
    protected void createTileImage() {
        if (this.getState() == Tile.TileState.DISPOSING || this.getState() == Tile.TileState.FATAL_ERROR) {
            return;
        }
        this.setState(Tile.TileState.LOADING);
        if (useThreadPool) {
            this.createTileImageAlt();
            return;
        }
        Thread t = new Thread(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "] ::LOD" + this.levelOfDetail + ":: " + "createTileImage"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String urlGet = TileHttpFetcher.this.createTileRequestURL();
                HttpGet get = new HttpGet(urlGet);
                long waitTime = TileHttpFetcher.this.getWaitTimeMillisToSeparateConnections();
                if (waitTime > 30000L) {
                    waitTime = 30000L;
                }
                try {
                    BufferedImage cache;
                    double sleepT = 2000.0 + 15000.0 * rnd.nextDouble();
                    if (isInStateForbidden && TileHttpFetcher.this.retries == 0) {
                        sleepT = 60000.0 + 30000.0 * rnd.nextDouble();
                    }
                    try {
                        Thread.sleep((long)sleepT);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (TileHttpFetcher.this.getState() == Tile.TileState.DISPOSING || TileHttpFetcher.this.getState() == Tile.TileState.FATAL_ERROR) {
                        return;
                    }
                    if (waitTime > 0L && TileHttpFetcher.this.getWaitTimeLock() != null) {
                        TileHttpFetcher.this.getWaitTimeLock().lock();
                    }
                    BasicHttpContext localContext = new BasicHttpContext();
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)get, (HttpContext)localContext);
                    ProxyInfoProvider.authenticateConnectionIfNeeded((HttpResponse)resp, (HttpContext)localContext, client);
                    if (TileHttpFetcher.this.getState() != Tile.TileState.DISPOSING && TileHttpFetcher.this.retries < 4 && resp.getStatusLine().getStatusCode() == 403) {
                        isInStateForbidden = true;
                        ++TileHttpFetcher.this.retries;
                        sleepT = (double)(TileHttpFetcher.this.retries * 60000) + 30000.0 * rnd.nextDouble();
                        try {
                            Thread.sleep((long)sleepT);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (TileHttpFetcher.this.getState() == Tile.TileState.DISPOSING || TileHttpFetcher.this.getState() == Tile.TileState.FATAL_ERROR) {
                            return;
                        }
                        TileHttpFetcher.this.setState(Tile.TileState.RETRYING);
                        get.abort();
                        TileHttpFetcher.this.createTileImage();
                        return;
                    }
                    if (resp.getStatusLine().getStatusCode() != 200) {
                        TileHttpFetcher.this.lasErrorMessage = "Not able to fetch " + this.getClass().getSimpleName() + " Image" + (TileHttpFetcher.this.retries < 4 ? ", retrying" : "") + ": " + resp.getStatusLine().getStatusCode();
                        NeptusLog.pub().error((Object)TileHttpFetcher.this.lasErrorMessage);
                        if (resp.getStatusLine().getStatusCode() == 400) {
                            TileHttpFetcher.this.setState(Tile.TileState.FATAL_ERROR);
                        } else {
                            TileHttpFetcher.this.setState(Tile.TileState.ERROR);
                        }
                        return;
                    }
                    TileHttpFetcher.this.retries = 0;
                    isInStateForbidden = false;
                    InputStream is = resp.getEntity().getContent();
                    ImageInputStream iis = ImageIO.createImageInputStream(is);
                    TileHttpFetcher.this.image = cache = ImageIO.read(iis);
                    TileHttpFetcher.this.setState(Tile.TileState.LOADED);
                    Thread tsave = new Thread(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "] :: Tile Saver"){

                        @Override
                        public void run() {
                            TileHttpFetcher.this.saveTile();
                        }
                    };
                    tsave.setDaemon(false);
                    tsave.start();
                    tsave.join();
                }
                catch (IllegalStateException e) {
                    TileHttpFetcher.this.lasErrorMessage = "Not able to fetch " + this.getClass().getSimpleName() + " Image, " + (TileHttpFetcher.this.retries <= 4 ? ", retrying" : "") + ": " + e;
                    TileHttpFetcher.this.setState(Tile.TileState.ERROR);
                }
                catch (ConnectionPoolTimeoutException e) {
                    TileHttpFetcher.this.lasErrorMessage = "Not able to fetch " + this.getClass().getSimpleName() + " Image, " + (TileHttpFetcher.this.retries <= 4 ? ", retrying" : "") + ": " + (Object)((Object)e);
                    TileHttpFetcher.this.setState(Tile.TileState.ERROR);
                }
                catch (UnknownHostException e) {
                    TileHttpFetcher.this.lasErrorMessage = "Not able to fetch " + this.getClass().getSimpleName() + " Image, " + (TileHttpFetcher.this.retries <= 4 ? ", retrying" : "") + ": " + e;
                    TileHttpFetcher.this.setState(Tile.TileState.ERROR);
                }
                catch (Exception e) {
                    TileHttpFetcher.this.lasErrorMessage = "Not able to fetch " + this.getClass().getSimpleName() + " Image" + (TileHttpFetcher.this.retries <= 4 ? ", retrying" : "") + ": " + e;
                    if (TileHttpFetcher.this.retries > 4) {
                        NeptusLog.pub().info((Object)("<###> " + TileHttpFetcher.this.lasErrorMessage + " :: " + e));
                    }
                    TileHttpFetcher.this.setState(Tile.TileState.ERROR);
                }
                finally {
                    get.abort();
                    if (waitTime > 0L && TileHttpFetcher.this.getWaitTimeLock() != null) {
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException e) {}
                        TileHttpFetcher.this.getWaitTimeLock().unlock();
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void createTileImageAlt() {
        final HttpFetcherWorker tf = this.getLoadingRunnable();
        if (workingThreadCounter.incrementAndGet() <= 10L) {
            Thread t = new Thread(tf.getIdStr()){
                private long lastJobTimeMillis;
                private long timeoutLastJobMillis;
                {
                    super(x0);
                    this.lastJobTimeMillis = -1L;
                    this.timeoutLastJobMillis = 10000L;
                }

                @Override
                public void run() {
                    this.lastJobTimeMillis = System.currentTimeMillis();
                    tf.run();
                    if (tf.getTileLoadingState() != LoadHttpTileState.END) {
                        httpFetcherWorkerList.offer(tf);
                    }
                    while (System.currentTimeMillis() - this.lastJobTimeMillis < this.timeoutLastJobMillis) {
                        HttpFetcherWorker toFetch = null;
                        try {
                            toFetch = (HttpFetcherWorker)httpFetcherWorkerList.poll(1000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (toFetch != null) {
                            this.lastJobTimeMillis = System.currentTimeMillis();
                            if (toFetch.getTimeToRun() < 0L || toFetch.getTimeToRun() - System.currentTimeMillis() < 0L) {
                                this.setName(toFetch.getIdStr());
                                toFetch.run();
                                if (toFetch.getTileLoadingState() != LoadHttpTileState.END) {
                                    httpFetcherWorkerList.offer(toFetch);
                                }
                            } else {
                                httpFetcherWorkerList.offer(toFetch);
                            }
                        }
                        this.setName(TileHttpFetcher.this.getClass().getSimpleName() + " [" + Integer.toHexString(TileHttpFetcher.this.hashCode()) + "] :: " + "createTileImage");
                        try {
                            Thread.sleep(toFetch != null ? 10L : 3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    workingThreadCounter.decrementAndGet();
                }
            };
            t.setPriority(1);
            t.setDaemon(true);
            t.start();
        } else {
            workingThreadCounter.decrementAndGet();
            httpFetcherWorkerList.offer(tf);
        }
    }

    private HttpFetcherWorker getLoadingRunnable() {
        return new HttpFetcherWorker(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "] ::LOD" + this.levelOfDetail + ":: " + this.tileX + "x" + this.tileY + " ::" + "createTileImage");
    }

    public static boolean isFetchableOrGenerated() {
        return true;
    }

    protected static boolean isInStateForbidden() {
        return isInStateForbidden;
    }

    static {
        useThreadPool = true;
        workingThreadCounter = new AtomicLong(0L);
        httpFetcherWorkerList = new LinkedBlockingQueue();
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState;

        static {
            $SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState = new int[LoadHttpTileState.values().length];
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.WAIT_FORBIDDEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.RETRY_FORBIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.WAIT_BETWEEN_CONNECTIONS_RETRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.WAIT_BETWEEN_CONNECTIONS_END.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.DECIDE_TO_LOCK_OR_CONTINUE.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.GET_LOCK.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$pt$lsts$neptus$renderer2d$tiles$TileHttpFetcher$LoadHttpTileState[LoadHttpTileState.FETCH_HTTP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class HttpFetcherWorker
    implements Runnable {
        private String idStr = "?";
        private LoadHttpTileState tileLoadingState = LoadHttpTileState.START;
        private long timeToRun = -1L;

        public HttpFetcherWorker(String id) {
            this.idStr = id;
        }

        public String getIdStr() {
            return this.idStr + " :: " + (Object)((Object)this.tileLoadingState);
        }

        public LoadHttpTileState getTileLoadingState() {
            return this.tileLoadingState;
        }

        public long getTimeToRun() {
            return this.timeToRun;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static enum LoadHttpTileState {
        START,
        FETCH_HTTP,
        WAIT_FORBIDDEN,
        RETRY_FORBIDDEN,
        WAIT_BETWEEN_CONNECTIONS_END,
        WAIT_BETWEEN_CONNECTIONS_RETRY,
        DECIDE_TO_LOCK_OR_CONTINUE,
        GET_LOCK,
        END;

    }
}

