/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;

@MapTileProvider(name="MapQuest Open Aerial")
public class TileMapQuestOpenAerial
extends TileHttpFetcher {
    private static final long serialVersionUID = -6223894220961990667L;
    protected static String tileClassId = TileMapQuestOpenAerial.class.getSimpleName();
    private static Map<String, TileMapQuestOpenAerial> tilesMap = Collections.synchronizedMap(new HashMap());
    private static final int MAX_LEVEL_OF_DETAIL = 18;

    public TileMapQuestOpenAerial(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
    }

    public TileMapQuestOpenAerial(String id) throws Exception {
        super(id);
    }

    public static int getMaxLevelOfDetail() {
        return 18;
    }

    @Override
    protected String createTileRequestURL() {
        int server = (int)(4.0f * rnd.nextFloat());
        String urlGet = "http://oatile" + server + "." + "mqcdn.com/naip/" + this.levelOfDetail + "/" + this.tileX + "/" + this.tileY + ".png";
        return urlGet;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache(tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache(tileClassId);
    }
}

