/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.SvgUtil;
import pt.lsts.neptus.util.coord.MapTileUtil;

@MapTileProvider(name="Mercator SVG (Local)")
public class TileMercadorSVG
extends Tile {
    private static final long serialVersionUID = -6947456498157990203L;
    protected static String tileClassId = TileMercadorSVG.class.getSimpleName();
    private static Map<String, TileMercadorSVG> tilesMap = Collections.synchronizedMap(new HashMap());
    private static final Object lock = new Object();
    protected static final String fxWM = "/images/World_Blank_Map_Mercator_projection.svg";
    protected static final double w = 634.26801;
    protected static final double h = 476.7276;
    protected static final LocationType centerOfImage = new LocationType();
    private static final int offsetX = 0;
    private static final int offsetY = 0;
    private static final int MAX_LEVEL_OF_DETAIL = 15;
    private static PrintTranscoder prm;
    private static PageFormat page;

    public TileMercadorSVG(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
        centerOfImage.setLatitudeDegs(-1.5);
        centerOfImage.translatePosition(-227000.0, -12000.0, 0.0);
        centerOfImage.setLongitudeDegs(10.0);
        centerOfImage.convertToAbsoluteLatLonDepth();
        prm = TileMercadorSVG.loadWorld(fxWM, 634.26801, 476.7276);
        Paper paper = new Paper();
        paper.setSize(634.26801, 476.7276);
        paper.setImageableArea(0.0, 0.0, 634.26801, 476.7276);
        page = new PageFormat();
        page.setPaper(paper);
    }

    public TileMercadorSVG(String id) throws Exception {
        super(id);
        centerOfImage.setLatitudeDegs(-1.5);
        centerOfImage.translatePosition(-227000.0, -12000.0, 0.0);
        centerOfImage.setLongitudeDegs(10.0);
        centerOfImage.convertToAbsoluteLatLonDepth();
        prm = TileMercadorSVG.loadWorld(fxWM, 634.26801, 476.7276);
        Paper paper = new Paper();
        paper.setSize(634.26801, 476.7276);
        paper.setImageableArea(0.0, 0.0, 634.26801, 476.7276);
        page = new PageFormat();
        page.setPaper(paper);
    }

    protected static PrintTranscoder loadWorld(String fx, double w, double h) {
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            String data = FileUtil.getFileAsString(FileUtil.getResourceAsFile(fx));
            Document wDoc = f.createDocument(null, (Reader)new StringReader(data));
            wDoc = SvgUtil.cleanInkscapeSVG(wDoc);
            PrintTranscoder prm = new PrintTranscoder();
            prm.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(w));
            prm.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(h));
            TranscoderInput ti = new TranscoderInput(wDoc);
            prm.transcode(ti, null);
            return prm;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (NoClassDefFoundError e) {
            System.out.print("Batik missing in the classpath. Proceding without worldmap.");
            return null;
        }
        catch (Error e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void retryLoadingTile() {
    }

    public static int getMaxLevelOfDetail() {
        return 15;
    }

    @Override
    protected void createTileImage() {
        if (this.getState() == Tile.TileState.DISPOSING) {
            return;
        }
        if (prm == null) {
            this.setState(Tile.TileState.FATAL_ERROR);
            this.lasErrorMessage = "Not able to load SVG Map painter!";
        }
        this.setState(Tile.TileState.LOADING);
        new Thread(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int msize = MapTileUtil.mapSize(TileMercadorSVG.this.levelOfDetail);
                double[] xyWC = new double[]{msize / 2, msize / 2};
                Point2D xyWG = centerOfImage.getPointInPixel(TileMercadorSVG.this.levelOfDetail);
                BufferedImage cache = new BufferedImage(256, 256, 2);
                Graphics2D g2 = cache.createGraphics();
                g2.translate(xyWG.getX() - xyWC[0], xyWG.getY() - xyWC[1]);
                double zt = (double)msize / 634.26801;
                g2.translate(0.0, ((double)msize - 476.7276 * zt) / 2.0);
                Graphics2D gg = null;
                if (TileMercadorSVG.this.tileX == 0) {
                    gg = (Graphics2D)g2.create();
                    gg.translate(-msize, -TileMercadorSVG.this.tileY * 256);
                    gg.scale(zt, zt);
                    gg.translate(0, 0);
                }
                g2.translate(-TileMercadorSVG.this.tileX * 256, -TileMercadorSVG.this.tileY * 256);
                g2.scale(zt, zt);
                g2.translate(0, 0);
                Object object = lock;
                synchronized (object) {
                    if (TileMercadorSVG.this.getState() != Tile.TileState.DISPOSING) {
                        if (gg != null) {
                            prm.print((Graphics)gg, page, 0);
                        }
                    } else {
                        return;
                    }
                    if (TileMercadorSVG.this.getState() == Tile.TileState.DISPOSING) {
                        return;
                    }
                    prm.print((Graphics)g2, page, 0);
                }
                if (gg != null) {
                    gg.dispose();
                }
                g2.dispose();
                TileMercadorSVG.this.temporaryTransparencyDetectedOnImageOnDisk = false;
                TileMercadorSVG.this.image = cache;
                TileMercadorSVG.this.setState(Tile.TileState.LOADED);
                TileMercadorSVG.this.saveTile();
            }
        }.start();
    }

    @Override
    protected void testForAlfaOnLoaddImage(BufferedImage img) {
        this.temporaryTransparencyDetectedOnImageOnDisk = false;
    }

    @Override
    protected float getTransparencyToApplyToImage() {
        return 0.2f;
    }

    public static boolean isFetchableOrGenerated() {
        return false;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        TileMercadorSVG.clearDiskCache(tileClassId);
    }

    public static Vector<TileMercadorSVG> loadCache() {
        return TileMercadorSVG.loadCache(tileClassId);
    }

    public static void main(String[] args) throws Exception {
    }
}

