/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;

@MapTileProvider(name="Open Street Map")
public class TileOpenStreetMap
extends TileHttpFetcher {
    private static final long serialVersionUID = -6223894220961990673L;
    protected static String tileClassId = TileOpenStreetMap.class.getSimpleName();
    private static Map<String, TileOpenStreetMap> tilesMap = Collections.synchronizedMap(new HashMap());
    private static final int MAX_LEVEL_OF_DETAIL = 18;

    public TileOpenStreetMap(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
    }

    public TileOpenStreetMap(String id) throws Exception {
        super(id);
    }

    public static int getMaxLevelOfDetail() {
        return 18;
    }

    @Override
    protected String createTileRequestURL() {
        int server = (int)(3.0f * rnd.nextFloat());
        char sv = (char)(97 + server);
        String urlGet = "http://" + sv + "." + "tile.openstreetmap.org/" + this.levelOfDetail + "/" + this.tileX + "/" + this.tileY + ".png";
        return urlGet;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache(tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache(tileClassId);
    }
}

