/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

public class CamSoft3D {
    private double v11;
    private double v12;
    private double v13;
    private double v21;
    private double v22;
    private double v23;
    private double v32;
    private double v33;
    private double v43;
    public double rho = 40.0;
    public double theta = 0.7853981633974483;
    public double phi = 0.7853981633974483;
    public double psi;
    public float dist = 8.0f;
    public double pidiv180 = Math.atan(1.0) / 45.0;

    public CamSoft3D() {
        this.coeff();
        this.dist = 1.0f;
    }

    public void camdef(double rhod, double thetad, double phid, double psid) {
        this.rho = rhod;
        this.theta = thetad;
        this.phi = phid;
        this.psi = psid;
        this.coeff();
    }

    private void coeff() {
        double costh = Math.cos(this.theta);
        double sinth = Math.sin(this.theta);
        double cosph = Math.cos(this.phi);
        double sinph = Math.sin(this.phi);
        this.v11 = -sinth;
        this.v12 = -cosph * costh;
        this.v13 = -sinph * costh;
        this.v21 = costh;
        this.v22 = -cosph * sinth;
        this.v23 = -sinph * sinth;
        this.v32 = sinph;
        this.v33 = -cosph;
        this.v43 = this.rho;
    }

    public Vector3f eyecoord(Vector3f pw) {
        Vector3f pe = new Vector3f();
        pe.x = (float)(this.v11 * (double)pw.x + this.v21 * (double)pw.y);
        pe.y = (float)(this.v12 * (double)pw.x + this.v22 * (double)pw.y + this.v32 * (double)pw.z);
        pe.z = (float)(this.v13 * (double)pw.x + this.v23 * (double)pw.y + this.v33 * (double)pw.z + this.v43);
        return pe;
    }

    private Vector2f perspective(Vector3f p) {
        Vector3f pe = null;
        pe = this.eyecoord(p);
        Vector2f pxy = new Vector2f();
        Vector3f prot = new Vector3f();
        prot.x = (float)((double)pe.x * Math.cos(this.psi) - (double)pe.y * Math.sin(this.psi));
        prot.y = (float)((double)pe.x * Math.sin(this.psi) + (double)pe.y * Math.cos(this.psi));
        prot.z = pe.z;
        pxy.x = prot.x / prot.z;
        pxy.y = prot.y / prot.z;
        return pxy;
    }

    public Vector2f to2d(Vector3f p) {
        Vector2f aux = null;
        aux = this.perspective(p);
        if (aux == null) {
            return null;
        }
        Vector2f rt = new Vector2f();
        rt.x = this.dist * aux.x;
        rt.y = -this.dist * aux.y;
        return rt;
    }

    public Vector3f getCamXYZ() {
        Vector3f ret = new Vector3f();
        ret.x = (float)(this.rho * Math.sin(this.phi) * Math.cos(this.theta));
        ret.y = (float)(this.rho * Math.sin(this.phi) * Math.sin(this.theta));
        ret.z = (float)(this.rho * Math.cos(this.phi));
        return ret;
    }
}

