/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.exp.swing.JCanvas3D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pt.lsts.neptus.renderer3d.MyCanvas3D;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class Camera3D {
    public boolean clean = false;
    protected double rho = 10.0;
    protected double phi = 0.0;
    protected double theta = 0.0;
    protected double psi = 0.0;
    protected Vector3d pivot;
    protected Vector3d pos;
    protected double scale;
    protected double viewangle;
    public Renderer3D associatedrender = null;
    public VehicleType lock = null;
    public AbstractElement lockmapobj = null;
    public Obj3D lockobj = null;
    public static final int TOP = 0;
    public static final int BACK = 1;
    public static final int RIGHT = 2;
    public static final int USER = 3;
    public static final int DEFAULT = -1;
    protected short type = (short)-1;
    protected int projection;
    public MyCanvas3D canvas;
    public JPanel jCanvas3DPanel;
    private BoundingSphere bounds;
    private ViewPlatform viewPlatform;
    public View view;
    private PhysicalBody body;
    private PhysicalEnvironment environment;
    private TransformGroup Theta = new TransformGroup();
    private TransformGroup Psi = new TransformGroup();
    private TransformGroup Phi = new TransformGroup();
    private TransformGroup Rho = new TransformGroup();
    private TransformGroup Pivot = new TransformGroup();
    private TransformGroup Scale = new TransformGroup();
    public BranchGroup fullcam = new BranchGroup();
    public double step = 0.25;
    public double stepscale = 0.025;

    public Camera3D() {
        this.pivot = new Vector3d(0.0, 0.0, 0.0);
        this.pos = new Vector3d(0.0, 0.0, 0.0);
        Transform3D t = new Transform3D();
        this.bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.Theta.setCapability(18);
        this.Theta.setCapability(17);
        t.setIdentity();
        t.rotX(this.theta);
        this.Theta.setTransform(t);
        this.Psi.setCapability(18);
        this.Psi.setCapability(17);
        t.setIdentity();
        t.rotZ(this.psi);
        this.Psi.setTransform(t);
        this.Phi.setCapability(18);
        this.Phi.setCapability(17);
        t.setIdentity();
        t.rotZ(this.phi);
        this.Phi.setTransform(t);
        this.Rho.setCapability(18);
        this.Rho.setCapability(17);
        t.setIdentity();
        t.set(new Vector3d(0.0, 0.0, this.rho));
        this.Rho.setTransform(t);
        this.Pivot.setCapability(18);
        this.Pivot.setCapability(17);
        t.setIdentity();
        t.set(this.pivot);
        this.Pivot.setTransform(t);
        this.Pivot.addChild((Node)this.Psi);
        this.Psi.addChild((Node)this.Theta);
        this.Theta.addChild((Node)this.Phi);
        this.Phi.addChild((Node)this.Rho);
        this.Scale = new TransformGroup();
        this.Scale.setCapability(18);
        this.Scale.setCapability(17);
        GraphicsConfigTemplate3D tmpl = new GraphicsConfigTemplate3D();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getBestConfiguration((GraphicsConfigTemplate)tmpl);
        JCanvas3D canJ = new JCanvas3D(device);
        canJ.setSize(400, 400);
        this.jCanvas3DPanel = new JPanel(new BorderLayout());
        this.jCanvas3DPanel.add((Component)canJ);
        this.canvas = new MyCanvas3D(config, this);
        this.canvas.stopRenderer();
        this.canvas.setDoubleBufferEnable(true);
        this.view = new View();
        this.viewPlatform = new ViewPlatform();
        this.viewPlatform.setActivationRadius(Float.MAX_VALUE);
        this.viewPlatform.setBounds((Bounds)this.bounds);
        this.Scale.addChild((Node)this.viewPlatform);
        this.Rho.addChild((Node)this.Scale);
        this.view = new View();
        this.view.setProjectionPolicy(1);
        this.projection = 1;
        this.view.addCanvas3D((Canvas3D)this.canvas);
        this.view.setBackClipDistance(800.0);
        this.view.setFrontClipDistance(0.1);
        this.body = new PhysicalBody();
        this.view.setPhysicalBody(this.body);
        this.environment = new PhysicalEnvironment();
        this.view.setPhysicalEnvironment(this.environment);
        this.view.attachViewPlatform(this.viewPlatform);
        this.view.setWindowResizePolicy(1);
        this.fullcam.addChild((Node)this.Pivot);
        this.fullcam.setCapability(18);
        this.fullcam.setCapability(17);
    }

    public Camera3D(int style) {
        this();
        switch (style) {
            case 0: {
                this.resetTop();
                break;
            }
            case 2: {
                this.resetRight();
                break;
            }
            case 1: {
                this.resetBack();
                break;
            }
            case 3: {
                this.resetUser();
                break;
            }
        }
    }

    public void setWindowResizePolicy(int p) {
        this.view.setWindowResizePolicy(p);
    }

    public void setType(int style) {
        switch (style) {
            case 0: {
                this.resetTop();
                break;
            }
            case 2: {
                this.resetRight();
                break;
            }
            case 1: {
                this.resetBack();
                break;
            }
            case 3: {
                this.resetUser();
                break;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public String getStrType() {
        switch (this.type) {
            case 0: {
                return "Top";
            }
            case 2: {
                return "Right";
            }
            case 1: {
                return "Back";
            }
            case 3: {
                return "User";
            }
        }
        return "Custom";
    }

    public void resetTop() {
        this.setPhi(0.0);
        this.setPsi(1.5707963267948966);
        this.setScale(0.2);
        this.setTheta(Math.PI);
        this.setRho(500.0);
        this.setPivot(new Vector3d(0.0, 0.0, 0.0));
        this.setProjection(0);
        this.type = 0;
    }

    public void resetBack() {
        this.setPhi(Math.PI);
        this.setPsi(4.71238898038469);
        this.setTheta(0.0);
        this.setScale(0.2);
        this.setTheta(1.5707963267948966);
        this.setRho(500.0);
        this.setPivot(new Vector3d(0.0, 0.0, 0.0));
        this.setProjection(0);
        this.type = 1;
    }

    public void resetRight() {
        this.setPhi(Math.PI);
        this.setPsi(Math.PI);
        this.setTheta(1.5707963267948966);
        this.setScale(0.2);
        this.setRho(500.0);
        this.setPivot(new Vector3d(0.0, 0.0, 0.0));
        this.setProjection(0);
        this.type = (short)2;
    }

    public void resetUser() {
        this.setPhi(Math.PI);
        this.setPsi(-1.5707963267948966);
        this.setTheta(2.356194490192345);
        this.setScale(1.0);
        this.setRho(30.0);
        this.setPivot(new Vector3d(0.0, 0.0, 0.0));
        this.setProjection(1);
        this.type = (short)3;
    }

    public void reset() {
        this.setPhi(0.0);
        this.setPsi(0.0);
        this.setTheta(0.0);
        this.setScale(0.2);
        this.setRho(30.0);
        this.setPivot(new Vector3d(0.0, 0.0, 0.0));
        this.setProjection(0);
        this.type = (short)-1;
    }

    public void setTheta(double t) {
        Transform3D tt = new Transform3D();
        this.theta = t;
        tt.rotX(this.theta);
        this.Theta.setTransform(tt);
    }

    public void setPhi(double p) {
        Transform3D t = new Transform3D();
        this.phi = p;
        t.rotZ(this.phi);
        this.Phi.setTransform(t);
    }

    public void setPsi(double p) {
        Transform3D t = new Transform3D();
        t.setIdentity();
        this.psi = p;
        t.rotZ(this.psi);
        this.Psi.setTransform(t);
    }

    public void setRho(double r) {
        Transform3D t = new Transform3D();
        t.setIdentity();
        this.rho = r;
        t.set(new Vector3d(0.0, 0.0, this.rho));
        this.Rho.setTransform(t);
    }

    public void setPivot(Vector3d p) {
        Transform3D t = new Transform3D();
        this.pivot = p;
        t.set(this.pivot);
        this.Pivot.setTransform(t);
    }

    public void setScale(double s) {
        Transform3D t = new Transform3D();
        this.scale = s;
        t.setScale(this.scale);
        t.invert();
        this.Scale.setTransform(t);
    }

    public double getScale() {
        return this.scale;
    }

    public void setProjection(int proj) {
        this.view.setProjectionPolicy(proj);
        this.projection = proj;
    }

    public BranchGroup getCamera3D() {
        return this.fullcam;
    }

    public void cleanup() {
        if (this.clean) {
            return;
        }
        for (int i = this.view.numCanvas3Ds() - 1; i >= 0; --i) {
            Canvas3D c = this.view.getCanvas3D(i);
            if (!c.isOffScreen()) continue;
            c.setOffScreenBuffer(null);
        }
        this.view.stopView();
        this.view.stopBehaviorScheduler();
        this.view.removeAllCanvas3Ds();
        this.view.attachViewPlatform(null);
        this.view = null;
        this.canvas.stopRenderer();
        this.canvas = null;
        this.fullcam.detach();
        this.fullcam = null;
        this.clean = true;
    }

    public JPanel getCanvas3DPanel() {
        return this.jCanvas3DPanel;
    }
}

