/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.FollowTrajectory;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Util3D;

public class Maneuver3DCreationHelper {
    public static Obj3D getModel3DManeuverForRender(Maneuver man) {
        if (man instanceof FollowTrajectory) {
            return Maneuver3DCreationHelper.getFollowPathModel3D((FollowTrajectory)man);
        }
        if (man instanceof Loiter) {
            return Maneuver3DCreationHelper.getLoiterModel3D((Loiter)man);
        }
        if (man instanceof RowsManeuver) {
            return Maneuver3DCreationHelper.getRowsManeuverModel3D((RowsManeuver)man);
        }
        if (man instanceof StationKeeping) {
            return Maneuver3DCreationHelper.getStationKeepingModel3D((StationKeeping)man);
        }
        return null;
    }

    public static Obj3D getFollowPathModel3D(FollowTrajectory follow) {
        Obj3D ret = new Obj3D();
        ret.setModel3D(Maneuver3DCreationHelper.getPointLineList3Ddouble(follow.getPathPoints()));
        boolean b = true;
        for (double[] p : follow.getPathPoints()) {
            Obj3D aux = new Obj3D();
            if (b) {
                aux.setModel3D(Util3D.getSphere(Color.GREEN, 0.6, 0.6, 0.6));
            } else {
                aux.setModel3D(Util3D.getSphere(Color.RED, 0.6, 0.6, 0.6));
            }
            b = !b;
            aux.setPos(p);
            ret.addObj3D(aux);
        }
        return ret;
    }

    public static Point3d[] getPath(Vector<Point3d> offsets3D) {
        Vector<Point3d> points = offsets3D;
        if (points == null || points.size() <= 1) {
            return new Point3d[0];
        }
        Point3d[] pts = new Point3d[points.size() * 2 - 2];
        int i = 1;
        int x = 1;
        pts[0] = points.firstElement();
        while (i < points.size() - 1) {
            pts[x] = points.get(i);
            pts[++x] = points.get(i);
            ++i;
            ++x;
        }
        pts[pts.length - 1] = points.get(points.size() - 1);
        return pts;
    }

    public static TransformGroup getPointLineList3Ddouble(List<double[]> list) {
        Vector<Point3d> pointsv = new Vector<Point3d>();
        for (double[] p : list) {
            Point3d point = new Point3d(p);
            pointsv.add(point);
        }
        return Maneuver3DCreationHelper.getPointLineList3D(pointsv);
    }

    public static TransformGroup getPointLineList3D(Vector<Point3d> points) {
        TransformGroup model = new TransformGroup();
        Appearance appearance = new Appearance();
        Material mat = new Material();
        Color3f c = new Color3f(1.0f, 0.0f, 0.0f);
        c.set(Color.YELLOW);
        mat.setEmissiveColor(c);
        mat.setAmbientColor(c);
        mat.setDiffuseColor(c);
        appearance.setMaterial(mat);
        Point3d[] myCoords = Maneuver3DCreationHelper.getPath(points);
        if (myCoords.length == 0) {
            return null;
        }
        LineArray myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        model.addChild((Node)shape3D);
        return model;
    }

    public static Obj3D getLoiterModel3D(Loiter loiter) {
        Obj3D ret = new Obj3D();
        ret.setModel3D(Util3D.getSphere(Color.WHITE, loiter.getRadius(), loiter.getRadius(), 0.6));
        return ret;
    }

    public static Obj3D getRowsManeuverModel3D(RowsManeuver rows) {
        Obj3D ret = new Obj3D();
        ret.setModel3D(Maneuver3DCreationHelper.getPointLineList3Ddouble(rows.getPathPoints()));
        boolean b = true;
        for (double[] p : rows.getPathPoints()) {
            Obj3D aux = new Obj3D();
            if (b) {
                aux.setModel3D(Util3D.getSphere(Color.GREEN, 0.6, 0.6, 0.6));
            } else {
                aux.setModel3D(Util3D.getSphere(Color.RED, 0.6, 0.6, 0.6));
            }
            b = !b;
            aux.setPos(p);
            ret.addObj3D(aux);
        }
        return ret;
    }

    public static Obj3D getStationKeepingModel3D(StationKeeping sk) {
        Obj3D ret = new Obj3D();
        TransformGroup model = new TransformGroup();
        model.addChild((Node)Util3D.getCylinder(Color.RED, sk.getRadius(), sk.getRadius(), 0.6, true));
        model.addChild((Node)Util3D.getCylinder(Color.WHITE, sk.getRadius(), sk.getRadius(), 0.6, false));
        ret.setModel3D(model);
        return ret;
    }
}

