/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.renderer3d.Camera3D;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.DynamicElement;
import pt.lsts.neptus.types.map.HomeReferenceElement;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;

class MyCanvas3D
extends Canvas3D {
    private static final long serialVersionUID = 1L;
    public J3DGraphics2D g2 = null;
    private Dimension d = new Dimension(0, 0);
    protected Camera3D camera;
    public Point2d p1 = new Point2d();
    public Point2d p2 = new Point2d();
    public boolean caminfo = false;
    public boolean axisinfo = false;
    public boolean objinfo = false;
    public boolean transpinfo = false;
    public boolean veicleinfo = false;
    public boolean reguainfo = false;
    public boolean selected = false;
    public boolean vehicleicons = false;
    public boolean objsicons = false;
    public boolean gradback = false;
    public Image trans;
    public Image mark;
    public Image home;

    public Point2d get3DTo2DPoint(Point3d point3d) {
        Transform3D temp = new Transform3D();
        this.getVworldToImagePlate(temp);
        temp.transform(point3d);
        Point2d point2d = new Point2d();
        if (point3d.z > 0.0) {
            return point2d;
        }
        this.getPixelLocationFromImagePlate(point3d, point2d);
        return point2d;
    }

    public Point2d get3DTo2DPoint(Point3d point3d, double dist) {
        Transform3D temp = new Transform3D();
        this.getVworldToImagePlate(temp);
        temp.transform(point3d);
        Point2d point2d = new Point2d();
        if (this.camera.projection == 0) {
            dist = 0.0;
        }
        if (point3d.z > -dist) {
            return point2d;
        }
        this.getPixelLocationFromImagePlate(point3d, point2d);
        return point2d;
    }

    public MyCanvas3D(GraphicsConfiguration gcfg, Camera3D cam) {
        super(gcfg);
        this.camera = cam;
        this.loadIcons();
    }

    public void loadIcons() {
        this.trans = ImageUtils.getImage("images/transponder.png");
        this.mark = ImageUtils.getImage("images/mark.png");
        this.home = ImageUtils.getImage("images/home.png");
    }

    public void postRender() {
        this.g2 = this.getGraphics2D();
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.getSize(this.d);
        if (this.vehicleicons) {
            this.vehicleIcons(this.d.width, this.d.height, this.g2);
        }
        if (this.objsicons) {
            this.objsIcons(this.d.width, this.d.height, this.g2);
        }
        if (this.caminfo) {
            this.camInfo(this.d.width, this.d.height, this.g2);
        }
        if (this.reguainfo) {
            this.reguaInfo(this.d.width, this.d.height, this.g2);
        }
        if (this.axisinfo) {
            this.axisInfo(this.d.width, this.d.height, this.g2);
        }
        if (this.objinfo) {
            this.objInfo(this.d.width, this.d.height, this.g2);
        }
        if (this.veicleinfo) {
            this.veicleInfo(this.d.width, this.d.height, this.g2);
        }
        if (this.camera.associatedrender.gtext) {
            this.gridInfo(this.d.width, this.d.height, this.g2);
        }
        this.defaultDisplay(this.d.width, this.d.height, this.g2);
        if (this.isVisible()) {
            try {
                this.g2.flush(true);
            }
            catch (IllegalStateException e) {
                NeptusLog.waste().warn((Object)"MyCanvas3D error", (Throwable)e);
            }
        }
    }

    public void defaultDisplay(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.BLACK);
        Point2d orig = this.get3DTo2DPoint(new Point3d(0.0, 0.0, 0.0));
        Enumeration<AbstractElement> enuma = this.camera.associatedrender.objects.keys();
        while (enuma.hasMoreElements()) {
            Rectangle2D stringBounds;
            AbstractElement objs = enuma.nextElement();
            Obj3D obj2 = this.camera.associatedrender.objects.get(objs);
            if (obj2.drawlabel) {
                orig = this.get3DTo2DPoint(new Point3d(obj2.pos));
                if (orig.y != 0.0 && orig.x != 0.0) {
                    stringBounds = g2.getFontMetrics().getStringBounds(objs.getId(), (Graphics)g2);
                    this.window((int)orig.x - 2, (int)orig.y - 12, (int)orig.x + (int)stringBounds.getWidth(), (int)orig.y + 2);
                    g2.drawString(objs.getId(), (int)orig.x, (int)orig.y);
                }
            }
            if (!obj2.drawinfo) continue;
            orig = this.get3DTo2DPoint(new Point3d(obj2.pos));
            if (orig.y == 0.0 || orig.x == 0.0) continue;
            if (objs instanceof DynamicElement) {
                DynamicElement de = (DynamicElement)objs;
                Rectangle2D stringBounds2 = g2.getFontMetrics().getStringBounds(objs.getCenterLocation().toString(), (Graphics)g2);
                Rectangle2D stringBounds22 = g2.getFontMetrics().getStringBounds(objs.getType().toString(), (Graphics)g2);
                Rectangle2D stringBounds3 = g2.getFontMetrics().getStringBounds("Idle Time: " + de.getIdleTimeSecs(), (Graphics)g2);
                int max = (int)stringBounds2.getWidth();
                if ((double)max < stringBounds22.getWidth()) {
                    max = (int)stringBounds22.getWidth();
                }
                if ((double)max < stringBounds3.getWidth()) {
                    max = (int)stringBounds3.getWidth();
                }
                this.window((int)orig.x - 2, (int)orig.y + 2, (int)orig.x + max, (int)orig.y + 38);
                g2.drawString("Idle Time: " + de.getIdleTimeSecs(), (int)orig.x, (int)orig.y + 36);
                g2.drawString(objs.getCenterLocation().toString(), (int)orig.x, (int)orig.y + 24);
                g2.drawString(objs.getType(), (int)orig.x, (int)orig.y + 12);
                continue;
            }
            stringBounds = g2.getFontMetrics().getStringBounds(objs.getCenterLocation().toString(), (Graphics)g2);
            Rectangle2D stringBounds2 = g2.getFontMetrics().getStringBounds(objs.getType().toString(), (Graphics)g2);
            int max = (int)stringBounds.getWidth();
            if ((double)max < stringBounds2.getWidth()) {
                max = (int)stringBounds2.getWidth();
            }
            this.window((int)orig.x - 2, (int)orig.y + 2, (int)orig.x + max, (int)orig.y + 28);
            g2.drawString(objs.getCenterLocation().toString(), (int)orig.x, (int)orig.y + 24);
            g2.drawString(objs.getType(), (int)orig.x, (int)orig.y + 12);
        }
    }

    public void objInfo(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.BLACK);
        Point2d orig = this.get3DTo2DPoint(new Point3d(0.0, 0.0, 0.0));
        Enumeration<AbstractElement> enuma = this.camera.associatedrender.objects.keys();
        while (enuma.hasMoreElements()) {
            AbstractElement objs = enuma.nextElement();
            Obj3D obj2 = this.camera.associatedrender.objects.get(objs);
            orig = this.get3DTo2DPoint(new Point3d(obj2.pos));
            if (orig.y == 0.0 || orig.x == 0.0) continue;
            Rectangle2D stringBounds = g2.getFontMetrics().getStringBounds(objs.getId(), (Graphics)g2);
            this.window((int)orig.x - 2, (int)orig.y - 12, (int)orig.x + (int)stringBounds.getWidth(), (int)orig.y + 2);
            g2.drawString(objs.getId(), (int)orig.x, (int)orig.y);
        }
    }

    public void gridInfo(int w, int h, J3DGraphics2D g2) {
        double scale = this.camera.associatedrender.gspacing;
        String units = " m";
        if (scale < 1.0) {
            units = "cm";
            scale *= 100.0;
        } else if (scale > 1000.0) {
            units = "Km";
            scale /= 1000.0;
        }
        int scaleint = (int)(scale * 100.0);
        scale = scaleint;
        String text = new String((scale /= 100.0) + units);
        this.window(w - 70, h - 35, w - 9, h - 10);
        g2.drawString(text, w - 60, h - 12);
        g2.drawString("Grid Unit", w - 60, h - 24);
    }

    public void veicleInfo(int w, int h, J3DGraphics2D g2) {
        g2.setStroke((Stroke)new BasicStroke(1.0f, 1, 1));
        g2.setColor(Color.BLACK);
        Point2d orig = this.get3DTo2DPoint(new Point3d(0.0, 0.0, 0.0));
        Enumeration<VehicleType> enuma = this.camera.associatedrender.vehicles.keys();
        while (enuma.hasMoreElements()) {
            VehicleType vt = enuma.nextElement();
            Obj3D obj2 = this.camera.associatedrender.vehicles.get(vt);
            orig = this.get3DTo2DPoint(new Point3d(obj2.pos));
            if (orig.y == 0.0 || orig.x == 0.0) continue;
            Rectangle2D stringBounds = g2.getFontMetrics().getStringBounds(vt.getName(), (Graphics)g2);
            this.window((int)orig.x - 2, (int)orig.y - 12, (int)orig.x + (int)stringBounds.getWidth(), (int)orig.y + 2);
            g2.drawString(vt.getName(), (int)orig.x, (int)orig.y);
        }
    }

    public void vehicleIcons(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.BLACK);
        Point2d orig = this.get3DTo2DPoint(new Point3d(0.0, 0.0, 0.0));
        Enumeration<VehicleType> enuma = this.camera.associatedrender.vehicles.keys();
        while (enuma.hasMoreElements()) {
            VehicleType vt = enuma.nextElement();
            Obj3D obj2 = this.camera.associatedrender.vehicles.get(vt);
            Cam c = new Cam();
            if (this.camera.lockobj == null) {
                c.camdef(20.0, this.camera.psi - obj2.yaw + 1.5707963267948966, this.camera.theta + obj2.pitch, -(this.camera.phi - Math.PI));
            } else {
                c.camdef(20.0, this.camera.psi + this.camera.lockobj.yaw - obj2.yaw + 1.5707963267948966, this.camera.theta + obj2.pitch, -(this.camera.phi - Math.PI));
            }
            Vector3f vec3a = new Vector3f(8.0f, 0.0f, 0.0f);
            Vector3f vec3b = new Vector3f(-1.0f, 0.0f, 0.0f);
            Vector3f vec3c = new Vector3f(-3.0f, 3.5f, 0.0f);
            Vector3f vec3d = new Vector3f(-3.0f, -3.5f, 0.0f);
            Vector2f vec2a = c.to2d(vec3a);
            Vector2f vec2b = c.to2d(vec3b);
            Vector2f vec2c = c.to2d(vec3c);
            Vector2f vec2d = c.to2d(vec3d);
            int x1 = (int)(3.0f * vec2a.x) - 15;
            int y1 = (int)(3.0f * vec2a.y) - 15;
            int x2 = (int)(3.0f * vec2b.x) - 15;
            int y2 = (int)(3.0f * vec2b.y) - 15;
            int x3 = (int)(3.0f * vec2c.x) - 15;
            int y3 = (int)(3.0f * vec2c.y) - 15;
            int x4 = (int)(3.0f * vec2d.x) - 15;
            int y4 = (int)(3.0f * vec2d.y) - 15;
            orig = this.get3DTo2DPoint(new Point3d(obj2.pos), 4.0);
            x1 = (int)((double)x1 + orig.x);
            y1 = (int)((double)y1 + orig.y);
            x2 = (int)((double)x2 + orig.x);
            y2 = (int)((double)y2 + orig.y);
            x3 = (int)((double)x3 + orig.x);
            y3 = (int)((double)y3 + orig.y);
            x4 = (int)((double)x4 + orig.x);
            y4 = (int)((double)y4 + orig.y);
            int[] px = new int[]{x1, x3, x2, x4};
            int[] py = new int[]{y1, y3, y2, y4};
            if (orig.y == 0.0 || orig.x == 0.0) continue;
            g2.setColor(vt.getIconColor());
            g2.fillPolygon(px, py, 4);
            g2.setColor(Color.BLACK);
        }
    }

    public void drawSky(int w, int h, J3DGraphics2D g2) {
        double vertang;
        double horang;
        if (this.camera.lockobj == null) {
            horang = this.camera.psi;
            vertang = this.camera.theta;
        } else {
            horang = this.camera.psi + this.camera.lockobj.yaw;
            vertang = this.camera.theta;
        }
        Vector2d camdir = new Vector2d();
        camdir.y = Math.cos(horang);
        camdir.x = -Math.sin(horang);
        if (Math.sin(vertang) < 0.0) {
            camdir.y = -camdir.y;
            camdir.x = -camdir.x;
        }
        Rectangle2D.Float e = new Rectangle2D.Float(0.0f, 0.0f, w, h);
        Point2d light = this.get3DTo2DPoint(new Point3d(camdir.x * 100000.0, camdir.y * 100000.0, 0.0), -20.0);
        Point2d dark = this.get3DTo2DPoint(new Point3d(camdir.x * 100000.0, camdir.y * 100000.0, 10.0), 0.0);
        Point2d horline = this.get3DTo2DPoint(new Point3d(camdir.x * 100000.0, camdir.y * 100000.0, 0.0), 0.0);
        Vector2d v = new Vector2d();
        v.x = light.x - dark.x;
        v.y = light.y - dark.y;
        v.normalize();
        Point2d up = new Point2d();
        up.x = v.x * 10.0;
        up.y = v.y * 10.0;
        GradientPaint gp = new GradientPaint((float)horline.x, (float)horline.y, new Color(0.007843138f, 0.44313726f, 0.67058825f), (float)(horline.x + up.x * 10.0), (float)(horline.y + up.y * 10.0), new Color(0.043137256f, 0.54313725f, 0.87058824f), false);
        g2.setPaint((Paint)gp);
        g2.fill((Shape)e);
    }

    public void objsIcons(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.BLACK);
        Stroke strokebase = g2.getStroke();
        Point2d orig = this.get3DTo2DPoint(new Point3d(0.0, 0.0, 0.0));
        Enumeration<AbstractElement> enuma = this.camera.associatedrender.objects.keys();
        while (enuma.hasMoreElements()) {
            AbstractElement objs = enuma.nextElement();
            Obj3D obj2 = this.camera.associatedrender.objects.get(objs);
            orig = this.get3DTo2DPoint(new Point3d(obj2.pos), 3.0);
            if (orig.y == 0.0 || orig.x == 0.0) continue;
            if (objs instanceof TransponderElement) {
                g2.drawImage(this.trans, (int)orig.x - this.trans.getWidth(null) / 2, (int)orig.y - this.trans.getWidth(null) / 2, null);
            }
            if (objs instanceof MarkElement) {
                g2.drawImage(this.mark, (int)orig.x - this.mark.getWidth(null) / 2, (int)orig.y - this.mark.getWidth(null) / 2, null);
            }
            if (!(objs instanceof HomeReferenceElement)) continue;
            g2.drawImage(this.home, (int)orig.x - this.home.getWidth(null) / 2, (int)orig.y - this.home.getWidth(null) / 2, null);
        }
        g2.setStroke(strokebase);
    }

    public void reguaInfo(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.BLACK);
        g2.drawLine((int)this.p1.x, (int)this.p1.y, (int)this.p2.x, (int)this.p2.y);
        Point3d point3d1 = new Point3d();
        Point3d point3d2 = new Point3d();
        this.camera.canvas.getPixelLocationInImagePlate(this.p1, point3d1);
        Transform3D temp = new Transform3D();
        this.camera.canvas.getImagePlateToVworld(temp);
        temp.transform(point3d1);
        this.camera.canvas.getPixelLocationInImagePlate(this.p2, point3d2);
        temp.transform(point3d2);
        double scale = point3d2.distance(point3d1);
        String units = " m";
        if (scale < 1.0) {
            units = "cm";
            scale *= 100.0;
        } else if (scale > 1000.0) {
            units = "Km";
            scale /= 1000.0;
        }
        int scaleint = (int)(scale * 100.0);
        scale = scaleint;
        String text = new String((scale /= 100.0) + units);
        double angle = AngleCalc.calcAngle(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
        for (angle = Math.toDegrees(-angle + Math.PI); angle < 0.0; angle += 360.0) {
        }
        while (angle > 360.0) {
            angle -= 360.0;
        }
        int angleint = (int)(angle * 100.0);
        angle = angleint;
        text = text + " " + (angle /= 100.0) + "\u00b0";
        if (this.camera.projection == 1) {
            text = "(Prespective view)";
        }
        Rectangle2D stringBounds = g2.getFontMetrics().getStringBounds(text, (Graphics)g2);
        this.window((int)this.p2.x - 2 + 2, (int)this.p2.y - 14, (int)this.p2.x + (int)stringBounds.getWidth(), (int)this.p2.y);
        g2.drawString(text, (int)this.p2.x + 2, (int)this.p2.y - 2);
    }

    public void axisInfo(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.BLACK);
        Cam c = new Cam();
        if (this.camera.lockobj == null) {
            c.camdef(20.0, this.camera.psi + 1.5707963267948966, this.camera.theta, -(this.camera.phi - Math.PI));
        } else {
            c.camdef(20.0, this.camera.psi + this.camera.lockobj.yaw + 1.5707963267948966, this.camera.theta, -(this.camera.phi - Math.PI));
        }
        int xr1 = w - 78;
        int yr1 = 8;
        int xr2 = w - 8;
        int yr2 = 89;
        this.window(xr1, yr1, xr2, yr2);
        int xc = w - 58;
        int yc = 51;
        g2.drawLine(xr1 + 10, yr1 + 10, xr2 - 10, yr1 + 10);
        g2.drawLine(xr1 + 10, yr1 + 5, xr1 + 10, yr1 + 15);
        g2.drawLine(xr2 - 10, yr1 + 5, xr2 - 10, yr1 + 15);
        if (this.camera.projection == 1) {
            g2.drawLine(xr1 + 22, yr1 + 7, xr1 + 22, yr1 + 13);
            g2.drawLine(xr2 - 22, yr1 + 7, xr2 - 22, yr1 + 13);
            g2.drawLine(xr1 + 31, yr1 + 9, xr1 + 31, yr1 + 11);
            g2.drawLine(xr2 - 31, yr1 + 9, xr2 - 31, yr1 + 11);
        } else {
            int x1 = xr1 + 10;
            int y1 = yr1 + 10;
            int x2 = xr2 - 10;
            int y2 = yr1 + 10;
            Point3d point3d1 = new Point3d();
            this.camera.canvas.getPixelLocationInImagePlate(x1, y1, point3d1);
            Transform3D temp = new Transform3D();
            this.camera.canvas.getImagePlateToVworld(temp);
            temp.transform(point3d1);
            Point3d point3d2 = new Point3d();
            this.camera.canvas.getPixelLocationInImagePlate(x2, y2, point3d2);
            temp.transform(point3d2);
            double scale = point3d2.distance(point3d1);
            String units = " m";
            if (scale < 1.0) {
                units = "cm";
                scale *= 100.0;
            } else if (scale > 1000.0) {
                units = "Km";
                scale /= 1000.0;
            }
            int scaleint = (int)(scale * 100.0);
            scale = scaleint;
            g2.drawString((scale /= 100.0) + "", xr1 + 15, yr1 + 25);
            g2.drawString(units, xr1 + 45, yr1 + 25);
        }
        Vector2f vec2a = null;
        Vector2f vec2b = null;
        Vector3f vec3a = new Vector3f(0.0f, 0.0f, -8.0f);
        Vector3f vec3b = new Vector3f(0.0f, 0.0f, 0.0f);
        vec2a = c.to2d(vec3a);
        vec2b = c.to2d(vec3b);
        int x1 = (int)(3.0f * vec2a.x);
        int y1 = (int)(3.0f * vec2a.y);
        int x2 = (int)(3.0f * vec2b.x);
        int y2 = (int)(3.0f * vec2b.y);
        g2.drawLine(x1 += xc, y1 += yc, x2 += xc, y2 += yc);
        g2.drawString("D", x1 - 5, y1);
        vec3a = new Vector3f(0.0f, 8.0f, 0.0f);
        vec3b = new Vector3f(0.0f, 0.0f, 0.0f);
        vec2a = c.to2d(vec3a);
        vec2b = c.to2d(vec3b);
        x1 = (int)(3.0f * vec2a.x);
        y1 = (int)(3.0f * vec2a.y);
        x2 = (int)(3.0f * vec2b.x);
        y2 = (int)(3.0f * vec2b.y);
        g2.drawLine(x1 += xc, y1 += yc, x2 += xc, y2 += yc);
        g2.drawString("E", x1 - 5, y1);
        vec3a = new Vector3f(8.0f, 0.0f, 0.0f);
        vec3b = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vec3c = new Vector3f(-3.0f, 3.5f, 0.0f);
        Vector3f vec3d = new Vector3f(-3.0f, -3.5f, 0.0f);
        vec2a = c.to2d(vec3a);
        vec2b = c.to2d(vec3b);
        Vector2f vec2c = c.to2d(vec3c);
        Vector2f vec2d = c.to2d(vec3d);
        x1 = (int)(3.0f * vec2a.x);
        y1 = (int)(3.0f * vec2a.y);
        x2 = (int)(3.0f * vec2b.x);
        y2 = (int)(3.0f * vec2b.y);
        int x3 = (int)(3.0f * vec2c.x);
        int y3 = (int)(3.0f * vec2c.y);
        int x4 = (int)(3.0f * vec2d.x);
        int y4 = (int)(3.0f * vec2d.y);
        int[] px = new int[]{x1 += xc, x3 += xc, x2 += xc, x4 += xc};
        int[] py = new int[]{y1 += yc, y3 += yc, y2 += yc, y4 += yc};
        g2.fillPolygon(px, py, 4);
        g2.drawLine(x1, y1, x2, y2);
        g2.drawString("N", x1 - 5, y1);
    }

    public void camInfo(int w, int h, J3DGraphics2D g2) {
        Rectangle2D stringBounds;
        Point3d vec2;
        double[] location;
        String text = "";
        LocationType curLocation = null;
        if (this.camera.lockobj == null) {
            location = new double[]{0.0, 0.0, 0.0};
            Point3d vec = new Point3d(location[0], location[1], location[2]);
            vec.x += this.camera.pivot.x;
            vec.y += this.camera.pivot.y;
            vec.z += this.camera.pivot.z;
            text = "Target:(" + (double)((int)(vec.x * 100.0)) / 100.0 + "," + (double)((int)(vec.y * 100.0)) / 100.0 + "," + (double)((int)(vec.z * 100.0)) / 100.0 + ")";
            curLocation = new LocationType(this.camera.associatedrender.location);
            curLocation.translatePosition(vec.x, vec.y, vec.z);
        } else if (this.camera.lock != null) {
            location = new double[]{0.0, 0.0, 0.0};
            vec2 = new Point3d(location[0], location[1], location[2]);
            Vector3d vec = new Vector3d(this.camera.lockobj.pos[0], this.camera.lockobj.pos[1], this.camera.lockobj.pos[2]);
            vec.x += this.camera.pivot.x;
            vec.y += this.camera.pivot.y;
            vec.z += this.camera.pivot.z;
            vec.x += vec2.x;
            vec.y += vec2.y;
            vec.z += vec2.z;
            text = "Target:(" + (double)((int)(vec.x * 100.0)) / 100.0 + "," + (double)((int)(vec.y * 100.0)) / 100.0 + "," + (double)((int)(vec.z * 100.0)) / 100.0 + ")";
            curLocation = new LocationType(this.camera.associatedrender.location);
            curLocation.translatePosition(vec.x, vec.y, vec.z);
        } else if (this.camera.lockmapobj != null) {
            location = new double[]{0.0, 0.0, 0.0};
            vec2 = new Point3d(location[0], location[1], location[2]);
            Vector3d vec = new Vector3d(this.camera.lockobj.pos[0], this.camera.lockobj.pos[1], this.camera.lockobj.pos[2]);
            vec.x += this.camera.pivot.x;
            vec.y += this.camera.pivot.y;
            vec.z += this.camera.pivot.z;
            vec.x += vec2.x;
            vec.y += vec2.y;
            vec.z += vec2.z;
            text = "Target:(" + (double)((int)(vec.x * 100.0)) / 100.0 + "," + (double)((int)(vec.y * 100.0)) / 100.0 + "," + (double)((int)(vec.z * 100.0)) / 100.0 + ")";
            curLocation = new LocationType(this.camera.associatedrender.location);
            curLocation.translatePosition(vec.x, vec.y, vec.z);
        }
        if (curLocation.getLatitudeDegs() != 0.0 || curLocation.getLongitudeDegs() != 0.0) {
            double[] latLonDepth = curLocation.getAbsoluteLatLonDepth();
            StringBuilder loc = new StringBuilder();
            loc.append("Target:(");
            loc.append(CoordinateUtil.latitudeAsString(latLonDepth[0], true));
            loc.append(" / " + CoordinateUtil.longitudeAsString(latLonDepth[1], true));
            loc.append(" / " + MathMiscUtils.round(latLonDepth[2], 1) + "m)");
            text = loc.toString();
        }
        if ((stringBounds = g2.getFontMetrics().getStringBounds(text, (Graphics)g2)).getWidth() > 210.0) {
            this.window(8, 8, (int)stringBounds.getWidth() + 15, 37);
        } else {
            this.window(8, 8, 225, 37);
        }
        g2.drawString(text, 15, 20);
        if (this.camera.lockobj == null) {
            text = "Locked: off";
        } else if (this.camera.lock != null) {
            text = "Locked: " + this.camera.lock.getName();
        } else if (this.camera.lockmapobj != null) {
            text = "Locked: " + this.camera.lockmapobj.getId();
        }
        g2.drawString(text, 15, 33);
        text = "View type: " + this.camera.getStrType();
        g2.drawString(text, 118, 33);
    }

    public void selected(int w, int h, J3DGraphics2D g2) {
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawLine(2, 2, w - 3, 2);
        g2.drawLine(2, h - 3, w - 3, h - 3);
        g2.drawLine(2, 2, 2, h - 3);
        g2.drawLine(w - 3, 2, w - 3, h - 3);
    }

    public void truePostRender() {
        super.postRender();
    }

    private void window(int xr1, int yr1, int xr2, int yr2) {
        float alpha = 0.5f;
        this.g2.setStroke((Stroke)new BasicStroke(1.0f, 1, 1));
        this.g2.setComposite((Composite)AlphaComposite.getInstance(3, alpha));
        this.g2.setPaint((Paint)new Color(225, 225, 220));
        this.g2.fillRect(xr1, yr1, xr2 - xr1, yr2 - yr1);
        alpha = 1.0f;
        this.g2.setComposite((Composite)AlphaComposite.getInstance(3, alpha));
        this.g2.setColor(Color.BLACK);
        this.g2.drawLine(xr1, yr1, xr2, yr1);
        this.g2.drawLine(xr1, yr1, xr1, yr2);
        this.g2.drawLine(xr1, yr2, xr2, yr2);
        this.g2.drawLine(xr2, yr1, xr2, yr2);
    }

    public Camera3D getCamera() {
        return this.camera;
    }

    public void setCamera(Camera3D camera) {
        this.camera = camera;
    }

    private class Cam {
        private double v11;
        private double v12;
        private double v13;
        private double v21;
        private double v22;
        private double v23;
        private double v32;
        private double v33;
        private double v43;
        protected double rho = 40.0;
        protected double theta = 0.7853981633974483;
        protected double phi = 0.7853981633974483;
        protected double psi;
        public float dist;

        public Cam() {
            this.coeff();
            this.dist = 1.0f;
        }

        public void camdef(double rhod, double thetad, double phid, double psid) {
            this.rho = rhod;
            this.theta = thetad;
            this.phi = phid;
            this.psi = psid;
            this.coeff();
        }

        private void coeff() {
            double costh = Math.cos(this.theta);
            double sinth = Math.sin(this.theta);
            double cosph = Math.cos(this.phi);
            double sinph = Math.sin(this.phi);
            this.v11 = -sinth;
            this.v12 = -cosph * costh;
            this.v13 = -sinph * costh;
            this.v21 = costh;
            this.v22 = -cosph * sinth;
            this.v23 = -sinph * sinth;
            this.v32 = sinph;
            this.v33 = -cosph;
            this.v43 = this.rho;
        }

        private Vector3f eyecoord(Vector3f pw) {
            Vector3f pe = new Vector3f();
            pe.x = (float)(this.v11 * (double)pw.x + this.v21 * (double)pw.y);
            pe.y = (float)(this.v12 * (double)pw.x + this.v22 * (double)pw.y + this.v32 * (double)pw.z);
            pe.z = (float)(this.v13 * (double)pw.x + this.v23 * (double)pw.y + this.v33 * (double)pw.z + this.v43);
            return pe;
        }

        private Vector2f perspective(Vector3f p) {
            Vector3f pe = null;
            pe = this.eyecoord(p);
            Vector2f pxy = new Vector2f();
            Vector3f prot = new Vector3f();
            prot.x = (float)((double)pe.x * Math.cos(this.psi) - (double)pe.y * Math.sin(this.psi));
            prot.y = (float)((double)pe.x * Math.sin(this.psi) + (double)pe.y * Math.cos(this.psi));
            prot.z = pe.z;
            pxy.x = prot.x;
            pxy.y = prot.y;
            return pxy;
        }

        public Vector2f to2d(Vector3f p) {
            Vector2f aux = null;
            aux = this.perspective(p);
            Vector2f rt = new Vector2f();
            rt.x = (float)((double)(this.dist * aux.x) + 5.0);
            rt.y = (float)((double)(-this.dist * aux.y) + 5.0);
            return rt;
        }
    }
}

