/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.mnstarfire.loaders3d.Inspector3DS;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.scenegraph.io.SceneGraphFileReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.web3d.j3d.loaders.VRML97Loader;
import org.web3d.j3d.loaders.X3DLoader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.renderer3d.Maneuver3DCreationHelper;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Texture3D;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.CylinderElement;
import pt.lsts.neptus.types.map.DynamicElement;
import pt.lsts.neptus.types.map.EllipsoidElement;
import pt.lsts.neptus.types.map.HomeReferenceElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.Model3DElement;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.map.ScatterPointsElement;
import pt.lsts.neptus.types.map.SimpleMapElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.GraphType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.X3dParse;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.viewer3d.Viewer3D;

public class Object3DCreationHelper {
    public static TransformGroup getModel3DForRender(AbstractElement elem) {
        if (elem instanceof HomeReferenceElement) {
            return Object3DCreationHelper.getHomeReferenceModel3D();
        }
        if (elem instanceof MarkElement) {
            return Object3DCreationHelper.getMarkModel3D();
        }
        if (elem instanceof CylinderElement) {
            return Object3DCreationHelper.getCylinderModel3D((CylinderElement)elem);
        }
        if (elem instanceof EllipsoidElement) {
            return Object3DCreationHelper.getElipsoidModel3D((EllipsoidElement)elem);
        }
        if (elem instanceof ImageElement) {
            return Object3DCreationHelper.getImageModel3D((ImageElement)elem);
        }
        if (elem instanceof Model3DElement) {
            return Object3DCreationHelper.getModel3DModel3D((Model3DElement)elem);
        }
        if (elem instanceof ParallelepipedElement) {
            return Object3DCreationHelper.getParallelepipedModel3D((ParallelepipedElement)elem);
        }
        if (elem instanceof PathElement) {
            return Object3DCreationHelper.getPathModel3D((PathElement)elem);
        }
        if (elem instanceof TransponderElement) {
            return Object3DCreationHelper.getTransponderModel3D((TransponderElement)elem);
        }
        if (elem instanceof ScatterPointsElement) {
            return ((ScatterPointsElement)elem).getModel3D();
        }
        if (elem instanceof PlanElement) {
            return null;
        }
        if (elem instanceof SimpleMapElement) {
            return Object3DCreationHelper.getMarkModel3D();
        }
        return null;
    }

    public static Obj3D getPlanModel3D(PlanType plan) {
        MissionType mission = plan.getMissionType();
        GraphType graph = plan.getGraph();
        Maneuver[] mans = graph.getManeuversSequence();
        Obj3D o3d = new Obj3D();
        double[] lastpoint = null;
        if (mans != null && mans.length > 0) {
            for (int i = 0; i < mans.length; ++i) {
                if (mans[i] instanceof LocatedManeuver) {
                    LocatedManeuver man = (LocatedManeuver)((Object)mans[i]);
                    Obj3D subObj3d = new Obj3D();
                    subObj3d.setModel3D(Object3DCreationHelper.getSphere());
                    double[] auxPos = new double[3];
                    auxPos = man.getManeuverLocation().getOffsetFrom(mission.getHomeRef());
                    auxPos[2] = -auxPos[2];
                    subObj3d.setPos(auxPos);
                    o3d.addObj3D(subObj3d);
                    double[] fp = man.getStartLocation().getOffsetFrom(mission.getHomeRef());
                    fp[2] = -fp[2];
                    double[] lp = man.getEndLocation().getOffsetFrom(mission.getHomeRef());
                    lp[2] = -lp[2];
                    if (lastpoint != null) {
                        Obj3D segmentObj3d = new Obj3D();
                        segmentObj3d.setModel3D(Object3DCreationHelper.getsegment3D(new Point3d(lastpoint), new Point3d(fp)));
                        o3d.addObj3D(segmentObj3d);
                    }
                    lastpoint = lp;
                    Obj3D manObj3d = Maneuver3DCreationHelper.getModel3DManeuverForRender(mans[i]);
                    if (manObj3d == null) continue;
                    manObj3d.setPos(auxPos);
                    o3d.addObj3D(manObj3d);
                    continue;
                }
                lastpoint = null;
            }
        }
        return o3d;
    }

    public static TransformGroup getSphere() {
        Sphere sphere = new Sphere(1.0f, 3, null);
        sphere.getChild(0).setCapability(14);
        sphere.getChild(0).setCapability(15);
        Transform3D t = new Transform3D();
        Transform3D t2 = new Transform3D();
        t.setScale(new Vector3d(1.0, 1.0, 1.0));
        t2.setScale(1.0);
        t.mul(t2);
        TransformGroup model = new TransformGroup();
        model.setCapability(12);
        Appearance appearance3 = new Appearance();
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setCapability(0);
        trans.setCapability(1);
        trans.setTransparency(0.5f);
        trans.setTransparencyMode(1);
        appearance3.setTransparencyAttributes(trans);
        Material mat = new Material();
        mat.setCapability(1);
        mat.setCapability(0);
        Color3f c = new Color3f();
        c.set(Color.BLUE);
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        appearance3.setMaterial(mat);
        sphere.setAppearance(appearance3);
        model.addChild((Node)sphere);
        model.setTransform(t);
        sphere.getAppearance();
        return model;
    }

    public static Point3d[] getPath(Vector<Point3d> offsets3D) {
        Vector<Point3d> points = offsets3D;
        if (points == null || points.size() <= 1) {
            return new Point3d[0];
        }
        Point3d[] pts = new Point3d[points.size() * 2 - 2];
        int i = 1;
        int x = 1;
        pts[0] = points.firstElement();
        while (i < points.size() - 1) {
            pts[x] = points.get(i);
            pts[++x] = points.get(i);
            ++i;
            ++x;
        }
        pts[pts.length - 1] = points.get(points.size() - 1);
        return pts;
    }

    public static TransformGroup getPath3D(Vector<Point3d> points) {
        TransformGroup model = new TransformGroup();
        Appearance appearance = new Appearance();
        Material mat = new Material();
        Color3f c = new Color3f(1.0f, 0.0f, 0.0f);
        c.set(Color.WHITE);
        mat.setEmissiveColor(c);
        mat.setAmbientColor(c);
        mat.setDiffuseColor(c);
        appearance.setMaterial(mat);
        Point3d[] myCoords = Object3DCreationHelper.getPath(points);
        if (myCoords.length == 0) {
            return null;
        }
        LineArray myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        model.addChild((Node)shape3D);
        return model;
    }

    public static TransformGroup getsegment3D(Point3d p1, Point3d p2) {
        Vector<Point3d> v = new Vector<Point3d>();
        v.add(p1);
        v.add(p2);
        return Object3DCreationHelper.getPath3D(v);
    }

    public static TransformGroup getVehicleModel3D(String pathTo3DModel) {
        File file = new File(ConfigFetch.resolvePath(pathTo3DModel));
        if (file != null) {
            if ("3ds".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                try {
                    Inspector3DS loader = new Inspector3DS(file.getAbsolutePath());
                    loader.parseIt();
                    TransformGroup theModel1 = loader.getModel();
                    NeptusLog.waste().info((Object)("Point to view window " + Util3D.getModelDim(theModel1)));
                    return theModel1;
                }
                catch (RuntimeException e) {
                    NeptusLog.pub().error((Object)("Error loading vehicle model (3DS)\n" + e));
                }
            } else if ("wrl".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                try {
                    VRML97Loader myFileLoader = null;
                    Scene myVRMLScene = null;
                    BranchGroup myVRMLModel = null;
                    myFileLoader = new VRML97Loader();
                    myFileLoader.setBasePath(file.getParent());
                    myVRMLScene = myFileLoader.load(file.getAbsolutePath());
                    myVRMLModel = myVRMLScene.getSceneGroup();
                    TransformGroup scene = new TransformGroup();
                    Enumeration enume = myVRMLModel.getAllChildren();
                    while (enume.hasMoreElements()) {
                        Group next = (Group)enume.nextElement();
                        myVRMLModel.removeChild((Node)next);
                        scene.addChild((Node)next);
                    }
                    return scene;
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("Error loading vehicle model (WRL)\n" + e));
                }
            } else if ("x3d".equalsIgnoreCase(FileUtil.getFileExtension(file)) || "x3dv".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                try {
                    X3DLoader myFileLoader = null;
                    Scene myVRMLScene = null;
                    BranchGroup myVRMLModel = null;
                    myFileLoader = new X3DLoader();
                    myFileLoader.setBasePath(file.getParent());
                    myVRMLScene = myFileLoader.load(file.getAbsolutePath());
                    myVRMLModel = myVRMLScene.getSceneGroup();
                    TransformGroup scene = new TransformGroup();
                    Enumeration enume = myVRMLModel.getAllChildren();
                    while (enume.hasMoreElements()) {
                        Group next = (Group)enume.nextElement();
                        myVRMLModel.removeChild((Node)next);
                        scene.addChild((Node)next);
                    }
                    return scene;
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)"Error loading vehicle model (X3D)\n");
                }
            } else {
                if ("j3d".equalsIgnoreCase(FileUtil.getFileExtension(file))) {
                    BranchGroup bg = null;
                    try {
                        SceneGraphFileReader filer = new SceneGraphFileReader(file);
                        bg = filer.readAllBranchGraphs()[0];
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (bg == null) {
                        NeptusLog.pub().error((Object)"Error loading vehicle model\n");
                    }
                    TransformGroup scene = new TransformGroup();
                    Enumeration enume = bg.getAllChildren();
                    while (enume.hasMoreElements()) {
                        Group next = (Group)enume.nextElement();
                        bg.removeChild((Node)next);
                        scene.addChild((Node)next);
                    }
                    return scene;
                }
                NeptusLog.pub().error((Object)"Error loading vehicle model - Invalid file type.\n");
            }
        }
        return new TransformGroup();
    }

    public static JDialog open3DViewerDialogForModelPath(Component parentComponent, String title, String model3dPath) {
        Window parent = SwingUtilities.windowForComponent(parentComponent);
        JDialog dialog = parent == null ? new JDialog((Frame)ConfigFetch.getSuperParentFrame(), title) : new JDialog(parent, title);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setSize(500, 500);
        try {
            TransformGroup trans = Object3DCreationHelper.getVehicleModel3D(model3dPath);
            Viewer3D v3d = new Viewer3D(trans);
            v3d.disableMenuBar();
            dialog.add(v3d);
            GuiUtils.centerOnScreen(dialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            dialog.add(new JLabel(I18n.textf("Error loading 3D model %modelPath", model3dPath)));
        }
        dialog.setVisible(true);
        return dialog;
    }

    public static TransformGroup getHomeReferenceModel3D() {
        TransformGroup model = new TransformGroup();
        Sphere sphere = new Sphere(1.0f);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 1.0f, 0, true, true, false, 3);
        Color3f c = new Color3f(1.0f, 1.0f, 1.0f);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        coloringAttributes = new ColoringAttributes(c, 3);
        Appearance appearance4 = new Appearance();
        appearance4.setRenderingAttributes(renderingAttributes);
        appearance4.setColoringAttributes(coloringAttributes);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(0.3f);
        trans.setTransparencyMode(1);
        appearance4.setTransparencyAttributes(trans);
        sphere.setAppearance(appearance4);
        Transform3D t = new Transform3D();
        t.setScale(0.1);
        model.setTransform(t);
        model.addChild((Node)sphere);
        model.addChild((Node)Util3D.makeAxis(false, 100.0));
        return model;
    }

    public static TransformGroup getMarkModel3D() {
        TransformGroup model = new TransformGroup();
        Sphere sphere = new Sphere();
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 1.0f, 0, true, true, false, 3);
        Color3f c = new Color3f(1.0f, 0.0f, 0.0f);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        Appearance appearance = new Appearance();
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Point3d[] listp = new Point3d[]{new Point3d(4.0, 0.0, 0.0), new Point3d(-4.0, 0.0, 0.0), new Point3d(0.0, 4.0, 0.0), new Point3d(0.0, -4.0, 0.0), new Point3d(0.0, 0.0, 4.0), new Point3d(0.0, 0.0, -4.0)};
        LineArray myLines = new LineArray(listp.length, 1);
        myLines.setCoordinates(0, listp);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        c = new Color3f(1.0f, 1.0f, 0.0f);
        coloringAttributes = new ColoringAttributes(c, 3);
        Appearance appearance2 = new Appearance();
        appearance2.setRenderingAttributes(renderingAttributes);
        appearance2.setColoringAttributes(coloringAttributes);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(0.3f);
        trans.setTransparencyMode(1);
        appearance2.setTransparencyAttributes(trans);
        sphere.setAppearance(appearance2);
        Transform3D t = new Transform3D();
        t.setScale(0.1);
        model.setTransform(t);
        model.addChild((Node)shape3D);
        model.addChild((Node)sphere);
        return model;
    }

    public static TransformGroup getCylinderModel3D(CylinderElement cylinder) {
        Cylinder sphere = new Cylinder(1.0f, 2.0f, 3, null);
        sphere.getChild(0).setCapability(14);
        sphere.getChild(0).setCapability(15);
        Enumeration childs = sphere.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (!(child instanceof Shape3D)) continue;
            Shape3D aux = (Shape3D)child;
            aux.setCapability(14);
            aux.setCapability(15);
        }
        Transform3D t = new Transform3D();
        Transform3D t2 = new Transform3D();
        t2.setIdentity();
        t.setScale(new Vector3d(cylinder.getLength(), cylinder.getWidth(), cylinder.getHeight()));
        t2.setScale(0.5);
        t.mul(t2);
        t2.setIdentity();
        t2.rotX(1.5707963267948966);
        t.mul(t2);
        TransformGroup model = new TransformGroup();
        model.setCapability(12);
        Appearance appearance3 = new Appearance();
        if (cylinder.texture != null) {
            Texture GogglesOn = new TextureLoader(cylinder.texture, null).getTexture();
            TextureAttributes myta = new TextureAttributes();
            Transform3D texturetrans = new Transform3D();
            texturetrans.setScale(new Vector3d(cylinder.getLength(), cylinder.getWidth(), cylinder.getHeight()));
            myta.setTextureTransform(texturetrans);
            myta.setTextureMode(2);
            appearance3.setTextureAttributes(myta);
            appearance3.setTexture(GogglesOn);
        }
        Material mat = new Material();
        mat.setCapability(1);
        mat.setCapability(0);
        Color3f c = new Color3f();
        c.set(cylinder.getColor());
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        mat.setShininess(cylinder.shininess);
        appearance3.setMaterial(mat);
        appearance3.setCapability(10);
        appearance3.setCapability(11);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setTransparency((float)cylinder.getTransparency() / 100.0f);
        trans.setTransparencyMode(1);
        appearance3.setTransparencyAttributes(trans);
        sphere.setAppearance(appearance3);
        model.addChild((Node)sphere);
        model.setTransform(t);
        return model;
    }

    public static TransformGroup getElipsoidModel3D(EllipsoidElement ellipsoid) {
        Sphere sphere = new Sphere(1.0f, 3, null);
        sphere.getChild(0).setCapability(14);
        sphere.getChild(0).setCapability(15);
        Transform3D t = new Transform3D();
        Transform3D t2 = new Transform3D();
        t.setScale(new Vector3d(ellipsoid.getLength(), ellipsoid.getWidth(), ellipsoid.getHeight()));
        t2.setScale(0.5);
        t.mul(t2);
        TransformGroup model = new TransformGroup();
        model.setCapability(12);
        Appearance appearance3 = new Appearance();
        if (ellipsoid.texture != null) {
            Texture GogglesOn = new TextureLoader(ellipsoid.texture, null).getTexture();
            TextureAttributes myta = new TextureAttributes();
            Transform3D texturetrans = new Transform3D();
            texturetrans.setScale(new Vector3d(ellipsoid.getLength(), ellipsoid.getWidth(), ellipsoid.getHeight()));
            myta.setTextureTransform(texturetrans);
            myta.setTextureMode(2);
            appearance3.setTextureAttributes(myta);
            appearance3.setTexture(GogglesOn);
        }
        Material mat = new Material();
        mat.setCapability(1);
        mat.setCapability(0);
        Color3f c = new Color3f();
        c.set(ellipsoid.getColor());
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        mat.setShininess(ellipsoid.shininess);
        appearance3.setMaterial(mat);
        appearance3.setCapability(10);
        appearance3.setCapability(11);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setCapability(0);
        trans.setCapability(1);
        trans.setTransparency((float)ellipsoid.getTransparency() / 100.0f);
        trans.setTransparencyMode(1);
        appearance3.setTransparencyAttributes(trans);
        sphere.setAppearance(appearance3);
        model.addChild((Node)sphere);
        model.setTransform(t);
        sphere.getAppearance();
        return model;
    }

    public static TransformGroup getModel3DModel3D(Model3DElement model) {
        TransformGroup themodel = new TransformGroup();
        if (model.getModel3DFilename() == null) {
            return null;
        }
        File fx = null;
        try {
            fx = new File(ConfigFetch.resolvePath(model.getModel3DFilename()));
        }
        catch (Exception e) {
            return null;
        }
        String extension = FileUtil.getFileExtension(fx);
        if (extension.equalsIgnoreCase("3ds")) {
            Inspector3DS obj3Dloader = new Inspector3DS(ConfigFetch.resolvePath(model.getModel3DFilename()));
            obj3Dloader.parseIt();
            themodel = obj3Dloader.getModel();
        } else {
            if (extension.equalsIgnoreCase("x3d")) {
                X3dParse parse = new X3dParse();
                parse.setFileX3d(fx.getAbsolutePath().toString());
                try {
                    themodel = parse.parse();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)"Model3dElement parse file error", (Throwable)e);
                    GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), e);
                }
                return null;
            }
            if (extension.equalsIgnoreCase("wrl")) {
                VRML97Loader myFileLoader = null;
                Scene myVRMLScene = null;
                BranchGroup myVRMLModel = null;
                try {
                    myFileLoader = new VRML97Loader();
                    myFileLoader.setBasePath(fx.getParent());
                    myFileLoader.setFlags(8);
                    myVRMLScene = myFileLoader.load(fx.getAbsolutePath());
                    myVRMLModel = myVRMLScene.getSceneGroup();
                    Enumeration enume = myVRMLModel.getAllChildren();
                    while (enume.hasMoreElements()) {
                        Node next = (Node)enume.nextElement();
                        myVRMLModel.removeChild(next);
                        themodel.addChild(next);
                    }
                    if (Util3D.removeBackgroud((Group)themodel)) {
                        NeptusLog.pub().info((Object)"<###>tem back");
                    }
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)"Model3dElement parse file error", (Throwable)e);
                    GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), e);
                }
            } else {
                themodel = null;
                NeptusLog.pub().error((Object)("Model3dElement: Invalid 3D file type [" + extension + "]."));
                GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), "Loader Model3dElement", "Invalid 3D file type [" + extension + "].");
            }
        }
        Transform3D t = new Transform3D();
        t.setIdentity();
        t.setScale(model.getModel3DScale());
        themodel.setTransform(t);
        Util3D.enablePicking((Node)themodel);
        return themodel;
    }

    public static TransformGroup getParallelepipedModel3D(ParallelepipedElement pipe) {
        Box cube = new Box(1.0f, 1.0f, 1.0f, 3, null);
        Enumeration childs = cube.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (!(child instanceof Shape3D)) continue;
            Shape3D aux = (Shape3D)child;
            aux.setCapability(14);
            aux.setCapability(15);
        }
        cube.getChild(0).setCapability(14);
        cube.getChild(0).setCapability(15);
        cube.setCapability(64);
        Transform3D t = new Transform3D();
        Transform3D t2 = new Transform3D();
        t.setScale(new Vector3d(pipe.getLength(), pipe.getWidth(), pipe.getHeight()));
        t2.setScale(0.5);
        t.mul(t2);
        TransformGroup model = new TransformGroup();
        model.setCapability(18);
        model.setCapability(17);
        model.setCapability(12);
        model.setCapability(13);
        Appearance appearance3 = new Appearance();
        if (pipe.texture != null) {
            Texture GogglesOn = new TextureLoader(pipe.texture, null).getTexture();
            TextureAttributes myta = new TextureAttributes();
            Transform3D texturetrans = new Transform3D();
            texturetrans.setScale(new Vector3d(pipe.getLength(), pipe.getWidth(), pipe.getHeight()));
            myta.setTextureTransform(texturetrans);
            myta.setTextureMode(2);
            appearance3.setTextureAttributes(myta);
            appearance3.setTexture(GogglesOn);
        }
        appearance3.setCapability(10);
        appearance3.setCapability(11);
        Material mat = new Material();
        mat.setCapability(1);
        mat.setCapability(0);
        Color3f c = new Color3f();
        c.set(pipe.getColor());
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        mat.setShininess(pipe.shininess);
        appearance3.setMaterial(mat);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setTransparency((float)pipe.getTransparency() / 100.0f);
        trans.setTransparencyMode(1);
        trans.setCapability(5);
        trans.setCapability(4);
        appearance3.setTransparencyAttributes(trans);
        cube.setCapability(64);
        cube.setAppearance(appearance3);
        Appearance appearance = new Appearance();
        appearance.setMaterial(mat);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Point3d[] myCoords = new Point3d[]{new Point3d(-1.0, 1.0, 1.0), new Point3d(1.0, 1.0, 1.0), new Point3d(-1.0, -1.0, 1.0), new Point3d(1.0, -1.0, 1.0), new Point3d(-1.0, -1.0, -1.0), new Point3d(1.0, -1.0, -1.0), new Point3d(-1.0, 1.0, -1.0), new Point3d(1.0, 1.0, -1.0), new Point3d(1.0, 1.0, -1.0), new Point3d(1.0, 1.0, 1.0), new Point3d(-1.0, 1.0, -1.0), new Point3d(-1.0, 1.0, 1.0), new Point3d(1.0, -1.0, -1.0), new Point3d(1.0, -1.0, 1.0), new Point3d(-1.0, -1.0, -1.0), new Point3d(-1.0, -1.0, 1.0), new Point3d(1.0, -1.0, 1.0), new Point3d(1.0, 1.0, 1.0), new Point3d(1.0, -1.0, -1.0), new Point3d(1.0, 1.0, -1.0), new Point3d(-1.0, -1.0, 1.0), new Point3d(-1.0, 1.0, 1.0), new Point3d(-1.0, -1.0, -1.0), new Point3d(-1.0, 1.0, -1.0)};
        LineArray myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        shape3D.getAppearance();
        shape3D.setAppearance(appearance);
        model.addChild((Node)shape3D);
        model.addChild((Node)cube);
        model.setTransform(t);
        return model;
    }

    public static TransformGroup getPathModel3D(PathElement path) {
        TransformGroup model = new TransformGroup();
        Appearance appearance = new Appearance();
        Material mat = new Material();
        Color3f c = new Color3f(1.0f, 0.0f, 0.0f);
        c.set(path.getMyColor());
        mat.setEmissiveColor(c);
        mat.setAmbientColor(c);
        mat.setDiffuseColor(c);
        appearance.setMaterial(mat);
        Point3d[] myCoords = path.getPath();
        if (path.getPath().length == 0) {
            return null;
        }
        LineArray myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        model.addChild((Node)shape3D);
        return model;
    }

    public static TransformGroup getImageModel3D(ImageElement img) {
        Texture3D image3D;
        try {
            image3D = new Texture3D(img.getImage(), (double)img.getImage().getHeight(null) * img.getImageScale(), (double)img.getImage().getWidth(null) * img.getImageScale());
        }
        catch (Exception e) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), "Error loading image", "Image '" + img.getId() + "' was not able to be loaded!\nCheck the path please:\n'" + img.getImageFileName().replace(ConfigFetch.getNeptusTmpDir(), "") + "'");
            return null;
        }
        Image heightImage = img.getImage();
        image3D.setTwoSided(true);
        image3D.setTransparency((float)img.getTransparency() / 100.0f);
        image3D.setShade(false);
        image3D.texturescale = 1.0;
        if (img.isBathymetric()) {
            if (img.getBathymetricImageFileName() != null) {
                heightImage = ImageUtils.getImage(img.getBathymetricImageFileName());
            }
            image3D.setBitmap(heightImage);
            image3D.maxvalue = img.getMaxHeight();
            image3D.minvalue = img.getMaxDepth();
            image3D.setResolution(img.getResolution());
        }
        TransformGroup model = image3D.getModel3D();
        return model;
    }

    public static TransformGroup getTransponderModel3D(TransponderElement transp) {
        InputStream istt = Object3DCreationHelper.class.getResourceAsStream("/models/trans1.3ds");
        String inFileNamet = StreamUtil.copyStreamToTempFile(istt).getAbsolutePath();
        InputStream istb = Object3DCreationHelper.class.getResourceAsStream("/models/boia1.3ds");
        String inFileNameb = StreamUtil.copyStreamToTempFile(istb).getAbsolutePath();
        Inspector3DS loader = new Inspector3DS(inFileNamet);
        loader.parseIt();
        TransformGroup theModel1 = loader.getModel();
        loader = new Inspector3DS(inFileNameb);
        loader.parseIt();
        TransformGroup theModel2 = loader.getModel();
        Transform3D t1 = new Transform3D();
        t1.setTranslation(new Vector3f(0.0f, 0.0f, -((float)transp.getNEDPosition()[2])));
        theModel2.setTransform(t1);
        TransformGroup theModel = new TransformGroup();
        theModel.addChild((Node)theModel1);
        theModel.addChild((Node)theModel2);
        return theModel;
    }

    public static TransformGroup getDynamicElementModel3D(DynamicElement elem) {
        TransformGroup model = new TransformGroup();
        Sphere sphere = new Sphere();
        Color3f c = new Color3f(elem.getInnerColor());
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        coloringAttributes.setCapability(1);
        Appearance appearance2 = new Appearance();
        appearance2.setColoringAttributes(coloringAttributes);
        sphere.setAppearance(appearance2);
        Transform3D t = new Transform3D();
        t.setScale(0.5);
        model.setTransform(t);
        model.addChild((Node)sphere);
        ChangeColorBehavior tb = new ChangeColorBehavior(1000L, coloringAttributes, elem);
        tb.setSchedulingBounds((Bounds)Util3D.BOUNDS3D);
        model.addChild((Node)tb);
        return model;
    }

    private static class ChangeColorBehavior
    extends Behavior {
        private WakeupCondition timeOut;
        private boolean isStopped = false;
        public ColoringAttributes coloringAttributes;
        public DynamicElement de;
        Color innerColor = Color.gray;

        public ChangeColorBehavior(long timeDelayA, ColoringAttributes coloringAttributesA, DynamicElement deA) {
            this.de = deA;
            this.timeOut = new WakeupOnElapsedTime(timeDelayA);
            this.coloringAttributes = coloringAttributesA;
            this.coloringAttributes.setCapability(1);
        }

        public void initialize() {
            this.wakeupOn(this.timeOut);
        }

        public void processStimulus(Enumeration criteria) {
            if (!this.isStopped) {
                this.innerColor = this.de.getIdleTimeSecs() == -1 ? Color.gray : this.de.getColorMap().getColor((double)this.de.getIdleTimeSecs() / (double)this.de.getConnectionTimeoutSecs());
                this.coloringAttributes.setColor(new Color3f(this.innerColor));
                if (this.de.getIdleTimeSecs() > this.de.getConnectionTimeoutSecs()) {
                    this.stopUpdate();
                } else {
                    this.wakeupOn(this.timeOut);
                }
            }
        }

        public void stopUpdate() {
            this.isStopped = true;
        }
    }
}

