/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.plugins.JVideoPanelConsole;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.renderer3d.TimeBehavior;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class ProjectionObj {
    Point3d lastvpositio;
    double lastroll;
    double lastpitch;
    double lastyaw;
    int ptop = 0;
    int pdown = 0;
    int pleft = 0;
    int pright = 0;
    public double viewAngleVert = 36.52577988438826;
    public double viewAngleHor = 49.97812801910477;
    public int gridResolutionV = 20;
    public int gridResolutionH = 20;
    public double xOffSet = 0.0;
    public double yOffSet = 0.0;
    public double zOffSet = 0.0;
    public boolean activated = false;
    public double pan = 0.0;
    public double tilt = 0.0;
    public double distanceWall = 0.2;
    public Renderer3D render;
    public JVideoPanelConsole videoSource = null;
    public VehicleType vehicle;
    public BranchGroup bg = null;
    public TransformGroup tg = null;
    public TimeBehavior tb = null;
    public Appearance app = new Appearance();
    public Texture2D texture;
    public ImageComponent2D ic;
    public BufferedImage imGlobal;
    private Shape3D projShape = new Shape3D();
    private GeometryArray geometry = null;
    QuadArray GFront = null;
    Vector3d[][] pointArray = null;
    Point3d[] Points = new Point3d[this.gridResolutionH * this.gridResolutionV * 4];

    public ProjectionObj(Renderer3D R, VehicleType v) {
        this.render = R;
        this.vehicle = v;
        this.GFront = new QuadArray(this.gridResolutionH * this.gridResolutionV * 4, 33);
        GeometryInfo gi = new GeometryInfo((GeometryArray)this.GFront);
        this.geometry = gi.getGeometryArray();
        this.geometry.setCapability(4);
        this.geometry.setCapability(0);
        this.geometry.setCapability(1);
        this.geometry.setCapability(7);
        this.geometry.setCapability(6);
        this.geometry.setCapability(20);
        this.geometry.setCapability(19);
        this.createAppearance();
        this.projShape = new Shape3D((Geometry)this.geometry, this.app);
        this.projShape.setCapability(14);
        this.projShape.setCapability(15);
        this.projShape.setCapability(12);
        this.projShape.setCapability(13);
        this.bg = new BranchGroup();
        this.tg = new TransformGroup();
        this.bg.addChild((Node)this.tg);
        this.bg.setCapability(14);
        this.bg.setCapability(17);
        this.tg.setCapability(18);
        this.tg.addChild((Node)this.projShape);
    }

    public void reInit() {
        if (this.bg.getParent() != null) {
            this.getRender().contentsNoPickTransGr.removeChild((Node)this.bg);
        }
        this.GFront = new QuadArray(this.gridResolutionH * this.gridResolutionV * 4, 33);
        Point2f[] tpoint = new Point2f[this.gridResolutionH * this.gridResolutionV * 4];
        for (int i = 0; i < this.gridResolutionH * this.gridResolutionV * 4; ++i) {
            tpoint[i] = new Point2f();
        }
        this.GFront.setTextureCoordinates(0, tpoint);
        GeometryInfo gi = new GeometryInfo((GeometryArray)this.GFront);
        this.geometry = gi.getGeometryArray();
        this.geometry.setCapability(4);
        this.geometry.setCapability(0);
        this.geometry.setCapability(1);
        this.geometry.setCapability(7);
        this.createAppearance();
        this.projShape = new Shape3D((Geometry)this.geometry, this.app);
        this.projShape.setCapability(14);
        this.projShape.setCapability(15);
        this.projShape.setCapability(12);
        this.projShape.setCapability(13);
        this.bg = new BranchGroup();
        this.tg = new TransformGroup();
        this.bg.addChild((Node)this.tg);
        this.bg.setCapability(14);
        this.bg.setCapability(17);
        this.tg.setCapability(18);
        this.tg.addChild((Node)this.projShape);
    }

    private void setPointArray(int i, int j, Vector3d p) {
        this.pointArray[i][j] = p;
    }

    public void rebuildPointArray() {
        this.pointArray = new Vector3d[this.gridResolutionH + 1][this.gridResolutionV + 1];
        double baseHor = Math.tan(Math.toRadians(this.viewAngleHor / 2.0));
        double baseVert = Math.tan(Math.toRadians(this.viewAngleVert / 2.0));
        double baseHorD = baseHor * 2.0;
        double baseVertD = baseVert * 2.0;
        for (int j = 0; j < this.gridResolutionV + 1; ++j) {
            for (int i = 0; i < this.gridResolutionH + 1; ++i) {
                this.setPointArray(i, j, new Vector3d(1.0, baseHorD / (double)this.gridResolutionH * (double)i - baseHor, baseVert - baseVertD / (double)this.gridResolutionV * (double)j));
            }
        }
        TexCoord2f[] tPoints = new TexCoord2f[this.gridResolutionH * this.gridResolutionV * 4];
        int x = 0;
        int y = 0;
        for (int i = 0; i < tPoints.length; i += 4) {
            tPoints[i] = new TexCoord2f((float)x / (float)this.gridResolutionH, 1.0f - (float)y / (float)this.gridResolutionV);
            tPoints[i + 1] = new TexCoord2f((float)(x + 1) / (float)this.gridResolutionH, 1.0f - (float)y / (float)this.gridResolutionV);
            tPoints[i + 2] = new TexCoord2f((float)(x + 1) / (float)this.gridResolutionH, 1.0f - (float)(y + 1) / (float)this.gridResolutionV);
            tPoints[i + 3] = new TexCoord2f((float)x / (float)this.gridResolutionH, 1.0f - (float)(y + 1) / (float)this.gridResolutionV);
            if (++x <= this.gridResolutionH - 1) continue;
            x = 0;
            ++y;
        }
        this.geometry.setValidVertexCount(tPoints.length);
        this.geometry.setTextureCoordinates(0, 0, tPoints);
        this.Points = new Point3d[this.gridResolutionH * this.gridResolutionV * 4];
        NeptusLog.pub().info((Object)"<###>chamado o rebuild");
    }

    public void printMatrix() {
        for (int i = 0; i < this.gridResolutionH + 1; ++i) {
            for (int j = 0; j < this.gridResolutionV + 1; ++j) {
                System.err.println("(" + i + "," + j + "):" + this.pointArray[i][j]);
            }
        }
    }

    private void createAppearance() {
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        this.app.setPolygonAttributes(pa);
        this.texture = new Texture2D(1, 6, Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE);
        this.texture.setCapability(7);
        this.texture.setCapability(4);
        this.texture.setMagFilter(3);
        BufferedImage im = new BufferedImage(Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE, 1);
        this.ic = new ImageComponent2D(1, Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE, true, true);
        this.ic.setCapability(3);
        this.ic.set(im);
        this.texture.setImage(0, (ImageComponent)this.ic);
        PolygonAttributes p = new PolygonAttributes(2, 0, 0.0f);
        this.app.setPolygonAttributes(p);
        this.app.setTexture((Texture)this.texture);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setCapability(0);
        trans.setCapability(1);
        trans.setTransparency(0.8f);
        trans.setTransparencyMode(1);
        this.app.setTransparencyAttributes(trans);
    }

    public void refreshVideoMap() {
        if (this.videoSource != null) {
            this.imGlobal = (BufferedImage)this.videoSource.grabFrameImage(this.ptop, this.pdown, this.pleft, this.pright);
            if (this.imGlobal != null) {
                this.ic.set(this.imGlobal);
                this.texture.setImage(0, (ImageComponent)this.ic);
            } else {
                NeptusLog.pub().info((Object)"<###>Null BufferedImage");
            }
        }
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###>Angulo vertical:" + Math.toDegrees(Math.atan(0.33)) * 2.0));
        NeptusLog.pub().info((Object)("<###>Angulo vertical:" + Math.toDegrees(Math.atan(0.445)) * 2.0));
    }

    public void refreshObj(Point3d vpositio, double roll, double pitch, double yaw) {
        this.lastvpositio = vpositio;
        this.lastroll = roll;
        this.lastpitch = pitch;
        this.lastyaw = yaw;
        if (this.activated) {
            this.refreshVideoMap();
            int x = 0;
            int y = 0;
            Vector3d v = new Vector3d();
            double tiltCalc = pitch + Math.toRadians(this.tilt);
            double panCalc = yaw + Math.toRadians(this.pan);
            Transform3D ret = new Transform3D();
            Transform3D xrot = new Transform3D();
            Transform3D yrot = new Transform3D();
            Transform3D zrot = new Transform3D();
            xrot.rotX(roll);
            yrot.rotY(tiltCalc);
            zrot.rotZ(panCalc);
            ret.mul(zrot);
            ret.mul(xrot);
            ret.mul(yrot);
            for (int i = 0; i < this.Points.length; i += 4) {
                ret.transform(this.pointArray[x][y], v);
                Point3d point = this.getRender().fireRay(vpositio, v);
                v.normalize();
                v.negate();
                v.x *= this.distanceWall;
                v.y *= this.distanceWall;
                v.z *= this.distanceWall;
                point.add((Tuple3d)v);
                this.Points[i] = point;
                ret.transform(this.pointArray[x + 1][y], v);
                point = this.getRender().fireRay(vpositio, v);
                v.normalize();
                v.negate();
                v.x *= this.distanceWall;
                v.y *= this.distanceWall;
                v.z *= this.distanceWall;
                point.add((Tuple3d)v);
                this.Points[i + 1] = point;
                ret.transform(this.pointArray[x + 1][y + 1], v);
                point = this.getRender().fireRay(vpositio, v);
                v.normalize();
                v.negate();
                v.x *= this.distanceWall;
                v.y *= this.distanceWall;
                v.z *= this.distanceWall;
                point.add((Tuple3d)v);
                this.Points[i + 2] = point;
                ret.transform(this.pointArray[x][y + 1], v);
                point = this.getRender().fireRay(vpositio, v);
                v.normalize();
                v.negate();
                v.x *= this.distanceWall;
                v.y *= this.distanceWall;
                v.z *= this.distanceWall;
                point.add((Tuple3d)v);
                this.Points[i + 3] = point;
                if (++x <= this.gridResolutionH - 1) continue;
                x = 0;
                ++y;
            }
            this.geometry.setCoordinates(0, this.Points);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
        if (this.activated) {
            if (this.bg.getParent() == null) {
                this.getRender().contentsNoPickTransGr.addChild((Node)this.bg);
            } else {
                this.getRender().contentsNoPickTransGr.removeChild((Node)this.bg);
                this.getRender().contentsNoPickTransGr.addChild((Node)this.bg);
            }
        } else if (this.bg.getParent() != null) {
            this.getRender().contentsNoPickTransGr.removeChild((Node)this.bg);
        }
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
    }

    public Renderer3D getRender() {
        return this.render;
    }

    public void setRender(Renderer3D render) {
        this.render = render;
    }

    public double getTilt() {
        return this.tilt;
    }

    public void setTilt(double tilt) {
        this.tilt = tilt;
    }

    public JVideoPanelConsole getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(JVideoPanelConsole videoSource) {
        this.videoSource = videoSource;
    }

    public double getXOffSet() {
        return this.xOffSet;
    }

    public void setXOffSet(double offSet) {
        this.xOffSet = offSet;
    }

    public double getYOffSet() {
        return this.yOffSet;
    }

    public void setYOffSet(double offSet) {
        this.yOffSet = offSet;
    }

    public double getZOffSet() {
        return this.zOffSet;
    }

    public void setZOffSet(double offSet) {
        this.zOffSet = offSet;
    }

    public double getViewAngleHor() {
        return this.viewAngleHor;
    }

    public void setViewAngleHor(double viewAngleHor) {
        this.viewAngleHor = viewAngleHor;
    }

    public double getViewAngleVert() {
        return this.viewAngleVert;
    }

    public void setViewAngleVert(double viewAngleVert) {
        this.viewAngleVert = viewAngleVert;
    }

    public int getGridResolutionH() {
        return this.gridResolutionH;
    }

    public void setGridResolutionH(int gridResolutionH) {
        this.gridResolutionH = gridResolutionH;
    }

    public int getGridResolutionV() {
        return this.gridResolutionV;
    }

    public void setGridResolutionV(int gridResolutionV) {
        this.gridResolutionV = gridResolutionV;
    }

    public VehicleType getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    public double getDistanceWall() {
        return this.distanceWall;
    }

    public void setDistanceWall(double distanceWall) {
        this.distanceWall = distanceWall;
    }

    public void leaveProjection() {
        int i;
        int RESOLUTION = 10;
        Appearance appCopy = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        appCopy.setPolygonAttributes(pa);
        Texture2D textureCopy = new Texture2D(1, 6, Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE);
        textureCopy.setMagFilter(3);
        ImageComponent2D icaux = new ImageComponent2D(1, this.imGlobal);
        textureCopy.setImage(0, (ImageComponent)icaux);
        PolygonAttributes p = new PolygonAttributes(2, 0, 0.0f);
        appCopy.setPolygonAttributes(p);
        appCopy.setTexture((Texture)textureCopy);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setCapability(0);
        trans.setCapability(1);
        trans.setTransparency(0.8f);
        trans.setTransparencyMode(1);
        appCopy.setTransparencyAttributes(trans);
        QuadArray GFrontCopy = new QuadArray(RESOLUTION * RESOLUTION * 4, 33);
        Vector3d[][] pointArrayCopy = new Vector3d[RESOLUTION + 1][RESOLUTION + 1];
        double baseHor = Math.tan(Math.toRadians(this.viewAngleHor / 2.0));
        double baseVert = Math.tan(Math.toRadians(this.viewAngleVert / 2.0));
        double baseHorD = baseHor * 2.0;
        double baseVertD = baseVert * 2.0;
        for (int j = 0; j < RESOLUTION + 1; ++j) {
            for (int i2 = 0; i2 < RESOLUTION + 1; ++i2) {
                pointArrayCopy[i2][j] = new Vector3d(1.0, baseHorD / (double)RESOLUTION * (double)i2 - baseHor, baseVert - baseVertD / (double)RESOLUTION * (double)j);
            }
        }
        Vector3d v = new Vector3d();
        int x = 0;
        int y = 0;
        double tiltCalc = this.lastpitch + Math.toRadians(this.tilt);
        double panCalc = this.lastyaw + Math.toRadians(this.pan);
        Transform3D ret = new Transform3D();
        Transform3D xrot = new Transform3D();
        Transform3D yrot = new Transform3D();
        Transform3D zrot = new Transform3D();
        xrot.rotX(this.lastroll);
        yrot.rotY(tiltCalc);
        zrot.rotZ(panCalc);
        ret.mul(zrot);
        ret.mul(xrot);
        ret.mul(yrot);
        for (i = 0; i < RESOLUTION * RESOLUTION * 4; i += 4) {
            ret.transform(pointArrayCopy[x][y], v);
            Point3d point = this.getRender().fireRay(this.lastvpositio, v);
            v.normalize();
            v.negate();
            v.x *= this.distanceWall;
            v.y *= this.distanceWall;
            v.z *= this.distanceWall;
            point.add((Tuple3d)v);
            GFrontCopy.setCoordinate(i, point);
            ret.transform(pointArrayCopy[x + 1][y], v);
            point = this.getRender().fireRay(this.lastvpositio, v);
            v.normalize();
            v.negate();
            v.x *= this.distanceWall;
            v.y *= this.distanceWall;
            v.z *= this.distanceWall;
            point.add((Tuple3d)v);
            GFrontCopy.setCoordinate(i + 1, point);
            ret.transform(pointArrayCopy[x + 1][y + 1], v);
            point = this.getRender().fireRay(this.lastvpositio, v);
            v.normalize();
            v.negate();
            v.x *= this.distanceWall;
            v.y *= this.distanceWall;
            v.z *= this.distanceWall;
            point.add((Tuple3d)v);
            GFrontCopy.setCoordinate(i + 2, point);
            ret.transform(pointArrayCopy[x][y + 1], v);
            point = this.getRender().fireRay(this.lastvpositio, v);
            v.normalize();
            v.negate();
            v.x *= this.distanceWall;
            v.y *= this.distanceWall;
            v.z *= this.distanceWall;
            point.add((Tuple3d)v);
            GFrontCopy.setCoordinate(i + 3, point);
            if (++x <= RESOLUTION - 1) continue;
            x = 0;
            ++y;
        }
        x = 0;
        y = 0;
        for (i = 0; i < RESOLUTION * RESOLUTION * 4; i += 4) {
            GFrontCopy.setTextureCoordinate(0, i, new TexCoord2f((float)x / (float)RESOLUTION, (float)y / (float)RESOLUTION));
            GFrontCopy.setTextureCoordinate(0, i + 1, new TexCoord2f((float)(x + 1) / (float)RESOLUTION, (float)y / (float)RESOLUTION));
            GFrontCopy.setTextureCoordinate(0, i + 2, new TexCoord2f((float)(x + 1) / (float)RESOLUTION, (float)(y + 1) / (float)RESOLUTION));
            GFrontCopy.setTextureCoordinate(0, i + 3, new TexCoord2f((float)x / (float)RESOLUTION, (float)(y + 1) / (float)RESOLUTION));
            if (++x <= RESOLUTION - 1) continue;
            x = 0;
            ++y;
        }
        Shape3D projShapeCopy = new Shape3D((Geometry)GFrontCopy, appCopy);
        BranchGroup bgaux = new BranchGroup();
        bgaux.addChild((Node)projShapeCopy);
        this.getRender().contentsNoPickTransGr.addChild((Node)bgaux);
    }

    public int getPdown() {
        return this.pdown;
    }

    public void setPdown(int pdown) {
        this.pdown = pdown;
    }

    public int getPleft() {
        return this.pleft;
    }

    public void setPleft(int pleft) {
        this.pleft = pleft;
    }

    public int getPright() {
        return this.pright;
    }

    public void setPright(int pright) {
        this.pright = pright;
    }

    public int getPtop() {
        return this.ptop;
    }

    public void setPtop(int ptop) {
        this.ptop = ptop;
    }
}

