/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import pt.lsts.neptus.console.plugins.JVideoPanelConsole;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.ComboEditor;
import pt.lsts.neptus.renderer3d.ProjectionObj;

public class ProjectionPropertiesProvider
implements PropertiesProvider {
    ProjectionObj pObj;

    public ProjectionPropertiesProvider(ProjectionObj po) {
        this.pObj = po;
    }

    @Override
    public DefaultProperty[] getProperties() {
        DefaultProperty xrel = PropertiesEditor.getPropertyInstance("x offset Camera to vehicle", "Camera", Double.class, this.pObj.getXOffSet(), true);
        DefaultProperty yrel = PropertiesEditor.getPropertyInstance("y offset Camera to vehicle", "Camera", Double.class, this.pObj.getYOffSet(), true);
        DefaultProperty zrel = PropertiesEditor.getPropertyInstance("z offset Camera to vehicle", "Camera", Double.class, this.pObj.getZOffSet(), true);
        DefaultProperty vang = PropertiesEditor.getPropertyInstance("Vertical Capture angle", "Camera", Double.class, this.pObj.getViewAngleVert(), true);
        DefaultProperty hang = PropertiesEditor.getPropertyInstance("Horizontal Capture angle", "Camera", Double.class, this.pObj.getViewAngleHor(), true);
        DefaultProperty pan = PropertiesEditor.getPropertyInstance("Pan angle", "Camera", Double.class, this.pObj.getPan(), true);
        DefaultProperty tilt = PropertiesEditor.getPropertyInstance("Tilt angle", "Camera", Double.class, this.pObj.getTilt(), true);
        DefaultProperty mtop = PropertiesEditor.getPropertyInstance("Margin Top", "Camera Image Margin", Integer.class, this.pObj.getPtop(), true);
        DefaultProperty mdown = PropertiesEditor.getPropertyInstance("Margin Botton", "Camera Image Margin", Integer.class, this.pObj.getPdown(), true);
        DefaultProperty mleft = PropertiesEditor.getPropertyInstance("Margin Left", "Camera Image Margin", Integer.class, this.pObj.getPleft(), true);
        DefaultProperty mright = PropertiesEditor.getPropertyInstance("Margin Right", "Camera Image Margin", Integer.class, this.pObj.getPright(), true);
        DefaultProperty act = PropertiesEditor.getPropertyInstance("Activate Projection", "Projection Obj", Boolean.class, this.pObj.isActivated(), true);
        DefaultProperty hgr = PropertiesEditor.getPropertyInstance("Horizontal Grid resolution", "Projection Obj", Integer.class, this.pObj.getGridResolutionH(), true);
        DefaultProperty vgr = PropertiesEditor.getPropertyInstance("Vertical Grid resolution", "Projection Obj", Integer.class, this.pObj.getGridResolutionV(), true);
        DefaultProperty intdist = PropertiesEditor.getPropertyInstance("Distance from intercection", "Projection Obj", Double.class, this.pObj.getDistanceWall(), true);
        DefaultProperty video = PropertiesEditor.getPropertyInstance("Video Panel Mapping", "Projection Obj", JVideoPanelConsole.class, this.pObj.getVideoSource(), true);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)video, new ComboEditor<JVideoPanelConsole>(this.pObj.getRender().getConsole().getSubPanelsOfClass(JVideoPanelConsole.class).toArray(new JVideoPanelConsole[0])));
        return new DefaultProperty[]{xrel, yrel, zrel, vang, hang, pan, tilt, mtop, mdown, mleft, mright, act, hgr, vgr, intdist, video};
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Projection Properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            if (p.getName().equals("x offset Camera to vehicle")) {
                this.pObj.setXOffSet((Double)p.getValue());
            }
            if (p.getName().equals("y offset Camera to vehicle")) {
                this.pObj.setYOffSet((Double)p.getValue());
            }
            if (p.getName().equals("z offset Camera to vehicle")) {
                this.pObj.setZOffSet((Double)p.getValue());
            }
            if (p.getName().equals("Vertical Capture angle")) {
                this.pObj.setViewAngleVert((Double)p.getValue());
            }
            if (p.getName().equals("Horizontal Capture angle")) {
                this.pObj.setViewAngleHor((Double)p.getValue());
            }
            if (p.getName().equals("Pan angle")) {
                this.pObj.setPan((Double)p.getValue());
            }
            if (p.getName().equals("Tilt angle")) {
                this.pObj.setTilt((Double)p.getValue());
            }
            if (p.getName().equals("Margin Top")) {
                this.pObj.setPtop((Integer)p.getValue());
            }
            if (p.getName().equals("Margin Botton")) {
                this.pObj.setPdown((Integer)p.getValue());
            }
            if (p.getName().equals("Margin Left")) {
                this.pObj.setPleft((Integer)p.getValue());
            }
            if (p.getName().equals("Margin Right")) {
                this.pObj.setPright((Integer)p.getValue());
            }
            if (p.getName().equals("Activate Projection")) {
                this.pObj.setActivated((Boolean)p.getValue());
            }
            if (p.getName().equals("Horizontal Grid resolution")) {
                this.pObj.setGridResolutionH((Integer)p.getValue());
            }
            if (p.getName().equals("Vertical Grid resolution")) {
                this.pObj.setGridResolutionV((Integer)p.getValue());
            }
            if (p.getName().equals("Distance from intercection")) {
                this.pObj.setDistanceWall((Double)p.getValue());
            }
            if (!p.getName().equals("Video Panel Mapping")) continue;
            this.pObj.setVideoSource((JVideoPanelConsole)p.getValue());
        }
        this.pObj.rebuildPointArray();
    }
}

