/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.renderer3d.Util3D;

public class RayTest
extends MouseAdapter {
    private PickCanvas pickCanvas;
    private PickTool pickTool;

    public RayTest() {
        Frame frame = new Frame("Box and Sphere");
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(config);
        canvas.setSize(400, 400);
        SimpleUniverse universe = new SimpleUniverse(canvas);
        BranchGroup group = new BranchGroup();
        Vector3f vector = new Vector3f(-0.3f, 0.0f, 0.0f);
        Transform3D transform = new Transform3D();
        transform.setTranslation(vector);
        TransformGroup transformGroup = new TransformGroup(transform);
        ColorCube cube = new ColorCube(0.4);
        transformGroup.addChild((Node)cube);
        group.addChild((Node)transformGroup);
        Vector3f vector2 = new Vector3f(0.3f, 0.0f, 0.0f);
        Transform3D transform2 = new Transform3D();
        transform2.setTranslation(vector2);
        TransformGroup transformGroup2 = new TransformGroup(transform2);
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(new PolygonAttributes(1, 1, 0.0f));
        Sphere sphere = new Sphere(0.3f, appearance);
        transformGroup2.addChild((Node)sphere);
        group.addChild((Node)transformGroup2);
        universe.getViewingPlatform().setNominalViewingTransform();
        Util3D.enablePicking((Node)group);
        universe.addBranchGraph(group);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvent) {
                System.exit(0);
            }
        });
        frame.add((Component)canvas);
        this.pickCanvas = new PickCanvas(canvas, group);
        this.pickCanvas.setMode(256);
        this.pickTool = new PickTool(group);
        this.pickTool.setMode(256);
        canvas.addMouseListener((MouseListener)this);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new RayTest();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.pickTool.setShapeRay(new Point3d(10.0, 0.1, 0.0), new Vector3d(-10.0, 0.0, 0.0));
        PickResult result = this.pickTool.pickClosest();
        if (result == null) {
            NeptusLog.pub().info((Object)"<###>---Nothing picked---");
        } else {
            NeptusLog.pub().info((Object)"<###>--------------- picked---");
            NeptusLog.pub().info((Object)("<###>Coordinates to world:" + result.getClosestIntersection(new Point3d(10.0, 0.1, 0.0)).getPointCoordinatesVW()));
            Primitive p = (Primitive)result.getNode(4);
            Shape3D s = (Shape3D)result.getNode(1);
            if (p != null) {
                NeptusLog.pub().info((Object)("<###> " + p.getClass().getName()));
            } else if (s != null) {
                NeptusLog.pub().info((Object)("<###> " + s.getClass().getName()));
            } else {
                NeptusLog.pub().info((Object)"<###>null");
            }
        }
        NeptusLog.pub().info((Object)"<###>--------------- end  picked---");
    }
}

