/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.Viewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.VirtualUniverse;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.plugins.JVideoPanelConsole;
import pt.lsts.neptus.gui.Grid3D;
import pt.lsts.neptus.gui.Properties3D;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.mme.wms.FetcherWMS;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.MapChangeListener;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.renderer2d.Renderer;
import pt.lsts.neptus.renderer3d.Camera3D;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Object3DCreationHelper;
import pt.lsts.neptus.renderer3d.ProjectionObj;
import pt.lsts.neptus.renderer3d.ProjectionPropertiesProvider;
import pt.lsts.neptus.renderer3d.SensorObj;
import pt.lsts.neptus.renderer3d.SensorPropertiesProvider;
import pt.lsts.neptus.renderer3d.Texture3D;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.renderer3d.VehicleTailObj3D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.CylinderElement;
import pt.lsts.neptus.types.map.DynamicElement;
import pt.lsts.neptus.types.map.EllipsoidElement;
import pt.lsts.neptus.types.map.HomeReferenceElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.map.ScatterPointsElement;
import pt.lsts.neptus.types.map.VehicleTailElement;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

public class Renderer3D
extends JPanel
implements MapChangeListener,
Renderer,
ActionListener,
MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener,
PreferencesListener,
ComponentListener {
    protected int priority3D = 1;
    private static final long serialVersionUID = 1L;
    public boolean clean = false;
    public static final int NEPTUS_MODE = 0;
    public static final int VIEWER_MODE = 1;
    public int mode = 0;
    protected int NVIEWS = 4;
    private JPanel[] views;
    private JPanel viewspanel = new JPanel();
    JToolBar toolbar = new JToolBar("Controls");
    private VirtualUniverse universe;
    private Locale locale;
    private BoundingSphere bounds;
    private BranchGroup contentBranch;
    public TransformGroup contentsTransGr;
    private BranchGroup contentNoPickBranch;
    public TransformGroup contentsNoPickTransGr;
    private BranchGroup viewBranch;
    private TransformGroup viewTransGr;
    private BranchGroup bgBranch;
    private Background bg;
    public Hashtable<AbstractElement, Obj3D> objects = new Hashtable();
    protected Hashtable<VehicleType, Obj3D> vehicles = new Hashtable();
    public Camera3D[] cams;
    protected LocationType location = new LocationType();
    private MapGroup myMapGroup;
    public String lockedVehicle = null;
    private Vector<Obj3D> objs3D = new Vector();
    ReentrantLock lock = new ReentrantLock();
    public short panel_op = 0;
    private short lines = (short)2;
    private short coluns = (short)2;
    private short panel_max = (short)-1;
    private VehicleType veicle_op;
    private short viewing = 1;
    private boolean seaflat = false;
    private boolean grid = false;
    private boolean axis = false;
    private boolean transp = false;
    private boolean mapa = false;
    private short rule = 0;
    private short background = 1;
    public boolean gNE = true;
    public boolean gUE = false;
    public boolean gUN = false;
    public float gdimension = 1000.0f;
    public float gspacing = 10.0f;
    public boolean gtext = false;
    public Color gcolor = new Color(0.8f, 0.8f, 0.8f);
    public Point3d gcenter = new Point3d(0.0, 0.0, 0.0);
    private boolean mouse1 = false;
    private boolean mouse3 = false;
    private int mousex;
    private int mousey;
    private Cursor rotateCursor;
    private Cursor translateCursor;
    private Cursor zoomCursor;
    private Cursor crosshairCursor;
    BranchGroup landscape;
    Obj3D seaobj;
    Obj3D seaflatobj;
    Obj3D lochomeobj;
    Obj3D gridobj;
    Obj3D plan;
    public ConsoleLayout console = null;
    private PickTool pickTool;
    public Vector<ProjectionObj> projections = new Vector();
    public Vector<SensorObj> sensors = new Vector();
    public boolean stop_vehicles;
    private Vector<VehicleTailObj3D> VehiclesTails = new Vector();
    private Hashtable<VehicleType, VehicleTailElement> vehicleTails = new Hashtable();
    private Vector<ChangeListener> changeListeners = new Vector();
    private JDialog dialog;
    Obj3D axisobj = new Obj3D(Util3D.makeAxis(true, 10.0));
    private boolean stopped = false;
    boolean renderingStop = false;

    public Renderer3D() {
        Camera3D[] cs = new Camera3D[4];
        try {
            cs[0] = new Camera3D(0);
            cs[1] = new Camera3D(2);
            cs[2] = new Camera3D(1);
            cs[3] = new Camera3D(3);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            GuiUtils.errorMessage(this, "Erro Render-3D", "erro iniciando Vistas");
            return;
        }
        this.cams = cs;
        this.NVIEWS = 4;
        this.lines = (short)2;
        this.coluns = (short)2;
        this.createLayout(this.lines, this.coluns);
        this.init3D();
        this.setCoordinateSystem();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setViewMode(1);
    }

    public Renderer3D(Camera3D[] cs, short rows, short cols) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.NVIEWS = cs.length;
        this.cams = cs;
        this.lines = rows;
        this.coluns = cols;
        this.createLayout(rows, cols);
        this.init3D();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setViewMode(1);
        this.grid(true, true);
        this.infoAxis(true);
        this.infoCam(true);
        this.setObjsIcons(true);
        this.setVehiclesIcons(true);
    }

    private void loadCursors() {
        this.rotateCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/rotate_cursor.png"), new Point(15, 15), "Rotate");
        this.zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/zoom_cursor.png"), new Point(15, 15), "Zoom");
        this.translateCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/translate_cursor.png"), new Point(15, 15), "Translate");
        this.crosshairCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtils.getImage("images/cursors/crosshair_cursor.png"), new Point(12, 12), "Crosshair");
    }

    void addCamera3D(Camera3D c) {
        this.viewTransGr.addChild((Node)c.getCamera3D());
        c.associatedrender = this;
    }

    private void createLayout(int rows, int coluns) {
        this.viewspanel.setLayout(new GridLayout(rows, coluns));
        this.views = new JPanel[this.NVIEWS];
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.views[i] = new JPanel();
            this.views[i].setBorder(BorderFactory.createBevelBorder(1));
            this.viewspanel.add(this.views[i]);
            this.views[i].setVisible(true);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.viewspanel, "Center");
    }

    private void init3D() {
        this.bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        GeneralPreferences.addPreferencesListener(this);
        this.setUniverse();
        this.setContent();
        this.setViewing();
    }

    private void setContent() {
        this.contentsNoPickTransGr = new TransformGroup();
        this.contentsNoPickTransGr.setCapability(18);
        this.contentsNoPickTransGr.setCapability(17);
        this.contentsNoPickTransGr.setCapability(12);
        this.contentsNoPickTransGr.setCapability(13);
        this.contentsNoPickTransGr.setCapability(14);
        this.contentsTransGr = new TransformGroup();
        this.contentsTransGr.setCapability(18);
        this.contentsTransGr.setCapability(17);
        this.contentsTransGr.setCapability(12);
        this.contentsTransGr.setCapability(13);
        this.contentsTransGr.setCapability(14);
        this.contentNoPickBranch = new BranchGroup();
        this.contentNoPickBranch.setCapability(14);
        this.contentBranch = new BranchGroup();
        this.contentBranch.setCapability(14);
        this.setBackgroundType(this.background);
        this.setLighting();
        this.makeGrid();
        this.contentBranch.addChild((Node)this.contentsTransGr);
        this.contentNoPickBranch.addChild((Node)this.contentsNoPickTransGr);
        this.locale.addBranchGraph(this.contentBranch);
        this.locale.addBranchGraph(this.contentNoPickBranch);
        this.pickTool = new PickTool(this.contentBranch);
        this.pickTool.setMode(256);
    }

    public void setBackgroundColor(Color3f c) {
        if (this.bgBranch != null) {
            this.contentsTransGr.removeChild((Node)this.bgBranch);
            this.bgBranch.detach();
        }
        this.bgBranch = new BranchGroup();
        this.bgBranch.setCapability(17);
        this.bg = new Background(c);
        this.bg.setApplicationBounds((Bounds)this.bounds);
        this.bgBranch.addChild((Node)this.bg);
        this.contentsTransGr.addChild((Node)this.bgBranch);
    }

    public short getBackgroundType() {
        return this.background;
    }

    public void setBackgroundType(short t) {
        TextureLoader tex;
        Image texture;
        Transform3D rot;
        TransformGroup rotx;
        Appearance backgroundApp;
        Sphere sphereObj;
        BranchGroup backGeoBranch;
        Background bg;
        if (t == 1) {
            this.setBackgroundColor(new Color3f(0.007843138f, 0.44313726f, 0.67058825f));
        }
        if (t == 2) {
            if (this.bgBranch != null) {
                this.contentsTransGr.removeChild((Node)this.bgBranch);
                this.bgBranch.detach();
            }
            bg = new Background();
            bg.setApplicationBounds((Bounds)this.bounds);
            backGeoBranch = new BranchGroup();
            sphereObj = new Sphere(1.0f, 7, 90);
            backgroundApp = sphereObj.getAppearance();
            rotx = new TransformGroup();
            rot = new Transform3D();
            rot.rotX(1.5707963267948966);
            rotx.setTransform(rot);
            rotx.addChild((Node)sphereObj);
            backGeoBranch.addChild((Node)rotx);
            bg.setGeometry(backGeoBranch);
            texture = ImageUtils.getImage("images/backsky.png");
            tex = new TextureLoader(texture, "RGB", (Component)this);
            if (tex != null) {
                backgroundApp.setTexture(tex.getTexture());
            }
            this.bgBranch = new BranchGroup();
            this.bgBranch.setCapability(17);
            this.bgBranch.addChild((Node)bg);
            this.contentsTransGr.addChild((Node)this.bgBranch);
        }
        if (t == 3) {
            if (this.bgBranch != null) {
                this.contentsTransGr.removeChild((Node)this.bgBranch);
                this.bgBranch.detach();
            }
            bg = new Background();
            bg.setApplicationBounds((Bounds)this.bounds);
            backGeoBranch = new BranchGroup();
            sphereObj = new Sphere(1.0f, 7, 90);
            backgroundApp = sphereObj.getAppearance();
            rotx = new TransformGroup();
            rot = new Transform3D();
            rot.rotX(1.5707963267948966);
            rotx.setTransform(rot);
            rotx.addChild((Node)sphereObj);
            backGeoBranch.addChild((Node)rotx);
            bg.setGeometry(backGeoBranch);
            texture = ImageUtils.getImage("images/landscape.png");
            tex = new TextureLoader(texture, "RGB", (Component)this);
            if (tex != null) {
                backgroundApp.setTexture(tex.getTexture());
            }
            this.bgBranch = new BranchGroup();
            this.bgBranch.setCapability(17);
            this.bgBranch.addChild((Node)bg);
            this.contentsTransGr.addChild((Node)this.bgBranch);
        }
        this.background = t;
    }

    public void setPlanObj(Obj3D obj) {
        if (this.plan != null) {
            this.removeObj3D(this.plan);
        }
        this.plan = obj;
        if (this.plan != null) {
            this.addObj3D(this.plan);
        }
    }

    public void addObj3D(Obj3D obj) {
        this.objs3D.add(obj);
        obj.setParent3D(this.contentsTransGr);
    }

    public void removeObj3D(Obj3D obj) {
        this.objs3D.remove(obj);
        this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
    }

    private void activateMap() {
        LocationType home = new LocationType();
        Enumeration<AbstractElement> enuma = this.objects.keys();
        while (enuma.hasMoreElements()) {
            AbstractElement objs = enuma.nextElement();
            if (objs instanceof HomeReferenceElement) continue;
            home = objs.getCenterLocation();
        }
        FetcherWMS land = new FetcherWMS();
        LocationType topleft = new LocationType(home);
        topleft.translatePosition(200.0, -200.0, 0.0);
        LocationType bottomright = new LocationType(home);
        bottomright.translatePosition(-200.0, 200.0, 0.0);
        land.setTopLeft(topleft);
        land.setBottomRight(bottomright);
        Texture3D terrain = new Texture3D(land.fetchImage(), ImageUtils.getImage("images/altura.png"), 400.0, 400.0);
        terrain.maxvalue = 10.0;
        terrain.minvalue = 8.0;
        terrain.transparency = 0.0f;
        TransformGroup shape = terrain.getModel3D();
        TransformGroup center = new TransformGroup();
        center.addChild((Node)shape);
        this.landscape = new BranchGroup();
        this.landscape.addChild((Node)center);
        this.landscape.setCapability(14);
        this.landscape.setCapability(17);
        this.landscape.compile();
    }

    private void makeGrid() {
        Shape3D shape3D2;
        LineArray myLines2;
        Point3d[] listp2;
        Shape3D shape3D;
        LineArray myLines;
        Point3d[] listp;
        int index;
        float step;
        int x;
        int i;
        TransformGroup theModel = new TransformGroup();
        theModel.setCapability(18);
        theModel.setCapability(17);
        theModel.setCapability(14);
        theModel.setCapability(12);
        theModel.setCapability(13);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 1.0f, 0, true, true, false, 3);
        Color3f c = new Color3f(this.gcolor);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        Appearance appearance = new Appearance();
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        if (this.gNE) {
            i = (int)(this.gdimension / this.gspacing);
            x = 0;
            step = 0.0f;
            index = 0;
            listp = new Point3d[(i + 1) * 2];
            while (x < i + 1) {
                listp[index] = new Point3d((double)(this.gdimension / 2.0f), (double)(-this.gdimension / 2.0f + step), 0.0);
                listp[++index] = new Point3d((double)(-this.gdimension / 2.0f), (double)(-this.gdimension / 2.0f + step), 0.0);
                ++index;
                ++x;
                step += this.gspacing;
            }
            myLines = new LineArray(listp.length, 1);
            myLines.setCoordinates(0, listp);
            shape3D = new Shape3D((Geometry)myLines, appearance);
            i = (int)(this.gdimension / this.gspacing);
            x = 0;
            step = 0.0f;
            index = 0;
            listp2 = new Point3d[(i + 1) * 2];
            while (x < i + 1) {
                listp2[index] = new Point3d((double)(-this.gdimension / 2.0f + step), (double)(this.gdimension / 2.0f), 0.0);
                listp2[++index] = new Point3d((double)(-this.gdimension / 2.0f + step), (double)(-this.gdimension / 2.0f), 0.0);
                ++index;
                ++x;
                step += this.gspacing;
            }
            myLines2 = new LineArray(listp2.length, 1);
            myLines2.setCoordinates(0, listp2);
            shape3D2 = new Shape3D((Geometry)myLines2, appearance);
            theModel.addChild((Node)shape3D);
            theModel.addChild((Node)shape3D2);
        }
        if (this.gUE) {
            i = (int)(this.gdimension / this.gspacing);
            x = 0;
            step = 0.0f;
            index = 0;
            listp = new Point3d[(i + 1) * 2];
            while (x < i + 1) {
                listp[index] = new Point3d(0.0, (double)(this.gdimension / 2.0f), (double)(-this.gdimension / 2.0f + step));
                listp[++index] = new Point3d(0.0, (double)(-this.gdimension / 2.0f), (double)(-this.gdimension / 2.0f + step));
                ++index;
                ++x;
                step += this.gspacing;
            }
            myLines = new LineArray(listp.length, 1);
            myLines.setCoordinates(0, listp);
            shape3D = new Shape3D((Geometry)myLines, appearance);
            i = (int)(this.gdimension / this.gspacing);
            x = 0;
            step = 0.0f;
            index = 0;
            listp2 = new Point3d[(i + 1) * 2];
            while (x < i + 1) {
                listp2[index] = new Point3d(0.0, (double)(-this.gdimension / 2.0f + step), (double)(this.gdimension / 2.0f));
                listp2[++index] = new Point3d(0.0, (double)(-this.gdimension / 2.0f + step), (double)(-this.gdimension / 2.0f));
                ++index;
                ++x;
                step += this.gspacing;
            }
            myLines2 = new LineArray(listp2.length, 1);
            myLines2.setCoordinates(0, listp2);
            shape3D2 = new Shape3D((Geometry)myLines2, appearance);
            theModel.addChild((Node)shape3D);
            theModel.addChild((Node)shape3D2);
        }
        if (this.gUN) {
            i = (int)(this.gdimension / this.gspacing);
            x = 0;
            step = 0.0f;
            index = 0;
            listp = new Point3d[(i + 1) * 2];
            while (x < i + 1) {
                listp[index] = new Point3d((double)(this.gdimension / 2.0f), 0.0, (double)(-this.gdimension / 2.0f + step));
                listp[++index] = new Point3d((double)(-this.gdimension / 2.0f), 0.0, (double)(-this.gdimension / 2.0f + step));
                ++index;
                ++x;
                step += this.gspacing;
            }
            myLines = new LineArray(listp.length, 1);
            myLines.setCoordinates(0, listp);
            shape3D = new Shape3D((Geometry)myLines, appearance);
            i = (int)(this.gdimension / this.gspacing);
            x = 0;
            step = 0.0f;
            index = 0;
            listp2 = new Point3d[(i + 1) * 2];
            while (x < i + 1) {
                listp2[index] = new Point3d((double)(-this.gdimension / 2.0f + step), 0.0, (double)(this.gdimension / 2.0f));
                listp2[++index] = new Point3d((double)(-this.gdimension / 2.0f + step), 0.0, (double)(-this.gdimension / 2.0f));
                ++index;
                ++x;
                step += this.gspacing;
            }
            myLines2 = new LineArray(listp2.length, 1);
            myLines2.setCoordinates(0, listp2);
            shape3D2 = new Shape3D((Geometry)myLines2, appearance);
            theModel.addChild((Node)shape3D);
            theModel.addChild((Node)shape3D2);
        }
        this.gridobj = new Obj3D(theModel);
    }

    public void grid(boolean g, boolean i) {
        this.gtext = i;
        if (!g) {
            this.contentsTransGr.removeChild((Node)this.gridobj.getFullObj3D());
            this.grid = false;
        } else {
            this.gridobj.setPos(this.gcenter);
            this.contentsTransGr.removeChild((Node)this.gridobj.getFullObj3D());
            this.gridobj.setParent3D(this.contentsTransGr);
            this.grid = true;
        }
    }

    public void menuOKgrid() {
        if (this.grid) {
            this.contentsTransGr.removeChild((Node)this.gridobj.getFullObj3D());
            this.makeGrid();
            this.gridobj.setPos(this.gcenter);
            this.gridobj.setParent3D(this.contentsTransGr);
        } else {
            this.makeGrid();
            this.gridobj.setPos(this.gcenter);
        }
    }

    public void infoAxis(boolean flag) {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.axisinfo = flag;
        }
    }

    public void infoCam(boolean flag) {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.caminfo = flag;
        }
    }

    private void setLighting() {
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setEnable(true);
        ambientLight.setColor(new Color3f(0.5f, 0.5f, 0.5f));
        ambientLight.setCapability(12);
        ambientLight.setCapability(13);
        ambientLight.setInfluencingBounds((Bounds)this.bounds);
        this.contentsTransGr.addChild((Node)ambientLight);
        DirectionalLight dirLight = new DirectionalLight();
        dirLight.setEnable(true);
        dirLight.setColor(new Color3f(0.8f, 0.8f, 0.8f));
        dirLight.setDirection(new Vector3f(1.0f, 1.0f, 1.0f));
        dirLight.setCapability(13);
        dirLight.setInfluencingBounds((Bounds)this.bounds);
        this.contentsTransGr.addChild((Node)dirLight);
        DirectionalLight dirLight2 = new DirectionalLight();
        dirLight2.setEnable(true);
        dirLight2.setColor(new Color3f(0.7f, 0.7f, 0.7f));
        dirLight2.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f));
        dirLight2.setCapability(13);
        dirLight2.setInfluencingBounds((Bounds)this.bounds);
        this.contentsTransGr.addChild((Node)dirLight2);
    }

    private void setViewing() {
        this.viewBranch = new BranchGroup();
        this.viewTransGr = new TransformGroup();
        this.viewTransGr.setCapability(18);
        this.viewTransGr.setCapability(17);
        this.viewTransGr.setCapability(12);
        this.viewTransGr.setCapability(13);
        this.viewTransGr.setCapability(14);
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.views[i].setLayout(new BorderLayout());
            this.views[i].add((Component)((Object)this.cams[i].canvas), "Center");
            this.addCamera3D(this.cams[i]);
            this.cams[i].associatedrender = this;
            this.cams[i].canvas.startRenderer();
            this.cams[i].canvas.addMouseListener(this);
            this.cams[i].canvas.addMouseMotionListener(this);
            this.cams[i].canvas.addKeyListener(this);
            this.cams[i].canvas.addMouseWheelListener(this);
        }
        this.viewBranch.addChild((Node)this.viewTransGr);
        this.locale.addBranchGraph(this.viewBranch);
    }

    public void unFreeze() {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.addMouseListener(this);
            this.cams[i].canvas.addMouseMotionListener(this);
            this.cams[i].canvas.addKeyListener(this);
            this.cams[i].canvas.addMouseWheelListener(this);
        }
    }

    public void freeze() {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.removeMouseListener(this);
            this.cams[i].canvas.removeMouseMotionListener(this);
            this.cams[i].canvas.removeKeyListener(this);
            this.cams[i].canvas.removeMouseWheelListener(this);
        }
    }

    public void noBorder() {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.views[i].setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void border() {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.views[i].setBorder(BorderFactory.createBevelBorder(1));
        }
    }

    private void setUniverse() {
        this.universe = new VirtualUniverse();
        this.updatePreferencies();
        this.locale = new Locale(this.universe);
    }

    public void setCoordinateSystem() {
        Transform3D t = new Transform3D();
        t.rotX(Math.PI);
        t.rotY(0.0);
        t.rotZ(0.0);
        this.contentsTransGr.setTransform(t);
        this.viewTransGr.setTransform(t);
    }

    public TransformGroup getFlatSea() {
        TransformGroup ret = new TransformGroup();
        QuadArray GFront = new QuadArray(4, 1);
        Point3d bottomLeft = new Point3d(-1000.0, 0.0, -1000.0);
        Point3d bottomRight = new Point3d(-1000.0, 0.0, 1000.0);
        Point3d topLeft = new Point3d(1000.0, 0.0, -1000.0);
        Point3d topRight = new Point3d(1000.0, 0.0, 1000.0);
        GFront.setCoordinate(3, topLeft);
        GFront.setCoordinate(2, topRight);
        GFront.setCoordinate(1, bottomRight);
        GFront.setCoordinate(0, bottomLeft);
        Appearance appGFront = new Appearance();
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(0.5f);
        trans.setTransparencyMode(1);
        appGFront.setTransparencyAttributes(trans);
        GeometryInfo gi = new GeometryInfo((GeometryArray)GFront);
        Material mat = new Material();
        Color3f c = new Color3f();
        c.set(Color.BLUE);
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        mat.setShininess(0.1f);
        appGFront.setMaterial(mat);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        gi.recomputeIndices();
        gi.unindexify();
        gi.compact();
        PolygonAttributes p = new PolygonAttributes(2, 0, 0.0f);
        appGFront.setPolygonAttributes(p);
        GeometryArray geom = gi.getGeometryArray();
        geom.setCapability(4);
        Shape3D shape = new Shape3D((Geometry)geom, appGFront);
        ret.addChild((Node)shape);
        return ret;
    }

    @Override
    public MapGroup getMapGroup() {
        return this.myMapGroup;
    }

    @Override
    public void setMapGroup(MapGroup mapGroup) {
        this.reset();
        if (this.myMapGroup != null) {
            this.myMapGroup.removeChangeListener(this);
        }
        this.myMapGroup = mapGroup;
        this.focusLocation(mapGroup.getHomeRef().getCenterLocation());
        AbstractElement[] objs = mapGroup.getAllObjects();
        mapGroup.addChangeListener(this);
        for (int i = 0; i < objs.length; ++i) {
            Obj3D obj;
            if (!this.objects.containsKey(objs[i])) {
                if (objs[i] instanceof PathElement && ((PathElement)objs[i]).isFinished()) {
                    obj = new Obj3D();
                    obj.setModel3D(Object3DCreationHelper.getModel3DForRender(objs[i]));
                    obj.setPos(objs[i].getCenterLocation().getOffsetFrom(this.location));
                    obj.setRoll(objs[i].getRollRad());
                    obj.setPitch(objs[i].getPitchRad());
                    obj.setYaw(objs[i].getYawRad());
                    this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                    this.objects.put(objs[i], obj);
                }
                if (objs[i] instanceof PathElement) continue;
                if (objs[i] instanceof DynamicElement) {
                    obj = new Obj3D();
                    TransformGroup m3d = Object3DCreationHelper.getModel3DForRender(objs[i]);
                    if (m3d == null) {
                        return;
                    }
                    obj.setModel3D(m3d);
                    obj.setPos(objs[i].getCenterLocation().getOffsetFrom(this.location));
                    obj.setRoll(objs[i].getRollRad());
                    obj.setPitch(objs[i].getPitchRad());
                    obj.setYaw(objs[i].getYawRad());
                    this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                    this.objects.put(objs[i], obj);
                    obj.drawinfo = true;
                    continue;
                }
                obj = new Obj3D();
                obj.setModel3D(Object3DCreationHelper.getModel3DForRender(objs[i]));
                obj.setPos(objs[i].getCenterLocation().getOffsetFrom(this.location));
                obj.setRoll(objs[i].getRollRad());
                obj.setPitch(objs[i].getPitchRad());
                obj.setYaw(objs[i].getYawRad());
                this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                this.objects.put(objs[i], obj);
                continue;
            }
            obj = this.objects.get(objs[i]);
            obj.setPos(objs[i].getCenterLocation().getOffsetFrom(this.location));
            obj.setRoll(objs[i].getRollRad());
            obj.setPitch(objs[i].getPitchRad());
            obj.setYaw(objs[i].getYawRad());
            this.setTrans(objs[i], (float)objs[i].getTransparency() / 100.0f);
        }
    }

    @Override
    public void vehicleStateChanged(String sys, SystemPositionAndAttitude state) {
        if (this.stop_vehicles) {
            return;
        }
        VehicleType vehicle = VehiclesHolder.getVehicleById(sys);
        if (vehicle == null) {
            return;
        }
        if (!this.vehicles.containsKey(vehicle)) {
            this.lock.lock();
            Obj3D v3D = new Obj3D(Object3DCreationHelper.getVehicleModel3D(vehicle.getModel3DHref()));
            this.vehicles.put(vehicle, v3D);
            v3D.setPos(state.getPosition().getOffsetFrom(this.location));
            v3D.setRoll(state.getRoll());
            v3D.setPitch(state.getPitch());
            v3D.setYaw(state.getYaw());
            this.contentsNoPickTransGr.addChild((Node)v3D.getFullObj3D());
            this.lock.unlock();
        } else {
            Obj3D v3D = this.vehicles.get(vehicle);
            Point3d pos = new Point3d(state.getPosition().getOffsetFrom(this.location));
            v3D.setPos(pos);
            v3D.setRoll(state.getRoll());
            v3D.setPitch(state.getPitch());
            v3D.setYaw(state.getYaw());
            this.lock.lock();
            for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                if (vtailo.getVehicle() != vehicle) continue;
                vtailo.addNewVehicleState(state);
            }
            for (ProjectionObj p : this.projections) {
                if (!p.getVehicle().getId().equals(vehicle.getId())) continue;
                p.refreshObj(pos, state.getRoll(), state.getPitch(), state.getYaw());
            }
            this.lock.unlock();
        }
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###>angulo" + 2.0 * Math.toDegrees(Math.atan(0.2898550724637681))));
        ConfigFetch.initialize();
        VehiclesHolder.loadVehicles();
        VehicleType vehicle = VehiclesHolder.getVehicleById("lusitania");
        Camera3D[] cs = new Camera3D[]{new Camera3D(3)};
        cs[0].setScale(1.0);
        cs[0].setPivot(new Vector3d(0.0, 0.0, 0.0));
        cs[0].setPsi(0.0);
        cs[0].setRho(100.0);
        cs[0].setTheta(0.0);
        Renderer3D r = new Renderer3D(cs, 1, 1);
        LocationType loc = new LocationType();
        SystemPositionAndAttitude sv = new SystemPositionAndAttitude(loc, 0.0, 0.0, 0.0);
        sv = new SystemPositionAndAttitude(loc, 0.0, 0.0, 0.0);
        JFrame a = new JFrame("Render");
        a.setSize(640, 480);
        a.setDefaultCloseOperation(3);
        a.getContentPane().setLayout(new BorderLayout());
        a.getContentPane().add((Component)r, "Center");
        a.setVisible(true);
        while (true) {
            sv.setPitch(0.0);
            r.vehicleStateChanged(vehicle.getId(), sv);
        }
    }

    public void setMap(MapType map) {
    }

    public void lockView(int view, Obj3D obje) {
        if (obje == null) {
            if (this.cams[view].lockobj != null) {
                this.cams[view].lockobj.removeCamera3D(this.cams[view]);
                this.viewTransGr.addChild((Node)this.cams[view].getCamera3D());
            }
            this.cams[view].lock = null;
            this.cams[view].lockmapobj = null;
            this.cams[view].lockobj = null;
            return;
        }
        if (this.cams[view].lockobj == null) {
            this.viewTransGr.removeChild((Node)this.cams[view].getCamera3D());
            obje.addCamera3D(this.cams[view]);
            this.cams[view].lockobj = obje;
            this.cams[view].lock = null;
            this.cams[view].lockmapobj = null;
            Enumeration<AbstractElement> e = this.objects.keys();
            while (e.hasMoreElements()) {
                AbstractElement key = e.nextElement();
                Obj3D obj = this.objects.get(key);
                if (obj != obje) continue;
                this.cams[view].lockmapobj = key;
            }
            Enumeration<VehicleType> e1 = this.vehicles.keys();
            while (e1.hasMoreElements()) {
                VehicleType key = e1.nextElement();
                Obj3D obj = this.vehicles.get(key);
                if (obj != obje) continue;
                this.cams[view].lock = key;
            }
        } else {
            this.cams[view].lockobj.removeCamera3D(this.cams[view]);
            obje.addCamera3D(this.cams[view]);
            this.cams[view].lockobj = obje;
            this.cams[view].lock = null;
            this.cams[view].lockmapobj = null;
            Enumeration<AbstractElement> e = this.objects.keys();
            while (e.hasMoreElements()) {
                AbstractElement key = e.nextElement();
                Obj3D obj = this.objects.get(key);
                if (obj != obje) continue;
                this.cams[view].lockmapobj = key;
            }
            Enumeration<VehicleType> e1 = this.vehicles.keys();
            while (e1.hasMoreElements()) {
                VehicleType key = e1.nextElement();
                Obj3D obj = this.objects.get(key);
                if (obj != obje) continue;
                this.cams[view].lock = key;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("maximize".equals(e.getActionCommand())) {
            int i;
            for (i = 0; i < this.NVIEWS; ++i) {
                this.viewspanel.remove(this.views[i]);
            }
            for (i = 0; i < this.NVIEWS; ++i) {
                if (i == this.panel_op) continue;
                this.viewspanel.setLayout(new BorderLayout());
                this.cams[i].canvas.startRenderer();
                this.viewspanel.add((Component)this.views[i], "Center");
                this.viewspanel.doLayout();
                this.views[i].doLayout();
                this.panel_max = this.panel_op;
            }
            for (i = 0; i < this.NVIEWS; ++i) {
                this.viewspanel.remove(this.views[i]);
            }
            this.viewspanel.setLayout(new BorderLayout());
            this.cams[this.panel_op].canvas.startRenderer();
            this.viewspanel.add((Component)this.views[this.panel_op], "Center");
            this.viewspanel.doLayout();
            this.views[this.panel_op].doLayout();
            this.panel_max = this.panel_op;
            return;
        }
        if ("restore".equals(e.getActionCommand())) {
            this.viewspanel.remove(this.views[this.panel_op]);
            this.viewspanel.setLayout(new GridLayout(this.lines, this.coluns));
            for (int i = 0; i < this.NVIEWS; ++i) {
                this.cams[i].canvas.truePostRender();
                this.cams[i].canvas.startRenderer();
                this.cams[i].canvas.validate();
                this.viewspanel.doLayout();
                this.views[i].doLayout();
                this.viewspanel.add(this.views[i]);
                this.cams[i].canvas.addNotify();
            }
            this.viewspanel.doLayout();
            Dimension d2 = new Dimension();
            d2.setSize(1, 1);
            for (int i = 0; i < this.NVIEWS; ++i) {
                this.views[i].doLayout();
            }
            this.panel_max = (short)-1;
            return;
        }
        if ("lock".equals(e.getActionCommand())) {
            if (this.cams[this.panel_op].lock != this.veicle_op) {
                this.lockView(this.panel_op, this.vehicles.get(this.veicle_op));
            } else {
                this.lockView(this.panel_op, null);
            }
            return;
        }
        if ("move".equals(e.getActionCommand())) {
            if (this.viewing == 1) {
                this.setViewMode(-1);
            } else {
                this.setViewMode(1);
            }
            this.sendChangeEvent();
            return;
        }
        if ("zoom".equals(e.getActionCommand())) {
            if (this.viewing == 2) {
                this.setViewMode(-1);
            } else {
                this.setViewMode(2);
            }
            this.sendChangeEvent();
            return;
        }
        if ("rotate".equals(e.getActionCommand())) {
            if (this.viewing == 3) {
                this.setViewMode(-1);
            } else {
                this.setViewMode(3);
            }
            this.sendChangeEvent();
            return;
        }
        if ("ruler".equals(e.getActionCommand())) {
            if (this.viewing == 4) {
                this.setViewMode(-1);
            } else {
                this.setViewMode(4);
            }
            this.sendChangeEvent();
            return;
        }
        if ("resetmenu".equals(e.getActionCommand())) {
            return;
        }
        if ("resettop".equals(e.getActionCommand())) {
            this.cams[this.panel_op].resetTop();
            return;
        }
        if ("resetright".equals(e.getActionCommand())) {
            this.cams[this.panel_op].resetRight();
            return;
        }
        if ("resetback".equals(e.getActionCommand())) {
            this.cams[this.panel_op].resetBack();
            return;
        }
        if ("resetuser".equals(e.getActionCommand())) {
            this.cams[this.panel_op].resetUser();
            return;
        }
        if ("resetview".equals(e.getActionCommand())) {
            this.cams[this.panel_op].setType(this.cams[this.panel_op].type);
            return;
        }
        if ("sea flat".equals(e.getActionCommand())) {
            if (this.seaflatobj == null) {
                this.seaflatobj = new Obj3D(this.getFlatSea());
                this.seaflatobj.setRoll(-1.5707963267948966);
            }
            if (this.seaflat) {
                this.contentsTransGr.removeChild((Node)this.seaflatobj.getFullObj3D());
                this.seaflat = false;
            } else {
                Point3d centro = new Point3d(0.0, 0.0, 0.0);
                this.seaflatobj.setPos(centro);
                this.seaflatobj.setParent3D(this.contentsTransGr);
                this.seaflat = true;
            }
            return;
        }
        if ("map".equals(e.getActionCommand())) {
            if (this.mapa) {
                this.contentsTransGr.removeChild((Node)this.landscape);
                this.mapa = false;
            } else {
                this.activateMap();
                this.contentsTransGr.addChild((Node)this.landscape);
                this.mapa = true;
            }
            return;
        }
        if ("transparency".equals(e.getActionCommand())) {
            if (this.transp) {
                this.setNoTrans();
                this.transp = false;
            } else {
                this.setTrans();
                this.transp = true;
            }
            return;
        }
        if ("backsolid".equals(e.getActionCommand())) {
            this.setBackgroundType((short)1);
            return;
        }
        if ("backsky".equals(e.getActionCommand())) {
            this.setBackgroundType((short)2);
            return;
        }
        if ("backskyground".equals(e.getActionCommand())) {
            this.setBackgroundType((short)3);
            return;
        }
        if ("grid".equals(e.getActionCommand())) {
            if (this.grid) {
                this.contentsTransGr.removeChild((Node)this.gridobj.getFullObj3D());
                this.grid = false;
            } else {
                this.gridobj.setPos(this.gcenter);
                this.gridobj.setParent3D(this.contentsTransGr);
                this.grid = true;
            }
            return;
        }
        if ("menugrid".equals(e.getActionCommand())) {
            Grid3D.showGridDialog(this);
            return;
        }
        if ("Axis".equals(e.getActionCommand())) {
            if (this.axis) {
                this.axis = false;
                this.showAxis(this.axis);
            } else {
                this.axis = true;
                this.showAxis(this.axis);
            }
            return;
        }
        if ("infocamera".equals(e.getActionCommand())) {
            this.cams[this.panel_op].canvas.caminfo = !this.cams[this.panel_op].canvas.caminfo;
            return;
        }
        if ("infoaxis".equals(e.getActionCommand())) {
            this.cams[this.panel_op].canvas.axisinfo = !this.cams[this.panel_op].canvas.axisinfo;
            return;
        }
        if ("infoobj".equals(e.getActionCommand())) {
            this.cams[this.panel_op].canvas.objinfo = !this.cams[this.panel_op].canvas.objinfo;
            return;
        }
        if ("infoveicle".equals(e.getActionCommand())) {
            this.cams[this.panel_op].canvas.veicleinfo = !this.cams[this.panel_op].canvas.veicleinfo;
            return;
        }
        if ("iconsobj".equals(e.getActionCommand())) {
            this.cams[this.panel_op].canvas.objsicons = !this.cams[this.panel_op].canvas.objsicons;
            return;
        }
        if ("iconsvehicle".equals(e.getActionCommand())) {
            this.cams[this.panel_op].canvas.vehicleicons = !this.cams[this.panel_op].canvas.vehicleicons;
            return;
        }
        if ("propreties".equals(e.getActionCommand().substring(0, 10))) {
            Enumeration<AbstractElement> enuma = this.objects.keys();
            while (enuma.hasMoreElements()) {
                AbstractElement key = enuma.nextElement();
                if (!key.getId().equals(e.getActionCommand().substring(10))) continue;
                Properties3D.showPropreties3DDialog(this, key);
            }
            return;
        }
        if ("Enable Pick".equals(e.getActionCommand())) {
            // empty if block
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            this.cams[i].canvas.selected = false;
            if (e.getSource() != this.cams[i].canvas) continue;
            this.panel_op = (short)i;
            this.cams[this.panel_op].canvas.selected = true;
            this.cams[this.panel_op].setPhi(this.cams[i].phi);
        }
        if (e.getButton() == 1 && this.viewing == 4) {
            if (this.rule == 1) {
                this.rule = 0;
                this.cams[this.panel_op].canvas.reguainfo = false;
            } else {
                this.rule = 1;
                this.cams[this.panel_op].canvas.reguainfo = true;
                this.cams[this.panel_op].canvas.p1.x = e.getX();
                this.cams[this.panel_op].canvas.p1.y = e.getY();
                this.cams[this.panel_op].canvas.p2.x = e.getX();
                this.cams[this.panel_op].canvas.p2.y = e.getY();
            }
        }
        if (e.getButton() == 3) {
            JMenuItem chek;
            VehicleType vt;
            Enumeration<VehicleType> enuma;
            JMenuItem item;
            JPopupMenu popup = new JPopupMenu();
            popup.setLightWeightPopupEnabled(false);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            if (this.NVIEWS != 1) {
                item = new JMenuItem("Maximize");
                item.setActionCommand("maximize");
                item.addActionListener(this);
                if (this.panel_max != -1) {
                    item.setEnabled(false);
                }
                popup.add(item);
                item = new JMenuItem("Restore");
                item.setActionCommand("restore");
                if (this.panel_max == -1) {
                    item.setEnabled(false);
                }
                item.addActionListener(this);
                popup.add(item);
            }
            item = new JMenuItem("Reset View");
            item.setIcon(ImageUtils.getIcon("images/menus/restart.png"));
            item.setActionCommand("resetview");
            item.addActionListener(this);
            popup.add(item);
            item = new JMenu("Viewing");
            item.setIcon(ImageUtils.getIcon("images/menus/position.png"));
            popup.add(item);
            JCheckBoxMenuItem chekm = new JCheckBoxMenuItem("Move");
            chekm.setActionCommand("move");
            chekm.addActionListener(this);
            if (this.viewing == 1) {
                chekm.setSelected(true);
            }
            item.add(chekm);
            JCheckBoxMenuItem chekz = new JCheckBoxMenuItem("Zoom");
            chekz.setActionCommand("zoom");
            if (this.viewing == 2) {
                chekz.setSelected(true);
            }
            chekz.addActionListener(this);
            item.add(chekz);
            JCheckBoxMenuItem chekr = new JCheckBoxMenuItem("Rotate");
            chekr.setActionCommand("rotate");
            if (this.viewing == 3) {
                chekr.setSelected(true);
            }
            chekr.addActionListener(this);
            item.add(chekr);
            JCheckBoxMenuItem chekruler = new JCheckBoxMenuItem("Ruler");
            chekruler.setActionCommand("ruler");
            if (this.viewing == 4) {
                chekruler.setSelected(true);
            }
            chekruler.addActionListener(this);
            item.add(chekruler);
            JMenu reset = new JMenu("Select View");
            reset.setIcon(ImageUtils.getIcon("images/menus/view.png"));
            popup.add(reset);
            JMenuItem resetitem = new JMenuItem("Top");
            resetitem.setActionCommand("resettop");
            resetitem.addActionListener(this);
            reset.add(resetitem);
            resetitem = new JMenuItem("Right");
            resetitem.setActionCommand("resetright");
            resetitem.addActionListener(this);
            reset.add(resetitem);
            resetitem = new JMenuItem("Back");
            resetitem.setActionCommand("resetback");
            resetitem.addActionListener(this);
            reset.add(resetitem);
            resetitem = new JMenuItem("User");
            resetitem.setActionCommand("resetuser");
            resetitem.addActionListener(this);
            reset.add(resetitem);
            resetitem = new JMenuItem("Custom View...");
            resetitem.setActionCommand("custommenu");
            resetitem.addActionListener(this);
            reset.add(resetitem);
            popup.add(reset);
            JMenu edit = new JMenu("Settings");
            edit.setIcon(ImageUtils.getIcon("images/menus/configure.png"));
            JCheckBoxMenuItem seaflatonoff = new JCheckBoxMenuItem("Sea Flat");
            seaflatonoff.setActionCommand("sea flat");
            seaflatonoff.setSelected(this.seaflat);
            seaflatonoff.addActionListener(this);
            edit.add(seaflatonoff);
            if (this.mode == 0) {
                edit.addSeparator();
                JCheckBoxMenuItem transponoff = new JCheckBoxMenuItem("Transparency");
                transponoff.setActionCommand("transparency");
                transponoff.setSelected(this.transp);
                transponoff.addActionListener(this);
                edit.add(transponoff);
                JCheckBoxMenuItem map = new JCheckBoxMenuItem("Map");
                map.setActionCommand("map");
                map.setSelected(this.mapa);
                map.addActionListener(this);
                edit.add(map);
            }
            edit.addSeparator();
            JMenu back = new JMenu("Background");
            edit.add(back);
            chekm = new JCheckBoxMenuItem("Solid Color");
            chekm.setActionCommand("backsolid");
            chekm.addActionListener(this);
            if (this.background == 1) {
                chekm.setSelected(true);
            }
            back.add(chekm);
            chekm = new JCheckBoxMenuItem("Sky texture");
            chekm.setActionCommand("backsky");
            chekm.addActionListener(this);
            if (this.background == 2) {
                chekm.setSelected(true);
            }
            back.add(chekm);
            chekm = new JCheckBoxMenuItem("Sky/Ground texture");
            chekm.setActionCommand("backskyground");
            chekm.addActionListener(this);
            if (this.background == 3) {
                chekm.setSelected(true);
            }
            back.add(chekm);
            popup.add(edit);
            JMenu grid = new JMenu("Grid");
            JCheckBoxMenuItem gridonoff = new JCheckBoxMenuItem("grid");
            gridonoff.setActionCommand("grid");
            gridonoff.setSelected(this.grid);
            gridonoff.addActionListener(this);
            grid.add(gridonoff);
            if (this.mode == 1) {
                JCheckBoxMenuItem showAxis = new JCheckBoxMenuItem("Axis");
                showAxis.setActionCommand("Axis");
                showAxis.setSelected(this.axis);
                showAxis.addActionListener(this);
                grid.add(showAxis);
            }
            JMenuItem menugrid = new JMenuItem("Menu Grid");
            menugrid.setActionCommand("menugrid");
            menugrid.addActionListener(this);
            grid.add(menugrid);
            grid.setIcon(ImageUtils.getIcon("images/menus/grid.png"));
            popup.add(grid);
            if (this.mode == 0) {
                item = new JMenu("Lock");
                item.setIcon(ImageUtils.getIcon("images/menus/lock.png"));
                enuma = this.vehicles.keys();
                while (enuma.hasMoreElements()) {
                    vt = enuma.nextElement();
                    chek = new JCheckBoxMenuItem(vt.getName());
                    chek.setName(vt.getId());
                    chek.addActionListener(new ActionListener((JCheckBoxMenuItem)chek){
                        final /* synthetic */ JCheckBoxMenuItem val$chek;
                        {
                            this.val$chek = jCheckBoxMenuItem;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (VehiclesHolder.getVehicleById(this.val$chek.getName()) == null || Renderer3D.this.lockedVehicle != null && Renderer3D.this.lockedVehicle.equals(VehiclesHolder.getVehicleById(this.val$chek.getName()).getId())) {
                                Renderer3D.this.followVehicle(null);
                            } else {
                                Renderer3D.this.followVehicle(VehiclesHolder.getVehicleById(this.val$chek.getName()).getId());
                            }
                        }
                    });
                    item.add(chek);
                    if (this.cams[this.panel_op].lock == vt) {
                        chek.setSelected(true);
                    }
                    this.veicle_op = vt;
                }
                popup.add(item);
                item = new JMenu("Infos");
                item.setIcon(ImageUtils.getIcon("images/menus/comment.png"));
                popup.add(item);
                chekm = new JCheckBoxMenuItem("Camera");
                chekm.setActionCommand("infocamera");
                chekm.addActionListener(this);
                if (this.cams[this.panel_op].canvas.caminfo) {
                    chekm.setSelected(true);
                }
                item.add(chekm);
                chekz = new JCheckBoxMenuItem("Axis");
                chekz.setActionCommand("infoaxis");
                if (this.cams[this.panel_op].canvas.axisinfo) {
                    chekz.setSelected(true);
                }
                chekz.addActionListener(this);
                item.add(chekz);
                chekz = new JCheckBoxMenuItem("Objects");
                chekz.setActionCommand("infoobj");
                if (this.cams[this.panel_op].canvas.objinfo) {
                    chekz.setSelected(true);
                }
                chekz.addActionListener(this);
                item.add(chekz);
                chekr = new JCheckBoxMenuItem("Vehicle");
                chekr.setActionCommand("infoveicle");
                if (this.cams[this.panel_op].canvas.veicleinfo) {
                    chekr.setSelected(true);
                }
                chekr.addActionListener(this);
                item.add(chekr);
                JCheckBoxMenuItem chekiconso = new JCheckBoxMenuItem("Objects Icons");
                chekiconso.setActionCommand("iconsobj");
                if (this.cams[this.panel_op].canvas.objsicons) {
                    chekiconso.setSelected(true);
                }
                chekiconso.addActionListener(this);
                item.add(chekiconso);
                JCheckBoxMenuItem chekiconsv = new JCheckBoxMenuItem("Vehicle Icons");
                chekiconsv.setActionCommand("iconsvehicle");
                if (this.cams[this.panel_op].canvas.vehicleicons) {
                    chekiconsv.setSelected(true);
                }
                chekiconsv.addActionListener(this);
                item.add(chekiconsv);
                item = new JMenu("Properties");
                item.setIcon(ImageUtils.getIcon("images/menus/list.png"));
                Enumeration<AbstractElement> enuma2 = this.objects.keys();
                while (enuma2.hasMoreElements()) {
                    AbstractElement vt2 = enuma2.nextElement();
                    JMenuItem iten = new JMenuItem(vt2.getId());
                    item.add(iten);
                    iten.setActionCommand("propreties" + vt2.getId());
                    iten.addActionListener(this);
                }
            }
            popup.add(item);
            if (this.console != null) {
                item = new JMenu("Projection");
                item.setIcon(ImageUtils.getIcon("images/menus/camera.png"));
                enuma = this.vehicles.keys();
                while (enuma.hasMoreElements()) {
                    vt = enuma.nextElement();
                    chek = new JMenuItem(vt.getName());
                    chek.setName(vt.getId());
                    chek.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (Renderer3D.this.getConsole().getSubPanelsOfClass(JVideoPanelConsole.class).isEmpty()) {
                                GuiUtils.errorMessage(null, "Console error (render projection)", "No JMF Video Panels activated in console");
                            } else {
                                VehicleType vsProj = VehiclesHolder.getVehicleById(chek.getName());
                                ProjectionObj projObj = null;
                                for (ProjectionObj po : Renderer3D.this.projections) {
                                    if (!po.getVehicle().getId().equals(vsProj.getId())) continue;
                                    projObj = po;
                                }
                                if (projObj == null) {
                                    projObj = new ProjectionObj(Renderer3D.this, vsProj);
                                    projObj.setGridResolutionH(2);
                                    projObj.setGridResolutionV(2);
                                    Renderer3D.this.projections.add(projObj);
                                }
                                PropertiesEditor.editProperties(new ProjectionPropertiesProvider(projObj), true);
                            }
                        }
                    });
                    item.add(chek);
                }
                popup.add(item);
            }
            if (this.console != null) {
                item = new JMenu("Sonar display");
                item.setIcon(ImageUtils.getIcon("images/menus/sensor.png"));
                enuma = this.vehicles.keys();
                while (enuma.hasMoreElements()) {
                    vt = enuma.nextElement();
                    chek = new JMenuItem(vt.getName());
                    chek.setName(vt.getId());
                    chek.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            VehicleType vsProj = VehiclesHolder.getVehicleById(chek.getName());
                            SensorObj sensorObj = null;
                            for (SensorObj po : Renderer3D.this.sensors) {
                                if (!po.getVehicle().getId().equals(vsProj.getId())) continue;
                                sensorObj = po;
                            }
                            if (sensorObj == null) {
                                sensorObj = new SensorObj(Renderer3D.this, vsProj);
                                Renderer3D.this.sensors.add(sensorObj);
                            }
                            PropertiesEditor.editProperties(new SensorPropertiesProvider(sensorObj), true);
                        }
                    });
                    item.add(chek);
                }
                popup.add(item);
            }
            item = new JMenuItem("R3D Shortcuts");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiUtils.htmlMessage(ConfigFetch.getSuperParentFrame(), "3D Renderer Shortcuts", "(Keys pressed while the Renderer component is focused)", "<html><h1>3D Renderer Shortcuts </h1><table border='1' align='center'><tr><td><div align='center'><strong>Key Combination</strong></div></td><td><div align='center'><strong>Action</strong></div></td></tr><tr><td>F1</td><td>Reset to Top View(x,y)</td></tr><tr><td>F2</td><td>Reset to Right View(z,x)</td></tr><tr><td>F3</td><td>Reset to Front View(z,y)</td></tr><tr><td>F4</td><td>Reset to Perspective View</td></tr><tr><td>Ctrl+R</td><td>Rotation Control Mode </td></tr><tr><td>Ctrl+M or Ctrl+T</td><td>Translation Control Mode</td></tr><tr><td>Ctrl+Z</td><td>Zoom Control Mode</td></tr><tr><td>Shift+Mouse Wheel </td><td>Move Back and Front clipping area</td></tr></table></html>");
                }
            });
            item.setIcon(ImageUtils.getIcon("images/menus/info.png"));
            popup.add(item);
            popup.show(this.views[this.panel_op], e.getX(), e.getY());
        }
    }

    public Point3d fireRay(Point3d p, Vector3d dir) {
        this.pickTool.setShapeRay(p, dir);
        PickResult result = this.pickTool.pickClosest();
        if (result == null) {
            return null;
        }
        return result.getClosestIntersection(p).getPointCoordinatesVW();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mouse1 = true;
            this.mousex = e.getX();
            this.mousey = e.getY();
        }
        if (e.getButton() == 3) {
            this.mouse3 = true;
            this.mousex = e.getX();
            this.mousey = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mouse1 = false;
        }
        if (e.getButton() == 3) {
            this.mouse3 = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int my;
        int mx;
        int i;
        if (this.mouse1) {
            if (this.viewing == 3) {
                for (i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
                    if (e.getSource() != this.cams[i].canvas) continue;
                    mx = e.getX();
                    my = e.getY();
                    if (e.isShiftDown() || this.cams[i].projection == 1) {
                        this.cams[i].setPsi(this.cams[i].psi + (double)(this.mousex - mx) / 50.0);
                        this.cams[i].setTheta(this.cams[i].theta + (double)(this.mousey - my) / 50.0);
                    } else {
                        this.cams[i].setPhi(this.cams[i].phi + (double)(this.mousex - mx) / 50.0);
                    }
                    this.mousex = mx;
                    this.mousey = my;
                }
            }
            if (this.viewing == 1) {
                for (i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
                    if (e.getSource() != this.cams[i].canvas) continue;
                    int auxx = this.views[i].getWidth();
                    int auxy = this.views[i].getHeight();
                    int mx2 = e.getX();
                    int my2 = e.getY();
                    int difx = this.mousex - mx2;
                    int dify = this.mousey - my2;
                    switch (this.cams[i].type) {
                        case 0: {
                            Vector3d vaux2;
                            Vector3d vaux;
                            Vector3d vec;
                            if (!e.isShiftDown()) {
                                vec = this.cams[i].pivot;
                                vaux = new Vector3d();
                                vaux.y = 1.0;
                                vaux.x = 1.0;
                                vaux.y = (double)difx / (this.cams[i].scale / 2.0) / (double)auxx;
                                vaux.x = (double)(-dify) / (this.cams[i].scale / 1.51) / (double)auxy;
                                vaux2 = new Vector3d();
                                vaux2.x = vaux.x * Math.cos(-this.cams[i].phi) - vaux.y * Math.sin(-this.cams[i].phi);
                                vaux2.y = vaux.x * Math.sin(-this.cams[i].phi) + vaux.y * Math.cos(-this.cams[i].phi);
                                vec.y += vaux2.y;
                                vec.x += vaux2.x;
                                this.cams[i].setPivot(vec);
                                break;
                            }
                            vec = this.cams[i].pivot;
                            vec.z += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        case 2: {
                            Vector3d vaux2;
                            Vector3d vaux;
                            Vector3d vec;
                            if (!e.isShiftDown()) {
                                vec = this.cams[i].pivot;
                                vaux = new Vector3d();
                                vaux.x = 1.0;
                                vaux.z = 1.0;
                                vaux.x = (double)(-difx) / (this.cams[i].scale / 2.0) / (double)auxx;
                                vaux.z = (double)(-dify) / (this.cams[i].scale / 1.51) / (double)auxy;
                                vaux2 = new Vector3d();
                                vaux2.x = vaux.x * Math.cos(-this.cams[i].phi) - vaux.z * Math.sin(-this.cams[i].phi);
                                vaux2.z = vaux.x * Math.sin(-this.cams[i].phi) + vaux.z * Math.cos(-this.cams[i].phi);
                                vec.x += vaux2.x;
                                vec.z += vaux2.z;
                                this.cams[i].setPivot(vec);
                                break;
                            }
                            vec = this.cams[i].pivot;
                            vec.y += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        case 1: {
                            Vector3d vaux2;
                            Vector3d vaux;
                            Vector3d vec;
                            if (!e.isShiftDown()) {
                                vec = this.cams[i].pivot;
                                vaux = new Vector3d();
                                vaux.y = 1.0;
                                vaux.z = 1.0;
                                vaux.y = (double)(-difx) / (this.cams[i].scale / 2.0) / (double)auxx;
                                vaux.z = (double)(-dify) / (this.cams[i].scale / 1.51) / (double)auxy;
                                vaux2 = new Vector3d();
                                vaux2.y = vaux.y * Math.cos(-this.cams[i].phi) - vaux.z * Math.sin(-this.cams[i].phi);
                                vaux2.z = vaux.y * Math.sin(-this.cams[i].phi) + vaux.z * Math.cos(-this.cams[i].phi);
                                vec.y += vaux2.y;
                                vec.z += vaux2.z;
                                this.cams[i].setPivot(vec);
                                break;
                            }
                            vec = this.cams[i].pivot;
                            vec.x += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        case 3: {
                            Vector3d vaux2;
                            Vector3d vaux;
                            Vector3d vec;
                            if (!e.isShiftDown()) {
                                vec = this.cams[i].pivot;
                                vaux = new Vector3d();
                                vaux.y = 1.0;
                                vaux.x = 1.0;
                                vaux.y = (double)(-difx) / (150.0 / this.cams[i].rho);
                                vaux.x = (double)(-dify) / (150.0 / this.cams[i].rho);
                                vaux2 = new Vector3d();
                                vaux2.x = vaux.y * Math.cos(this.cams[i].psi) - vaux.x * Math.sin(this.cams[i].psi);
                                vaux2.y = vaux.y * Math.sin(this.cams[i].psi) + vaux.x * Math.cos(this.cams[i].psi);
                                vec.y += vaux2.y;
                                vec.x += vaux2.x;
                                this.cams[i].setPivot(vec);
                                break;
                            }
                            vec = this.cams[i].pivot;
                            vec.z += (double)dify / (150.0 / this.cams[i].rho);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        default: {
                            Vector3d vec;
                            if (!e.isShiftDown()) {
                                vec = this.cams[i].pivot;
                                vec.x += (double)difx / (this.cams[i].scale * 150.0);
                                vec.y += (double)(-dify) / (this.cams[i].scale * 150.0);
                                this.cams[i].setPivot(vec);
                                break;
                            }
                            vec = this.cams[i].pivot;
                            vec.z += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                        }
                    }
                    this.mousex = mx2;
                    this.mousey = my2;
                }
            }
            if (this.viewing == 2) {
                for (i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
                    if (e.getSource() != this.cams[i].canvas) continue;
                    mx = e.getX();
                    my = e.getY();
                    if (this.cams[i].projection == 1) {
                        if (!e.isShiftDown()) {
                            this.cams[i].setRho(this.cams[i].rho + (double)(my - this.mousey) / 30.0);
                        } else {
                            this.cams[i].setScale(this.cams[i].scale + (double)(my - this.mousey) / 150.0);
                        }
                    } else if (!e.isShiftDown()) {
                        this.cams[i].setScale(this.cams[i].scale + (double)(this.mousey - my) / 150.0);
                    } else {
                        this.cams[i].setRho(this.cams[i].rho + (double)(this.mousey - my) / 30.0);
                    }
                    this.mousex = mx;
                    this.mousey = my;
                }
            }
        }
        if (this.mouse3) {
            if (this.viewing == 3) {
                for (i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
                    if (e.getSource() != this.cams[i].canvas) continue;
                    mx = e.getX();
                    my = e.getY();
                    this.cams[i].setPhi(this.cams[i].phi + (double)(this.mousex - mx) / 50.0);
                    this.mousex = mx;
                    this.mousey = my;
                }
            }
            if (this.viewing == 1) {
                for (i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
                    if (e.getSource() != this.cams[i].canvas) continue;
                    mx = e.getX();
                    my = e.getY();
                    int difx = this.mousex - mx;
                    int dify = this.mousey - my;
                    switch (this.cams[i].type) {
                        case 0: {
                            Vector3d vec = this.cams[i].pivot;
                            vec.z += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        case 2: {
                            Vector3d vec = this.cams[i].pivot;
                            vec.y += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        case 1: {
                            Vector3d vec = this.cams[i].pivot;
                            vec.x += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        case 3: {
                            Vector3d vec = this.cams[i].pivot;
                            vec.z += (double)dify / (150.0 / this.cams[i].rho);
                            this.cams[i].setPivot(vec);
                            break;
                        }
                        default: {
                            Vector3d vec = this.cams[i].pivot;
                            vec.z += (double)dify / (this.cams[i].scale * 150.0);
                            this.cams[i].setPivot(vec);
                        }
                    }
                    this.mousex = mx;
                    this.mousey = my;
                }
            }
            if (this.viewing == 2) {
                for (i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
                    if (e.getSource() != this.cams[i].canvas) continue;
                    mx = e.getX();
                    my = e.getY();
                    if (this.cams[i].projection == 1) {
                        this.cams[i].setScale(this.cams[i].scale + (double)(my - this.mousey) / 150.0);
                    } else {
                        this.cams[i].setRho(this.cams[i].rho + (double)(this.mousey - my) / 30.0);
                    }
                    this.mousex = mx;
                    this.mousey = my;
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.viewing == 4 && e.getSource() == this.cams[this.panel_op].canvas && this.rule == 1) {
            this.cams[this.panel_op].canvas.p2.x = e.getX();
            this.cams[this.panel_op].canvas.p2.y = e.getY();
            this.cams[this.panel_op].setPhi(this.cams[this.panel_op].phi);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void focusLocation(LocationType location) {
        double[] newpos;
        double[] newpos2;
        double[] d = new double[3];
        d = this.location.getOffsetFrom(location);
        for (Obj3D obj : this.objs3D) {
            double[] newpos22 = obj.pos;
            newpos22[0] = newpos22[0] + d[0];
            newpos22[1] = newpos22[1] + d[1];
            newpos22[2] = newpos22[2] + d[2];
            obj.setPos(newpos22);
        }
        if (this.seaobj != null) {
            newpos2 = this.seaobj.pos;
            newpos2[0] = newpos2[0] + d[0];
            newpos2[1] = newpos2[1] + d[1];
            newpos2[2] = newpos2[2] + d[2];
            this.seaobj.setPos(newpos2);
        }
        if (this.seaflatobj != null) {
            newpos2 = this.seaflatobj.pos;
            newpos2[0] = newpos2[0] + d[0];
            newpos2[1] = newpos2[1] + d[1];
            newpos2[2] = newpos2[2] + d[2];
            this.seaflatobj.setPos(newpos2);
        }
        if (this.gridobj != null) {
            newpos2 = this.gridobj.pos;
            newpos2[0] = newpos2[0] + d[0];
            newpos2[1] = newpos2[1] + d[1];
            newpos2[2] = newpos2[2] + d[2];
            this.gridobj.setPos(newpos2);
        }
        Enumeration<VehicleType> enuma = this.vehicles.keys();
        while (enuma.hasMoreElements()) {
            VehicleType vt = enuma.nextElement();
            Obj3D v3D = this.vehicles.get(vt);
            newpos = v3D.pos;
            newpos[0] = newpos[0] + d[0];
            newpos[1] = newpos[1] + d[1];
            newpos[2] = newpos[2] + d[2];
            v3D.setPos(newpos);
        }
        for (Obj3D obj : this.objects.values()) {
            double[] newpos3 = obj.pos;
            newpos3[0] = newpos3[0] + d[0];
            newpos3[1] = newpos3[1] + d[1];
            newpos3[2] = newpos3[2] + d[2];
            obj.setPos(newpos3);
        }
        for (VehicleTailObj3D tailobj : this.VehiclesTails) {
            newpos = tailobj.pos;
            newpos[0] = newpos[0] + d[0];
            newpos[1] = newpos[1] + d[1];
            newpos[2] = newpos[2] + d[2];
            tailobj.setPos(newpos);
        }
        this.location.setLocation(location);
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].setType(this.cams[i].getType());
        }
    }

    @Override
    public void focusObject(AbstractElement mo) {
        this.focusLocation(mo.getCenterLocation());
    }

    private Cylinder foundCylinder(TransformGroup model) {
        Enumeration childs = model.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (child instanceof Cylinder) {
                return (Cylinder)child;
            }
            if (!(child instanceof TransformGroup)) continue;
            return this.foundCylinder((TransformGroup)child);
        }
        return null;
    }

    public void setNoTrans() {
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            TransparencyAttributes trans;
            Appearance appearance3;
            Sphere shape;
            TransformGroup model;
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key instanceof EllipsoidElement) {
                model = obj.getModel3D();
                shape = Util3D.foundSphere(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparencyMode(4);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (key instanceof CylinderElement) {
                model = obj.getModel3D();
                shape = this.foundCylinder(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparencyMode(4);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (!(key instanceof ParallelepipedElement)) continue;
            model = obj.getModel3D();
            shape = Util3D.foundBox(model);
            appearance3 = shape.getAppearance();
            trans = new TransparencyAttributes();
            trans.setTransparencyMode(4);
            trans.setCapability(3);
            trans.setCapability(2);
            appearance3.setTransparencyAttributes(trans);
            shape.setAppearance(appearance3);
        }
    }

    public void setTrans() {
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            TransparencyAttributes trans;
            Appearance appearance3;
            Sphere shape;
            TransformGroup model;
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key instanceof EllipsoidElement) {
                model = obj.getModel3D();
                shape = Util3D.foundSphere(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparency(0.3f);
                trans.setTransparencyMode(1);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (key instanceof CylinderElement) {
                model = obj.getModel3D();
                shape = this.foundCylinder(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparency(0.3f);
                trans.setTransparencyMode(1);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (!(key instanceof ParallelepipedElement)) continue;
            model = obj.getModel3D();
            shape = Util3D.foundBox(model);
            appearance3 = shape.getAppearance();
            trans = new TransparencyAttributes();
            trans.setTransparency(0.3f);
            trans.setTransparencyMode(1);
            trans.setCapability(3);
            trans.setCapability(2);
            appearance3.setTransparencyAttributes(trans);
            shape.setAppearance(appearance3);
        }
    }

    public void setTrans(AbstractElement obje) {
        this.setTrans(obje, 0.3f);
    }

    public void setTrans(AbstractElement obje, float transp) {
        if (transp >= 0.95f) {
            this.hide(obje);
            return;
        }
        if (transp <= 0.5f) {
            this.setNoTrans(obje);
        }
        this.unHide(obje);
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            TransparencyAttributes trans;
            Appearance appearance3;
            Sphere shape;
            TransformGroup model;
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key != obje) continue;
            if (key instanceof EllipsoidElement) {
                model = obj.getModel3D();
                shape = Util3D.foundSphere(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparency(transp);
                trans.setTransparencyMode(1);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (key instanceof CylinderElement) {
                model = obj.getModel3D();
                shape = this.foundCylinder(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparency(transp);
                trans.setTransparencyMode(1);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (key instanceof ParallelepipedElement) {
                model = obj.getModel3D();
                shape = Util3D.foundBox(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparency(transp);
                trans.setTransparencyMode(1);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (!(key instanceof ImageElement)) continue;
            model = obj.getModel3D();
            shape = Util3D.foundImageShape(model);
            appearance3 = shape.getAppearance();
            trans = appearance3.getTransparencyAttributes();
            trans.setTransparency(transp);
            trans.setTransparencyMode(1);
        }
    }

    public void setNoTrans(AbstractElement obje) {
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            TransparencyAttributes trans;
            Appearance appearance3;
            Sphere shape;
            TransformGroup model;
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key != obje) continue;
            if (key instanceof ImageElement) {
                // empty if block
            }
            if (key instanceof EllipsoidElement) {
                model = obj.getModel3D();
                shape = Util3D.foundSphere(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparencyMode(4);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (key instanceof CylinderElement) {
                model = obj.getModel3D();
                shape = this.foundCylinder(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparencyMode(4);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (key instanceof ParallelepipedElement) {
                model = obj.getModel3D();
                shape = Util3D.foundBox(model);
                appearance3 = shape.getAppearance();
                trans = new TransparencyAttributes();
                trans.setTransparencyMode(4);
                trans.setCapability(3);
                trans.setCapability(2);
                appearance3.setTransparencyAttributes(trans);
                shape.setAppearance(appearance3);
            }
            if (!(key instanceof ImageElement)) continue;
            model = obj.getModel3D();
            shape = Util3D.foundImageShape(model);
            appearance3 = shape.getAppearance();
            trans = appearance3.getTransparencyAttributes();
            trans.setTransparencyMode(4);
        }
    }

    public boolean isTrans(AbstractElement obje) {
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key != obje) continue;
            if (key instanceof EllipsoidElement) {
                TransformGroup model = obj.getModel3D();
                Sphere shape = Util3D.foundSphere(model);
                Appearance appearance3 = shape.getAppearance();
                TransparencyAttributes trans = new TransparencyAttributes();
                trans = appearance3.getTransparencyAttributes();
                return (double)trans.getTransparency() > 0.0;
            }
            if (key instanceof CylinderElement) {
                TransformGroup model = obj.getModel3D();
                Cylinder shape = this.foundCylinder(model);
                Appearance appearance3 = shape.getAppearance();
                TransparencyAttributes trans = new TransparencyAttributes();
                trans.setCapability(2);
                trans = appearance3.getTransparencyAttributes();
                return (double)trans.getTransparency() > 0.0;
            }
            if (key instanceof ParallelepipedElement) {
                TransformGroup model = obj.getModel3D();
                Box shape = Util3D.foundBox(model);
                Appearance appearance3 = shape.getAppearance();
                TransparencyAttributes trans = new TransparencyAttributes();
                trans.setCapability(2);
                trans = appearance3.getTransparencyAttributes();
                return (double)trans.getTransparency() > 0.0;
            }
            if (!(key instanceof ImageElement)) continue;
            TransformGroup model = obj.getModel3D();
            Shape3D shape = Util3D.foundImageShape(model);
            Appearance appearance3 = shape.getAppearance();
            TransparencyAttributes trans = new TransparencyAttributes();
            trans.setCapability(2);
            trans = appearance3.getTransparencyAttributes();
            return trans.getTransparencyMode() != 4;
        }
        return false;
    }

    public void hide(AbstractElement obje) {
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key != obje || obj.hide) continue;
            obj.hide = true;
            this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
        }
    }

    public void unHide(AbstractElement obje) {
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            if (key != obje || !obj.hide) continue;
            obj.hide = false;
            this.contentsTransGr.addChild((Node)obj.getFullObj3D());
        }
    }

    public void reset() {
        for (int i = 0; i < this.NVIEWS; ++i) {
            if (this.cams[i].lockmapobj == null) continue;
            this.lockView(i, null);
        }
        Enumeration<AbstractElement> e = this.objects.keys();
        while (e.hasMoreElements()) {
            AbstractElement key = e.nextElement();
            Obj3D obj = this.objects.get(key);
            this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
        }
        this.objects.clear();
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            this.cams[i].setPivot(new Vector3d(0.0, 0.0, 0.0));
        }
    }

    @Override
    public void mapChanged(MapChangeEvent mapChange) {
        if (mapChange.getEventType() == -1) {
            if (mapChange.getMapGroup() == null) {
                return;
            }
            for (int i = 0; i < this.NVIEWS; ++i) {
                if (this.cams[i].lockmapobj == null) continue;
                this.lockView(i, null);
            }
            Enumeration<AbstractElement> e = this.objects.keys();
            while (e.hasMoreElements()) {
                AbstractElement key = e.nextElement();
                Obj3D obj = this.objects.get(key);
                this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
            }
            this.objects.clear();
            this.setMapGroup(mapChange.getMapGroup());
            return;
        }
        if (mapChange.getEventType() == 0) {
            this.lock.lock();
            AbstractElement objs = mapChange.getChangedObject();
            if (objs == null) {
                this.lock.unlock();
                return;
            }
            if (objs instanceof ScatterPointsElement) {
                Obj3D obj;
                ScatterPointsElement objscatter = (ScatterPointsElement)objs;
                if (objscatter.getLastAdded() == null && objscatter.getLastRemoved() == null) {
                    Obj3D obj2 = this.objects.get(objs);
                    if (obj2 == null) {
                        this.lock.unlock();
                        return;
                    }
                    Obj3D aux = obj2;
                    boolean transpaux = this.isTrans(objs);
                    this.contentsTransGr.removeChild((Node)obj2.getFullObj3D());
                    obj2 = objscatter.getFullObj3D(this.location);
                    this.contentsTransGr.addChild((Node)obj2.getFullObj3D());
                    this.objects.put(objs, obj2);
                    if (transpaux) {
                        this.setTrans(objs);
                    } else {
                        this.setNoTrans(objs);
                    }
                    for (int i = 0; i < this.NVIEWS; ++i) {
                        if (this.cams[i].lockobj != aux) continue;
                        this.lockView(i, obj2);
                    }
                    this.lock.unlock();
                    return;
                }
                if (objscatter.getLastAdded() != null && (obj = this.objects.get(objs)) != null && objscatter != null) {
                    Obj3D[] objarray;
                    if (obj.getObj3DChildsLength() > objscatter.getNumberOfPoints() * 2) {
                        obj.removeLastNObj3D(obj.getObj3DChildsLength() - objscatter.getNumberOfPoints() * 2);
                    }
                    if ((objarray = objscatter.getLastAddedModel3D()) != null && objarray[0] != null) {
                        obj.addObj3D(objarray[0]);
                    }
                }
                this.lock.unlock();
                return;
            }
            if (objs instanceof PathElement && ((PathElement)objs).isFinished()) {
                Obj3D obj = this.objects.get(objs);
                if (obj == null) {
                    obj = new Obj3D();
                    obj.setModel3D(Object3DCreationHelper.getModel3DForRender(objs));
                    obj.setPos(objs.getCenterLocation().getOffsetFrom(this.location));
                    obj.setRoll(objs.getRollRad());
                    obj.setPitch(objs.getPitchRad());
                    obj.setYaw(objs.getYawRad());
                    this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                    this.objects.put(objs, obj);
                    this.lock.unlock();
                    return;
                }
                Obj3D aux = obj;
                this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
                obj = new Obj3D();
                obj.setModel3D(Object3DCreationHelper.getModel3DForRender(objs));
                System.err.println("entro:" + mapChange.getChangeType());
                obj.setPos(objs.getCenterLocation().getOffsetFrom(this.location));
                obj.setRoll(objs.getRollRad());
                obj.setPitch(objs.getPitchRad());
                obj.setYaw(objs.getYawRad());
                this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                this.objects.put(objs, obj);
                for (int i = 0; i < this.NVIEWS; ++i) {
                    if (this.cams[i].lockobj != aux) continue;
                    this.lockView(i, obj);
                }
                this.lock.unlock();
                return;
            }
            if (!(objs instanceof PathElement)) {
                Obj3D obj = this.objects.get(objs);
                if (obj == null) {
                    this.lock.unlock();
                    return;
                }
                Obj3D aux = obj;
                if (mapChange.getChangeType().equals("OBJECT_SCALED") || mapChange.getChangeType().equals("UNKNOWN_CHANGE")) {
                    this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
                    obj = new Obj3D();
                    obj.setModel3D(Object3DCreationHelper.getModel3DForRender(objs));
                }
                obj.setPos(objs.getCenterLocation().getOffsetFrom(this.location));
                obj.setRoll(objs.getRollRad());
                obj.setPitch(objs.getPitchRad());
                obj.setYaw(objs.getYawRad());
                if (mapChange.getChangeType().equals("OBJECT_SCALED") || mapChange.getChangeType().equals("UNKNOWN_CHANGE")) {
                    this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                    this.objects.put(objs, obj);
                }
                this.setTrans(objs, (float)objs.getTransparency() / 100.0f);
                for (int i = 0; i < this.NVIEWS; ++i) {
                    if (this.cams[i].lockobj != aux) continue;
                    this.lockView(i, obj);
                }
                this.lock.unlock();
                return;
            }
            this.lock.unlock();
            return;
        }
        if (mapChange.getEventType() == 2) {
            AbstractElement objs = mapChange.getChangedObject();
            if (objs == null) {
                return;
            }
            if (this.objects.containsKey(objs)) {
                return;
            }
            if (objs instanceof ScatterPointsElement) {
                ScatterPointsElement objscatter = (ScatterPointsElement)objs;
                Obj3D obj = objscatter.getFullObj3D(this.location);
                this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                this.objects.put(objs, obj);
                return;
            }
            if (objs instanceof DynamicElement) {
                Obj3D obj = new Obj3D();
                TransformGroup m3d = Object3DCreationHelper.getModel3DForRender(objs);
                if (m3d == null) {
                    return;
                }
                obj.setModel3D(m3d);
                obj.setPos(objs.getCenterLocation().getOffsetFrom(this.location));
                obj.setRoll(objs.getRollRad());
                obj.setPitch(objs.getPitchRad());
                obj.setYaw(objs.getYawRad());
                this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                this.objects.put(objs, obj);
                System.err.println("---------------");
                obj.drawinfo = true;
                return;
            }
            if (objs instanceof PathElement && ((PathElement)objs).isFinished()) {
                Obj3D obj = new Obj3D();
                obj.setModel3D(Object3DCreationHelper.getModel3DForRender(objs));
                obj.setPos(objs.getCenterLocation().getOffsetFrom(this.location));
                obj.setRoll(objs.getRollRad());
                obj.setPitch(objs.getPitchRad());
                obj.setYaw(objs.getYawRad());
                this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                this.objects.put(objs, obj);
                return;
            }
            if (!(objs instanceof PathElement)) {
                Obj3D obj = new Obj3D();
                TransformGroup m3d = Object3DCreationHelper.getModel3DForRender(objs);
                if (m3d == null) {
                    return;
                }
                obj.setModel3D(m3d);
                obj.setPos(objs.getCenterLocation().getOffsetFrom(this.location));
                obj.setRoll(objs.getRollRad());
                obj.setPitch(objs.getPitchRad());
                obj.setYaw(objs.getYawRad());
                this.contentsTransGr.addChild((Node)obj.getFullObj3D());
                this.objects.put(objs, obj);
                return;
            }
            return;
        }
        if (mapChange.getEventType() == 1) {
            AbstractElement objs = mapChange.getChangedObject();
            if (objs == null) {
                NeptusLog.pub().warn((Object)("Map changed : Changed object is null! - " + this));
                return;
            }
            Obj3D obj = this.objects.get(objs);
            if (obj == null) {
                return;
            }
            for (int i = 0; i < this.NVIEWS; ++i) {
                if (this.cams[i] == null || this.cams[i].lockobj != obj) continue;
                this.lockView(i, null);
            }
            if (this.contentsTransGr != null) {
                this.contentsTransGr.removeChild((Node)obj.getFullObj3D());
            }
            this.objects.remove(objs);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            if (e.getSource() != this.cams[i].canvas) continue;
            if (112 == e.getKeyCode()) {
                this.cams[i].resetTop();
            }
            if (113 == e.getKeyCode()) {
                this.cams[i].resetRight();
            }
            if (114 == e.getKeyCode()) {
                this.cams[i].resetBack();
            }
            if (115 == e.getKeyCode()) {
                this.cams[i].resetUser();
            }
            if (e.isControlDown()) {
                if (82 == e.getKeyCode()) {
                    this.viewing = (short)3;
                    this.sendChangeEvent();
                }
                if (77 == e.getKeyCode()) {
                    this.viewing = 1;
                    this.sendChangeEvent();
                }
                if (86 == e.getKeyCode()) {
                    this.viewing = 1;
                    this.sendChangeEvent();
                }
                if (90 == e.getKeyCode()) {
                    this.viewing = (short)2;
                    this.sendChangeEvent();
                }
                if (84 == e.getKeyCode()) {
                    this.viewing = 1;
                    this.sendChangeEvent();
                }
            }
            if (e.isAltDown()) {
                if (67 == e.getKeyCode()) {
                    this.cams[this.panel_op].canvas.caminfo = !this.cams[this.panel_op].canvas.caminfo;
                }
                if (77 == e.getKeyCode()) {
                    this.viewing = 1;
                    this.sendChangeEvent();
                }
                if (86 == e.getKeyCode()) {
                    this.viewing = 1;
                    this.sendChangeEvent();
                }
                if (90 == e.getKeyCode()) {
                    this.viewing = (short)2;
                    this.sendChangeEvent();
                }
            }
            if (116 != e.getKeyCode()) continue;
            for (ProjectionObj p : this.projections) {
                this.stop_vehicles = true;
                p.leaveProjection();
                this.stop_vehicles = false;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void setViewMode(int mode) {
        this.viewing = (short)mode;
        if (this.rotateCursor == null) {
            this.loadCursors();
        }
        switch (mode) {
            case 3: {
                for (int i = 0; i < this.NVIEWS; ++i) {
                    this.views[i].setCursor(this.rotateCursor);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.NVIEWS; ++i) {
                    this.views[i].setCursor(this.translateCursor);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.NVIEWS; ++i) {
                    this.views[i].setCursor(this.zoomCursor);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.NVIEWS; ++i) {
                    this.views[i].setCursor(this.crosshairCursor);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.NVIEWS; ++i) {
                    this.views[i].setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    @Override
    public String getLockedVehicle() {
        return this.lockedVehicle;
    }

    public void removeAllVehicles() {
        this.contentsNoPickTransGr.removeAllChildren();
        this.vehicles.clear();
    }

    public void removeVehicle(VehicleType vehicle) {
        if (this.vehicles.get(vehicle) != null) {
            this.contentsNoPickTransGr.removeChild((Node)this.vehicles.get(vehicle).getFullObj3D());
        }
        this.vehicles.remove(vehicle);
    }

    @Override
    public void followVehicle(String system) {
        int i;
        if (this.lockedVehicle != null && this.lockedVehicle.equals(system)) {
            return;
        }
        if (this.lockedVehicle != null && !this.lockedVehicle.equals(system)) {
            for (i = 0; i < this.NVIEWS; ++i) {
                if (this.cams[i].lock == null) continue;
                this.lockView(i, null);
            }
        }
        this.lockedVehicle = system;
        if (system == null) {
            for (i = 0; i < this.NVIEWS; ++i) {
                if (this.cams[i].lock == null) continue;
                this.lockView(i, null);
            }
        } else {
            for (i = 0; i < this.NVIEWS; ++i) {
                VehicleType vehicle = VehiclesHolder.getVehicleById(system);
                if (vehicle == null) continue;
                this.lockView(i, this.vehicles.get(vehicle));
                this.cams[i].setType(this.cams[i].getType());
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    @Override
    public int getShowMode() {
        return this.viewing;
    }

    private void sendChangeEvent() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ChangeEvent ce = new ChangeEvent(this);
            this.changeListeners.get(i).stateChanged(ce);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            if (e.getSource() != this.cams[i].canvas) continue;
            int mw = e.getWheelRotation();
            if (this.cams[i].projection == 1) {
                if (!e.isShiftDown()) {
                    this.cams[i].setRho(this.cams[i].rho + (double)mw * (this.cams[i].rho / 1.1) / 5.0);
                    continue;
                }
                this.cams[i].setScale(this.cams[i].scale + (double)(mw * 10) / 150.0);
                continue;
            }
            if (!e.isShiftDown()) {
                this.cams[i].setScale(this.cams[i].scale + (double)(-mw * 10) * (this.cams[i].scale / 100.0));
                continue;
            }
            this.cams[i].setRho(this.cams[i].rho + (double)(-mw) * (this.cams[i].rho / 1.1) / 30.0);
        }
    }

    public void getDialog(String title) {
        this.dialog = new JDialog((Frame)new JFrame(), title);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(this.getWidth() + 5, this.getHeight() + 80);
        this.dialog.setModal(true);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Renderer3D.this.dialog.setVisible(false);
                Renderer3D.this.dialog.dispose();
            }
        });
        GuiUtils.centerOnScreen(this.dialog);
        JPanel controlsPanel = new JPanel();
        this.add(controlsPanel);
        this.dialog.setVisible(true);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void showAxis(boolean flag) {
        if (flag) {
            this.addObj3D(this.axisobj);
        } else {
            this.removeObj3D(this.axisobj);
        }
        this.axis = flag;
    }

    public void setObjsIcons(boolean b) {
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            this.cams[i].canvas.objsicons = b;
        }
    }

    public void setVehiclesIcons(boolean b) {
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            this.cams[i].canvas.vehicleicons = b;
        }
    }

    protected void updatePreferencies() {
        this.priority3D = GeneralPreferences.renderer3DPriority;
        int np = 500;
        np = GeneralPreferences.numberOfShownPoints;
        for (VehicleTailElement vte : this.vehicleTails.values()) {
            vte.setNumberOfPoints(np);
        }
    }

    @Override
    public void preferencesUpdated() {
        this.updatePreferencies();
    }

    public void setVehicleIcons(boolean flag) {
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.vehicleicons = flag;
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!this.isVisible() || this.getWidth() <= 0 && !this.stopped) {
            this.stop();
            this.stopped = true;
        } else {
            this.start();
            this.stopped = false;
        }
    }

    public void stop() {
        if (this.renderingStop) {
            return;
        }
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.stopRenderer();
        }
        this.renderingStop = true;
    }

    public void start() {
        if (!this.renderingStop) {
            return;
        }
        for (int i = 0; i < this.NVIEWS; ++i) {
            this.cams[i].canvas.startRenderer();
        }
        this.renderingStop = false;
    }

    public ConsoleLayout getConsole() {
        return this.console;
    }

    public void setConsole(ConsoleLayout console) {
        this.console = console;
    }

    @Override
    public void cleanup() {
        if (this.clean) {
            return;
        }
        if (this.cams[0] == null) {
            return;
        }
        this.freeze();
        for (int i = 0; i < this.NVIEWS; i = (int)((short)(i + 1))) {
            this.viewTransGr.removeChild((Node)this.cams[i].getCamera3D());
            this.cams[i].cleanup();
            this.cams[i] = null;
        }
        this.contentBranch = null;
        this.contentsTransGr = null;
        this.viewBranch = null;
        this.viewTransGr = null;
        VirtualUniverse.setJ3DThreadPriority((int)0);
        this.universe.removeAllLocales();
        System.gc();
        if (this.myMapGroup != null) {
            this.myMapGroup.removeChangeListener(this);
        }
        this.clean = true;
        Viewer.clearViewerMap();
        Primitive.clearGeometryCache();
        GeneralPreferences.removePreferencesListener(this);
    }

    public void destroy() {
        this.cleanup();
    }

    public BoundingSphere getBoundsSphere() {
        return this.bounds;
    }

    public void setBoundsSphere(BoundingSphere bounds) {
        this.bounds = bounds;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.stop();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.start();
    }

    @Override
    public void clearVehicleTail(String[] vehiclesArray) {
        this.lock.lock();
        if (vehiclesArray == null) {
            Enumeration<VehicleType> enuma = this.vehicles.keys();
            while (enuma.hasMoreElements()) {
                VehicleType vtype = enuma.nextElement();
                for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                    if (vtailo.getVehicle() != vtype) continue;
                    vtailo.clearTail();
                }
            }
        } else {
            for (String sys : vehiclesArray) {
                VehicleType vtype = VehiclesHolder.getVehicleById(sys);
                for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                    if (vtailo.getVehicle() != vtype) continue;
                    vtailo.clearTail();
                }
            }
        }
        this.lock.unlock();
    }

    @Override
    public void setVehicleTailOff(String[] vehiclesArray) {
        this.lock.lock();
        if (vehiclesArray == null) {
            Enumeration<VehicleType> enuma = this.vehicles.keys();
            while (enuma.hasMoreElements()) {
                VehicleType vtype = enuma.nextElement();
                VehicleTailObj3D confirm = null;
                for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                    if (vtailo.getVehicle() != vtype) continue;
                    confirm = vtailo;
                }
                if (confirm == null) continue;
                this.contentsNoPickTransGr.removeChild((Node)confirm.getFullObj3D());
                this.VehiclesTails.remove(confirm);
                confirm.clean();
            }
        } else {
            for (String sys : vehiclesArray) {
                VehicleType vtype = VehiclesHolder.getVehicleById(sys);
                VehicleTailObj3D confirm = null;
                for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                    if (vtailo.getVehicle() != vtype) continue;
                    confirm = vtailo;
                }
                if (confirm == null) continue;
                this.contentsNoPickTransGr.removeChild((Node)confirm.getFullObj3D());
                this.VehiclesTails.remove(confirm);
                confirm.clean();
            }
        }
        this.lock.unlock();
    }

    @Override
    public void setVehicleTailOn(String[] vehiclesArray) {
        this.lock.lock();
        if (vehiclesArray == null) {
            Enumeration<VehicleType> enuma = this.vehicles.keys();
            while (enuma.hasMoreElements()) {
                VehicleType vtype = enuma.nextElement();
                boolean confirm = false;
                for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                    if (vtailo.getVehicle() != vtype) continue;
                    confirm = true;
                }
                if (confirm) continue;
                VehicleTailObj3D novoVTail = new VehicleTailObj3D(this.location);
                novoVTail.setVehicle(vtype);
                this.VehiclesTails.add(novoVTail);
                this.contentsNoPickTransGr.addChild((Node)novoVTail.getFullObj3D());
            }
        } else {
            for (String sys : vehiclesArray) {
                VehicleType vtype = VehiclesHolder.getVehicleById(sys);
                boolean confirm = false;
                for (VehicleTailObj3D vtailo : this.VehiclesTails) {
                    if (vtailo.getVehicle() != vtype) continue;
                    confirm = true;
                }
                if (confirm) continue;
                VehicleTailObj3D novoVTail = new VehicleTailObj3D(this.location);
                novoVTail.setVehicle(vtype);
                this.VehiclesTails.add(novoVTail);
                this.contentsNoPickTransGr.addChild((Node)novoVTail.getFullObj3D());
            }
        }
        this.lock.unlock();
    }
}

