/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JButton;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class Texture3D {
    private double width = 0.0;
    private double height = 0.0;
    public Image bitmap = null;
    public Image texture = null;
    public double texturescale = 1.0;
    public int resolution = 10;
    public double maxvalue = 10.0;
    public double minvalue = 0.0;
    public boolean shade = true;
    public float transparency = 0.0f;
    public boolean twosided;

    public void setTextureScale(double value) {
        this.texturescale = 1.0;
    }

    public void setResolution(int value) {
        this.resolution = value;
    }

    public void setMaxValue(double value) {
        this.maxvalue = value;
    }

    public void setMinValue(double value) {
        this.minvalue = value;
    }

    public void setShade(boolean flag) {
        this.shade = flag;
    }

    public void setTransparency(float flag) {
        this.transparency = flag;
    }

    public void setTwoSided(boolean flag) {
        this.twosided = flag;
    }

    public Texture3D() {
    }

    public Texture3D(Image tex) {
        this.setTexture(tex);
    }

    public Texture3D(Image tex, double sizeh, double sizew) {
        this.setTexture(tex);
        this.width = sizew;
        this.height = sizeh;
    }

    public Texture3D(Image tex, Image bit, double sizeh, double sizew) {
        this.setTexture(tex);
        this.bitmap = bit;
        this.width = sizew;
        this.height = sizeh;
    }

    public void setSize(double sizeh, double sizew) {
        this.width = sizew;
        this.height = sizeh;
    }

    private BufferedImage createBufferedImage(Image img) {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        return bi;
    }

    private QuadArray makeTerrain3D(Image img) {
        double diff = this.maxvalue - this.minvalue;
        double factor = diff / 255.0;
        QuadArray GFront = new QuadArray(4 * this.resolution * this.resolution, 35);
        BufferedImage buffer = this.createBufferedImage(img);
        double tamy = buffer.getWidth();
        double tamx = buffer.getHeight();
        double deltax = tamx / (double)this.resolution;
        double deltay = tamy / (double)this.resolution;
        double deltau = 1.0f / (float)this.resolution;
        Point3d topLeft3d = new Point3d(this.height / 2.0, -this.width / 2.0, 0.0);
        Point3d bottomRight3d = new Point3d(-this.height / 2.0, this.width / 2.0, 0.0);
        Point3d bottomLeft3d = new Point3d(-this.height / 2.0, -this.width / 2.0, 0.0);
        double deltaglobalx = (topLeft3d.x - bottomRight3d.x) / (double)this.resolution;
        double deltaglobaly = (bottomRight3d.y - topLeft3d.y) / (double)this.resolution;
        int quad = 0;
        int auxx = 0;
        int auxy = 0;
        double x = 0.0;
        while (x + x / 100.0 < tamx) {
            double y = 0.0;
            while (y + y / 100.0 < tamy) {
                double x1 = bottomLeft3d.x + deltaglobalx * (double)auxx;
                double y1 = bottomLeft3d.y + deltaglobaly * (double)auxy;
                double x2 = bottomLeft3d.x + deltaglobalx * (double)auxx + deltaglobalx;
                double y2 = bottomLeft3d.y + deltaglobaly * (double)auxy + deltaglobaly;
                GFront.setCoordinate(quad, new Point3d(x1, y1, (double)(buffer.getRGB((int)y, (int)(tamx - 1.0 - x)) & 0xFF) * factor + this.minvalue));
                GFront.setTextureCoordinate(0, quad, new TexCoord2f((float)(deltau * (double)auxy), (float)(deltau * (double)auxx)));
                ++quad;
                if (y + deltay < tamy) {
                    GFront.setCoordinate(quad, new Point3d(x1, y2, (double)(buffer.getRGB((int)(y + deltay), (int)(tamx - 1.0 - x)) & 0xFF) * factor + this.minvalue));
                } else {
                    GFront.setCoordinate(quad, new Point3d(x1, y2, (double)(buffer.getRGB((int)(y + (deltay - 1.0)), (int)(tamx - 1.0 - x)) & 0xFF) * factor + this.minvalue));
                }
                GFront.setTextureCoordinate(0, quad, new TexCoord2f((float)(deltau * (double)auxy + deltau), (float)(deltau * (double)auxx)));
                ++quad;
                if (x + deltax < tamx && y + deltay < tamy) {
                    GFront.setCoordinate(quad, new Point3d(x2, y2, (double)(buffer.getRGB((int)(y + deltay), (int)(tamx - 1.0 - (x + deltax))) & 0xFF) * factor + this.minvalue));
                } else if (x + deltax == tamx && y + deltay < tamy) {
                    GFront.setCoordinate(quad, new Point3d(x2, y2, (double)(buffer.getRGB((int)(y + deltay), (int)(tamx - 1.0 - (x + (deltax - 1.0)))) & 0xFF) * factor + this.minvalue));
                } else if (x + deltax < tamx && y + deltay == tamy) {
                    GFront.setCoordinate(quad, new Point3d(x2, y2, (double)(buffer.getRGB((int)(y + (deltay - 1.0)), (int)(tamx - 1.0 - (x + deltax))) & 0xFF) * factor + this.minvalue));
                } else {
                    GFront.setCoordinate(quad, new Point3d(x2, y2, (double)(buffer.getRGB((int)(y + (deltay - 1.0)), (int)(tamx - 1.0 - (x + (deltax - 1.0)))) & 0xFF) * factor + this.minvalue));
                }
                GFront.setTextureCoordinate(0, quad, new TexCoord2f((float)(deltau * (double)auxy + deltau), (float)(deltau * (double)auxx + deltau)));
                ++quad;
                if (x + deltax < tamx) {
                    GFront.setCoordinate(quad, new Point3d(x2, y1, (double)(buffer.getRGB((int)y, (int)(tamx - 1.0 - (x + deltax))) & 0xFF) * factor + this.minvalue));
                } else {
                    GFront.setCoordinate(quad, new Point3d(x2, y1, (double)(buffer.getRGB((int)y, (int)(tamx - 1.0 - (x + deltax - 1.0))) & 0xFF) * factor + this.minvalue));
                }
                GFront.setTextureCoordinate(0, quad, new TexCoord2f((float)(deltau * (double)auxy), (float)(deltau * (double)auxx + deltau)));
                ++quad;
                ++auxy;
                y += deltay;
            }
            ++auxx;
            auxy = 0;
            x += deltax;
        }
        GFront.setCapability(4);
        GFront.setCapability(21);
        GFront.setCapability(17);
        GFront.setCapability(0);
        GFront.setCapability(5);
        return GFront;
    }

    public TransformGroup getModel3D() {
        TransparencyAttributes trans;
        MediaTracker tracker = new MediaTracker(new JButton());
        tracker.addImage(this.texture, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            System.err.println("erro ao esperar pela imagem!");
        }
        tracker = new MediaTracker(new JButton());
        tracker.addImage(this.bitmap, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            System.err.println("erro ao esperar pela imagem!");
        }
        QuadArray GFront = null;
        if (this.bitmap == null) {
            GFront = new QuadArray(4, 33);
            Point3d topLeft3d = new Point3d(this.height / 2.0, -this.width / 2.0, 0.0);
            Point3d bottomRight3d = new Point3d(-this.height / 2.0, this.width / 2.0, 0.0);
            GFront.setCoordinate(3, topLeft3d);
            GFront.setCoordinate(2, new Point3d(topLeft3d.x, bottomRight3d.y, 0.0));
            GFront.setCoordinate(1, bottomRight3d);
            GFront.setCoordinate(0, new Point3d(bottomRight3d.x, topLeft3d.y, 0.0));
            GFront.setTextureCoordinate(0, 0, new TexCoord2f(0.0f, 0.0f));
            GFront.setTextureCoordinate(0, 1, new TexCoord2f(1.0f, 0.0f));
            GFront.setTextureCoordinate(0, 2, new TexCoord2f(1.0f, 1.0f));
            GFront.setTextureCoordinate(0, 3, new TexCoord2f(0.0f, 1.0f));
        } else {
            GFront = this.makeTerrain3D(this.bitmap);
        }
        Appearance appGFront = new Appearance();
        appGFront.setCapability(10);
        appGFront.setCapability(11);
        if (this.texture != null) {
            Texture GogglesOn = new TextureLoader(this.texture, null).getTexture();
            appGFront.setTexture(GogglesOn);
            TextureAttributes myta = new TextureAttributes();
            Transform3D texturetrans = new Transform3D();
            texturetrans.setScale(new Vector3d(this.texturescale, this.texturescale, this.texturescale));
            myta.setTextureTransform(texturetrans);
            myta.setTextureMode(5);
            appGFront.setTextureAttributes(myta);
        }
        if (this.transparency >= 0.001f) {
            trans = new TransparencyAttributes();
            trans.setCapability(3);
            trans.setCapability(2);
            trans.setCapability(0);
            trans.setCapability(1);
            trans.setTransparency(this.transparency);
            trans.setTransparencyMode(1);
            appGFront.setTransparencyAttributes(trans);
        } else {
            trans = new TransparencyAttributes();
            trans.setCapability(3);
            trans.setCapability(2);
            trans.setCapability(0);
            trans.setCapability(1);
            trans.setTransparencyMode(4);
            appGFront.setTransparencyAttributes(trans);
        }
        GeometryInfo gi = new GeometryInfo((GeometryArray)GFront);
        if (this.shade) {
            Material mat = new Material();
            mat.setShininess(0.1f);
            appGFront.setMaterial(mat);
            NormalGenerator ng = new NormalGenerator();
            ng.generateNormals(gi);
            gi.recomputeIndices();
            gi.unindexify();
            gi.compact();
        }
        if (this.twosided) {
            PolygonAttributes p = new PolygonAttributes(2, 0, 0.0f);
            appGFront.setPolygonAttributes(p);
        }
        GeometryArray geom = gi.getGeometryArray();
        geom.setCapability(4);
        Shape3D shape = new Shape3D((Geometry)geom, appGFront);
        shape.setCapability(14);
        shape.setCapability(15);
        TransformGroup ret = new TransformGroup();
        ret.setCapability(12);
        ret.addChild((Node)shape);
        return ret;
    }

    public static void main(String[] arg) {
        Renderer3D render = new Renderer3D();
        GuiUtils.testFrame(render, "3D");
        Image texture = ImageUtils.getImage("images/batimetria.png");
        Image depth = ImageUtils.getImage("images/batimetria.png");
        Texture3D terrain = new Texture3D(texture, depth, 49.0, 49.0);
        terrain.resolution = 100;
        terrain.shade = false;
        terrain.transparency = 0.3f;
        terrain.minvalue = 14.0;
        terrain.maxvalue = 2.0;
        terrain.texturescale = 1.0;
        terrain.twosided = true;
        Obj3D obj = new Obj3D();
        obj.setModel3D(terrain.getModel3D());
        render.addObj3D(obj);
    }

    public Image getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(Image bitmap) {
        this.bitmap = bitmap;
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setTexture(Image text) {
        this.texture = text;
        int size = this.texture.getWidth(null) * this.texture.getHeight(null);
        if (size > 480000) {
            MediaTracker tracker = new MediaTracker(new JButton());
            tracker.addImage(this.texture, 0);
            try {
                tracker.waitForAll();
            }
            catch (Exception e) {
                System.err.println("erro ao esperar pela imagem!");
            }
            double factor = 1.0;
            factor = 480000.0 / (double)size;
            int width = (int)((double)this.texture.getWidth(null) * factor);
            int height = (int)((double)this.texture.getHeight(null) * factor);
            this.texture = this.texture.getScaledInstance(width, height, 4);
        }
    }
}

