/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.picking.PickTool;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pt.lsts.neptus.renderer3d.Camera3D;

public class Util3D {
    public static float pickBug = 0.001f;
    public static int FORMAT_SIZE = 128;
    public static BoundingSphere BOUNDS3D = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);

    public static Shape3D foundImageShape(TransformGroup model) {
        Enumeration childs = model.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (child instanceof Shape3D) {
                return (Shape3D)child;
            }
            if (!(child instanceof TransformGroup)) continue;
            return Util3D.foundImageShape((TransformGroup)child);
        }
        return null;
    }

    public static Box foundBox(TransformGroup model) {
        Enumeration childs = model.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (child instanceof Box) {
                return (Box)child;
            }
            if (!(child instanceof TransformGroup)) continue;
            return Util3D.foundBox((TransformGroup)child);
        }
        return null;
    }

    public static boolean removeBackgroud(Group model) {
        Enumeration childs = model.getAllChildren();
        boolean flag = false;
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (child instanceof Background) {
                ((Group)((Background)child).getParent()).removeChild((Node)((Background)child));
                flag = true;
            }
            if (!(child instanceof Group)) continue;
            flag = Util3D.removeBackgroud((Group)child);
        }
        return flag;
    }

    public static Sphere foundSphere(TransformGroup model) {
        Enumeration childs = model.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (child instanceof Sphere) {
                return (Sphere)child;
            }
            if (!(child instanceof TransformGroup)) continue;
            return Util3D.foundSphere((TransformGroup)child);
        }
        return null;
    }

    public static Cylinder foundCylinder(TransformGroup model) {
        Enumeration childs = model.getAllChildren();
        while (childs.hasMoreElements()) {
            Object child = childs.nextElement();
            if (child instanceof Cylinder) {
                return (Cylinder)child;
            }
            if (!(child instanceof TransformGroup)) continue;
            return Util3D.foundCylinder((TransformGroup)child);
        }
        return null;
    }

    public static TransformGroup makeAxis(boolean leters, double size) {
        TransformGroup model = new TransformGroup();
        Sphere sphere = new Sphere(0.25f);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 1.0f, 0, true, true, false, 3);
        Color3f c = new Color3f(1.0f, 1.0f, 1.0f);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        Point3d[] listp1 = new Point3d[]{new Point3d(size, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0)};
        Point3d[] listp2 = new Point3d[]{new Point3d(0.0, size, 0.0), new Point3d(0.0, 0.0, 0.0)};
        Point3d[] listp3 = new Point3d[]{new Point3d(0.0, 0.0, size), new Point3d(0.0, 0.0, 0.0)};
        LineArray myLines1 = new LineArray(listp1.length, 1);
        myLines1.setCoordinates(0, listp1);
        LineArray myLines2 = new LineArray(listp1.length, 1);
        myLines2.setCoordinates(0, listp2);
        LineArray myLines3 = new LineArray(listp1.length, 1);
        myLines3.setCoordinates(0, listp3);
        Appearance appearance1 = new Appearance();
        appearance1.setRenderingAttributes(renderingAttributes);
        c = new Color3f(1.0f, 0.0f, 0.0f);
        coloringAttributes = new ColoringAttributes(c, 3);
        appearance1.setColoringAttributes(coloringAttributes);
        Shape3D shape3D1 = new Shape3D((Geometry)myLines1, appearance1);
        Appearance appearance2 = new Appearance();
        appearance2.setRenderingAttributes(renderingAttributes);
        c = new Color3f(0.0f, 1.0f, 0.0f);
        coloringAttributes = new ColoringAttributes(c, 3);
        appearance2.setColoringAttributes(coloringAttributes);
        Shape3D shape3D2 = new Shape3D((Geometry)myLines2, appearance2);
        Appearance appearance3 = new Appearance();
        appearance3.setRenderingAttributes(renderingAttributes);
        c = new Color3f(0.3f, 0.3f, 1.0f);
        coloringAttributes = new ColoringAttributes(c, 3);
        appearance3.setColoringAttributes(coloringAttributes);
        Shape3D shape3D3 = new Shape3D((Geometry)myLines3, appearance3);
        c = new Color3f(1.0f, 1.0f, 1.0f);
        coloringAttributes = new ColoringAttributes(c, 3);
        Appearance appearance4 = new Appearance();
        appearance4.setRenderingAttributes(renderingAttributes);
        appearance4.setColoringAttributes(coloringAttributes);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(0.3f);
        trans.setTransparencyMode(1);
        appearance4.setTransparencyAttributes(trans);
        sphere.setAppearance(appearance4);
        Transform3D t = new Transform3D();
        t.setScale(0.1);
        model.setTransform(t);
        model.addChild((Node)shape3D1);
        model.addChild((Node)shape3D2);
        model.addChild((Node)shape3D3);
        if (leters) {
            TransformGroup xtextTrans = new TransformGroup();
            Transform3D xtrans2 = new Transform3D();
            xtrans2.setTranslation(new Vector3d(2.0, 0.0, 0.0));
            xtextTrans.setTransform(xtrans2);
            Text2D xtext2D = new Text2D("N", new Color3f(1.0f, 0.0f, 0.0f), "Helvetica", 100, 3);
            xtextTrans.setTransform(xtrans2);
            xtextTrans.addChild((Node)xtext2D);
            TransformGroup xtextTrans2 = new TransformGroup();
            Transform3D xtrans3 = new Transform3D();
            xtrans3.rotX(Math.PI);
            xtrans2.mul(xtrans3);
            Text2D xtext2D2 = new Text2D("N", new Color3f(1.0f, 0.0f, 0.0f), "Helvetica", 100, 3);
            xtextTrans2.setTransform(xtrans2);
            xtextTrans2.addChild((Node)xtext2D2);
            model.addChild((Node)xtextTrans);
            model.addChild((Node)xtextTrans2);
            TransformGroup ytextTrans = new TransformGroup();
            Transform3D ytrans2 = new Transform3D();
            ytrans2.setTranslation(new Vector3d(0.0, 2.0, 0.0));
            ytextTrans.setTransform(ytrans2);
            Text2D ytext2D = new Text2D("E", new Color3f(0.0f, 1.0f, 0.0f), "Helvetica", 100, 3);
            ytextTrans.setTransform(ytrans2);
            ytextTrans.addChild((Node)ytext2D);
            TransformGroup ytextTrans2 = new TransformGroup();
            Transform3D ytrans3 = new Transform3D();
            ytrans3.rotY(Math.PI);
            ytrans2.mul(ytrans3);
            Text2D ytext2D2 = new Text2D("E", new Color3f(0.0f, 1.0f, 0.0f), "Helvetica", 100, 3);
            ytextTrans2.setTransform(ytrans2);
            ytextTrans2.addChild((Node)ytext2D2);
            model.addChild((Node)ytextTrans);
            model.addChild((Node)ytextTrans2);
            TransformGroup ztextTrans = new TransformGroup();
            Transform3D ztrans2 = new Transform3D();
            Transform3D ztrans3 = new Transform3D();
            ztrans2.setTranslation(new Vector3d(0.0, 0.0, 2.0));
            ztrans3.rotY(1.5707963267948966);
            ztrans2.mul(ztrans3);
            ztextTrans.setTransform(ztrans2);
            Text2D ztext2D = new Text2D("D", new Color3f(0.7f, 0.7f, 1.0f), "Helvetica", 100, 3);
            ztextTrans.setTransform(ztrans2);
            ztextTrans.addChild((Node)ztext2D);
            TransformGroup ztextTrans2 = new TransformGroup();
            ztrans3.rotX(Math.PI);
            ztrans2.mul(ztrans3);
            Text2D ztext2D2 = new Text2D("D", new Color3f(0.7f, 0.7f, 1.0f), "Helvetica", 100, 3);
            ztextTrans2.setTransform(ztrans2);
            ztextTrans2.addChild((Node)ztext2D2);
            model.addChild((Node)ztextTrans);
            model.addChild((Node)ztextTrans2);
        }
        return model;
    }

    public static Color Color3fToColor(Color3f colorf) {
        Color ret = colorf.get();
        return ret;
    }

    public static Color3f ColorToColor3f(Color color) {
        Color3f ret = new Color3f();
        ret.set(color);
        return ret;
    }

    public static Point3f getModelDim(TransformGroup model) {
        Vector<Shape3D> gShapeObjects = new Vector<Shape3D>();
        Util3D.GetShapeNodes(model, gShapeObjects);
        Point3f ret = new Point3f();
        Point3f retmin = new Point3f();
        Point3f retmax = new Point3f();
        for (Shape3D s : gShapeObjects) {
            Enumeration list = s.getAllGeometries();
            while (list.hasMoreElements()) {
                Point3f[] pointlist;
                Geometry g = (Geometry)list.nextElement();
                GeometryInfo gi = new GeometryInfo((GeometryArray)g);
                for (Point3f p : pointlist = gi.getCoordinates()) {
                    if (p.x > retmax.x) {
                        retmax.x = p.x;
                    }
                    if (p.y > retmax.y) {
                        retmax.y = p.y;
                    }
                    if (p.z > retmax.z) {
                        retmax.z = p.z;
                    }
                    if (p.x < retmin.x) {
                        retmax.x = p.x;
                    }
                    if (p.y < retmin.y) {
                        retmax.y = p.y;
                    }
                    if (!(p.z < retmin.z)) continue;
                    retmax.z = p.z;
                }
            }
        }
        if (retmin.x < 0.0f) {
            retmin.x *= -1.0f;
        }
        if (retmin.y < 0.0f) {
            retmin.y *= -1.0f;
        }
        if (retmin.z < 0.0f) {
            retmin.z *= -1.0f;
        }
        if (retmax.x < 0.0f) {
            retmax.x *= -1.0f;
        }
        if (retmax.y < 0.0f) {
            retmax.y *= -1.0f;
        }
        if (retmax.z < 0.0f) {
            retmax.z *= -1.0f;
        }
        ret.x = retmin.x > retmax.x ? retmin.x : retmax.x;
        ret.y = retmin.y > retmax.y ? retmin.y : retmax.y;
        ret.z = retmin.z > retmax.z ? retmin.z : retmax.z;
        return ret;
    }

    public static void GetShapeNodes(BranchGroup parentGroup, Vector<Shape3D> gShapeObjects) {
        for (int i = 0; i < parentGroup.numChildren(); ++i) {
            Node tNode = parentGroup.getChild(i);
            if (tNode.getClass() == BranchGroup.class) {
                Util3D.GetShapeNodes((BranchGroup)tNode, gShapeObjects);
                continue;
            }
            if (tNode.getClass() == TransformGroup.class) {
                Util3D.GetShapeNodes((TransformGroup)tNode, gShapeObjects);
                continue;
            }
            if (tNode.getClass() != Shape3D.class) continue;
            gShapeObjects.add((Shape3D)tNode);
        }
    }

    private static void GetShapeNodes(TransformGroup parentGroup, Vector<Shape3D> gShapeObjects) {
        for (int i = 0; i < parentGroup.numChildren(); ++i) {
            Node tNode = parentGroup.getChild(i);
            if (tNode.getClass() == BranchGroup.class) {
                Util3D.GetShapeNodes((BranchGroup)tNode, gShapeObjects);
                continue;
            }
            if (tNode.getClass() == TransformGroup.class) {
                Util3D.GetShapeNodes((TransformGroup)tNode, gShapeObjects);
                continue;
            }
            if (tNode.getClass() != Shape3D.class) continue;
            gShapeObjects.add((Shape3D)tNode);
        }
    }

    public static void enablePicking(Node node) {
        Enumeration e;
        node.setPickable(true);
        node.setCapability(1);
        try {
            Group group = (Group)node;
            e = group.getAllChildren();
            while (e.hasMoreElements()) {
                Util3D.enablePicking((Node)e.nextElement());
            }
        }
        catch (ClassCastException e2) {
            // empty catch block
        }
        try {
            Shape3D shape = (Shape3D)node;
            PickTool.setCapabilities((Node)node, (int)4100);
            e = shape.getAllGeometries();
            while (e.hasMoreElements()) {
                Geometry g = (Geometry)e.nextElement();
                g.setCapability(18);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static Point3d setTransform(Point3d vec, double roll, double pitch, double yaw) {
        Transform3D ret = new Transform3D();
        Transform3D xrot = new Transform3D();
        Transform3D yrot = new Transform3D();
        Transform3D zrot = new Transform3D();
        xrot.rotX(roll);
        yrot.rotY(pitch);
        zrot.rotZ(yaw);
        ret.mul(zrot);
        ret.mul(xrot);
        ret.mul(yrot);
        Point3d retvector = new Point3d();
        ret.transform(vec, retvector);
        return retvector;
    }

    public static void setCameraPosition3Points(Camera3D cam, Point3d a, Point3d b, Point3d c) {
        Vector3d va = new Vector3d((Tuple3d)a);
        Vector3d vb = new Vector3d((Tuple3d)b);
        Vector3d vc = new Vector3d((Tuple3d)c);
        va.x = vb.x - va.x;
        va.y = vb.y - va.y;
        va.z = vb.z - va.z;
        vb.x = vc.x - va.x;
        vb.y = vc.y - va.y;
        vb.z = vc.z - va.z;
        vc.cross(va, vb);
        vc.normalize();
        double psi = Math.atan(vc.y / vc.x);
        double theta = Math.acos(vc.z);
        cam.setPsi(psi);
        cam.setTheta(theta);
        double rho = a.distance(b);
        if (rho < b.distance(c)) {
            rho = b.distance(c);
        }
        if (rho < c.distance(a)) {
            rho = c.distance(a);
        }
        cam.setRho(rho);
        Vector3d pivot = new Vector3d((a.x + b.x + c.x) / 3.0, (a.y + b.y + c.y) / 3.0, (a.z + b.z + c.z) / 3.0);
        cam.setPivot(pivot);
    }

    public static void setCameraPositionBox(Camera3D cam, Point3d a, Point3d b) {
        double captAng = 2.0 * Math.toDegrees(Math.atan(0.2898550724637681));
        Vector3d center = new Vector3d();
        center.x = (a.x + b.x) / 2.0;
        center.y = (a.y + b.y) / 2.0;
        center.z = (a.z + b.z) / 2.0;
        double deslocHor = a.x > b.x ? (a.x - b.x) / 2.0 : (b.x - a.x) / 2.0;
        double altaux = Math.sin(Math.toRadians(captAng / 2.0)) * deslocHor;
        double Rho = Math.sqrt(altaux * altaux + deslocHor * deslocHor);
        double tamVert = a.z > b.z ? a.z - b.z : b.z - a.z;
        tamVert = tamVert / 2.0 + altaux;
        double andSul = Math.sqrt(Rho * Rho - tamVert * tamVert);
        double tamHor = a.y > b.y ? (a.y - b.y) / 2.0 : (b.y - a.y) / 2.0;
        double andSul2 = Math.sin(Math.toRadians(captAng / 2.0)) * tamHor;
        center.x = andSul > andSul2 ? (center.x -= andSul) : (center.x -= andSul2);
        cam.setPhi(Math.PI);
        cam.setPsi(-1.5707963267948966);
        cam.setTheta(Math.PI - Math.toRadians(72.0));
        cam.setPivot(center);
        cam.setRho(Rho);
        cam.setProjection(1);
    }

    public static TransformGroup getSphere(Color ca, double scalex, double scaley, double scalez) {
        Sphere sphere = new Sphere(1.0f, 3, null);
        sphere.getChild(0).setCapability(14);
        sphere.getChild(0).setCapability(15);
        Transform3D t = new Transform3D();
        Transform3D t2 = new Transform3D();
        t.setScale(new Vector3d(scalex, scaley, scalez));
        t2.setScale(1.0);
        t.mul(t2);
        TransformGroup model = new TransformGroup();
        model.setCapability(12);
        Appearance appearance3 = new Appearance();
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setCapability(0);
        trans.setCapability(1);
        trans.setTransparency(0.5f);
        trans.setTransparencyMode(1);
        appearance3.setTransparencyAttributes(trans);
        Material mat = new Material();
        mat.setCapability(1);
        mat.setCapability(0);
        Color3f c = new Color3f();
        c.set(ca);
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        appearance3.setMaterial(mat);
        sphere.setAppearance(appearance3);
        model.addChild((Node)sphere);
        model.setTransform(t);
        sphere.getAppearance();
        return model;
    }

    public static TransformGroup getCylinder(Color ca, double scalex, double scaley, double scalez, boolean sideTop) {
        Cylinder cylinder = new Cylinder(1.0f, 3.0f, null);
        cylinder.getChild(0).setCapability(14);
        cylinder.getChild(0).setCapability(15);
        Transform3D t = new Transform3D();
        Transform3D t2 = new Transform3D();
        t.setScale(new Vector3d(scalex, scaley, scalez));
        t2.rotX(1.5707963267948966);
        t.mul(t2);
        TransformGroup model = new TransformGroup();
        model.setCapability(12);
        Appearance appearance3 = new Appearance();
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setCapability(0);
        trans.setCapability(1);
        trans.setTransparency(0.5f);
        trans.setTransparencyMode(1);
        appearance3.setTransparencyAttributes(trans);
        Material mat = new Material();
        mat.setCapability(1);
        mat.setCapability(0);
        Color3f c = new Color3f();
        c.set(ca);
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        appearance3.setMaterial(mat);
        PolygonAttributes p = new PolygonAttributes(2, 0, 0.0f);
        appearance3.setPolygonAttributes(p);
        cylinder.setAppearance(appearance3);
        if (sideTop) {
            cylinder.removeChild(1);
            cylinder.removeChild(1);
        } else {
            cylinder.removeChild(0);
        }
        model.addChild((Node)cylinder);
        model.setTransform(t);
        return model;
    }
}

