/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class VehicleTailObj3D {
    public VehicleType vehicle;
    private SystemPositionAndAttitude lastPoint = null;
    private int NPoints = 0;
    private Vector<BranchGroup> shapesList = new Vector();
    private TransformGroup move = new TransformGroup();
    protected double[] pos = new double[3];
    private BranchGroup fullobj = new BranchGroup();
    private LocationType lt;
    public double sideSize = 0.5;
    public boolean activated = true;

    VehicleTailObj3D(LocationType loc) {
        this.fullobj.setCapability(17);
        this.fullobj.setCapability(14);
        this.fullobj.setCapability(12);
        this.fullobj.setCapability(13);
        this.move.setCapability(18);
        this.move.setCapability(17);
        this.move.setCapability(14);
        this.move.setCapability(12);
        this.move.setCapability(13);
        this.fullobj.addChild((Node)this.move);
        this.lt = loc;
    }

    public void addNewVehicleState(SystemPositionAndAttitude state) {
        ++this.NPoints;
        if (this.lastPoint != null) {
            BranchGroup shapeSeg = this.createShapeSegment(this.lastPoint, state);
            shapeSeg.setCapability(17);
            this.shapesList.add(shapeSeg);
            this.move.addChild((Node)shapeSeg);
            int numberOfPoints = GeneralPreferences.numberOfShownPoints;
            int diference = this.NPoints - numberOfPoints;
            if (diference > 0) {
                BranchGroup[] shapesListArray = this.shapesList.toArray(new BranchGroup[0]);
                for (int i = 0; i < diference; ++i) {
                    this.move.removeChild((Node)shapesListArray[i]);
                    this.shapesList.remove(shapesListArray[i]);
                }
                this.NPoints -= diference;
            }
        }
        this.lastPoint = state;
    }

    private BranchGroup createShapeSegment(SystemPositionAndAttitude a, SystemPositionAndAttitude b) {
        if (a == null || b == null) {
            return null;
        }
        QuadArray gFront = new QuadArray(4, 1);
        Point3d aPoint = new Point3d(a.getPosition().getOffsetFrom(this.lt));
        Point3d bPoint = new Point3d(b.getPosition().getOffsetFrom(this.lt));
        aPoint.x -= this.pos[0];
        aPoint.y -= this.pos[1];
        aPoint.z -= this.pos[2];
        bPoint.x -= this.pos[0];
        bPoint.y -= this.pos[1];
        bPoint.z -= this.pos[2];
        Point3d left = new Point3d(0.0, this.sideSize, 0.0);
        Point3d right = new Point3d(0.0, -this.sideSize, 0.0);
        Point3d bottomLeft = Util3D.setTransform(left, a.getRoll(), a.getPitch(), a.getYaw());
        Point3d bottomRight = Util3D.setTransform(right, a.getRoll(), a.getPitch(), a.getYaw());
        Point3d topLeft = Util3D.setTransform(left, b.getRoll(), b.getPitch(), b.getYaw());
        Point3d topRight = Util3D.setTransform(right, b.getRoll(), b.getPitch(), b.getYaw());
        bottomLeft.x += aPoint.x;
        bottomLeft.y += aPoint.y;
        bottomLeft.z += aPoint.z;
        bottomRight.x += aPoint.x;
        bottomRight.y += aPoint.y;
        bottomRight.z += aPoint.z;
        topLeft.x += bPoint.x;
        topLeft.y += bPoint.y;
        topLeft.z += bPoint.z;
        topRight.x += bPoint.x;
        topRight.y += bPoint.y;
        topRight.z += bPoint.z;
        gFront.setCoordinate(3, topLeft);
        gFront.setCoordinate(2, topRight);
        gFront.setCoordinate(1, bottomRight);
        gFront.setCoordinate(0, bottomLeft);
        Appearance appGFront = new Appearance();
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(0.5f);
        trans.setTransparencyMode(1);
        appGFront.setTransparencyAttributes(trans);
        GeometryInfo gi = new GeometryInfo((GeometryArray)gFront);
        Material mat = new Material();
        Color3f c = new Color3f();
        c.set(this.vehicle.getIconColor());
        mat.setDiffuseColor(c);
        mat.setSpecularColor(c);
        mat.setShininess(0.1f);
        appGFront.setMaterial(mat);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        gi.recomputeIndices();
        gi.unindexify();
        gi.compact();
        PolygonAttributes p = new PolygonAttributes(2, 0, 0.0f);
        appGFront.setPolygonAttributes(p);
        GeometryArray geom = gi.getGeometryArray();
        geom.setCapability(4);
        Shape3D shape = new Shape3D((Geometry)geom, appGFront);
        BranchGroup ret = new BranchGroup();
        ret.setCapability(17);
        ret.addChild((Node)shape);
        return ret;
    }

    public void clearTail() {
        this.shapesList.clear();
        this.move.removeAllChildren();
        this.lastPoint = null;
        this.NPoints = 0;
    }

    public BranchGroup getFullObj3D() {
        return this.fullobj;
    }

    public void clean() {
        this.clearTail();
    }

    public VehicleType getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    public void setPos(double[] p) {
        Transform3D m = new Transform3D();
        m.set(new Vector3d(p[0], p[1], p[2]));
        this.move.setTransform(m);
        this.pos[0] = p[0];
        this.pos[1] = p[1];
        this.pos[2] = p[2];
    }

    public void setPos(Point3d p) {
        Transform3D m = new Transform3D();
        m.set(new Vector3d(p.x, p.y, p.z));
        this.move.setTransform(m);
        this.pos[0] = p.x;
        this.pos[1] = p.y;
        this.pos[2] = p.z;
    }

    public Point3d getPos() {
        Point3d ptn = new Point3d();
        ptn.x = this.pos[0];
        ptn.y = this.pos[1];
        ptn.z = this.pos[2];
        return ptn;
    }

    public LocationType getCenterLocation() {
        return this.lt;
    }

    public void setCenterLocation(LocationType l) {
        this.lt.setLocation(l);
    }
}

