/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.serial;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.serial.SerialPortParameters;
import pt.lsts.neptus.util.GuiUtils;

public class PortSelector
extends JDialog {
    private JPanel back = null;
    private JPanel controls = null;
    private JButton cancelBtn = null;
    private JButton connectBotao = null;
    private JPanel main = null;
    private JLabel jLabel = null;
    private JComboBox<String> portCombo = null;
    private Vector<CommPortIdentifier> ports = new Vector();
    private CommPortIdentifier selectedPort = null;
    private boolean parallelPortsShown = true;
    private boolean serialPortsShown = true;
    private boolean parametersShown = true;
    private SerialPortParameters serialPortParameters = null;

    public PortSelector() {
        this.initialize();
    }

    public PortSelector(Window owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(340, 210));
        this.setTitle("Port selection");
        this.setContentPane(this.getBack());
    }

    private JPanel getBack() {
        if (this.back == null) {
            this.back = new JPanel();
            this.back.setLayout(new BorderLayout());
            this.back.add((Component)this.getControls(), "South");
            this.back.add((Component)this.getMain(), "Center");
        }
        return this.back;
    }

    private JPanel getControls() {
        if (this.controls == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.controls = new JPanel();
            this.controls.setLayout(flowLayout);
            this.controls.add((Component)this.getCancelBtn(), null);
            this.controls.add((Component)this.getConnectBtn(), null);
        }
        return this.controls;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton();
            this.cancelBtn.setText("Cancel");
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PortSelector.this.dispose();
                }
            });
        }
        return this.cancelBtn;
    }

    private JButton getConnectBtn() {
        if (this.connectBotao == null) {
            this.connectBotao = new JButton();
            this.connectBotao.setText("Connect");
            this.connectBotao.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PortSelector.this.portCombo.getSelectedIndex() == -1) {
                        return;
                    }
                    PortSelector.this.selectedPort = (CommPortIdentifier)PortSelector.this.ports.get(PortSelector.this.portCombo.getSelectedIndex());
                    try {
                        CommPort cmp = PortSelector.this.selectedPort.open("PortSelector", 1000);
                        cmp.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        GuiUtils.errorMessage(PortSelector.this, "Port in use", "The selected port is already being used by other application");
                    }
                    PortSelector.this.dispose();
                }
            });
        }
        return this.connectBotao;
    }

    private JPanel getMain() {
        if (this.main == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setVgap(20);
            flowLayout1.setHgap(20);
            this.jLabel = new JLabel();
            this.jLabel.setText("Select port to use:");
            this.jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.main = new JPanel();
            this.main.setLayout(flowLayout1);
            this.main.add((Component)this.jLabel, null);
            this.main.add(this.getPortCombo(), null);
            this.main.add((Component)this.getSerialPortParameters(), null);
            this.serialPortParameters.setBorder(BorderFactory.createLoweredBevelBorder());
            this.serialPortParameters.setEnabled(false);
            this.main.add(this.serialPortParameters);
        }
        return this.main;
    }

    private JComboBox<String> getPortCombo() {
        if (this.portCombo == null) {
            this.portCombo = new JComboBox();
            this.portCombo.setPreferredSize(new Dimension(120, 20));
            this.portCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (PortSelector.this.portCombo.getSelectedIndex() == -1) {
                        PortSelector.this.serialPortParameters.setEnabled(false);
                    } else if (((CommPortIdentifier)PortSelector.this.ports.get(PortSelector.this.portCombo.getSelectedIndex())).getPortType() == 2) {
                        PortSelector.this.serialPortParameters.setEnabled(false);
                    } else {
                        PortSelector.this.serialPortParameters.setEnabled(true);
                    }
                }
            });
            this.refreshPortList();
        }
        return this.portCombo;
    }

    public CommPortIdentifier getSelectedPort() {
        return this.selectedPort;
    }

    public static CommPortIdentifier showPortSelectionDialog() {
        PortSelector ps = new PortSelector();
        ps.setParametersShown(false);
        ps.setResizable(false);
        ps.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        ps.setVisible(true);
        return ps.selectedPort;
    }

    public static PortSelector showSerialPortSelectionDialog(Window owner, boolean showParameters) {
        PortSelector ps = new PortSelector(owner);
        ps.setTitle("Serial Port Selection");
        ps.setSerialPortsShown(true);
        ps.setParallelPortsShown(false);
        ps.setParametersShown(showParameters);
        ps.setResizable(false);
        ps.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        GuiUtils.centerOnScreen(ps);
        ps.setVisible(true);
        return ps;
    }

    public static CommPortIdentifier showParallelPortSelectionDialog() {
        PortSelector ps = new PortSelector();
        ps.setTitle("Parallel Port Selection");
        ps.setSerialPortsShown(false);
        ps.setParallelPortsShown(true);
        ps.setParametersShown(false);
        ps.setResizable(false);
        ps.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        ps.setVisible(true);
        return ps.selectedPort;
    }

    public boolean isParallelPortsShown() {
        return this.parallelPortsShown;
    }

    public void setParallelPortsShown(boolean parallelPortsShown) {
        this.parallelPortsShown = parallelPortsShown;
        this.refreshPortList();
    }

    public boolean isSerialPortsShown() {
        return this.serialPortsShown;
    }

    public void setParametersShown(boolean parametersShown) {
        this.parametersShown = parametersShown;
        this.getSerialPortParameters().setVisible(parametersShown);
    }

    public boolean isParametersShown() {
        return this.parametersShown;
    }

    public void setSerialPortsShown(boolean serialPortsShown) {
        this.serialPortsShown = serialPortsShown;
        this.refreshPortList();
    }

    private void refreshPortList() {
        this.ports.removeAllElements();
        Enumeration<?> avPorts = PortSelector.enumerateComPorts();
        while (avPorts.hasMoreElements()) {
            CommPortIdentifier commID = (CommPortIdentifier)avPorts.nextElement();
            if (commID.getPortType() == 2 && this.isParallelPortsShown()) {
                this.ports.add(commID);
            }
            if (commID.getPortType() != 1 || !this.isSerialPortsShown()) continue;
            this.ports.add(commID);
        }
        this.portCombo.removeAllItems();
        for (CommPortIdentifier commID : this.ports) {
            this.portCombo.insertItemAt(commID.getName(), this.portCombo.getItemCount());
        }
    }

    public SerialPortParameters getSerialPortParameters() {
        if (this.serialPortParameters == null) {
            this.serialPortParameters = new SerialPortParameters();
        }
        return this.serialPortParameters;
    }

    public static Enumeration<?> enumerateComPorts() {
        try {
            Field masterIdList_Field = CommPortIdentifier.class.getDeclaredField("masterIdList");
            masterIdList_Field.setAccessible(true);
            masterIdList_Field.set(null, null);
            String temp_string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javax.comm.properties";
            Method loadDriver_Method = CommPortIdentifier.class.getDeclaredMethod("loadDriver", String.class);
            loadDriver_Method.setAccessible(true);
            loadDriver_Method.invoke(null, temp_string);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)e);
        }
        return CommPortIdentifier.getPortIdentifiers();
    }

    public static void main(String[] args) {
        System.err.println(PortSelector.showSerialPortSelectionDialog(null, true));
        System.err.println(PortSelector.showParallelPortSelectionDialog());
        System.err.println(PortSelector.showPortSelectionDialog());
    }
}

